/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.jboss.aop.Advisor;
import org.jboss.aop.JoinPointInfo;
import org.jboss.aop.joinpoint.FieldAccess;
import org.jboss.aop.joinpoint.FieldJoinpoint;
import org.jboss.aop.joinpoint.Joinpoint;
import org.jboss.aop.util.MethodHashing;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldInfo
extends JoinPointInfo
implements FieldAccess {
    private int index;
    private Field advisedField;
    private Method wrapper;
    private boolean read;

    public FieldInfo() {
    }

    public FieldInfo(Advisor advisor, boolean read) {
        super(advisor, null);
        this.read = read;
    }

    public FieldInfo(Class<?> clazz, int index, String fieldName, long wrapperHash, Advisor advisor, boolean read) {
        super(advisor, clazz);
        try {
            this.index = index;
            this.advisedField = System.getSecurityManager() == null ? GetDeclaredFieldAction.NON_PRIVILEGED.get(this, clazz, fieldName) : GetDeclaredFieldAction.PRIVILEGED.get(this, clazz, fieldName);
            this.wrapper = MethodHashing.findMethodByHash(clazz, wrapperHash);
            this.setAdvisor(advisor);
            this.read = read;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private FieldInfo(FieldInfo other) {
        super(other);
        this.index = other.index;
        this.advisedField = other.advisedField;
        this.wrapper = other.wrapper;
        this.read = other.read;
    }

    @Override
    protected Joinpoint internalGetJoinpoint() {
        return new FieldJoinpoint(this.advisedField);
    }

    @Override
    public JoinPointInfo copy() {
        return new FieldInfo(this);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Field ");
        sb.append(this.read ? " Read" : "Write");
        sb.append("[");
        sb.append("field=" + this.advisedField);
        sb.append("]");
        return sb.toString();
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public void setAdvisedField(Field advisedField) {
        this.advisedField = advisedField;
    }

    @Deprecated
    public Field getAdvisedField() {
        return this.advisedField;
    }

    @Override
    public Field getField() {
        return this.advisedField;
    }

    public void setWrapper(Method wrapper) {
        this.wrapper = wrapper;
    }

    public Method getWrapper() {
        return this.wrapper;
    }

    public void setRead(boolean read) {
        this.read = read;
    }

    @Override
    public boolean isRead() {
        return this.read;
    }

    @Override
    public <T extends Annotation> T resolveAnnotation(Class<T> annotation) {
        T val = super.resolveAnnotation(annotation);
        if (val != null) {
            return val;
        }
        if (this.getAdvisor() != null && (val = this.getAdvisor().resolveTypedAnnotation(this.advisedField, annotation)) != null) {
            return val;
        }
        return null;
    }

    private Field doGet(Class<?> clazz, String name) throws NoSuchFieldException {
        Field field = null;
        for (Class<?> superClass = clazz; superClass != null; superClass = superClass.getSuperclass()) {
            try {
                field = superClass.getDeclaredField(name);
                break;
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        if (field == null) {
            throw new NoSuchFieldException("Cannot find field in " + clazz.getName() + " or any of its superclasses");
        }
        return field;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface GetDeclaredFieldAction {
        public static final GetDeclaredFieldAction PRIVILEGED = new GetDeclaredFieldAction(){

            @Override
            public Field get(final FieldInfo target, final Class<?> clazz, final String name) throws NoSuchFieldException {
                try {
                    return AccessController.doPrivileged(new PrivilegedExceptionAction<Field>(){

                        @Override
                        public Field run() throws Exception {
                            return target.doGet(clazz, name);
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    Exception ex = e.getException();
                    if (ex instanceof NoSuchFieldException) {
                        throw (NoSuchFieldException)ex;
                    }
                    throw new RuntimeException(ex);
                }
            }
        };
        public static final GetDeclaredFieldAction NON_PRIVILEGED = new GetDeclaredFieldAction(){

            @Override
            public Field get(FieldInfo target, Class<?> clazz, String name) throws NoSuchFieldException {
                return target.doGet(clazz, name);
            }
        };

        public Field get(FieldInfo var1, Class<?> var2, String var3) throws NoSuchFieldException;
    }
}

