/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.advice;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jboss.aop.advice.PrecedenceDef;
import org.jboss.aop.advice.PrecedenceDefEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PrecedenceGraph {
    private Map<PrecedenceDefEntry, Node> nodes = new HashMap<PrecedenceDefEntry, Node>();

    public PrecedenceGraph(Collection<PrecedenceDef> precedenceDefs) {
        for (PrecedenceDef precedence : precedenceDefs) {
            PrecedenceDefEntry[] entries = precedence.getEntries();
            if (entries.length < 2) continue;
            Node node1 = this.createNode(entries[0]);
            for (int i = 1; i < entries.length; ++i) {
                Node node2 = this.createNode(entries[i]);
                node1.addNextNode(node2);
                node1 = node2;
            }
        }
    }

    private Node createNode(PrecedenceDefEntry entry) {
        Node node = this.nodes.get(entry);
        if (node == null) {
            node = new Node(entry);
            this.nodes.put(entry, node);
        }
        return node;
    }

    public PrecedenceDefEntry[] getSortedPrecedence() {
        PrecedenceDefEntry[] overallPrecedence = new PrecedenceDefEntry[this.nodes.size()];
        int i = 0;
        for (Node node : this.nodes.values()) {
            if (!node.hasPreviousNode() && !node.isVisited() && (i = node.addSortedPrecedence(overallPrecedence, i)) == overallPrecedence.length) break;
        }
        return overallPrecedence;
    }

    private static class Node {
        private PrecedenceDefEntry precedenceEntry;
        private SearchStatus searchStatus;
        private Collection<Node> next;
        private Collection<Node> previous;

        public Node(PrecedenceDefEntry precedenceEntry) {
            this.precedenceEntry = precedenceEntry;
            this.searchStatus = SearchStatus.NOT_VISITED;
            this.next = new ArrayList<Node>();
            this.previous = new ArrayList<Node>();
        }

        public boolean hasPreviousNode() {
            return !this.previous.isEmpty();
        }

        public boolean isVisited() {
            return this.searchStatus != SearchStatus.NOT_VISITED;
        }

        public void addNextNode(Node node) {
            if (!this.next.contains(node)) {
                for (Node previousNode : this.previous) {
                    previousNode.removeEdge(node);
                }
                this.next.add(node);
                node.previous.add(this);
            }
        }

        public int addSortedPrecedence(PrecedenceDefEntry[] sortedPrecedence, int index) {
            switch (this.searchStatus) {
                case NOT_VISITED: {
                    this.searchStatus = SearchStatus.VISITING;
                    if (!this.previous.isEmpty()) {
                        for (Node node : this.previous) {
                            if (node.isVisited()) continue;
                            index = node.addSortedPrecedence(sortedPrecedence, index);
                        }
                    }
                    this.searchStatus = SearchStatus.VISITED;
                    sortedPrecedence[index++] = this.precedenceEntry;
                    boolean cleared = true;
                    for (Node node : this.next) {
                        int newIndex = node.addSortedPrecedence(sortedPrecedence, index);
                        if (newIndex == -1) {
                            cleared = false;
                            continue;
                        }
                        index = newIndex;
                    }
                    if (!cleared) break;
                    this.searchStatus = SearchStatus.CLEARED;
                    break;
                }
                case VISITING: {
                    index = -1;
                    break;
                }
                case VISITED: {
                    throw new RuntimeException("The specified advice precedence rules contain an invalid cyclic dependency");
                }
            }
            return index;
        }

        private void removeEdge(Node node) {
            this.next.remove(node);
            node.previous.remove(this);
            ArrayList<Node> toRemove = new ArrayList<Node>();
            for (Node previousNode : this.previous) {
                toRemove.add(previousNode);
            }
            for (Node previousNode : toRemove) {
                previousNode.removeEdge(node);
            }
        }

        public int hashCode() {
            return this.precedenceEntry.hashCode();
        }

        public boolean equals(Node other) {
            return this.precedenceEntry.equals(other);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum SearchStatus {
            NOT_VISITED,
            VISITING,
            VISITED,
            CLEARED;

        }
    }
}

