/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.test.spi;

import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CombinedException
extends Exception {
    private final List<Throwable> causes;

    public CombinedException(String message, List<Throwable> causes) {
        super(message);
        this.causes = Collections.unmodifiableList(causes);
    }

    public CombinedException(String message) {
        super(message);
        this.causes = Collections.emptyList();
    }

    public CombinedException(String message, Throwable cause) {
        super(message, cause);
        this.causes = Collections.singletonList(cause);
    }

    public CombinedException(Throwable cause) {
        super(cause);
        this.causes = Collections.singletonList(cause);
    }

    public List<Throwable> getCauses() {
        return this.causes;
    }

    @Override
    public String getMessage() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.causes.size(); ++i) {
            Throwable cause = this.causes.get(i);
            builder.append(String.format("Exception %d: '[%s] %s'%n", i + 1, cause.getClass().getName(), cause.getMessage()));
        }
        return builder.toString();
    }
}

