/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import java.util.List;
import java.util.concurrent.ThreadFactory;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.threads.ThreadsServices;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public interface HandoffExecutorResolver {
    public static final HandoffExecutorResolver STANDARD_RESOLVER = new SimpleResolver(ThreadsServices.EXECUTOR);

    public ServiceName resolveHandoffExecutor(String var1, String var2, ServiceName var3, ServiceTarget var4, List<ServiceController<?>> var5, ServiceListener<? super ThreadFactory> ... var6);

    public void releaseHandoffExecutor(String var1, String var2, ServiceName var3, OperationContext var4);

    public static class SimpleResolver
    extends AbstractThreadFactoryResolver {
        final ServiceName handoffExecutorServiceNameBase;

        public SimpleResolver(ServiceName handoffExecutorServiceNameBase) {
            this.handoffExecutorServiceNameBase = handoffExecutorServiceNameBase;
        }

        @Override
        public ServiceName resolveNamedHandoffExecutor(String handoffExecutorName, String threadPoolName, ServiceName threadPoolServiceName) {
            return this.handoffExecutorServiceNameBase.append(new String[]{handoffExecutorName});
        }
    }

    public static abstract class AbstractThreadFactoryResolver
    implements HandoffExecutorResolver {
        @Override
        public ServiceName resolveHandoffExecutor(String handoffExecutorName, String threadPoolName, ServiceName threadPoolServiceName, ServiceTarget serviceTarget, List<ServiceController<?>> newControllers, ServiceListener<? super ThreadFactory> ... newServiceListeners) {
            ServiceName threadFactoryServiceName = null;
            threadFactoryServiceName = handoffExecutorName != null ? this.resolveNamedHandoffExecutor(handoffExecutorName, threadPoolName, threadPoolServiceName) : this.resolveDefaultHandoffExecutor(threadPoolName, threadPoolServiceName, serviceTarget, newControllers, newServiceListeners);
            return threadFactoryServiceName;
        }

        @Override
        public void releaseHandoffExecutor(String handoffExecutorName, String threadPoolName, ServiceName threadPoolServiceName, OperationContext context) {
            if (handoffExecutorName != null) {
                this.releaseNamedHandoffExecutor(handoffExecutorName, threadPoolName, threadPoolServiceName, context);
            } else {
                this.releaseDefaultHandoffExecutor(threadPoolServiceName, context);
            }
        }

        protected abstract ServiceName resolveNamedHandoffExecutor(String var1, String var2, ServiceName var3);

        protected void releaseNamedHandoffExecutor(String handoffExecutorName, String threadPoolName, ServiceName threadPoolServiceName, OperationContext context) {
        }

        protected ServiceName resolveDefaultHandoffExecutor(String threadPoolName, ServiceName threadPoolServiceName, ServiceTarget serviceTarget, List<ServiceController<?>> newControllers, ServiceListener<? super ThreadFactory> ... newServiceListeners) {
            return null;
        }

        protected void releaseDefaultHandoffExecutor(ServiceName threadPoolServiceName, OperationContext context) {
        }
    }
}

