/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloading.spi.metadata;

import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import org.jboss.classloader.plugins.filter.CombiningClassFilter;
import org.jboss.classloader.spi.filter.ClassFilter;
import org.jboss.classloader.spi.filter.PackageClassFilter;
import org.jboss.classloading.spi.helpers.NameAndVersionSupport;
import org.jboss.classloading.spi.metadata.CapabilitiesMetaData;
import org.jboss.classloading.spi.metadata.Capability;
import org.jboss.classloading.spi.metadata.ExportAll;
import org.jboss.classloading.spi.metadata.Requirement;
import org.jboss.classloading.spi.metadata.RequirementsMetaData;
import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementProperties;
import org.jboss.managed.api.annotation.ManagementProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ManagementObject(properties=ManagementProperties.EXPLICIT, name="org.jboss.classloading.spi.metadata.ClassLoadingMetaData")
public class ClassLoadingMetaData
extends NameAndVersionSupport {
    private static final long serialVersionUID = -2782951093046585620L;
    private String domain;
    private String parentDomain;
    private boolean j2seClassLoadingCompliance = true;
    private boolean cacheable = true;
    private boolean blackListable = true;
    private ExportAll exportAll;
    private boolean importAll;
    private String includedPackages;
    private String excludedPackages;
    private String excludedExportPackages;
    private ClassFilter included;
    private ClassFilter excluded;
    private ClassFilter excludedExport;
    private RequirementsMetaData requirements = new RequirementsMetaData();
    private CapabilitiesMetaData capabilities = new CapabilitiesMetaData();

    public String getDomain() {
        return this.domain;
    }

    @ManagementProperty
    @XmlAttribute
    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getParentDomain() {
        return this.parentDomain;
    }

    @ManagementProperty
    @XmlAttribute
    public void setParentDomain(String parentDomain) {
        this.parentDomain = parentDomain;
    }

    public ExportAll getExportAll() {
        return this.exportAll;
    }

    @ManagementProperty
    @XmlAttribute(name="export-all")
    public void setExportAll(ExportAll exportAll) {
        this.exportAll = exportAll;
    }

    public String getIncludedPackages() {
        return this.includedPackages;
    }

    @ManagementProperty(name="included")
    @XmlAttribute(name="included")
    public void setIncludedPackages(String includedPackages) {
        this.includedPackages = includedPackages;
    }

    public ClassFilter getIncluded() {
        PackageClassFilter packageFilter = null;
        if (this.includedPackages != null) {
            packageFilter = PackageClassFilter.createPackageClassFilterFromString((String)this.includedPackages);
        }
        if (packageFilter == null) {
            return this.included;
        }
        if (this.included == null) {
            return packageFilter;
        }
        return CombiningClassFilter.create((boolean)true, (ClassFilter[])new ClassFilter[]{packageFilter, this.included});
    }

    @XmlTransient
    public void setIncluded(ClassFilter included) {
        this.included = included;
    }

    public String getExcludedPackages() {
        return this.excludedPackages;
    }

    @ManagementProperty(name="excluded")
    @XmlAttribute(name="excluded")
    public void setExcludedPackages(String excludedPackages) {
        this.excludedPackages = excludedPackages;
    }

    public ClassFilter getExcluded() {
        PackageClassFilter packageFilter = null;
        if (this.excludedPackages != null) {
            packageFilter = PackageClassFilter.createPackageClassFilterFromString((String)this.excludedPackages);
        }
        if (packageFilter == null) {
            return this.excluded;
        }
        if (this.excluded == null) {
            return packageFilter;
        }
        return CombiningClassFilter.create((boolean)true, (ClassFilter[])new ClassFilter[]{packageFilter, this.excluded});
    }

    @XmlTransient
    public void setExcluded(ClassFilter excluded) {
        this.excluded = excluded;
    }

    public String getExcludedExportPackages() {
        return this.excludedExportPackages;
    }

    @ManagementProperty(name="excludedExport")
    @XmlAttribute(name="excludedExport")
    public void setExcludedExportPackages(String excludedExportPackages) {
        this.excludedExportPackages = excludedExportPackages;
    }

    public ClassFilter getExcludedExport() {
        PackageClassFilter packageFilter = null;
        if (this.excludedExportPackages != null) {
            packageFilter = PackageClassFilter.createPackageClassFilterFromString((String)this.excludedExportPackages);
        }
        if (packageFilter == null) {
            return this.excludedExport;
        }
        if (this.excludedExport == null) {
            return packageFilter;
        }
        return CombiningClassFilter.create((boolean)true, (ClassFilter[])new ClassFilter[]{packageFilter, this.excludedExport});
    }

    @XmlTransient
    public void setExcludedExport(ClassFilter excludedExport) {
        this.excludedExport = excludedExport;
    }

    public boolean isImportAll() {
        return this.importAll;
    }

    @ManagementProperty
    @XmlAttribute(name="import-all")
    public void setImportAll(boolean importAll) {
        this.importAll = importAll;
    }

    public boolean isJ2seClassLoadingCompliance() {
        return this.j2seClassLoadingCompliance;
    }

    @ManagementProperty(name="parentFirst")
    @XmlAttribute(name="parent-first")
    public void setJ2seClassLoadingCompliance(boolean classLoadingCompliance) {
        this.j2seClassLoadingCompliance = classLoadingCompliance;
    }

    public boolean isCacheable() {
        return this.cacheable;
    }

    @ManagementProperty(name="cache")
    @XmlAttribute(name="cache")
    public void setCacheable(boolean cacheable) {
        this.cacheable = cacheable;
    }

    public boolean isBlackListable() {
        return this.blackListable;
    }

    @ManagementProperty(name="blackList")
    @XmlAttribute(name="blackList")
    public void setBlackListable(boolean blackListable) {
        this.blackListable = blackListable;
    }

    public CapabilitiesMetaData getCapabilities() {
        return this.capabilities;
    }

    @ManagementProperty
    public void setCapabilities(CapabilitiesMetaData capabilities) {
        if (capabilities == null) {
            throw new IllegalArgumentException("Null capabilities");
        }
        this.capabilities = capabilities;
    }

    public void setCapabilities(List<Capability> capabilities) {
        if (this.capabilities == null) {
            this.capabilities = new CapabilitiesMetaData();
        }
        this.capabilities.setCapabilities(capabilities);
    }

    public RequirementsMetaData getRequirements() {
        return this.requirements;
    }

    @ManagementProperty
    public void setRequirements(RequirementsMetaData requirements) {
        if (requirements == null) {
            throw new IllegalArgumentException("Null requirements");
        }
        this.requirements = requirements;
    }

    public void setRequirements(List<Requirement> requirements) {
        if (this.requirements == null) {
            this.requirements = new RequirementsMetaData();
        }
        this.requirements.setRequirements(requirements);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append("@");
        builder.append(Integer.toHexString(System.identityHashCode(this)));
        builder.append("{");
        this.toString(builder);
        builder.append("}");
        return builder.toString();
    }

    protected void toString(StringBuilder builder) {
        List<Requirement> requirements;
        List<Capability> capabilities;
        ExportAll exportAll;
        String parentDomain;
        builder.append("name=").append(this.getName());
        builder.append(" version=").append(this.getVersion());
        String domain = this.getDomain();
        if (domain != null) {
            builder.append(" domain=").append(domain);
        }
        if ((parentDomain = this.getParentDomain()) != null) {
            builder.append(" parentDomain=").append(parentDomain);
        }
        if ((exportAll = this.getExportAll()) != null) {
            builder.append(" ").append((Object)exportAll);
        }
        if (this.isImportAll()) {
            builder.append(" IMPORT-ALL");
        }
        builder.append(" parent-first=").append(this.isJ2seClassLoadingCompliance());
        if (!this.isCacheable()) {
            builder.append(" NO-CACHE");
        }
        if (!this.isBlackListable()) {
            builder.append(" NO-BLACK-LIST");
        }
        if ((capabilities = this.getCapabilities().getCapabilities()) != null) {
            builder.append(" capabilities=").append(capabilities);
        }
        if ((requirements = this.getRequirements().getRequirements()) != null) {
            builder.append(" requirements=").append(requirements);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof ClassLoadingMetaData)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ClassLoadingMetaData other = (ClassLoadingMetaData)obj;
        if (!ClassLoadingMetaData.equals(this.getDomain(), other.getDomain())) {
            return false;
        }
        if (!ClassLoadingMetaData.equals(this.getParentDomain(), other.getParentDomain())) {
            return false;
        }
        if (!ClassLoadingMetaData.equals((Object)this.getExportAll(), (Object)other.getExportAll())) {
            return false;
        }
        if (this.isImportAll() != other.isImportAll()) {
            return false;
        }
        if (this.isJ2seClassLoadingCompliance() != other.isJ2seClassLoadingCompliance()) {
            return false;
        }
        if (this.isCacheable() != other.isCacheable()) {
            return false;
        }
        if (this.isBlackListable() != other.isBlackListable()) {
            return false;
        }
        if (!ClassLoadingMetaData.equals(this.getCapabilities().getCapabilities(), other.getCapabilities().getCapabilities())) {
            return false;
        }
        return ClassLoadingMetaData.equals(this.getRequirements().getRequirements(), other.getRequirements().getRequirements());
    }

    private static boolean equals(Object one, Object two) {
        if (one == null && two == null) {
            return true;
        }
        if (one == null && two != null) {
            return false;
        }
        return one.equals(two);
    }

    @Override
    public ClassLoadingMetaData clone() {
        ClassLoadingMetaData clone = (ClassLoadingMetaData)super.clone();
        this.requirements = clone.requirements.clone();
        this.capabilities = clone.capabilities.clone();
        return clone;
    }
}

