/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.jboss.forge.roaster._shade.org.eclipse.core.resources.IProject;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.IClasspathAttribute;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.IClasspathEntry;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.IModuleDescription;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.JavaCore;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.JavaModelException;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.compiler.CharOperation;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.compiler.env.IUpdatableModule;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.compiler.lookup.ModuleBinding;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.ClasspathEntry;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.JavaModel;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.JavaModelStatus;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.JavaProject;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.util.Util;

public class ModuleUpdater {
    private JavaProject javaProoject;
    private Map<String, IUpdatableModule.UpdatesByKind> moduleUpdates = new HashMap<String, IUpdatableModule.UpdatesByKind>();

    public ModuleUpdater(JavaProject javaProject) {
        this.javaProoject = javaProject;
    }

    public void computeModuleUpdates(IClasspathEntry entry) throws JavaModelException {
        IClasspathAttribute[] iClasspathAttributeArray = entry.getExtraAttributes();
        int n = iClasspathAttributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            String value;
            int n3;
            int n4;
            String[] stringArray;
            IClasspathAttribute attribute = iClasspathAttributeArray[n2];
            String attributeName = attribute.getName();
            String values = attribute.getValue();
            if (attributeName.equals("add-exports")) {
                stringArray = values.split(":");
                n4 = stringArray.length;
                n3 = 0;
                while (n3 < n4) {
                    value = stringArray[n3];
                    int slash = value.indexOf(47);
                    int equals = value.indexOf(61);
                    if (slash != -1 && equals != -1) {
                        String modName = value.substring(0, slash);
                        char[] packName = value.substring(slash + 1, equals).toCharArray();
                        char[][] targets = CharOperation.splitOn(',', value.substring(equals + 1).toCharArray());
                        this.addModuleUpdate(modName, new IUpdatableModule.AddExports(packName, targets), IUpdatableModule.UpdateKind.PACKAGE);
                    } else {
                        Util.log(2, "Invalid argument to add-exports: " + value);
                    }
                    ++n3;
                }
            } else if (attributeName.equals("add-reads")) {
                stringArray = values.split(":");
                n4 = stringArray.length;
                n3 = 0;
                while (n3 < n4) {
                    value = stringArray[n3];
                    int equals = value.indexOf(61);
                    if (equals != -1) {
                        String srcMod = value.substring(0, equals);
                        char[] targetMod = value.substring(equals + 1).toCharArray();
                        this.addModuleUpdate(srcMod, new IUpdatableModule.AddReads(targetMod), IUpdatableModule.UpdateKind.MODULE);
                    } else {
                        Util.log(2, "Invalid argument to add-reads: " + value);
                    }
                    ++n3;
                }
            } else if (attributeName.equals("module-main-class")) {
                IModuleDescription module = this.javaProoject.getModuleDescription();
                if (module == null) {
                    throw new JavaModelException(new JavaModelStatus(969));
                }
                this.addModuleUpdate(module.getElementName(), m -> m.setMainClassName(values.toCharArray()), IUpdatableModule.UpdateKind.MODULE);
            }
            ++n2;
        }
    }

    public void addModuleUpdate(String moduleName, Consumer<IUpdatableModule> update, IUpdatableModule.UpdateKind kind) {
        IUpdatableModule.UpdatesByKind updates = this.moduleUpdates.get(moduleName);
        if (updates == null) {
            updates = new IUpdatableModule.UpdatesByKind();
            this.moduleUpdates.put(moduleName, updates);
        }
        updates.getList(kind, true).add(update);
    }

    public void applyModuleUpdates(IUpdatableModule compilerModule, IUpdatableModule.UpdateKind kind) {
        IUpdatableModule.UpdatesByKind updates;
        char[] name = compilerModule.name();
        if (name != ModuleBinding.UNNAMED && (updates = this.moduleUpdates.get(String.valueOf(name))) != null) {
            for (Consumer<IUpdatableModule> update : updates.getList(kind, false)) {
                update.accept(compilerModule);
            }
        }
    }

    private static boolean containsNonModularDependency(IClasspathEntry[] entries) {
        IClasspathEntry[] iClasspathEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry e = iClasspathEntryArray[n2];
            if (e.getEntryKind() != 3 && !((ClasspathEntry)e).isModular()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void addReadUnnamedForNonEmptyClasspath(JavaProject project, IClasspathEntry[] expandedClasspath) throws JavaModelException {
        for (String moduleName : ModuleUpdater.determineModulesOfProjectsWithNonEmptyClasspath(project, expandedClasspath)) {
            this.addModuleUpdate(moduleName, m -> m.addReads(ModuleBinding.ALL_UNNAMED), IUpdatableModule.UpdateKind.MODULE);
        }
    }

    public static Set<String> determineModulesOfProjectsWithNonEmptyClasspath(JavaProject project, IClasspathEntry[] expandedClasspath) throws JavaModelException {
        IModuleDescription moduleDescription;
        LinkedHashSet<String> list = new LinkedHashSet<String>();
        if (ModuleUpdater.containsNonModularDependency(expandedClasspath) && (moduleDescription = project.getModuleDescription()) != null) {
            list.add(moduleDescription.getElementName());
        }
        IClasspathEntry[] iClasspathEntryArray = expandedClasspath;
        int n = expandedClasspath.length;
        int n2 = 0;
        while (n2 < n) {
            IModuleDescription prereqModuleDescription;
            JavaProject prereqJavaProject;
            IProject prereqProject;
            Object target;
            IClasspathEntry e1 = iClasspathEntryArray[n2];
            if (e1.getEntryKind() == 2 && (target = JavaModel.getTarget(e1.getPath(), true)) instanceof IProject && JavaProject.hasJavaNature(prereqProject = (IProject)target) && ModuleUpdater.containsNonModularDependency((prereqJavaProject = (JavaProject)JavaCore.create(prereqProject)).getResolvedClasspath()) && (prereqModuleDescription = prereqJavaProject.getModuleDescription()) != null) {
                list.add(prereqModuleDescription.getElementName());
            }
            ++n2;
        }
        return list;
    }

    public IUpdatableModule.UpdatesByKind getUpdates(String moduleName) {
        return this.moduleUpdates.get(moduleName);
    }
}

