/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.nd.java.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.compiler.CharOperation;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.compiler.classfmt.BinaryTypeFormatter;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.compiler.classfmt.ElementValuePairInfo;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.compiler.env.ClassSignature;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.compiler.env.EnumConstantSignature;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.compiler.env.IBinaryAnnotation;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.compiler.env.IBinaryElementValuePair;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.compiler.env.IBinaryField;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.compiler.env.IBinaryMethod;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.compiler.env.IBinaryNestedType;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.compiler.env.IBinaryTypeAnnotation;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.compiler.env.ITypeAnnotationWalker;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.compiler.impl.Constant;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.nd.IReader;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.nd.db.IString;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.nd.java.JavaNames;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.nd.java.NdAnnotation;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.nd.java.NdAnnotationValuePair;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.nd.java.NdConstant;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.nd.java.NdConstantAnnotation;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.nd.java.NdConstantArray;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.nd.java.NdConstantClass;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.nd.java.NdConstantEnum;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.nd.java.NdMethod;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.nd.java.NdMethodException;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.nd.java.NdMethodParameter;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.nd.java.NdResourceFile;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.nd.java.NdType;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.nd.java.NdTypeAnnotation;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.nd.java.NdTypeId;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.nd.java.NdTypeInterface;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.nd.java.NdTypeParameter;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.nd.java.NdTypeSignature;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.nd.java.NdVariable;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.nd.java.TypeRef;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.nd.java.model.IndexBinaryField;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.nd.java.model.IndexBinaryMethod;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.nd.java.model.IndexBinaryNestedType;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.nd.java.model.IndexBinaryTypeAnnotation;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.util.CharArrayBuffer;

public class IndexBinaryType
implements IBinaryType {
    private final TypeRef typeRef;
    private boolean simpleAttributesInitialized;
    private char[] enclosingMethod;
    private char[] enclosingType;
    private char[] fileName;
    private char[] superclassName;
    private int modifiers;
    private boolean isAnonymous;
    private boolean isLocal;
    private boolean isMember;
    private long tagBits;
    private char[] binaryTypeName;
    private static final IBinaryAnnotation[] NO_ANNOTATIONS = new IBinaryAnnotation[0];
    private static final int[] NO_PATH = new int[0];

    public IndexBinaryType(TypeRef type, char[] indexPath) {
        this.typeRef = type;
        this.fileName = indexPath;
    }

    public boolean exists() {
        return this.typeRef.get() != null;
    }

    @Override
    public int getModifiers() {
        this.initSimpleAttributes();
        return this.modifiers;
    }

    @Override
    public boolean isBinaryType() {
        return true;
    }

    @Override
    public char[] getFileName() {
        return this.fileName;
    }

    @Override
    public IBinaryAnnotation[] getAnnotations() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (IReader rl = this.typeRef.lock();){
            NdType type = this.typeRef.get();
            if (type != null) {
                return IndexBinaryType.toAnnotationArray(this.typeRef.get().getAnnotations());
            }
            return NO_ANNOTATIONS;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static IBinaryAnnotation[] toAnnotationArray(List<? extends NdAnnotation> annotations) {
        if (annotations.isEmpty()) {
            return NO_ANNOTATIONS;
        }
        IBinaryAnnotation[] result = new IBinaryAnnotation[annotations.size()];
        int idx = 0;
        while (idx < result.length) {
            result[idx] = IndexBinaryType.createBinaryAnnotation(annotations.get(idx));
            ++idx;
        }
        return result;
    }

    @Override
    public IBinaryTypeAnnotation[] getTypeAnnotations() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (IReader rl = this.typeRef.lock();){
            NdType type = this.typeRef.get();
            if (type != null) {
                return IndexBinaryType.createBinaryTypeAnnotations(type.getTypeAnnotations());
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return null;
    }

    @Override
    public char[] getEnclosingMethod() {
        this.initSimpleAttributes();
        return this.enclosingMethod;
    }

    @Override
    public char[] getEnclosingTypeName() {
        this.initSimpleAttributes();
        return this.enclosingType;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IBinaryField[] getFields() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (IReader rl = this.typeRef.lock();){
            NdType type = this.typeRef.get();
            if (type == null) return null;
            List<NdVariable> variables = type.getVariables();
            if (variables.isEmpty()) {
                return null;
            }
            IBinaryField[] result = new IBinaryField[variables.size()];
            int fieldIdx = 0;
            while (true) {
                if (fieldIdx >= variables.size()) {
                    return result;
                }
                result[fieldIdx] = IndexBinaryType.createBinaryField(variables.get(fieldIdx));
                ++fieldIdx;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public char[] getGenericSignature() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (IReader rl = this.typeRef.lock();){
            NdType type = this.typeRef.get();
            if (type == null) return null;
            if (!type.getFlag((byte)8)) {
                return null;
            }
            CharArrayBuffer buffer = new CharArrayBuffer();
            NdTypeParameter.getSignature(buffer, type.getTypeParameters());
            NdTypeSignature superclass = type.getSuperclass();
            if (superclass != null) {
                superclass.getSignature(buffer);
            }
            Iterator<NdTypeInterface> iterator = type.getInterfaces().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return buffer.getContents();
                }
                NdTypeInterface nextInterface = iterator.next();
                nextInterface.getInterface().getSignature(buffer);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public char[][] getInterfaceNames() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (IReader rl = this.typeRef.lock();){
            NdType type = this.typeRef.get();
            if (type == null) return null;
            List<NdTypeInterface> interfaces = type.getInterfaces();
            if (interfaces.isEmpty()) {
                return null;
            }
            char[][] result = new char[interfaces.size()][];
            int idx = 0;
            while (true) {
                if (idx >= interfaces.size()) {
                    return result;
                }
                NdTypeSignature nextInterface = interfaces.get(idx).getInterface();
                result[idx] = nextInterface.getRawType().getBinaryName();
                ++idx;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IBinaryNestedType[] getMemberTypes() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (IReader rl = this.typeRef.lock();){
            IBinaryNestedType[] iBinaryNestedTypeArray;
            NdType type = this.typeRef.get();
            if (type == null) return null;
            List<NdType> declaredTypes = type.getTypeId().getDeclaredTypes();
            if (declaredTypes.isEmpty()) {
                return null;
            }
            NdResourceFile resFile = type.getResourceFile();
            IString javaRoot = resFile.getPackageFragmentRoot();
            ArrayList<IBinaryNestedType> result = new ArrayList<IBinaryNestedType>();
            Iterator<NdType> iterator = declaredTypes.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    if (!result.isEmpty()) break;
                    iBinaryNestedTypeArray = null;
                    return iBinaryNestedTypeArray;
                }
                NdType next = iterator.next();
                NdResourceFile nextResFile = next.getResourceFile();
                if (nextResFile.getPackageFragmentRoot().compare(javaRoot, true) != 0) continue;
                result.add(this.createBinaryNestedType(next));
            }
            iBinaryNestedTypeArray = result.toArray(new IBinaryNestedType[result.size()]);
            return iBinaryNestedTypeArray;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    private IBinaryNestedType createBinaryNestedType(NdType next) {
        return new IndexBinaryNestedType(next.getTypeId().getBinaryName(), next.getDeclaringType().getBinaryName(), next.getModifiers());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IBinaryMethod[] getMethods() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (IReader rl = this.typeRef.lock();){
            NdType type = this.typeRef.get();
            if (type == null) return null;
            List<NdMethod> methods = type.getMethodsInDeclarationOrder();
            if (methods.isEmpty()) {
                return null;
            }
            IBinaryMethod[] result = new IBinaryMethod[methods.size()];
            int idx = 0;
            while (true) {
                if (idx >= result.length) {
                    return result;
                }
                result[idx] = this.createBinaryMethod(methods.get(idx));
                ++idx;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public char[][][] getMissingTypeNames() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (IReader rl = this.typeRef.lock();){
            NdType type = this.typeRef.get();
            if (type == null) return null;
            IString string = type.getMissingTypeNames();
            if (string.length() == 0) {
                return null;
            }
            char[] missingTypeNames = string.getChars();
            char[][] paths = CharOperation.splitOn(',', missingTypeNames);
            char[][][] result = new char[paths.length][][];
            int idx = 0;
            while (true) {
                if (idx >= paths.length) {
                    return result;
                }
                result[idx] = CharOperation.splitOn('/', paths[idx]);
                ++idx;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    @Override
    public char[] getName() {
        this.initSimpleAttributes();
        return this.binaryTypeName;
    }

    @Override
    public char[] getSourceName() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (IReader rl = this.typeRef.lock();){
            NdType type = this.typeRef.get();
            if (type != null) {
                return type.getSourceName();
            }
            return new char[0];
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public char[] getSuperclassName() {
        this.initSimpleAttributes();
        return this.superclassName;
    }

    @Override
    public long getTagBits() {
        this.initSimpleAttributes();
        return this.tagBits;
    }

    @Override
    public boolean isAnonymous() {
        this.initSimpleAttributes();
        return this.isAnonymous;
    }

    @Override
    public boolean isLocal() {
        this.initSimpleAttributes();
        return this.isLocal;
    }

    @Override
    public boolean isMember() {
        this.initSimpleAttributes();
        return this.isMember;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public char[] sourceFileName() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (IReader rl = this.typeRef.lock();){
            NdType type = this.typeRef.get();
            if (type == null) return null;
            char[] result = type.getSourceFileName().getChars();
            if (result.length != 0) return result;
            return null;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    @Override
    public ITypeAnnotationWalker enrichWithExternalAnnotationsFor(ITypeAnnotationWalker walker, Object member, LookupEnvironment environment) {
        return walker;
    }

    private IBinaryMethod createBinaryMethod(NdMethod ndMethod) {
        return IndexBinaryMethod.create().setAnnotations(IndexBinaryType.toAnnotationArray(ndMethod.getAnnotations())).setModifiers(ndMethod.getModifiers()).setIsConstructor(ndMethod.isConstructor()).setArgumentNames(this.getArgumentNames(ndMethod)).setDefaultValue(IndexBinaryType.unpackValue(ndMethod.getDefaultValue())).setExceptionTypeNames(this.getExceptionTypeNames(ndMethod)).setGenericSignature(IndexBinaryType.getGenericSignatureFor(ndMethod)).setMethodDescriptor(ndMethod.getMethodDescriptor()).setParameterAnnotations(this.getParameterAnnotations(ndMethod)).setSelector(ndMethod.getSelector()).setTagBits(ndMethod.getTagBits()).setIsClInit(ndMethod.isClInit()).setTypeAnnotations(IndexBinaryType.createBinaryTypeAnnotations(ndMethod.getTypeAnnotations()));
    }

    private static IBinaryTypeAnnotation[] createBinaryTypeAnnotations(List<? extends NdTypeAnnotation> typeAnnotations) {
        if (typeAnnotations.isEmpty()) {
            return null;
        }
        IBinaryTypeAnnotation[] result = new IBinaryTypeAnnotation[typeAnnotations.size()];
        int idx = 0;
        for (NdTypeAnnotation ndTypeAnnotation : typeAnnotations) {
            IBinaryAnnotation annotation = IndexBinaryType.createBinaryAnnotation(ndTypeAnnotation);
            int[] typePath = IndexBinaryType.getTypePath(ndTypeAnnotation.getTypePath());
            int info = 0;
            byte info2 = 0;
            switch (ndTypeAnnotation.getTargetType()) {
                case 0: 
                case 1: {
                    info = ndTypeAnnotation.getTargetInfoArg0();
                    break;
                }
                case 16: {
                    info = ndTypeAnnotation.getTarget();
                    break;
                }
                case 17: 
                case 18: {
                    info = ndTypeAnnotation.getTargetInfoArg0();
                    info2 = ndTypeAnnotation.getTargetInfoArg1();
                    break;
                }
                case 19: 
                case 20: 
                case 21: {
                    break;
                }
                case 22: {
                    info = ndTypeAnnotation.getTarget();
                    break;
                }
                case 23: {
                    info = ndTypeAnnotation.getTarget();
                    break;
                }
                default: {
                    throw new IllegalStateException("Target type not handled " + ndTypeAnnotation.getTargetType());
                }
            }
            result[idx++] = new IndexBinaryTypeAnnotation(ndTypeAnnotation.getTargetType(), info, info2, typePath, annotation);
        }
        return result;
    }

    private static int[] getTypePath(byte[] typePath) {
        if (typePath.length == 0) {
            return NO_PATH;
        }
        int[] result = new int[typePath.length];
        int idx = 0;
        while (idx < typePath.length) {
            result[idx] = typePath[idx];
            ++idx;
        }
        return result;
    }

    private static char[] getGenericSignatureFor(NdMethod method) {
        if (!method.hasAllFlags(1)) {
            return null;
        }
        CharArrayBuffer result = new CharArrayBuffer();
        method.getGenericSignature(result, method.hasAllFlags(2));
        return result.getContents();
    }

    private char[][] getArgumentNames(NdMethod ndMethod) {
        char[][] result = ndMethod.getParameterNames();
        int lastNonEmpty = -1;
        int idx = 0;
        while (idx < result.length) {
            if (result[idx] != null && result[idx].length != 0) {
                lastNonEmpty = idx;
            }
            ++idx;
        }
        if (lastNonEmpty != result.length - 1) {
            char[][] newResult = new char[lastNonEmpty + 1][];
            System.arraycopy(result, 0, newResult, 0, lastNonEmpty + 1);
            return newResult;
        }
        return result;
    }

    private IBinaryAnnotation[][] getParameterAnnotations(NdMethod ndMethod) {
        List<NdMethodParameter> parameters = ndMethod.getMethodParameters();
        if (parameters.isEmpty()) {
            return null;
        }
        IBinaryAnnotation[][] result = new IBinaryAnnotation[parameters.size()][];
        int idx = 0;
        while (idx < parameters.size()) {
            NdMethodParameter next = parameters.get(idx);
            result[idx] = IndexBinaryType.toAnnotationArray(next.getAnnotations());
            ++idx;
        }
        return result;
    }

    private char[][] getExceptionTypeNames(NdMethod ndMethod) {
        List<NdMethodException> exceptions = ndMethod.getExceptions();
        char[][] result = new char[exceptions.size()][];
        int idx = 0;
        while (idx < exceptions.size()) {
            NdMethodException next = exceptions.get(idx);
            result[idx] = next.getExceptionType().getRawType().getBinaryName();
            ++idx;
        }
        return result;
    }

    public static IBinaryField createBinaryField(NdVariable ndVariable) {
        char[] name = ndVariable.getName().getChars();
        Constant constant = null;
        NdConstant ndConstant = ndVariable.getConstant();
        if (ndConstant != null) {
            constant = ndConstant.getConstant();
        }
        if (constant == null) {
            constant = Constant.NotAConstant;
        }
        NdTypeSignature type = ndVariable.getType();
        IBinaryTypeAnnotation[] typeAnnotationArray = IndexBinaryType.createBinaryTypeAnnotations(ndVariable.getTypeAnnotations());
        IBinaryAnnotation[] annotations = IndexBinaryType.toAnnotationArray(ndVariable.getAnnotations());
        CharArrayBuffer signature = new CharArrayBuffer();
        if (ndVariable.hasVariableFlag(1)) {
            type.getSignature(signature);
        }
        long tagBits = ndVariable.getTagBits();
        return new IndexBinaryField(annotations, constant, signature.getContents(), ndVariable.getModifiers(), name, tagBits, typeAnnotationArray, type.getRawType().getFieldDescriptor().getChars());
    }

    public static IBinaryAnnotation createBinaryAnnotation(NdAnnotation ndAnnotation) {
        List<NdAnnotationValuePair> elementValuePairs = ndAnnotation.getElementValuePairs();
        final IBinaryElementValuePair[] resultingPair = new IBinaryElementValuePair[elementValuePairs.size()];
        int idx = 0;
        while (idx < elementValuePairs.size()) {
            NdAnnotationValuePair next = elementValuePairs.get(idx);
            resultingPair[idx] = new ElementValuePairInfo(next.getName().getChars(), IndexBinaryType.unpackValue(next.getValue()));
            ++idx;
        }
        final char[] binaryName = JavaNames.fieldDescriptorToBinaryName(ndAnnotation.getType().getRawType().getFieldDescriptor().getChars());
        return new IBinaryAnnotation(){

            @Override
            public char[] getTypeName() {
                return binaryName;
            }

            @Override
            public IBinaryElementValuePair[] getElementValuePairs() {
                return resultingPair;
            }

            public String toString() {
                return BinaryTypeFormatter.annotationToString(this);
            }
        };
    }

    public void initSimpleAttributes() {
        if (!this.simpleAttributesInitialized) {
            this.simpleAttributesInitialized = true;
            Throwable throwable = null;
            Object var2_3 = null;
            try (IReader rl = this.typeRef.lock();){
                NdType type = this.typeRef.get();
                if (type != null) {
                    IString declaringMethod = type.getDeclaringMethod();
                    if (declaringMethod.length() != 0) {
                        char[] methodName = declaringMethod.getChars();
                        this.enclosingMethod = methodName;
                        this.enclosingType = type.getDeclaringType().getBinaryName();
                    } else {
                        NdTypeId typeId = type.getDeclaringType();
                        if (typeId != null) {
                            this.enclosingType = typeId.getBinaryName();
                        }
                    }
                    this.modifiers = type.getModifiers();
                    this.isAnonymous = type.isAnonymous();
                    this.isLocal = type.isLocal();
                    this.isMember = type.isMember();
                    this.tagBits = type.getTagBits();
                    NdTypeSignature superclass = type.getSuperclass();
                    this.superclassName = (char[])(superclass != null ? superclass.getRawType().getBinaryName() : null);
                    this.binaryTypeName = JavaNames.fieldDescriptorToBinaryName(type.getFieldDescriptor().getChars());
                } else {
                    this.binaryTypeName = JavaNames.fieldDescriptorToBinaryName(this.typeRef.getFieldDescriptor());
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private static Object unpackValue(NdConstant value) {
        if (value == null) {
            return null;
        }
        if (value instanceof NdConstantAnnotation) {
            NdConstantAnnotation annotation = (NdConstantAnnotation)value;
            return IndexBinaryType.createBinaryAnnotation(annotation.getValue());
        }
        if (value instanceof NdConstantArray) {
            NdConstantArray array = (NdConstantArray)value;
            List<NdConstant> arrayContents = array.getValue();
            Object[] result = new Object[arrayContents.size()];
            int idx = 0;
            while (idx < arrayContents.size()) {
                result[idx] = IndexBinaryType.unpackValue(arrayContents.get(idx));
                ++idx;
            }
            return result;
        }
        if (value instanceof NdConstantEnum) {
            NdConstantEnum ndConstantEnum = (NdConstantEnum)value;
            NdTypeSignature signature = ndConstantEnum.getType();
            return new EnumConstantSignature(signature.getRawType().getBinaryName(), ndConstantEnum.getValue());
        }
        if (value instanceof NdConstantClass) {
            NdConstantClass constant = (NdConstantClass)value;
            return new ClassSignature(constant.getValue().getRawType().getBinaryName());
        }
        return value.getConstant();
    }

    @Override
    public BinaryTypeBinding.ExternalAnnotationStatus getExternalAnnotationStatus() {
        return BinaryTypeBinding.ExternalAnnotationStatus.NOT_EEA_CONFIGURED;
    }

    @Override
    public char[] getModule() {
        return null;
    }
}

