/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.util;

import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.util.IConstantPool;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.util.IConstantPoolEntry;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.util.ClassFileStruct;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.util.ConstantPoolEntry;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.util.ConstantPoolEntry2;

public class ConstantPool
extends ClassFileStruct
implements IConstantPool {
    private int constantPoolCount;
    private int[] constantPoolOffset;
    private byte[] classFileBytes;

    ConstantPool(byte[] reference, int[] constantPoolOffset) {
        this.constantPoolCount = constantPoolOffset.length;
        this.constantPoolOffset = constantPoolOffset;
        this.classFileBytes = reference;
    }

    @Override
    public IConstantPoolEntry decodeEntry(int index) {
        ConstantPoolEntry constantPoolEntry = null;
        int kind = this.getEntryKind(index);
        switch (kind) {
            case 7: {
                constantPoolEntry = new ConstantPoolEntry();
                constantPoolEntry.reset();
                constantPoolEntry.setKind(kind);
                constantPoolEntry.setClassInfoNameIndex(this.u2At(this.classFileBytes, 1, this.constantPoolOffset[index]));
                constantPoolEntry.setClassInfoName(this.getUtf8ValueAt(constantPoolEntry.getClassInfoNameIndex()));
                break;
            }
            case 6: {
                constantPoolEntry = new ConstantPoolEntry();
                constantPoolEntry.reset();
                constantPoolEntry.setKind(kind);
                constantPoolEntry.setDoubleValue(this.doubleAt(this.classFileBytes, 1, this.constantPoolOffset[index]));
                break;
            }
            case 9: {
                constantPoolEntry = new ConstantPoolEntry();
                constantPoolEntry.reset();
                constantPoolEntry.setKind(kind);
                constantPoolEntry.reset();
                constantPoolEntry.setKind(kind);
                constantPoolEntry.setClassIndex(this.u2At(this.classFileBytes, 1, this.constantPoolOffset[index]));
                int declaringClassIndex = this.u2At(this.classFileBytes, 1, this.constantPoolOffset[constantPoolEntry.getClassIndex()]);
                constantPoolEntry.setClassName(this.getUtf8ValueAt(declaringClassIndex));
                constantPoolEntry.setNameAndTypeIndex(this.u2At(this.classFileBytes, 3, this.constantPoolOffset[index]));
                int fieldNameIndex = this.u2At(this.classFileBytes, 1, this.constantPoolOffset[constantPoolEntry.getNameAndTypeIndex()]);
                int fieldDescriptorIndex = this.u2At(this.classFileBytes, 3, this.constantPoolOffset[constantPoolEntry.getNameAndTypeIndex()]);
                constantPoolEntry.setFieldName(this.getUtf8ValueAt(fieldNameIndex));
                constantPoolEntry.setFieldDescriptor(this.getUtf8ValueAt(fieldDescriptorIndex));
                break;
            }
            case 10: 
            case 11: {
                constantPoolEntry = new ConstantPoolEntry();
                constantPoolEntry.reset();
                constantPoolEntry.setKind(kind);
                constantPoolEntry.reset();
                constantPoolEntry.setKind(kind);
                constantPoolEntry.setClassIndex(this.u2At(this.classFileBytes, 1, this.constantPoolOffset[index]));
                int declaringClassIndex = this.u2At(this.classFileBytes, 1, this.constantPoolOffset[constantPoolEntry.getClassIndex()]);
                constantPoolEntry.setClassName(this.getUtf8ValueAt(declaringClassIndex));
                constantPoolEntry.setNameAndTypeIndex(this.u2At(this.classFileBytes, 3, this.constantPoolOffset[index]));
                int methodNameIndex = this.u2At(this.classFileBytes, 1, this.constantPoolOffset[constantPoolEntry.getNameAndTypeIndex()]);
                int methodDescriptorIndex = this.u2At(this.classFileBytes, 3, this.constantPoolOffset[constantPoolEntry.getNameAndTypeIndex()]);
                constantPoolEntry.setMethodName(this.getUtf8ValueAt(methodNameIndex));
                constantPoolEntry.setMethodDescriptor(this.getUtf8ValueAt(methodDescriptorIndex));
                break;
            }
            case 4: {
                constantPoolEntry = new ConstantPoolEntry();
                constantPoolEntry.reset();
                constantPoolEntry.setKind(kind);
                constantPoolEntry.reset();
                constantPoolEntry.setKind(kind);
                constantPoolEntry.setFloatValue(this.floatAt(this.classFileBytes, 1, this.constantPoolOffset[index]));
                break;
            }
            case 3: {
                constantPoolEntry = new ConstantPoolEntry();
                constantPoolEntry.reset();
                constantPoolEntry.setKind(kind);
                constantPoolEntry.setIntegerValue(this.i4At(this.classFileBytes, 1, this.constantPoolOffset[index]));
                break;
            }
            case 5: {
                constantPoolEntry = new ConstantPoolEntry();
                constantPoolEntry.reset();
                constantPoolEntry.setKind(kind);
                constantPoolEntry.setLongValue(this.i8At(this.classFileBytes, 1, this.constantPoolOffset[index]));
                break;
            }
            case 12: {
                constantPoolEntry = new ConstantPoolEntry();
                constantPoolEntry.reset();
                constantPoolEntry.setKind(kind);
                constantPoolEntry.setNameAndTypeNameIndex(this.u2At(this.classFileBytes, 1, this.constantPoolOffset[index]));
                constantPoolEntry.setNameAndTypeDescriptorIndex(this.u2At(this.classFileBytes, 3, this.constantPoolOffset[index]));
                break;
            }
            case 8: {
                constantPoolEntry = new ConstantPoolEntry();
                constantPoolEntry.reset();
                constantPoolEntry.setKind(kind);
                constantPoolEntry.setStringIndex(this.u2At(this.classFileBytes, 1, this.constantPoolOffset[index]));
                constantPoolEntry.setStringValue(this.getUtf8ValueAt(constantPoolEntry.getStringIndex()));
                break;
            }
            case 1: {
                constantPoolEntry = new ConstantPoolEntry();
                constantPoolEntry.reset();
                constantPoolEntry.setKind(kind);
                constantPoolEntry.setUtf8Length(this.u2At(this.classFileBytes, 1, this.constantPoolOffset[index]));
                constantPoolEntry.setUtf8Value(this.getUtf8ValueAt(index));
                break;
            }
            case 15: {
                ConstantPoolEntry2 constantPoolEntry2 = new ConstantPoolEntry2();
                constantPoolEntry2.reset();
                constantPoolEntry2.setKind(kind);
                constantPoolEntry2.setReferenceKind(this.u1At(this.classFileBytes, 1, this.constantPoolOffset[index]));
                constantPoolEntry2.setReferenceIndex(this.u2At(this.classFileBytes, 2, this.constantPoolOffset[index]));
                constantPoolEntry = constantPoolEntry2;
                break;
            }
            case 16: {
                ConstantPoolEntry2 constantPoolEntry2 = new ConstantPoolEntry2();
                constantPoolEntry2.reset();
                constantPoolEntry2.setKind(kind);
                int methodDescriptorIndex = this.u2At(this.classFileBytes, 1, this.constantPoolOffset[index]);
                constantPoolEntry2.setDescriptorIndex(methodDescriptorIndex);
                constantPoolEntry2.setMethodDescriptor(this.getUtf8ValueAt(methodDescriptorIndex));
                constantPoolEntry = constantPoolEntry2;
                break;
            }
            case 18: {
                ConstantPoolEntry2 constantPoolEntry2 = new ConstantPoolEntry2();
                constantPoolEntry2.reset();
                constantPoolEntry2.setKind(kind);
                constantPoolEntry2.setBootstrapMethodAttributeIndex(this.u2At(this.classFileBytes, 1, this.constantPoolOffset[index]));
                int nameAndTypeIndex = this.u2At(this.classFileBytes, 3, this.constantPoolOffset[index]);
                constantPoolEntry2.setNameAndTypeIndex(nameAndTypeIndex);
                int methodNameIndex = this.u2At(this.classFileBytes, 1, this.constantPoolOffset[nameAndTypeIndex]);
                int methodDescriptorIndex = this.u2At(this.classFileBytes, 3, this.constantPoolOffset[nameAndTypeIndex]);
                constantPoolEntry2.setMethodName(this.getUtf8ValueAt(methodNameIndex));
                constantPoolEntry2.setMethodDescriptor(this.getUtf8ValueAt(methodDescriptorIndex));
                constantPoolEntry = constantPoolEntry2;
                break;
            }
            case 17: {
                ConstantPoolEntry2 constantPoolEntry2 = new ConstantPoolEntry2();
                constantPoolEntry2.reset();
                constantPoolEntry2.setKind(kind);
                constantPoolEntry2.setBootstrapMethodAttributeIndex(this.u2At(this.classFileBytes, 1, this.constantPoolOffset[index]));
                int nameAndTypeIndex2 = this.u2At(this.classFileBytes, 3, this.constantPoolOffset[index]);
                constantPoolEntry2.setNameAndTypeIndex(nameAndTypeIndex2);
                int fieldNameIndex = this.u2At(this.classFileBytes, 1, this.constantPoolOffset[nameAndTypeIndex2]);
                int fieldDescriptorIndex = this.u2At(this.classFileBytes, 3, this.constantPoolOffset[nameAndTypeIndex2]);
                constantPoolEntry2.setFieldName(this.getUtf8ValueAt(fieldNameIndex));
                constantPoolEntry2.setFieldDescriptor(this.getUtf8ValueAt(fieldDescriptorIndex));
                constantPoolEntry = constantPoolEntry2;
                break;
            }
            case 19: {
                ConstantPoolEntry2 constantPoolEntry2 = new ConstantPoolEntry2();
                constantPoolEntry2.reset();
                constantPoolEntry2.setKind(kind);
                int moduleIndex = this.u2At(this.classFileBytes, 1, this.constantPoolOffset[index]);
                constantPoolEntry2.setModuleIndex(moduleIndex);
                constantPoolEntry2.setModuleName(this.getUtf8ValueAt(moduleIndex));
                constantPoolEntry = constantPoolEntry2;
                break;
            }
            case 20: {
                ConstantPoolEntry2 constantPoolEntry2 = new ConstantPoolEntry2();
                constantPoolEntry2.reset();
                constantPoolEntry2.setKind(kind);
                int packageIndex = this.u2At(this.classFileBytes, 1, this.constantPoolOffset[index]);
                constantPoolEntry2.setPackageIndex(packageIndex);
                constantPoolEntry2.setPackageName(this.getUtf8ValueAt(packageIndex));
                constantPoolEntry = constantPoolEntry2;
            }
        }
        return constantPoolEntry;
    }

    @Override
    public int getConstantPoolCount() {
        return this.constantPoolCount;
    }

    @Override
    public int getEntryKind(int index) {
        return this.u1At(this.classFileBytes, 0, this.constantPoolOffset[index]);
    }

    private char[] getUtf8ValueAt(int utf8Index) {
        int utf8Offset = this.constantPoolOffset[utf8Index];
        return this.utf8At(this.classFileBytes, 0, utf8Offset + 3, this.u2At(this.classFileBytes, 0, utf8Offset + 1));
    }
}

