/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.loader.sources;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.container.ModuleRevision;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.container.ModuleWiring;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.framework.EquinoxBundle;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.framework.EquinoxContainer;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.loader.BundleLoader;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.loader.sources.SingleSourcePackage;
import org.jboss.forge.roaster._shade.org.osgi.framework.Bundle;
import org.jboss.forge.roaster._shade.org.osgi.framework.ServiceFactory;
import org.jboss.forge.roaster._shade.org.osgi.service.packageadmin.PackageAdmin;

public abstract class PackageSource {
    protected final String id;

    public PackageSource(String id) {
        this.id = id.intern();
    }

    public String getId() {
        return this.id;
    }

    public abstract SingleSourcePackage[] getSuppliers();

    public boolean compare(PackageSource other) {
        return this.id.equals(other.getId());
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean isNullSource() {
        return false;
    }

    public abstract Class<?> loadClass(String var1) throws ClassNotFoundException;

    public abstract URL getResource(String var1);

    public abstract Enumeration<URL> getResources(String var1) throws IOException;

    public boolean hasCommonSource(PackageSource other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        SingleSourcePackage[] suppliers1 = this.getSuppliers();
        SingleSourcePackage[] suppliers2 = other.getSuppliers();
        if (suppliers1 == null || suppliers2 == null) {
            return false;
        }
        SingleSourcePackage[] singleSourcePackageArray = suppliers1;
        int n = suppliers1.length;
        int n2 = 0;
        while (n2 < n) {
            SingleSourcePackage supplier1 = singleSourcePackageArray[n2];
            SingleSourcePackage[] singleSourcePackageArray2 = suppliers2;
            int n3 = suppliers2.length;
            int n4 = 0;
            while (n4 < n3) {
                SingleSourcePackage supplier2 = singleSourcePackageArray2[n4];
                if (supplier2.equals(supplier1)) {
                    return true;
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.id).append(" -> ");
        SingleSourcePackage[] suppliers = this.getSuppliers();
        if (suppliers == null) {
            return builder.append(String.valueOf(null)).toString();
        }
        builder.append('[');
        int i = 0;
        while (i < suppliers.length) {
            if (i > 0) {
                builder.append(',');
            }
            builder.append(suppliers[i].getLoader());
            ++i;
        }
        builder.append(']');
        return builder.toString();
    }

    public abstract Collection<String> listResources(String var1, String var2);

    public static boolean isServiceAssignableTo(Bundle registrant, Bundle client, String className, Class<?> serviceClass, boolean checkInternal, EquinoxContainer container) {
        if (registrant == client) {
            return true;
        }
        String pkgName = BundleLoader.getPackageName(className);
        if (pkgName.startsWith("java.")) {
            return true;
        }
        BundleLoader producerBL = PackageSource.getBundleLoader(registrant);
        if (producerBL == null) {
            return false;
        }
        BundleLoader consumerBL = PackageSource.getBundleLoader(client);
        if (consumerBL == null) {
            return false;
        }
        PackageSource consumerSource = PackageSource.getSourceFromLoader(consumerBL, pkgName, className, checkInternal, container.getPackageAdmin());
        if (consumerSource == null) {
            return true;
        }
        if (container.isBootDelegationPackage(pkgName)) {
            return true;
        }
        PackageSource producerSource = PackageSource.getSourceFromLoader(producerBL, pkgName, className, checkInternal, container.getPackageAdmin());
        if (producerSource == null) {
            Bundle bundle;
            if (serviceClass != null && ServiceFactory.class.isAssignableFrom(serviceClass) && (bundle = container.getPackageAdmin().getBundle(serviceClass)) != null && bundle != registrant) {
                return true;
            }
            producerSource = PackageSource.getPackageSource(serviceClass, pkgName, className, checkInternal, container.getPackageAdmin());
            if (producerSource == null) {
                return false;
            }
        }
        return producerSource.hasCommonSource(consumerSource);
    }

    private static PackageSource getSourceFromLoader(BundleLoader loader, String pkgName, String className, boolean checkInternal, PackageAdmin packageAdmin) {
        PackageSource source = loader.getPackageSource(pkgName);
        if (source != null || !checkInternal) {
            return source;
        }
        try {
            Bundle b;
            Class<?> clazz = loader.findLocalClass(className);
            if (clazz != null && (b = packageAdmin.getBundle(clazz)) != null) {
                if (loader.getWiring().getBundle() == b) {
                    return new SingleSourcePackage(pkgName, loader);
                }
                BundleLoader classBundleLoader = PackageSource.getBundleLoader(b);
                if (classBundleLoader != null) {
                    return new SingleSourcePackage(pkgName, classBundleLoader);
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {}
        return null;
    }

    private static PackageSource getPackageSource(Class<?> serviceClass, String pkgName, String className, boolean checkInternal, PackageAdmin packageAdmin) {
        Class<?>[] interfaces;
        if (serviceClass == null) {
            return null;
        }
        Bundle serviceBundle = packageAdmin.getBundle(serviceClass);
        if (serviceBundle == null) {
            return null;
        }
        BundleLoader producerBL = PackageSource.getBundleLoader(serviceBundle);
        if (producerBL == null) {
            return null;
        }
        PackageSource producerSource = PackageSource.getSourceFromLoader(producerBL, pkgName, className, checkInternal, packageAdmin);
        if (producerSource != null) {
            return producerSource;
        }
        Class<?>[] classArray = interfaces = serviceClass.getInterfaces();
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> intf = classArray[n2];
            producerSource = PackageSource.getPackageSource(intf, pkgName, className, checkInternal, packageAdmin);
            if (producerSource != null) {
                return producerSource;
            }
            ++n2;
        }
        return PackageSource.getPackageSource(serviceClass.getSuperclass(), pkgName, className, checkInternal, packageAdmin);
    }

    private static BundleLoader getBundleLoader(Bundle bundle) {
        ModuleRevision producer = ((EquinoxBundle)bundle).getModule().getCurrentRevision();
        ModuleWiring producerWiring = producer.getWiring();
        return producerWiring == null ? null : (BundleLoader)producerWiring.getModuleLoader();
    }
}

