/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.log;

import java.io.PrintStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jboss.forge.roaster._shade.org.eclipse.equinox.log.LogFilter;
import org.jboss.forge.roaster._shade.org.eclipse.equinox.log.SynchronousLogListener;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.framework.util.ArrayMap;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.framework.EquinoxContainer;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.log.ExtendedLogEntryImpl;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.log.ExtendedLogReaderServiceImpl;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.log.OrderedExecutor;
import org.jboss.forge.roaster._shade.org.osgi.framework.Bundle;
import org.jboss.forge.roaster._shade.org.osgi.framework.ServiceFactory;
import org.jboss.forge.roaster._shade.org.osgi.framework.ServiceReference;
import org.jboss.forge.roaster._shade.org.osgi.framework.ServiceRegistration;
import org.jboss.forge.roaster._shade.org.osgi.service.log.LogEntry;
import org.jboss.forge.roaster._shade.org.osgi.service.log.LogLevel;
import org.jboss.forge.roaster._shade.org.osgi.service.log.LogListener;

public class ExtendedLogReaderServiceFactory
implements ServiceFactory<ExtendedLogReaderServiceImpl> {
    static final int MAX_RECURSIONS = 50;
    private static final Enumeration<LogEntry> EMPTY_ENUMERATION = Collections.enumeration(Collections.EMPTY_LIST);
    static final LogFilter NULL_LOGGER_FILTER = new LogFilter(){

        @Override
        public boolean isLoggable(Bundle b, String loggerName, int logLevel) {
            return true;
        }
    };
    private static final LogFilter[] ALWAYS_LOG = new LogFilter[0];
    private static PrintStream errorStream;
    private final ReentrantReadWriteLock listenersLock = new ReentrantReadWriteLock();
    private ArrayMap<LogListener, Object[]> listeners = new ArrayMap(5);
    private LogFilter[] filters = null;
    private final ThreadLocal<int[]> nestedCallCount = new ThreadLocal();
    private final LinkedList<LogEntry> history;
    private final int maxHistory;
    private final LogLevel defaultLevel;
    private OrderedExecutor executor;

    static boolean safeIsLoggable(LogFilter filter, Bundle bundle, String name, int level) {
        try {
            return filter.isLoggable(bundle, name, level);
        }
        catch (LinkageError | RuntimeException e) {
            ExtendedLogReaderServiceFactory.getErrorStream().println("LogFilter.isLoggable threw a non-fatal unchecked exception as follows:");
            e.printStackTrace(ExtendedLogReaderServiceFactory.getErrorStream());
            return false;
        }
    }

    private static synchronized PrintStream getErrorStream() {
        if (errorStream == null) {
            return System.err;
        }
        return errorStream;
    }

    public static synchronized void setErrorStream(PrintStream ps) {
        errorStream = ps;
    }

    static void safeLogged(LogListener listener, LogEntry logEntry) {
        try {
            listener.logged(logEntry);
        }
        catch (LinkageError | RuntimeException e) {
            ExtendedLogReaderServiceFactory.getErrorStream().println("LogListener.logged threw a non-fatal unchecked exception as follows:");
            e.printStackTrace(ExtendedLogReaderServiceFactory.getErrorStream());
        }
    }

    public ExtendedLogReaderServiceFactory(int maxHistory, LogLevel defaultLevel) {
        this.defaultLevel = defaultLevel;
        this.maxHistory = maxHistory;
        this.history = maxHistory > 0 ? new LinkedList() : null;
    }

    public void start(EquinoxContainer equinoxContainer) {
        this.executor = new OrderedExecutor(equinoxContainer);
    }

    public void stop() {
        this.executor.shutdown();
    }

    public LogLevel getDefaultLogLevel() {
        return this.defaultLevel;
    }

    @Override
    public ExtendedLogReaderServiceImpl getService(Bundle bundle, ServiceRegistration<ExtendedLogReaderServiceImpl> registration) {
        return new ExtendedLogReaderServiceImpl(this);
    }

    @Override
    public void ungetService(Bundle bundle, ServiceRegistration<ExtendedLogReaderServiceImpl> registration, ExtendedLogReaderServiceImpl service) {
        service.shutdown();
    }

    boolean isLoggable(final Bundle bundle, final String name, final int level) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return ExtendedLogReaderServiceFactory.this.isLoggablePrivileged(bundle, name, level);
                }
            });
        }
        return this.isLoggablePrivileged(bundle, name, level);
    }

    boolean isLoggablePrivileged(Bundle bundle, String name, int level) {
        LogFilter[] filtersCopy;
        this.listenersLock.readLock().lock();
        try {
            filtersCopy = this.filters;
        }
        finally {
            this.listenersLock.readLock().unlock();
        }
        try {
            if (this.incrementNestedCount() == 50) {
                return false;
            }
            if (filtersCopy == null) {
                return false;
            }
            if (filtersCopy == ALWAYS_LOG) {
                return true;
            }
            int filtersLength = filtersCopy.length;
            int i = 0;
            while (i < filtersLength) {
                LogFilter filter = filtersCopy[i];
                if (ExtendedLogReaderServiceFactory.safeIsLoggable(filter, bundle, name, level)) {
                    return true;
                }
                ++i;
            }
        }
        finally {
            this.decrementNestedCount();
        }
        return false;
    }

    private int incrementNestedCount() {
        int[] count = this.getCount();
        count[0] = count[0] + 1;
        return count[0];
    }

    private void decrementNestedCount() {
        int[] count = this.getCount();
        if (count[0] == 0) {
            return;
        }
        count[0] = count[0] - 1;
    }

    private int[] getCount() {
        int[] count = this.nestedCallCount.get();
        if (count == null) {
            count = new int[1];
            this.nestedCallCount.set(count);
        }
        return count;
    }

    void log(final Bundle bundle, final String name, final StackTraceElement stackTraceElement, final Object context, final LogLevel logLevelEnum, final int level, final String message, final ServiceReference<?> ref, final Throwable exception) {
        if (System.getSecurityManager() != null) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    ExtendedLogReaderServiceFactory.this.logPrivileged(bundle, name, stackTraceElement, context, logLevelEnum, level, message, ref, exception);
                    return null;
                }
            });
        } else {
            this.logPrivileged(bundle, name, stackTraceElement, context, logLevelEnum, level, message, ref, exception);
        }
    }

    void logPrivileged(Bundle bundle, String name, StackTraceElement stackTraceElement, Object context, LogLevel logLevelEnum, int level, String message, ServiceReference<?> ref, Throwable exception) {
        ArrayMap<LogListener, Object[]> listenersCopy;
        ExtendedLogEntryImpl logEntry = new ExtendedLogEntryImpl(bundle, name, stackTraceElement, context, logLevelEnum, level, message, ref, exception);
        this.storeEntry(logEntry);
        this.listenersLock.readLock().lock();
        try {
            listenersCopy = this.listeners;
        }
        finally {
            this.listenersLock.readLock().unlock();
        }
        try {
            if (this.incrementNestedCount() >= 50) {
                return;
            }
            int size = listenersCopy.size();
            int i = 0;
            while (i < size) {
                Object[] listenerObjects = listenersCopy.getValue(i);
                LogFilter filter = (LogFilter)listenerObjects[0];
                if (ExtendedLogReaderServiceFactory.safeIsLoggable(filter, bundle, name, level)) {
                    LogListener listener = listenersCopy.getKey(i);
                    OrderedExecutor.OrderedTaskQueue orderedTaskQueue = (OrderedExecutor.OrderedTaskQueue)listenerObjects[1];
                    if (orderedTaskQueue != null) {
                        orderedTaskQueue.execute(new LogTask(logEntry, listener), size);
                    } else {
                        ExtendedLogReaderServiceFactory.safeLogged(listener, logEntry);
                    }
                }
                ++i;
            }
        }
        finally {
            this.decrementNestedCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeEntry(LogEntry logEntry) {
        if (this.history != null) {
            LinkedList<LogEntry> linkedList = this.history;
            synchronized (linkedList) {
                if (this.history.size() == this.maxHistory) {
                    this.history.removeLast();
                }
                this.history.addFirst(logEntry);
            }
        }
    }

    void addLogListener(LogListener listener, LogFilter filter) {
        this.listenersLock.writeLock().lock();
        try {
            ArrayMap<LogListener, Object[]> listenersCopy = new ArrayMap<LogListener, Object[]>(this.listeners.getKeys(), this.listeners.getValues());
            Object[] listenerObjects = listenersCopy.get(listener);
            if (listenerObjects == null) {
                OrderedExecutor.OrderedTaskQueue taskQueue = listener instanceof SynchronousLogListener ? null : this.executor.createQueue();
                listenerObjects = new Object[]{filter, taskQueue};
            } else if (filter != listenerObjects[0]) {
                listenerObjects[0] = filter;
            }
            listenersCopy.put(listener, listenerObjects);
            this.recalculateFilters(listenersCopy);
            this.listeners = listenersCopy;
        }
        finally {
            this.listenersLock.writeLock().unlock();
        }
    }

    private void recalculateFilters(ArrayMap<LogListener, Object[]> listenersCopy) {
        ArrayList<LogFilter> filtersList = new ArrayList<LogFilter>();
        int size = listenersCopy.size();
        int i = 0;
        while (i < size) {
            Object[] listenerObjects = listenersCopy.getValue(i);
            LogFilter filter = (LogFilter)listenerObjects[0];
            if (filter == NULL_LOGGER_FILTER) {
                this.filters = ALWAYS_LOG;
                return;
            }
            filtersList.add(filter);
            ++i;
        }
        if (filtersList.isEmpty()) {
            this.filters = null;
        }
        this.filters = filtersList.toArray(new LogFilter[filtersList.size()]);
    }

    void removeLogListener(LogListener listener) {
        this.listenersLock.writeLock().lock();
        try {
            ArrayMap<LogListener, Object[]> listenersCopy = new ArrayMap<LogListener, Object[]>(this.listeners.getKeys(), this.listeners.getValues());
            listenersCopy.remove(listener);
            this.recalculateFilters(listenersCopy);
            this.listeners = listenersCopy;
        }
        finally {
            this.listenersLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Enumeration<LogEntry> getLog() {
        if (this.history == null) {
            return EMPTY_ENUMERATION;
        }
        LinkedList<LogEntry> linkedList = this.history;
        synchronized (linkedList) {
            return Collections.enumeration(new ArrayList<LogEntry>(this.history));
        }
    }

    static final class LogTask
    implements Runnable {
        private final LogEntry logEntry;
        private final LogListener listener;

        LogTask(LogEntry logEntry, LogListener listener) {
            this.logEntry = logEntry;
            this.listener = listener;
        }

        @Override
        public void run() {
            ExtendedLogReaderServiceFactory.safeLogged(this.listener, this.logEntry);
        }
    }
}

