/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster.model.impl;

import org.jboss.forge.roaster.model.JavaType;
import org.jboss.forge.roaster.model.source.Import;
import org.jboss.forge.roaster.model.source.Importer;
import org.jboss.forge.roaster.spi.WildcardImportResolver;

public class ClassLoaderWildcardImportResolver
implements WildcardImportResolver {
    public String resolve(JavaType<?> source, String type) {
        if (source instanceof Importer) {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            Importer importer = (Importer)source;
            for (Import importDeclaration : importer.getImports()) {
                if (!importDeclaration.isWildcard()) continue;
                String resolvedClass = importDeclaration.getQualifiedName() + "." + type;
                try {
                    contextClassLoader.loadClass(resolvedClass);
                    return resolvedClass;
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
        }
        return type;
    }
}

