/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager;

import java.security.Permission;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.LoggingPermission;
import org.jboss.logmanager.AtomicArray;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.handlers.FlushableCloseable;

public abstract class ExtHandler
extends Handler
implements FlushableCloseable {
    private static final Permission CONTROL_PERMISSION = new LoggingPermission("control", null);
    private volatile boolean autoFlush;
    protected volatile Handler[] handlers;
    protected static final AtomicArray<ExtHandler, Handler> handlersUpdater = AtomicArray.create(AtomicReferenceFieldUpdater.newUpdater(ExtHandler.class, Handler[].class, "handlers"), Handler.class);

    protected ExtHandler() {
        handlersUpdater.clear(this);
    }

    @Override
    public final void publish(LogRecord record) {
        if (record != null && this.isLoggable(record)) {
            this.doPublish(ExtLogRecord.wrap(record));
        }
    }

    public final void publish(ExtLogRecord record) {
        if (record != null && this.isLoggable(record)) {
            this.doPublish(record);
        }
    }

    protected void doPublish(ExtLogRecord record) {
        if (this.autoFlush) {
            this.flush();
        }
    }

    public void addHandler(Handler handler) throws SecurityException {
        ExtHandler.checkAccess();
        if (handler == null) {
            throw new NullPointerException("handler is null");
        }
        handlersUpdater.add(this, handler);
    }

    public void removeHandler(Handler handler) throws SecurityException {
        ExtHandler.checkAccess();
        if (handler == null) {
            return;
        }
        handlersUpdater.remove(this, handler, true);
    }

    public Handler[] getHandlers() {
        Handler[] handlers = this.handlers;
        return handlers.length > 0 ? (Handler[])handlers.clone() : handlers;
    }

    public Handler[] clearHandlers() throws SecurityException {
        ExtHandler.checkAccess();
        Handler[] handlers = this.handlers;
        handlersUpdater.clear(this);
        return handlers.length > 0 ? (Handler[])handlers.clone() : handlers;
    }

    public Handler[] setHandlers(Handler[] newHandlers) throws SecurityException {
        if (newHandlers == null) {
            throw new IllegalArgumentException("newHandlers is null");
        }
        if (newHandlers.length == 0) {
            return this.clearHandlers();
        }
        ExtHandler.checkAccess();
        Handler[] handlers = handlersUpdater.getAndSet(this, (Handler[])newHandlers);
        return handlers.length > 0 ? (Handler[])handlers.clone() : handlers;
    }

    public boolean isAutoFlush() {
        return this.autoFlush;
    }

    public void setAutoFlush(boolean autoFlush) throws SecurityException {
        ExtHandler.checkAccess();
        this.autoFlush = autoFlush;
    }

    protected static void checkAccess() throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(CONTROL_PERMISSION);
        }
    }
}

