/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.poi.excel.export.template;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.jeecgframework.poi.cache.ExcelCache;
import org.jeecgframework.poi.cache.ImageCache;
import org.jeecgframework.poi.entity.ImageEntity;
import org.jeecgframework.poi.excel.annotation.ExcelTarget;
import org.jeecgframework.poi.excel.entity.TemplateExportParams;
import org.jeecgframework.poi.excel.entity.enmus.ExcelType;
import org.jeecgframework.poi.excel.entity.params.ExcelExportEntity;
import org.jeecgframework.poi.excel.entity.params.ExcelForEachParams;
import org.jeecgframework.poi.excel.entity.params.ExcelTemplateParams;
import org.jeecgframework.poi.excel.export.base.ExcelExportBase;
import org.jeecgframework.poi.excel.export.styler.IExcelExportStyler;
import org.jeecgframework.poi.excel.html.helper.MergedRegionHelper;
import org.jeecgframework.poi.exception.excel.ExcelExportException;
import org.jeecgframework.poi.exception.excel.enums.ExcelExportEnum;
import org.jeecgframework.poi.util.PoiCellUtil;
import org.jeecgframework.poi.util.PoiElUtil;
import org.jeecgframework.poi.util.PoiExcelGraphDataUtil;
import org.jeecgframework.poi.util.PoiExcelTempUtil;
import org.jeecgframework.poi.util.PoiMergeCellUtil;
import org.jeecgframework.poi.util.PoiPublicUtil;
import org.jeecgframework.poi.util.PoiSheetUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExcelExportOfTemplateUtil
extends ExcelExportBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcelExportOfTemplateUtil.class);
    private Set<String> tempCreateCellSet = new HashSet<String>();
    private TemplateExportParams teplateParams;
    private MergedRegionHelper mergedRegionHelper;

    private void addDataToSheet(Class<?> pojoClass, Collection<?> dataSet, Sheet sheet, Workbook workbook) throws Exception {
        int index;
        if (workbook instanceof XSSFWorkbook) {
            this.type = ExcelType.XSSF;
        }
        Map<String, Integer> titlemap = this.getTitleMap(sheet);
        Drawing patriarch = sheet.createDrawingPatriarch();
        Field[] fileds = PoiPublicUtil.getClassFields(pojoClass);
        ExcelTarget etarget = pojoClass.getAnnotation(ExcelTarget.class);
        String targetId = null;
        if (etarget != null) {
            targetId = etarget.value();
        }
        ArrayList<ExcelExportEntity> excelParams = new ArrayList<ExcelExportEntity>();
        this.getAllExcelField(null, targetId, fileds, excelParams, pojoClass, null);
        this.sortAndFilterExportField(excelParams, titlemap);
        short rowHeight = this.getRowHeight(excelParams);
        int titleHeight = index = this.teplateParams.getHeadingRows() + this.teplateParams.getHeadingStartRow();
        sheet.shiftRows(this.teplateParams.getHeadingRows() + this.teplateParams.getHeadingStartRow(), sheet.getLastRowNum(), this.getShiftRows(dataSet, excelParams), true, true);
        if (excelParams.size() == 0) {
            return;
        }
        for (Object t : dataSet) {
            index += this.createCells(patriarch, index, t, excelParams, sheet, workbook, rowHeight);
        }
        this.mergeCells(sheet, excelParams, titleHeight);
    }

    private int getShiftRows(Collection<?> dataSet, List<ExcelExportEntity> excelParams) throws Exception {
        int size = 0;
        for (Object t : dataSet) {
            size += this.getOneObjectSize(t, excelParams);
        }
        return size;
    }

    public int getOneObjectSize(Object t, List<ExcelExportEntity> excelParams) throws Exception {
        int maxHeight = 1;
        int paramSize = excelParams.size();
        for (int k = 0; k < paramSize; ++k) {
            Collection list;
            ExcelExportEntity entity = excelParams.get(k);
            if (entity.getList() == null || (list = (Collection)entity.getMethod().invoke(t, new Object[0])) == null || list.size() <= maxHeight) continue;
            maxHeight = list.size();
        }
        return maxHeight;
    }

    public Workbook createExcleByTemplate(TemplateExportParams params, Class<?> pojoClass, Collection<?> dataSet, Map<String, Object> map) {
        if (params == null || map == null || StringUtils.isEmpty((CharSequence)params.getTemplateUrl())) {
            throw new ExcelExportException(ExcelExportEnum.PARAMETER_ERROR);
        }
        Workbook wb = null;
        try {
            int le;
            this.teplateParams = params;
            wb = this.getCloneWorkBook();
            this.setExcelExportStyler((IExcelExportStyler)this.teplateParams.getStyle().getConstructor(Workbook.class).newInstance(wb));
            int n = le = params.isScanAllsheet() ? wb.getNumberOfSheets() : params.getSheetNum().length;
            for (int i = 0; i < le; ++i) {
                if (params.getSheetName() != null && params.getSheetName().length > i && StringUtils.isNotEmpty((CharSequence)params.getSheetName()[i])) {
                    wb.setSheetName(i, params.getSheetName()[i]);
                }
                this.tempCreateCellSet.clear();
                this.parseTemplate(wb.getSheetAt(i), map, params.isColForEach());
            }
            if (dataSet != null) {
                this.dataHanlder = params.getDataHanlder();
                if (this.dataHanlder != null) {
                    this.needHanlderList = Arrays.asList(this.dataHanlder.getNeedHandlerFields());
                }
                this.addDataToSheet(pojoClass, dataSet, wb.getSheetAt(params.getDataSheetNum()), wb);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
        return wb;
    }

    private Workbook getCloneWorkBook() throws Exception {
        return ExcelCache.getWorkbookByTemplate(this.teplateParams.getTemplateUrl(), this.teplateParams.getSheetNum(), this.teplateParams.isScanAllsheet());
    }

    private Map<String, Integer> getTitleMap(Sheet sheet) {
        Row row = null;
        HashMap<String, Integer> titlemap = new HashMap<String, Integer>();
        for (int j = 0; j < this.teplateParams.getHeadingRows(); ++j) {
            row = sheet.getRow(j + this.teplateParams.getHeadingStartRow());
            Iterator cellTitle = row.cellIterator();
            int i = row.getFirstCellNum();
            while (cellTitle.hasNext()) {
                Cell cell = (Cell)cellTitle.next();
                String value = cell.getStringCellValue();
                if (!StringUtils.isEmpty((CharSequence)value)) {
                    titlemap.put(value, i);
                }
                ++i;
            }
        }
        return titlemap;
    }

    private void parseTemplate(Sheet sheet, Map<String, Object> map, boolean colForeach) throws Exception {
        this.deleteCell(sheet, map);
        this.mergedRegionHelper = new MergedRegionHelper(sheet);
        if (colForeach) {
            this.colForeach(sheet, map);
        }
        Row row = null;
        int index = 0;
        while (index <= sheet.getLastRowNum()) {
            if ((row = sheet.getRow(index++)) == null) continue;
            for (int i = row.getFirstCellNum(); i < row.getLastCellNum(); ++i) {
                if (row.getCell(i) == null || this.tempCreateCellSet.contains(row.getRowNum() + "_" + row.getCell(i).getColumnIndex())) continue;
                this.setValueForCellByMap(row.getCell(i), map);
            }
        }
    }

    private void deleteCell(Sheet sheet, Map<String, Object> map) throws Exception {
        Row row = null;
        Cell cell = null;
        int index = 0;
        while (index <= sheet.getLastRowNum()) {
            if ((row = sheet.getRow(index++)) == null) continue;
            for (int i = row.getFirstCellNum(); i < row.getLastCellNum(); ++i) {
                cell = row.getCell(i);
                if (row.getCell(i) == null || cell.getCellTypeEnum() != CellType.STRING && cell.getCellTypeEnum() != CellType.NUMERIC) continue;
                cell.setCellType(CellType.STRING);
                String text = cell.getStringCellValue();
                if (!text.contains("!if:")) continue;
                if (Boolean.valueOf(PoiElUtil.eval(text.substring(text.indexOf("{{") + 2, text.indexOf("}}")).trim(), map).toString()).booleanValue()) {
                    PoiSheetUtility.deleteColumn(sheet, i);
                }
                cell.setCellValue("");
            }
        }
    }

    private void setValueForCellByMap(Cell cell, Map<String, Object> map) throws Exception {
        CellType cellType = cell.getCellTypeEnum();
        if (cellType != CellType.STRING && cellType != CellType.NUMERIC) {
            return;
        }
        cell.setCellType(CellType.STRING);
        String oldString = cell.getStringCellValue();
        if (oldString != null && oldString.indexOf("{{") != -1 && !oldString.contains("fe:")) {
            String params = null;
            boolean isNumber = false;
            if (this.isNumber(oldString)) {
                isNumber = true;
                oldString = oldString.replace("n:", "");
            }
            while (oldString.indexOf("{{") != -1) {
                params = oldString.substring(oldString.indexOf("{{") + 2, oldString.indexOf("}}"));
                oldString = oldString.replace("{{" + params + "}}", PoiElUtil.eval(params, map).toString());
            }
            if (isNumber && StringUtils.isNotBlank((CharSequence)oldString)) {
                cell.setCellValue(Double.parseDouble(oldString));
                cell.setCellType(CellType.NUMERIC);
            } else {
                cell.setCellValue(oldString);
            }
        }
        if (oldString != null && oldString.contains("fe:")) {
            this.addListDataToExcel(cell, map, oldString.trim());
        }
    }

    private boolean isNumber(String text) {
        return text.startsWith("n:") || text.contains("{n:") || text.contains(" n:");
    }

    private void addListDataToExcel(Cell cell, Map<String, Object> map, String name) throws Exception {
        Object t;
        boolean isCreate = !name.contains("!fe:");
        boolean isShift = name.contains("$fe:");
        name = name.replace("!fe:", "").replace("$fe:", "").replace("fe:", "").replace("{{", "");
        String[] keys = name.replaceAll("\\s{1,}", " ").trim().split(" ");
        Collection datas = (Collection)PoiPublicUtil.getParamsValue(keys[0], map);
        Object[] columnsInfo = this.getAllDataColumns(cell, name.replace(keys[0], ""), this.mergedRegionHelper);
        int rowspan = (Integer)columnsInfo[0];
        int colspan = (Integer)columnsInfo[1];
        List columns = (List)columnsInfo[2];
        if (datas == null) {
            return;
        }
        Iterator its = datas.iterator();
        int rowIndex = cell.getRow().getRowNum() + 1;
        int loopSize = 0;
        if (its.hasNext()) {
            t = its.next();
            cell.getRow().setHeight(((ExcelForEachParams)columns.get(0)).getHeight());
            loopSize = this.setForeachRowCellValue(isCreate, cell.getRow(), cell.getColumnIndex(), t, columns, map, rowspan, colspan, this.mergedRegionHelper)[0];
            rowIndex += rowspan - 1 + loopSize - 1;
        }
        if (isShift && datas.size() * rowspan > 1 && cell.getRowIndex() + rowspan <= cell.getRow().getSheet().getLastRowNum()) {
            int lastRowNum = cell.getRow().getSheet().getLastRowNum();
            int shiftRows = lastRowNum - cell.getRowIndex() - rowspan;
            cell.getRow().getSheet().shiftRows(cell.getRowIndex() + rowspan, lastRowNum, (datas.size() - 1) * rowspan, true, true);
            this.mergedRegionHelper.shiftRows(cell.getSheet(), cell.getRowIndex() + rowspan, (datas.size() - 1) * rowspan, shiftRows);
            PoiExcelTempUtil.reset(cell.getSheet(), cell.getRowIndex() + rowspan + (datas.size() - 1) * rowspan, cell.getRow().getSheet().getLastRowNum());
        }
        while (its.hasNext()) {
            t = its.next();
            Row row = this.createRow(rowIndex, cell.getSheet(), isCreate, rowspan);
            row.setHeight(((ExcelForEachParams)columns.get(0)).getHeight());
            loopSize = this.setForeachRowCellValue(isCreate, row, cell.getColumnIndex(), t, columns, map, rowspan, colspan, this.mergedRegionHelper)[0];
            rowIndex += rowspan + loopSize - 1;
        }
    }

    private void setForEeachCellValue(boolean isCreate, Row row, int columnIndex, Object t, List<ExcelTemplateParams> columns, Map<String, Object> map) throws Exception {
        int i;
        int max = columnIndex + columns.size();
        for (i = 0; i < max; ++i) {
            if (row.getCell(i) != null) continue;
            row.createCell(i);
        }
        max = columns.size();
        for (i = 0; i < max; ++i) {
            boolean isNumber = false;
            String tempStr = new String(columns.get(i).getName());
            if (this.isNumber(tempStr)) {
                isNumber = true;
                tempStr = tempStr.replace("n:", "");
            }
            map.put(this.teplateParams.getTempParams(), t);
            String val = PoiElUtil.eval(tempStr, map).toString();
            if (isNumber && StringUtils.isNotEmpty((CharSequence)val)) {
                row.getCell(i + columnIndex).setCellValue(Double.parseDouble(val));
                row.getCell(i + columnIndex).setCellType(CellType.NUMERIC);
            } else {
                row.getCell(i + columnIndex).setCellValue(val);
            }
            row.getCell(i + columnIndex).setCellStyle(columns.get(i).getCellStyle());
            this.tempCreateCellSet.add(row.getRowNum() + "_" + (i + columnIndex));
        }
    }

    private List<ExcelTemplateParams> getAllDataColumns(Cell cell, String name) {
        Cell tempCell;
        ArrayList<ExcelTemplateParams> columns = new ArrayList<ExcelTemplateParams>();
        cell.setCellValue("");
        if (name.contains("}}")) {
            columns.add(new ExcelTemplateParams(name.replace("}}", "").trim(), cell.getCellStyle(), cell.getRow().getHeight()));
            return columns;
        }
        columns.add(new ExcelTemplateParams(name.trim(), cell.getCellStyle(), cell.getRow().getHeight()));
        int index = cell.getColumnIndex();
        short lastCellNum = cell.getRow().getLastCellNum();
        while ((tempCell = cell.getRow().getCell(++index)) != null || index < lastCellNum) {
            String cellStringString;
            try {
                cellStringString = tempCell.getStringCellValue();
                if (StringUtils.isBlank((CharSequence)cellStringString) && index >= lastCellNum) {
                    break;
                }
            }
            catch (Exception e) {
                throw new ExcelExportException("for each \u5f53\u4e2d\u5b58\u5728\u7a7a\u5b57\u7b26\u4e32,\u8bf7\u68c0\u67e5\u6a21\u677f");
            }
            tempCell.setCellValue("");
            if (cellStringString.contains("}}")) {
                columns.add(new ExcelTemplateParams(cellStringString.trim().replace("}}", ""), tempCell.getCellStyle(), tempCell.getRow().getHeight()));
                break;
            }
            if (cellStringString.trim().contains(this.teplateParams.getTempParams())) {
                columns.add(new ExcelTemplateParams(cellStringString.trim(), tempCell.getCellStyle(), tempCell.getRow().getHeight()));
                continue;
            }
            if (!cellStringString.trim().equals("")) break;
            columns.add(new ExcelTemplateParams("", tempCell.getCellStyle(), tempCell.getRow().getHeight()));
        }
        return columns;
    }

    private void sortAndFilterExportField(List<ExcelExportEntity> excelParams, Map<String, Integer> titlemap) {
        for (int i = excelParams.size() - 1; i >= 0; --i) {
            if (excelParams.get(i).getList() != null && excelParams.get(i).getList().size() > 0) {
                this.sortAndFilterExportField(excelParams.get(i).getList(), titlemap);
                if (excelParams.get(i).getList().size() == 0) {
                    excelParams.remove(i);
                    continue;
                }
                excelParams.get(i).setOrderNum(i);
                continue;
            }
            if (titlemap.containsKey(excelParams.get(i).getName())) {
                excelParams.get(i).setOrderNum(i);
                continue;
            }
            excelParams.remove(i);
        }
        this.sortAllParams(excelParams);
    }

    private void colForeach(Sheet sheet, Map<String, Object> map) throws Exception {
        Row row = null;
        Cell cell = null;
        int index = 0;
        while (index <= sheet.getLastRowNum()) {
            if ((row = sheet.getRow(index++)) == null) continue;
            for (int i = row.getFirstCellNum(); i < row.getLastCellNum(); ++i) {
                String text;
                cell = row.getCell(i);
                if (row.getCell(i) == null || cell.getCellType() != CellType.STRING && cell.getCellType() != CellType.NUMERIC || !(text = PoiCellUtil.getCellValue(cell)).contains("#fe:") && !text.contains("v_fe:")) continue;
                this.foreachCol(cell, map, text);
            }
        }
    }

    private void foreachCol(Cell cell, Map<String, Object> map, String name) throws Exception {
        boolean isCreate = name.contains("v_fe:");
        name = name.replace("v_fe:", "").replace("#fe:", "").replace("{{", "");
        String[] keys = name.replaceAll("\\s{1,}", " ").trim().split(" ");
        Collection datas = (Collection)PoiPublicUtil.getParamsValue(keys[0], map);
        Object[] columnsInfo = this.getAllDataColumns(cell, name.replace(keys[0], ""), this.mergedRegionHelper);
        if (datas == null) {
            return;
        }
        Iterator its = datas.iterator();
        int rowspan = (Integer)columnsInfo[0];
        int colspan = (Integer)columnsInfo[1];
        List columns = (List)columnsInfo[2];
        while (its.hasNext()) {
            Object t = its.next();
            this.setForeachRowCellValue(true, cell.getRow(), cell.getColumnIndex(), t, columns, map, rowspan, colspan, this.mergedRegionHelper);
            if (cell.getRow().getCell(cell.getColumnIndex() + colspan) == null) {
                cell.getRow().createCell(cell.getColumnIndex() + colspan);
            }
            cell = cell.getRow().getCell(cell.getColumnIndex() + colspan);
        }
        if (isCreate) {
            cell = cell.getRow().getCell(cell.getColumnIndex() - 1);
            cell.setCellValue(cell.getStringCellValue() + "}}");
        }
    }

    private int[] setForeachRowCellValue(boolean isCreate, Row row, int columnIndex, Object t, List<ExcelForEachParams> columns, Map<String, Object> map, int rowspan, int colspan, MergedRegionHelper mergedRegionHelper) throws Exception {
        this.createRowCellSetStyle(row, columnIndex, columns, rowspan, colspan);
        int loopSize = 1;
        int loopCi = 1;
        row = row.getSheet().getRow(row.getRowNum() - rowspan + 1);
        for (int k = 0; k < rowspan; ++k) {
            int ci = columnIndex;
            row.setHeight(this.getMaxHeight(k, colspan, columns));
            for (int i = 0; i < colspan && i < columns.size(); ++i) {
                boolean isNeedMerge;
                String val;
                boolean isNumber = false;
                ExcelForEachParams params = columns.get(colspan * k + i);
                this.tempCreateCellSet.add(row.getRowNum() + "_" + ci);
                if (params == null) continue;
                if (StringUtils.isEmpty((CharSequence)params.getName()) && StringUtils.isEmpty((CharSequence)params.getConstValue())) {
                    row.getCell(ci).setCellStyle(params.getCellStyle());
                    ci += params.getColspan();
                    continue;
                }
                Object obj = null;
                String tempStr = params.getName();
                if (StringUtils.isEmpty((CharSequence)params.getName())) {
                    val = params.getConstValue();
                } else {
                    if (this.isHasSymbol(tempStr, "n:")) {
                        isNumber = true;
                        tempStr = tempStr.replaceFirst("n:", "");
                    }
                    map.put(this.teplateParams.getTempParams(), t);
                    boolean isDict = false;
                    String dict = null;
                    if (this.isHasSymbol(tempStr, "dict:")) {
                        isDict = true;
                        dict = tempStr.substring(tempStr.indexOf("dict:") + 5).split(";")[0];
                        tempStr = tempStr.replaceFirst("dict:", "");
                        tempStr = tempStr.replaceFirst(dict + ";", "");
                    }
                    obj = PoiElUtil.eval(tempStr, map);
                    if (isDict && !(obj instanceof Collection)) {
                        obj = this.dictHandler.toName(dict, t, tempStr, obj);
                    }
                    val = obj.toString();
                }
                if (obj != null && obj instanceof Collection) {
                    String collectName = PoiElUtil.evalFindName(tempStr, map);
                    int[] loop = this.setForEachLoopRowCellValue(row, ci, (Collection)obj, columns, params, map, rowspan, colspan, mergedRegionHelper, collectName);
                    loopSize = Math.max(loopSize, loop[0]);
                    i += loop[1] - 1;
                    ci = loop[2] - params.getColspan();
                } else if (obj != null && obj instanceof ImageEntity) {
                    ImageEntity img = (ImageEntity)obj;
                    row.getCell(ci).setCellValue("");
                    if (img.getRowspan() > 1 || img.getColspan() > 1) {
                        img.setHeight(0);
                        row.getCell(ci).getSheet().addMergedRegion(new CellRangeAddress(row.getCell(ci).getRowIndex(), row.getCell(ci).getRowIndex() + img.getRowspan() - 1, row.getCell(ci).getColumnIndex(), row.getCell(ci).getColumnIndex() + img.getColspan() - 1));
                    }
                    this.createImageCell(row.getCell(ci), img.getHeight(), img.getRowspan(), img.getColspan(), img.getUrl(), img.getData());
                } else if (isNumber && StringUtils.isNotEmpty((CharSequence)val)) {
                    row.getCell(ci).setCellValue(Double.parseDouble(val));
                } else {
                    try {
                        row.getCell(ci).setCellValue(val);
                    }
                    catch (Exception e) {
                        LOGGER.error(e.getMessage(), (Throwable)e);
                    }
                }
                if (params.getCellStyle() != null) {
                    row.getCell(ci).setCellStyle(params.getCellStyle());
                }
                this.setMergedRegionStyle(row, ci, params);
                boolean bl = isNeedMerge = (params.getRowspan() != 1 || params.getColspan() != 1) && !mergedRegionHelper.isMergedRegion(row.getRowNum() + 1, ci);
                if (isNeedMerge) {
                    PoiMergeCellUtil.addMergedRegion(row.getSheet(), row.getRowNum(), row.getRowNum() + params.getRowspan() - 1, ci, ci + params.getColspan() - 1);
                }
                ci += params.getColspan();
            }
            loopCi = Math.max(loopCi, ci);
            if (loopSize > 1) {
                this.handlerLoopMergedRegion(row, columnIndex, columns, loopSize);
            }
            row = row.getSheet().getRow(row.getRowNum() + 1);
        }
        return new int[]{loopSize, loopCi};
    }

    public void createImageCell(Cell cell, double height, int rowspan, int colspan, String imagePath, byte[] data) throws Exception {
        if (height > (double)cell.getRow().getHeight()) {
            cell.getRow().setHeight((short)height);
        }
        Object anchor = this.type.equals((Object)ExcelType.HSSF) ? new HSSFClientAnchor(0, 0, 0, 0, (short)cell.getColumnIndex(), cell.getRow().getRowNum(), (short)(cell.getColumnIndex() + colspan), cell.getRow().getRowNum() + rowspan) : new XSSFClientAnchor(0, 0, 0, 0, (int)((short)cell.getColumnIndex()), cell.getRow().getRowNum(), (int)((short)(cell.getColumnIndex() + colspan)), cell.getRow().getRowNum() + rowspan);
        if (StringUtils.isNotEmpty((CharSequence)imagePath)) {
            data = ImageCache.getImage(imagePath);
        }
        if (data != null) {
            PoiExcelGraphDataUtil.getDrawingPatriarch(cell.getSheet()).createPicture((ClientAnchor)anchor, cell.getSheet().getWorkbook().addPicture(data, this.getImageType(data)));
        }
    }

    private int[] setForEachLoopRowCellValue(Row row, int columnIndex, Collection obj, List<ExcelForEachParams> columns, ExcelForEachParams params, Map<String, Object> map, int rowspan, int colspan, MergedRegionHelper mergedRegionHelper, String collectName) throws Exception {
        List<ExcelForEachParams> temp = this.getLoopEachParams(columns, columnIndex, collectName);
        Iterator its = obj.iterator();
        Row tempRow = row;
        int nums = 0;
        int ci = columnIndex;
        while (its.hasNext()) {
            Object data = its.next();
            map.put("loop_" + columnIndex, data);
            int[] loopArr = this.setForeachRowCellValue(false, tempRow, columnIndex, data, temp, map, rowspan, colspan, mergedRegionHelper);
            nums += loopArr[0];
            ci = Math.max(ci, loopArr[1]);
            map.remove("loop_" + columnIndex);
            tempRow = this.createRow(tempRow.getRowNum() + loopArr[0], row.getSheet(), false, rowspan);
        }
        for (int i = 0; i < temp.size(); ++i) {
            temp.get(i).setName(temp.get(i).getTempName().pop());
            temp.get(i).setCollectCell(true);
        }
        return new int[]{nums, temp.size(), ci};
    }

    private Row createRow(int rowIndex, Sheet sheet, boolean isCreate, int rows) {
        for (int i = 0; i < rows; ++i) {
            if (isCreate) {
                sheet.createRow(rowIndex++);
                continue;
            }
            if (sheet.getRow(rowIndex++) != null) continue;
            sheet.createRow(rowIndex - 1);
        }
        return sheet.getRow(rowIndex - rows);
    }

    private List<ExcelForEachParams> getLoopEachParams(List<ExcelForEachParams> columns, int columnIndex, String collectName) {
        ArrayList<ExcelForEachParams> temp = new ArrayList<ExcelForEachParams>();
        for (int i = 0; i < columns.size(); ++i) {
            columns.get(i).setCollectCell(false);
            if (columns.get(i) != null && !columns.get(i).getName().contains(collectName)) continue;
            temp.add(columns.get(i));
            if (columns.get(i).getTempName() == null) {
                columns.get(i).setTempName(new Stack<String>());
            }
            columns.get(i).setCollectCell(true);
            columns.get(i).getTempName().push(columns.get(i).getName());
            columns.get(i).setName(columns.get(i).getName().replace(collectName, "loop_" + columnIndex));
        }
        return temp;
    }

    private void createRowCellSetStyle(Row row, int columnIndex, List<ExcelForEachParams> columns, int rowspan, int colspan) {
        for (int i = 0; i < rowspan; ++i) {
            int size = columns.size();
            int max = columnIndex + colspan;
            for (int j = columnIndex; j < max; ++j) {
                CellStyle style;
                if (row.getCell(j) != null) continue;
                row.createCell(j);
                CellStyle cellStyle = row.getRowNum() % 2 == 0 ? this.getStyles(false, size <= j - columnIndex ? null : columns.get(j - columnIndex)) : (style = this.getStyles(true, size <= j - columnIndex ? null : columns.get(j - columnIndex)));
                if (style == null) continue;
                row.getCell(j).setCellStyle(style);
            }
            if (i >= rowspan - 1) continue;
            row = row.getSheet().getRow(row.getRowNum() + 1);
        }
    }

    private CellStyle getStyles(boolean isSingle, ExcelForEachParams excelForEachParams) {
        return this.excelExportStyler.getTemplateStyles(isSingle, excelForEachParams);
    }

    private short getMaxHeight(int k, int colspan, List<ExcelForEachParams> columns) {
        short high = columns.get(0).getHeight();
        for (int n = k; n > 0; --n) {
            if (columns.get(n * colspan).getHeight() == 0) {
                continue;
            }
            high = columns.get(n * colspan).getHeight();
            break;
        }
        return high;
    }

    private boolean isHasSymbol(String text, String symbol) {
        return text.startsWith(symbol) || text.contains("{" + symbol) || text.contains(" " + symbol);
    }

    private void handlerLoopMergedRegion(Row row, int columnIndex, List<ExcelForEachParams> columns, int loopSize) {
        for (int i = 0; i < columns.size(); ++i) {
            if (!columns.get(i).isCollectCell()) {
                PoiMergeCellUtil.addMergedRegion(row.getSheet(), row.getRowNum(), row.getRowNum() + loopSize - 1, columnIndex, columnIndex + columns.get(i).getColspan() - 1);
            }
            columnIndex += columns.get(i).getColspan();
        }
    }

    private void setMergedRegionStyle(Row row, int ci, ExcelForEachParams params) {
        int i;
        for (i = 1; i < params.getColspan(); ++i) {
            if (params.getCellStyle() == null) continue;
            row.getCell(ci + i).setCellStyle(params.getCellStyle());
        }
        for (i = 1; i < params.getRowspan(); ++i) {
            for (int j = 0; j < params.getColspan(); ++j) {
                if (params.getCellStyle() == null) continue;
                row.getCell(ci + j).setCellStyle(params.getCellStyle());
            }
        }
    }

    private Object[] getAllDataColumns(Cell cell, String name, MergedRegionHelper mergedRegionHelper) {
        ArrayList<ExcelForEachParams> columns = new ArrayList<ExcelForEachParams>();
        cell.setCellValue("");
        columns.add(this.getExcelTemplateParams(name.replace("}}", ""), cell, mergedRegionHelper));
        int rowspan = 1;
        int colspan = 1;
        if (!name.contains("}}")) {
            int index = cell.getColumnIndex();
            int startIndex = cell.getColumnIndex();
            Row row = cell.getRow();
            while (index < row.getLastCellNum()) {
                String cellStringString;
                int colSpan = columns.get(columns.size() - 1) != null ? ((ExcelForEachParams)columns.get(columns.size() - 1)).getColspan() : 1;
                index += colSpan;
                for (int i = 1; i < colSpan; ++i) {
                    columns.add(null);
                }
                cell = row.getCell(index);
                if (cell == null) {
                    columns.add(null);
                    continue;
                }
                try {
                    cellStringString = cell.getStringCellValue();
                    if (StringUtils.isBlank((CharSequence)cellStringString) && colspan + startIndex <= index) {
                        throw new ExcelExportException("for each \u5f53\u4e2d\u5b58\u5728\u7a7a\u5b57\u7b26\u4e32,\u8bf7\u68c0\u67e5\u6a21\u677f");
                    }
                    if (StringUtils.isBlank((CharSequence)cellStringString) && colspan + startIndex > index) {
                        columns.add(new ExcelForEachParams(null, cell.getCellStyle(), 0));
                        continue;
                    }
                }
                catch (Exception e) {
                    throw new ExcelExportException(ExcelExportEnum.TEMPLATE_ERROR, (Throwable)e);
                }
                cell.setCellValue("");
                if (cellStringString.contains("}}")) {
                    columns.add(this.getExcelTemplateParams(cellStringString.replace("}}", ""), cell, mergedRegionHelper));
                    int lastCellColspan = ((ExcelForEachParams)columns.get(columns.size() - 1)).getColspan();
                    for (int i = 1; i < lastCellColspan; ++i) {
                        columns.add(null);
                    }
                    break;
                }
                if (cellStringString.contains("]]")) {
                    columns.add(this.getExcelTemplateParams(cellStringString.replace("]]", ""), cell, mergedRegionHelper));
                    colspan = index - startIndex + 1;
                    index = startIndex - ((ExcelForEachParams)columns.get(columns.size() - 1)).getColspan();
                    row = row.getSheet().getRow(row.getRowNum() + 1);
                    ++rowspan;
                    continue;
                }
                columns.add(this.getExcelTemplateParams(cellStringString.replace("]]", ""), cell, mergedRegionHelper));
            }
        }
        colspan = 0;
        for (int i = 0; i < columns.size(); ++i) {
            colspan += columns.get(i) != null ? ((ExcelForEachParams)columns.get(i)).getColspan() : 0;
        }
        return new Object[]{rowspan, colspan /= rowspan, columns};
    }

    private ExcelForEachParams getExcelTemplateParams(String name, Cell cell, MergedRegionHelper mergedRegionHelper) {
        name = name.trim();
        ExcelForEachParams params = new ExcelForEachParams(name, cell.getCellStyle(), cell.getRow().getHeight());
        if (name.startsWith("'") && name.endsWith("'")) {
            params.setName(null);
            params.setConstValue(name.substring(1, name.length() - 1));
        }
        if ("&NULL&".equals(name)) {
            params.setName(null);
            params.setConstValue("");
        }
        if (mergedRegionHelper.isMergedRegion(cell.getRowIndex() + 1, cell.getColumnIndex())) {
            Integer[] colAndrow = mergedRegionHelper.getRowAndColSpan(cell.getRowIndex() + 1, cell.getColumnIndex());
            params.setRowspan(colAndrow[0]);
            params.setColspan(colAndrow[1]);
        }
        return params;
    }
}

