/*
 * Decompiled with CFR 0.152.
 */
package com.jeecg.qywx.api.user;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jeecg.qywx.api.base.JwAccessTokenAPI;
import com.jeecg.qywx.api.base.JwParamesAPI;
import com.jeecg.qywx.api.core.common.AccessToken;
import com.jeecg.qywx.api.core.util.HttpUtil;
import com.jeecg.qywx.api.user.vo.User;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwUserAPI {
    private static final Logger logger = LoggerFactory.getLogger(JwUserAPI.class);
    private static String user_create_url = "https://qyapi.weixin.qq.com/cgi-bin/user/create?access_token=ACCESS_TOKEN";
    private static String user_update_url = "https://qyapi.weixin.qq.com/cgi-bin/user/update?access_token=ACCESS_TOKEN";
    private static String user_delete_url = "https://qyapi.weixin.qq.com/cgi-bin/user/delete?access_token=ACCESS_TOKEN&userid=USERID";
    private static String user_delete_all_url = "https://qyapi.weixin.qq.com/cgi-bin/user/batchdelete?access_token=ACCESS_TOKEN";
    private static String user_get_url_byuserid = "https://qyapi.weixin.qq.com/cgi-bin/user/get?access_token=ACCESS_TOKEN&userid=USERID";
    private static String user_get_dep_all_url = "https://qyapi.weixin.qq.com/cgi-bin/user/simplelist?access_token=ACCESS_TOKEN&department_id=DEPARTMENT_ID&fetch_child=FETCH_CHILD&status=STATUS";
    private static String user_get_url = "https://qyapi.weixin.qq.com/cgi-bin/user/list?access_token=ACCESS_TOKEN&department_id=DEPARTMENT_ID&fetch_child=FETCH_CHILD&status=STATUS";
    private static String user_get_userid = "https://qyapi.weixin.qq.com/cgi-bin/user/getuserid?access_token=ACCESS_TOKEN";

    public static int createUser(User user, String accessToken) {
        int result = 0;
        logger.info("[CREATEUSER]", (Object)"createUser param:user:{},accessToken:{}", (Object)new Object[]{user, accessToken});
        String url = user_create_url.replace("ACCESS_TOKEN", accessToken);
        String jsonUser = JSONObject.toJSONString((Object)user);
        logger.info("[CREATEUSER]", (Object)"createUser param:jsonUser:{}", (Object)new Object[]{jsonUser});
        JSONObject jsonObject = HttpUtil.sendPost(url, jsonUser);
        logger.info("[CREATEUSER]", (Object)"createUser response:{}", (Object)new Object[]{jsonObject.toJSONString()});
        if (null != jsonObject) {
            int errcode;
            result = errcode = jsonObject.getIntValue("errcode");
        }
        return result;
    }

    public static int updateUser(User user, String accessToken) {
        int result = 0;
        logger.info("[UPDATEUSER]", (Object)"updateUser param:user:{},accessToken:{}", (Object)new Object[]{user, accessToken});
        String url = user_update_url.replace("ACCESS_TOKEN", accessToken);
        String jsonUser = JSONObject.toJSONString((Object)user);
        logger.info("[UPDATEUSER]", (Object)"updateUser param:jsonUser:{}", (Object)new Object[]{jsonUser});
        JSONObject jsonObject = HttpUtil.sendPost(url, jsonUser);
        logger.info("[UPDATEUSER]", (Object)"updateUser response:{}", (Object)new Object[]{jsonObject.toJSONString()});
        if (null != jsonObject) {
            int errcode;
            result = errcode = jsonObject.getIntValue("errcode");
        }
        return result;
    }

    public static int deleteUser(String userid, String accessToken) {
        int result = 0;
        logger.info("[DELETEUSER]", (Object)"deleteUser param:userid:{},accessToken:{}", (Object)new Object[]{userid, accessToken});
        String url = user_delete_url.replace("ACCESS_TOKEN", accessToken).replace("USERID", userid);
        logger.info("[DELETEUSER]", (Object)"deleteUser param:userid:{}", (Object)new Object[]{userid});
        JSONObject jsonObject = HttpUtil.sendPost(url);
        logger.info("[DELETEUSER]", (Object)"deleteUser response:{}", (Object)new Object[]{jsonObject.toJSONString()});
        if (null != jsonObject) {
            int errcode;
            result = errcode = jsonObject.getIntValue("errcode");
        }
        return result;
    }

    public static int batchDeleteUsers(String[] useridlist, String accessToken) {
        int result = 0;
        logger.info("[BATCHDELETEUSERS]", (Object)"batchDeleteUsers param:useridlist:{},accessToken:{}", (Object)new Object[]{useridlist, accessToken});
        String url = user_delete_all_url.replace("ACCESS_TOKEN", accessToken);
        HashMap<String, String[]> paramtermap = new HashMap<String, String[]>();
        paramtermap.put("useridlist", useridlist);
        String jsonUserids = JSONObject.toJSONString(paramtermap);
        logger.info("[BATCHDELETEUSERS]", (Object)"batchDeleteUsers param:useridlist:{}", (Object)new Object[]{paramtermap});
        JSONObject jsonObject = HttpUtil.sendPost(url, jsonUserids);
        logger.info("[BATCHDELETEUSERS]", (Object)"batchDeleteUsers response:{}", (Object)new Object[]{jsonObject.toJSONString()});
        if (null != jsonObject) {
            int errcode;
            result = errcode = jsonObject.getIntValue("errcode");
        }
        return result;
    }

    public static User getUserByUserid(String userid, String accessToken) {
        int errcode;
        logger.info("[GETUSERBYUSERID]", (Object)"getUserByUserid param:userid:{},accessToken:{}", (Object)new Object[]{userid, accessToken});
        String url = user_get_url_byuserid.replace("ACCESS_TOKEN", accessToken).replace("USERID", userid);
        JSONObject jsonObject = HttpUtil.sendPost(url);
        logger.info("[GETUSERBYUSERID]", (Object)"getUserByUserid response:{}", (Object)new Object[]{jsonObject.toJSONString()});
        if (null != jsonObject && (errcode = jsonObject.getIntValue("errcode")) == 0) {
            User user = (User)JSONObject.toJavaObject((JSON)jsonObject, User.class);
            return user;
        }
        return null;
    }

    public static List<User> getUsersByDepartid(String department_id, String fetch_child, String status, String accessToken) {
        int errcode;
        logger.info("[GETUSERSBYDEPARTID]", (Object)"getUsersByDepartid param:department_id:{},fetch_child:{},status:{},accessToken:{}", (Object)new Object[]{department_id, fetch_child, status, accessToken});
        String url = user_get_dep_all_url.replace("ACCESS_TOKEN", accessToken).replace("DEPARTMENT_ID", department_id);
        if (fetch_child != null) {
            url = url.replace("FETCH_CHILD", fetch_child);
        }
        if (status != null) {
            url = url.replace("STATUS", status);
        }
        JSONObject jsonObject = HttpUtil.sendPost(url);
        logger.info("[GETUSERSBYDEPARTID]", (Object)"getUsersByDepartid response:{}", (Object)new Object[]{jsonObject.toJSONString()});
        if (null != jsonObject && (errcode = jsonObject.getIntValue("errcode")) == 0) {
            List users = JSON.parseArray((String)jsonObject.getString("userlist"), User.class);
            return users;
        }
        return null;
    }

    public static List<User> getDetailUsersByDepartid(String department_id, String fetch_child, String status, String accessToken) {
        int errcode;
        if (null == fetch_child) {
            fetch_child = "1";
        }
        if (null == status) {
            status = "0";
        }
        logger.info("[GETDETAILUSERSBYDEPARTID]", (Object)"getDetailUsersByDepartid param:department_id:{},fetch_child:{},status:{},accessToken:{}", (Object)new Object[]{department_id, fetch_child, status, accessToken});
        String url = user_get_url.replace("ACCESS_TOKEN", accessToken).replace("DEPARTMENT_ID", department_id).replace("FETCH_CHILD", fetch_child).replace("STATUS", status);
        JSONObject jsonObject = HttpUtil.sendPost(url);
        logger.info("[GETDETAILUSERSBYDEPARTID]", (Object)"getDetailUsersByDepartid response:{}", (Object)new Object[]{jsonObject.toJSONString()});
        if (null != jsonObject && (errcode = jsonObject.getIntValue("errcode")) == 0) {
            List users = JSON.parseArray((String)jsonObject.getString("userlist"), User.class);
            return users;
        }
        return null;
    }

    public static String getUserIdByPhone(String phone, String accessToken) {
        int errcode;
        logger.info("[GETUSERIDBYPHONE] getUserIdByPhone param:phone:{},accessToken:{}", new Object[]{phone, accessToken});
        JSONObject params = new JSONObject();
        params.put("mobile", (Object)phone);
        String url = user_get_userid.replace("ACCESS_TOKEN", accessToken);
        JSONObject response = HttpUtil.sendPost(url, params.toJSONString());
        if (response != null && (errcode = response.getIntValue("errcode")) == 0) {
            return response.getString("userid");
        }
        return null;
    }

    public static void main(String[] args) {
        AccessToken accessToken = JwAccessTokenAPI.getAccessToken(JwParamesAPI.corpId, JwParamesAPI.secret);
        User user = JwUserAPI.getUserByUserid("yangqj", accessToken.getAccesstoken());
        System.out.println(JSONObject.toJSON((Object)user));
    }
}

