/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.controller;

import com.alibaba.nacos.config.server.service.datasource.DataSourceService;
import com.alibaba.nacos.config.server.service.datasource.DynamicDataSource;
import com.alibaba.nacos.core.cluster.ServerMemberManager;
import com.alibaba.nacos.sys.utils.InetUtils;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/cs/health"})
public class HealthController {
    private DataSourceService dataSourceService;
    private String heathUpStr = "UP";
    private String heathDownStr = "DOWN";
    private String heathWarnStr = "WARN";
    @Autowired
    private ServerMemberManager memberManager;

    @PostConstruct
    public void init() {
        this.dataSourceService = DynamicDataSource.getInstance().getDataSource();
    }

    @GetMapping
    public String getHealth() {
        StringBuilder sb = new StringBuilder();
        String dbStatus = this.dataSourceService.getHealth();
        if (dbStatus.contains(this.heathUpStr) && this.memberManager.isInIpList()) {
            sb.append(this.heathUpStr);
        } else if (dbStatus.contains(this.heathWarnStr) && this.memberManager.isInIpList()) {
            sb.append("WARN:");
            sb.append("slave db (").append(dbStatus.split(":")[1]).append(") down. ");
        } else {
            sb.append("DOWN:");
            if (dbStatus.contains(this.heathDownStr)) {
                sb.append("master db (").append(dbStatus.split(":")[1]).append(") down. ");
            }
            if (!this.memberManager.isInIpList()) {
                sb.append("server ip ").append(InetUtils.getSelfIP()).append(" is not in the serverList of address server. ");
            }
        }
        return sb.toString();
    }
}

