/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.enums;

import com.alibaba.nacos.common.utils.StringUtils;

public enum FileTypeEnum {
    YML("yaml", "text/plain;charset=UTF-8"),
    YAML("yaml", "text/plain;charset=UTF-8"),
    TXT("text", "text/plain;charset=UTF-8"),
    TEXT("text", "text/plain;charset=UTF-8"),
    JSON("json", "application/json;charset=UTF-8"),
    XML("xml", "application/xml;charset=UTF-8"),
    HTM("html", "text/html;charset=UTF-8"),
    HTML("html", "text/html;charset=UTF-8"),
    PROPERTIES("properties", "text/plain;charset=UTF-8");

    private String fileType;
    private String contentType;
    private static final FileTypeEnum[] VALUES;

    private FileTypeEnum(String fileType) {
        this.fileType = fileType;
        this.contentType = "text/plain;charset=UTF-8";
    }

    private FileTypeEnum(String fileType, String contentType) {
        this.fileType = fileType;
        this.contentType = contentType;
    }

    public String getFileType() {
        return this.fileType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public static FileTypeEnum getFileTypeEnumByFileExtensionOrFileType(String extOrFileType) {
        if (StringUtils.isNotBlank((String)extOrFileType)) {
            String upperExtName = extOrFileType.trim().toUpperCase();
            for (FileTypeEnum value : VALUES) {
                if (!value.name().equals(upperExtName)) continue;
                return value;
            }
        }
        return TEXT;
    }

    static {
        VALUES = FileTypeEnum.values();
    }
}

