/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.sql;

import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.constant.Constants;
import com.alibaba.nacos.config.server.model.ConfigInfo;
import com.alibaba.nacos.config.server.model.event.ConfigDumpEvent;
import com.alibaba.nacos.config.server.service.sql.ModifyRequest;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EmbeddedStorageContextUtils {
    private static final ThreadLocal<ArrayList<ModifyRequest>> SQL_CONTEXT = ThreadLocal.withInitial(ArrayList::new);
    private static final ThreadLocal<Map<String, String>> EXTEND_INFO_CONTEXT = ThreadLocal.withInitial(HashMap::new);

    public static void addSqlContext(String sql, Object ... args) {
        ArrayList<ModifyRequest> requests = SQL_CONTEXT.get();
        ModifyRequest context = new ModifyRequest();
        context.setExecuteNo(requests.size());
        context.setSql(sql);
        context.setArgs(args);
        requests.add(context);
        SQL_CONTEXT.set(requests);
    }

    public static void putExtendInfo(String key, String value) {
        Map<String, String> old = EXTEND_INFO_CONTEXT.get();
        old.put(key, value);
        EXTEND_INFO_CONTEXT.set(old);
    }

    public static void putAllExtendInfo(Map<String, String> map) {
        Map<String, String> old = EXTEND_INFO_CONTEXT.get();
        old.putAll(map);
        EXTEND_INFO_CONTEXT.set(old);
    }

    public static void onModifyConfigInfo(ConfigInfo configInfo, String srcIp, Timestamp time) {
        if (!EnvUtil.getStandaloneMode()) {
            ConfigDumpEvent event = ConfigDumpEvent.builder().remove(false).namespaceId(configInfo.getTenant()).dataId(configInfo.getDataId()).group(configInfo.getGroup()).isBeta(false).content(configInfo.getContent()).type(configInfo.getType()).handleIp(srcIp).lastModifiedTs(time.getTime()).build();
            HashMap<String, String> extendInfo = new HashMap<String, String>(2);
            extendInfo.put(Constants.EXTEND_INFO_CONFIG_DUMP_EVENT, JacksonUtils.toJson((Object)((Object)event)));
            EmbeddedStorageContextUtils.putAllExtendInfo(extendInfo);
        }
    }

    public static void onModifyConfigBetaInfo(ConfigInfo configInfo, String betaIps, String srcIp, Timestamp time) {
        if (!EnvUtil.getStandaloneMode()) {
            ConfigDumpEvent event = ConfigDumpEvent.builder().remove(false).namespaceId(configInfo.getTenant()).dataId(configInfo.getDataId()).group(configInfo.getGroup()).isBeta(true).betaIps(betaIps).content(configInfo.getContent()).type(configInfo.getType()).handleIp(srcIp).lastModifiedTs(time.getTime()).build();
            HashMap<String, String> extendInfo = new HashMap<String, String>(2);
            extendInfo.put(Constants.EXTEND_INFO_CONFIG_DUMP_EVENT, JacksonUtils.toJson((Object)((Object)event)));
            EmbeddedStorageContextUtils.putAllExtendInfo(extendInfo);
        }
    }

    public static void onModifyConfigTagInfo(ConfigInfo configInfo, String tag, String srcIp, Timestamp time) {
        if (!EnvUtil.getStandaloneMode()) {
            ConfigDumpEvent event = ConfigDumpEvent.builder().remove(false).namespaceId(configInfo.getTenant()).dataId(configInfo.getDataId()).group(configInfo.getGroup()).isBeta(false).tag(tag).content(configInfo.getContent()).type(configInfo.getType()).handleIp(srcIp).lastModifiedTs(time.getTime()).build();
            HashMap<String, String> extendInfo = new HashMap<String, String>(2);
            extendInfo.put(Constants.EXTEND_INFO_CONFIG_DUMP_EVENT, JacksonUtils.toJson((Object)((Object)event)));
            EmbeddedStorageContextUtils.putAllExtendInfo(extendInfo);
        }
    }

    public static void onDeleteConfigInfo(String namespaceId, String group, String dataId, String srcIp, Timestamp time) {
        if (!EnvUtil.getStandaloneMode()) {
            ConfigDumpEvent event = ConfigDumpEvent.builder().remove(true).namespaceId(namespaceId).group(group).dataId(dataId).isBeta(false).handleIp(srcIp).lastModifiedTs(time.getTime()).build();
            HashMap<String, String> extendInfo = new HashMap<String, String>(2);
            extendInfo.put(Constants.EXTEND_INFO_CONFIG_DUMP_EVENT, JacksonUtils.toJson((Object)((Object)event)));
            EmbeddedStorageContextUtils.putAllExtendInfo(extendInfo);
        }
    }

    public static void onBatchDeleteConfigInfo(List<ConfigInfo> configInfos) {
        if (!EnvUtil.getStandaloneMode()) {
            ArrayList<ConfigDumpEvent> events = new ArrayList<ConfigDumpEvent>();
            for (ConfigInfo configInfo : configInfos) {
                String namespaceId = StringUtils.isBlank((String)configInfo.getTenant()) ? "" : configInfo.getTenant();
                ConfigDumpEvent event = ConfigDumpEvent.builder().remove(true).namespaceId(namespaceId).group(configInfo.getGroup()).dataId(configInfo.getDataId()).isBeta(false).build();
                events.add(event);
            }
            HashMap<String, String> extendInfo = new HashMap<String, String>(2);
            extendInfo.put(Constants.EXTEND_INFOS_CONFIG_DUMP_EVENT, JacksonUtils.toJson(events));
            EmbeddedStorageContextUtils.putAllExtendInfo(extendInfo);
        }
    }

    public static void onDeleteConfigBetaInfo(String namespaceId, String group, String dataId, long time) {
        if (!EnvUtil.getStandaloneMode()) {
            ConfigDumpEvent event = ConfigDumpEvent.builder().remove(true).namespaceId(namespaceId).dataId(dataId).group(group).isBeta(true).build();
            HashMap<String, String> extendInfo = new HashMap<String, String>(2);
            extendInfo.put(Constants.EXTEND_INFO_CONFIG_DUMP_EVENT, JacksonUtils.toJson((Object)((Object)event)));
            EmbeddedStorageContextUtils.putAllExtendInfo(extendInfo);
        }
    }

    public static void onDeleteConfigTagInfo(String namespaceId, String group, String dataId, String tag, String srcIp) {
        if (!EnvUtil.getStandaloneMode()) {
            ConfigDumpEvent event = ConfigDumpEvent.builder().remove(true).namespaceId(namespaceId).group(group).dataId(dataId).isBeta(true).tag(tag).handleIp(srcIp).build();
            HashMap<String, String> extendInfo = new HashMap<String, String>(2);
            extendInfo.put(Constants.EXTEND_INFO_CONFIG_DUMP_EVENT, JacksonUtils.toJson((Object)((Object)event)));
            EmbeddedStorageContextUtils.putAllExtendInfo(extendInfo);
        }
    }

    public static boolean containsExtendInfo(String key) {
        Map<String, String> extendInfo = EXTEND_INFO_CONTEXT.get();
        boolean exist = extendInfo.containsKey(key);
        EXTEND_INFO_CONTEXT.set(extendInfo);
        return exist;
    }

    public static List<ModifyRequest> getCurrentSqlContext() {
        return SQL_CONTEXT.get();
    }

    public static Map<String, String> getCurrentExtendInfo() {
        return EXTEND_INFO_CONTEXT.get();
    }

    public static void cleanAllContext() {
        SQL_CONTEXT.remove();
        EXTEND_INFO_CONTEXT.remove();
    }
}

