/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.utils;

import com.alibaba.nacos.config.server.constant.Constants;

public class ContentUtils {
    private static final int LIMIT_CONTENT_SIZE = 100;

    public static void verifyIncrementPubContent(String content) {
        if (content == null || content.length() == 0) {
            throw new IllegalArgumentException("\u53d1\u5e03/\u5220\u9664\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (int i = 0; i < content.length(); ++i) {
            char c = content.charAt(i);
            if (c == '\r' || c == '\n') {
                throw new IllegalArgumentException("\u53d1\u5e03/\u5220\u9664\u5185\u5bb9\u4e0d\u80fd\u5305\u542b\u56de\u8f66\u548c\u6362\u884c");
            }
            if (c != Constants.WORD_SEPARATOR.charAt(0)) continue;
            throw new IllegalArgumentException("\u53d1\u5e03/\u5220\u9664\u5185\u5bb9\u4e0d\u80fd\u5305\u542b(char)2");
        }
    }

    public static String getContentIdentity(String content) {
        int index = content.indexOf(Constants.WORD_SEPARATOR);
        if (index == -1) {
            throw new IllegalArgumentException("\u5185\u5bb9\u6ca1\u6709\u5305\u542b\u5206\u9694\u7b26");
        }
        return content.substring(0, index);
    }

    public static String getContent(String content) {
        int index = content.indexOf(Constants.WORD_SEPARATOR);
        if (index == -1) {
            throw new IllegalArgumentException("\u5185\u5bb9\u6ca1\u6709\u5305\u542b\u5206\u9694\u7b26");
        }
        return content.substring(index + 1);
    }

    public static String truncateContent(String content) {
        if (content == null) {
            return "";
        }
        if (content.length() <= 100) {
            return content;
        }
        return content.substring(0, 100) + "...";
    }
}

