/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZipUtils.class);

    public static byte[] zip(List<ZipItem> source) {
        byte[] result = null;
        try (ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
             ZipOutputStream zipOut = new ZipOutputStream(byteOut);){
            for (ZipItem item : source) {
                zipOut.putNextEntry(new ZipEntry(item.getItemName()));
                zipOut.write(item.getItemData().getBytes(StandardCharsets.UTF_8));
            }
            zipOut.flush();
            zipOut.finish();
            result = byteOut.toByteArray();
        }
        catch (IOException e) {
            LOGGER.error("an error occurred while compressing data.", (Throwable)e);
        }
        return result;
    }

    public static UnZipResult unzip(byte[] source) {
        ZipItem metaDataItem;
        ArrayList<ZipItem> itemList;
        block30: {
            itemList = new ArrayList<ZipItem>();
            metaDataItem = null;
            try {
                ZipInputStream zipIn = new ZipInputStream(new ByteArrayInputStream(source));
                Throwable throwable = null;
                block22: while (true) {
                    try {
                        ZipEntry entry;
                        while ((entry = zipIn.getNextEntry()) != null) {
                            if (entry.isDirectory()) continue;
                            try {
                                ByteArrayOutputStream out = new ByteArrayOutputStream();
                                Throwable throwable2 = null;
                                try {
                                    int offset;
                                    byte[] buffer = new byte[1024];
                                    while ((offset = zipIn.read(buffer)) != -1) {
                                        out.write(buffer, 0, offset);
                                    }
                                    if (".meta.yml".equals(entry.getName())) {
                                        metaDataItem = new ZipItem(entry.getName(), out.toString("UTF-8"));
                                        continue block22;
                                    }
                                    itemList.add(new ZipItem(entry.getName(), out.toString("UTF-8")));
                                    continue block22;
                                }
                                catch (Throwable throwable3) {
                                    throwable2 = throwable3;
                                    throw throwable3;
                                }
                                finally {
                                    if (out == null) continue block22;
                                    if (throwable2 != null) {
                                        try {
                                            out.close();
                                        }
                                        catch (Throwable throwable4) {
                                            throwable2.addSuppressed(throwable4);
                                        }
                                        continue block22;
                                    }
                                    out.close();
                                    continue block22;
                                }
                            }
                            catch (IOException e) {
                                LOGGER.error("unzip error", (Throwable)e);
                            }
                        }
                        break block30;
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                }
                finally {
                    if (zipIn != null) {
                        if (throwable != null) {
                            try {
                                zipIn.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                        } else {
                            zipIn.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                LOGGER.error("unzip error", (Throwable)e);
            }
        }
        return new UnZipResult(itemList, metaDataItem);
    }

    public static class UnZipResult {
        private List<ZipItem> zipItemList;
        private ZipItem metaDataItem;

        public UnZipResult(List<ZipItem> zipItemList, ZipItem metaDataItem) {
            this.zipItemList = zipItemList;
            this.metaDataItem = metaDataItem;
        }

        public List<ZipItem> getZipItemList() {
            return this.zipItemList;
        }

        public void setZipItemList(List<ZipItem> zipItemList) {
            this.zipItemList = zipItemList;
        }

        public ZipItem getMetaDataItem() {
            return this.metaDataItem;
        }

        public void setMetaDataItem(ZipItem metaDataItem) {
            this.metaDataItem = metaDataItem;
        }
    }

    public static class ZipItem {
        private String itemName;
        private String itemData;

        public ZipItem(String itemName, String itemData) {
            this.itemName = itemName;
            this.itemData = itemData;
        }

        public String getItemName() {
            return this.itemName;
        }

        public void setItemName(String itemName) {
            this.itemName = itemName;
        }

        public String getItemData() {
            return this.itemData;
        }

        public void setItemData(String itemData) {
            this.itemData = itemData;
        }
    }
}

