/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.console.service;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.exception.api.NacosApiException;
import com.alibaba.nacos.api.model.v2.ErrorCode;
import com.alibaba.nacos.common.utils.NamespaceUtil;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.model.TenantInfo;
import com.alibaba.nacos.config.server.service.repository.CommonPersistService;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoPersistService;
import com.alibaba.nacos.console.enums.NamespaceTypeEnum;
import com.alibaba.nacos.console.model.Namespace;
import com.alibaba.nacos.console.model.NamespaceAllInfo;
import java.util.ArrayList;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class NamespaceOperationService {
    private final ConfigInfoPersistService configInfoPersistService;
    private final CommonPersistService commonPersistService;
    private static final String DEFAULT_NAMESPACE = "public";
    private static final String DEFAULT_NAMESPACE_SHOW_NAME = "Public";
    private static final String DEFAULT_NAMESPACE_DESCRIPTION = "Public Namespace";
    private static final int DEFAULT_QUOTA = 200;
    private static final String DEFAULT_CREATE_SOURCE = "nacos";
    private static final String DEFAULT_TENANT = "";
    private static final String DEFAULT_KP = "1";

    public NamespaceOperationService(ConfigInfoPersistService configInfoPersistService, CommonPersistService commonPersistService) {
        this.configInfoPersistService = configInfoPersistService;
        this.commonPersistService = commonPersistService;
    }

    public List<Namespace> getNamespaceList() {
        List tenantInfos = this.commonPersistService.findTenantByKp(DEFAULT_KP);
        Namespace namespace0 = new Namespace(NamespaceUtil.getNamespaceDefaultId(), DEFAULT_NAMESPACE, 200, this.configInfoPersistService.configInfoCount(DEFAULT_TENANT), NamespaceTypeEnum.GLOBAL.getType());
        ArrayList<Namespace> namespaceList = new ArrayList<Namespace>();
        namespaceList.add(namespace0);
        for (TenantInfo tenantInfo : tenantInfos) {
            int configCount = this.configInfoPersistService.configInfoCount(tenantInfo.getTenantId());
            Namespace namespaceTmp = new Namespace(tenantInfo.getTenantId(), tenantInfo.getTenantName(), tenantInfo.getTenantDesc(), 200, configCount, NamespaceTypeEnum.CUSTOM.getType());
            namespaceList.add(namespaceTmp);
        }
        return namespaceList;
    }

    public NamespaceAllInfo getNamespace(String namespaceId) throws NacosException {
        if (StringUtils.isBlank((CharSequence)namespaceId) || namespaceId.equals(NamespaceUtil.getNamespaceDefaultId())) {
            return new NamespaceAllInfo(namespaceId, DEFAULT_NAMESPACE_SHOW_NAME, 200, this.configInfoPersistService.configInfoCount(DEFAULT_TENANT), NamespaceTypeEnum.GLOBAL.getType(), DEFAULT_NAMESPACE_DESCRIPTION);
        }
        TenantInfo tenantInfo = this.commonPersistService.findTenantByKp(DEFAULT_KP, namespaceId);
        if (null == tenantInfo) {
            throw new NacosApiException(HttpStatus.NOT_FOUND.value(), ErrorCode.NAMESPACE_NOT_EXIST, "namespaceId [ " + namespaceId + " ] not exist");
        }
        int configCount = this.configInfoPersistService.configInfoCount(namespaceId);
        return new NamespaceAllInfo(namespaceId, tenantInfo.getTenantName(), 200, configCount, NamespaceTypeEnum.CUSTOM.getType(), tenantInfo.getTenantDesc());
    }

    public Boolean createNamespace(String namespaceId, String namespaceName, String namespaceDesc) throws NacosException {
        if (this.commonPersistService.tenantInfoCountByTenantId(namespaceId) > 0) {
            throw new NacosApiException(HttpStatus.INTERNAL_SERVER_ERROR.value(), ErrorCode.NAMESPACE_ALREADY_EXIST, "namespaceId [" + namespaceId + "] already exist");
        }
        this.commonPersistService.insertTenantInfoAtomic(DEFAULT_KP, namespaceId, namespaceName, namespaceDesc, DEFAULT_CREATE_SOURCE, System.currentTimeMillis());
        return true;
    }

    public Boolean editNamespace(String namespaceId, String namespaceName, String namespaceDesc) {
        this.commonPersistService.updateTenantNameAtomic(DEFAULT_KP, namespaceId, namespaceName, namespaceDesc);
        return true;
    }

    public Boolean removeNamespace(String namespaceId) {
        this.commonPersistService.removeTenantInfoAtomic(DEFAULT_KP, namespaceId);
        return true;
    }
}

