/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.control.tps;

import com.alibaba.nacos.common.spi.NacosServiceLoader;
import com.alibaba.nacos.plugin.control.Loggers;
import com.alibaba.nacos.plugin.control.configs.ControlConfigs;
import com.alibaba.nacos.plugin.control.tps.RuleBarrier;
import com.alibaba.nacos.plugin.control.tps.RuleBarrierCreator;
import com.alibaba.nacos.plugin.control.tps.nacos.LocalSimpleCountBarrierCreator;
import com.alibaba.nacos.plugin.control.tps.request.TpsCheckRequest;
import com.alibaba.nacos.plugin.control.tps.response.TpsCheckResponse;
import com.alibaba.nacos.plugin.control.tps.rule.TpsControlRule;
import java.util.Collection;
import java.util.concurrent.TimeUnit;

public abstract class TpsBarrier {
    protected String pointName;
    protected RuleBarrier pointBarrier;
    protected static RuleBarrierCreator ruleBarrierCreator;

    public TpsBarrier(String pointName) {
        this.pointName = pointName;
        this.pointBarrier = ruleBarrierCreator.createRuleBarrier(pointName, pointName, TimeUnit.SECONDS);
    }

    public static void setRuleBarrierCreator(RuleBarrierCreator ruleBarrierCreatorInstance) {
        ruleBarrierCreator = ruleBarrierCreatorInstance;
    }

    public abstract TpsCheckResponse applyTps(TpsCheckRequest var1);

    public RuleBarrier getPointBarrier() {
        return this.pointBarrier;
    }

    public String getPointName() {
        return this.pointName;
    }

    public abstract void applyRule(TpsControlRule var1);

    static {
        String tpsBarrierCreator = ControlConfigs.getInstance().getTpsBarrierCreator();
        Collection loadedCreators = NacosServiceLoader.load(RuleBarrierCreator.class);
        for (RuleBarrierCreator barrierCreator : loadedCreators) {
            if (!tpsBarrierCreator.equalsIgnoreCase(barrierCreator.name())) continue;
            Loggers.CONTROL.info("Found tps rule creator of name : {}", (Object)tpsBarrierCreator);
            ruleBarrierCreator = barrierCreator;
            break;
        }
        if (ruleBarrierCreator == null) {
            Loggers.CONTROL.warn("Fail to found tps rule creator of name : {},use  default local simple creator", (Object)tpsBarrierCreator);
            ruleBarrierCreator = LocalSimpleCountBarrierCreator.getInstance();
        }
    }
}

