/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.controllers;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.pojo.ServiceInfo;
import com.alibaba.nacos.api.naming.utils.NamingUtils;
import com.alibaba.nacos.api.selector.Selector;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.auth.common.ActionTypes;
import com.alibaba.nacos.common.utils.ConvertUtils;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.common.utils.NumberUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.core.utils.WebUtils;
import com.alibaba.nacos.naming.core.InstanceOperator;
import com.alibaba.nacos.naming.core.InstanceOperatorClientImpl;
import com.alibaba.nacos.naming.core.InstanceOperatorServiceImpl;
import com.alibaba.nacos.naming.core.ServiceManager;
import com.alibaba.nacos.naming.core.ServiceOperator;
import com.alibaba.nacos.naming.core.ServiceOperatorV1Impl;
import com.alibaba.nacos.naming.core.ServiceOperatorV2Impl;
import com.alibaba.nacos.naming.core.v2.index.ServiceStorage;
import com.alibaba.nacos.naming.core.v2.metadata.ServiceMetadata;
import com.alibaba.nacos.naming.core.v2.pojo.Service;
import com.alibaba.nacos.naming.core.v2.upgrade.UpgradeJudgement;
import com.alibaba.nacos.naming.core.v2.upgrade.doublewrite.delay.DoubleWriteDelayTaskEngine;
import com.alibaba.nacos.naming.misc.SwitchDomain;
import com.alibaba.nacos.naming.misc.UtilsAndCommons;
import com.alibaba.nacos.naming.monitor.MetricsMonitor;
import com.alibaba.nacos.naming.pojo.Subscriber;
import com.alibaba.nacos.naming.pojo.instance.HttpRequestInstanceBuilder;
import com.alibaba.nacos.naming.selector.NoneSelector;
import com.alibaba.nacos.naming.selector.SelectorManager;
import com.alibaba.nacos.naming.utils.ServiceUtil;
import com.alibaba.nacos.naming.web.CanDistro;
import com.alibaba.nacos.naming.web.NamingResourceParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/ns/upgrade/ops"})
public class UpgradeOpsController {
    private final SwitchDomain switchDomain;
    private final ServiceManager serviceManager;
    private final ServiceOperatorV1Impl serviceOperatorV1;
    private final ServiceOperatorV2Impl serviceOperatorV2;
    private final InstanceOperatorServiceImpl instanceServiceV1;
    private final InstanceOperatorClientImpl instanceServiceV2;
    private final ServiceStorage serviceStorage;
    private final DoubleWriteDelayTaskEngine doubleWriteDelayTaskEngine;
    private final UpgradeJudgement upgradeJudgement;
    @Autowired
    private SelectorManager selectorManager;

    public UpgradeOpsController(SwitchDomain switchDomain, ServiceManager serviceManager, ServiceOperatorV1Impl serviceOperatorV1, ServiceOperatorV2Impl serviceOperatorV2, InstanceOperatorServiceImpl instanceServiceV1, InstanceOperatorClientImpl instanceServiceV2, ServiceStorage serviceStorage, DoubleWriteDelayTaskEngine doubleWriteDelayTaskEngine, UpgradeJudgement upgradeJudgement) {
        this.switchDomain = switchDomain;
        this.serviceManager = serviceManager;
        this.serviceOperatorV1 = serviceOperatorV1;
        this.serviceOperatorV2 = serviceOperatorV2;
        this.instanceServiceV1 = instanceServiceV1;
        this.instanceServiceV2 = instanceServiceV2;
        this.serviceStorage = serviceStorage;
        this.doubleWriteDelayTaskEngine = doubleWriteDelayTaskEngine;
        this.upgradeJudgement = upgradeJudgement;
    }

    @GetMapping(value={"/metrics"})
    public String metrics(@RequestParam(required=false, defaultValue="false") boolean json) throws NacosException {
        ObjectNode result = this.getMetrics();
        if (json) {
            return JacksonUtils.toJson((Object)result);
        }
        StringBuilder sb = new StringBuilder();
        Iterator fields = result.fields();
        fields.forEachRemaining(e -> {
            sb.append(String.format("%-30s = ", e.getKey()));
            JsonNode value = (JsonNode)e.getValue();
            if (value.isIntegralNumber()) {
                sb.append(String.format("%5d", value.longValue()));
            } else if (value.isFloatingPointNumber()) {
                sb.append(String.format("%.3f", value.doubleValue()));
            } else if (value.isTextual()) {
                sb.append(value.textValue());
            } else {
                sb.append(value.toString());
            }
            sb.append('\n');
        });
        return sb.toString();
    }

    private ObjectNode getMetrics() throws NacosException {
        ObjectNode result = JacksonUtils.createEmptyJsonNode();
        HashSet<String> serviceNamesV2 = new HashSet<String>();
        HashSet<String> persistentServiceNamesV2 = new HashSet<String>();
        HashSet<String> ephemeralServiceNamesV2 = new HashSet<String>();
        int persistentInstanceCountV2 = 0;
        int ephemeralInstanceCountV2 = 0;
        Set<String> allNamespaces = com.alibaba.nacos.naming.core.v2.ServiceManager.getInstance().getAllNamespaces();
        for (String ns : allNamespaces) {
            Set<Service> services = com.alibaba.nacos.naming.core.v2.ServiceManager.getInstance().getSingletons(ns);
            for (Service service : services) {
                String nameWithNs = service.getNamespace() + "##" + service.getGroupedServiceName();
                serviceNamesV2.add(nameWithNs);
                if (service.isEphemeral()) {
                    ephemeralServiceNamesV2.add(nameWithNs);
                } else {
                    persistentServiceNamesV2.add(nameWithNs);
                }
                ServiceInfo data = this.serviceStorage.getPushData(service);
                for (Instance instance : data.getHosts()) {
                    if (instance.isEphemeral()) {
                        ++ephemeralInstanceCountV2;
                        continue;
                    }
                    ++persistentInstanceCountV2;
                }
            }
        }
        result.put("upgraded", this.upgradeJudgement.isUseGrpcFeatures());
        result.put("isAll20XVersion", this.upgradeJudgement.isAll20XVersion());
        result.put("isDoubleWriteEnabled", this.switchDomain.isDoubleWriteEnabled());
        result.put("doubleWriteDelayTaskCount", this.doubleWriteDelayTaskEngine.size());
        result.put("serviceCountV1", this.serviceManager.getServiceCount());
        result.put("instanceCountV1", this.serviceManager.getInstanceCount());
        result.put("serviceCountV2", MetricsMonitor.getDomCountMonitor().get());
        result.put("instanceCountV2", MetricsMonitor.getIpCountMonitor().get());
        result.put("subscribeCountV2", MetricsMonitor.getSubscriberCount().get());
        result.put("responsibleServiceCountV1", this.serviceManager.getResponsibleServiceCount());
        result.put("responsibleInstanceCountV1", this.serviceManager.getResponsibleInstanceCount());
        result.put("ephemeralServiceCountV2", ephemeralServiceNamesV2.size());
        result.put("persistentServiceCountV2", persistentServiceNamesV2.size());
        result.put("ephemeralInstanceCountV2", ephemeralInstanceCountV2);
        result.put("persistentInstanceCountV2", persistentInstanceCountV2);
        Set serviceNamesV1 = this.serviceManager.getAllServiceNames().entrySet().stream().flatMap(e -> ((Set)e.getValue()).stream().map(name -> {
            if (!name.contains("@@")) {
                name = NamingUtils.getGroupedName((String)name, (String)"DEFAULT_GROUP");
            }
            return (String)e.getKey() + "##" + name;
        })).collect(Collectors.toSet());
        result.put("service.V1.not.in.V2", String.join((CharSequence)"\n", CollectionUtils.subtract(serviceNamesV1, serviceNamesV2)));
        result.put("service.V2.not.in.V1", String.join((CharSequence)"\n", CollectionUtils.subtract(serviceNamesV2, serviceNamesV1)));
        return result;
    }

    @PostMapping(value={"/service"})
    @Secured(parser=NamingResourceParser.class, action=ActionTypes.WRITE)
    public String createService(@RequestParam(defaultValue="v2", required=false) String ver, HttpServletRequest request, @RequestParam(defaultValue="public") String namespaceId, @RequestParam String serviceName, @RequestParam(required=false, defaultValue="0.0F") float protectThreshold, @RequestParam(defaultValue="") String metadata, @RequestParam(defaultValue="") String selector) throws Exception {
        ServiceMetadata serviceMetadata = new ServiceMetadata();
        serviceMetadata.setProtectThreshold(protectThreshold);
        serviceMetadata.setSelector(this.parseSelector(selector));
        serviceMetadata.setExtendData(UtilsAndCommons.parseMetadata(metadata));
        boolean ephemeral = ConvertUtils.toBoolean((String)WebUtils.optional((HttpServletRequest)request, (String)"ephemeral", (String)String.valueOf(this.switchDomain.isDefaultInstanceEphemeral())));
        serviceMetadata.setEphemeral(ephemeral);
        this.getServiceOperator(ver).create(namespaceId, serviceName, serviceMetadata);
        return "ok";
    }

    @DeleteMapping(value={"/service"})
    @Secured(parser=NamingResourceParser.class, action=ActionTypes.WRITE)
    public String removeService(@RequestParam(defaultValue="v2", required=false) String ver, @RequestParam(defaultValue="public") String namespaceId, @RequestParam String serviceName) throws Exception {
        this.getServiceOperator(ver).delete(namespaceId, serviceName);
        return "ok";
    }

    private ServiceOperator getServiceOperator(String ver) {
        return "v2".equals(ver) ? this.serviceOperatorV2 : this.serviceOperatorV1;
    }

    @GetMapping(value={"/service"})
    @Secured(parser=NamingResourceParser.class, action=ActionTypes.READ)
    public ObjectNode detailService(@RequestParam(defaultValue="v2", required=false) String ver, @RequestParam(defaultValue="public") String namespaceId, @RequestParam String serviceName) throws NacosException {
        return this.getServiceOperator(ver).queryService(namespaceId, serviceName);
    }

    @GetMapping(value={"/service/list"})
    @Secured(parser=NamingResourceParser.class, action=ActionTypes.READ)
    public ObjectNode listService(@RequestParam(defaultValue="v2", required=false) String ver, HttpServletRequest request) throws Exception {
        int pageNo = NumberUtils.toInt((String)WebUtils.required((HttpServletRequest)request, (String)"pageNo"));
        int pageSize = NumberUtils.toInt((String)WebUtils.required((HttpServletRequest)request, (String)"pageSize"));
        String namespaceId = WebUtils.optional((HttpServletRequest)request, (String)"namespaceId", (String)"public");
        String groupName = WebUtils.optional((HttpServletRequest)request, (String)"groupName", (String)"DEFAULT_GROUP");
        String selectorString = WebUtils.optional((HttpServletRequest)request, (String)"selector", (String)"");
        ObjectNode result = JacksonUtils.createEmptyJsonNode();
        Collection<String> serviceNameList = this.getServiceOperator(ver).listService(namespaceId, groupName, selectorString);
        result.put("count", serviceNameList.size());
        result.replace("doms", JacksonUtils.transferToJsonNode(ServiceUtil.pageServiceName(pageNo, pageSize, serviceNameList)));
        return result;
    }

    @PutMapping(value={"/service"})
    @Secured(parser=NamingResourceParser.class, action=ActionTypes.WRITE)
    public String updateService(@RequestParam(defaultValue="v2", required=false) String ver, HttpServletRequest request) throws Exception {
        String namespaceId = WebUtils.optional((HttpServletRequest)request, (String)"namespaceId", (String)"public");
        String serviceName = WebUtils.required((HttpServletRequest)request, (String)"serviceName");
        ServiceMetadata serviceMetadata = new ServiceMetadata();
        serviceMetadata.setProtectThreshold(NumberUtils.toFloat((String)WebUtils.required((HttpServletRequest)request, (String)"protectThreshold")));
        serviceMetadata.setExtendData(UtilsAndCommons.parseMetadata(WebUtils.optional((HttpServletRequest)request, (String)"metadata", (String)"")));
        serviceMetadata.setSelector(this.parseSelector(WebUtils.optional((HttpServletRequest)request, (String)"selector", (String)"")));
        Service service = Service.newService(namespaceId, NamingUtils.getGroupName((String)serviceName), NamingUtils.getServiceName((String)serviceName));
        this.getServiceOperator(ver).update(service, serviceMetadata);
        return "ok";
    }

    @RequestMapping(value={"/service/names"})
    @Secured(parser=NamingResourceParser.class, action=ActionTypes.READ)
    public ObjectNode searchService(@RequestParam(defaultValue="v2", required=false) String ver, @RequestParam(defaultValue="") String namespaceId, @RequestParam(defaultValue="") String expr, @RequestParam(required=false) boolean responsibleOnly) throws NacosException {
        HashMap<String, Object> serviceNameMap = new HashMap<String, Object>(16);
        int totalCount = 0;
        ServiceOperator serviceOperator = this.getServiceOperator(ver);
        if (StringUtils.isNotBlank((String)namespaceId)) {
            Collection<String> names = serviceOperator.searchServiceName(namespaceId, expr, responsibleOnly);
            serviceNameMap.put(namespaceId, names);
            totalCount = names.size();
        } else {
            for (String each : serviceOperator.listAllNamespace()) {
                Collection<String> names = serviceOperator.searchServiceName(each, expr, responsibleOnly);
                serviceNameMap.put(each, names);
                totalCount += names.size();
            }
        }
        ObjectNode result = JacksonUtils.createEmptyJsonNode();
        result.replace("services", JacksonUtils.transferToJsonNode(serviceNameMap));
        result.put("count", totalCount);
        return result;
    }

    private Selector parseSelector(String selectorJsonString) throws Exception {
        String expression;
        if (StringUtils.isBlank((CharSequence)selectorJsonString)) {
            return new NoneSelector();
        }
        JsonNode selectorJson = JacksonUtils.toObj((String)URLDecoder.decode(selectorJsonString, "UTF-8"));
        String type = Optional.ofNullable(selectorJson.get("type")).orElseThrow(() -> new NacosException(400, "not match any type of selector!")).asText();
        Selector selector = this.selectorManager.parseSelector(type, expression = (String)Optional.ofNullable(selectorJson.get("expression")).map(JsonNode::asText).orElse(null));
        if (Objects.isNull(selector)) {
            throw new NacosException(400, "not match any type of selector!");
        }
        return selector;
    }

    @CanDistro
    @PostMapping(value={"/instance"})
    @Secured(parser=NamingResourceParser.class, action=ActionTypes.WRITE)
    public String registerInstance(@RequestParam(defaultValue="v2", required=false) String ver, HttpServletRequest request) throws Exception {
        String namespaceId = WebUtils.optional((HttpServletRequest)request, (String)"namespaceId", (String)"public");
        String serviceName = WebUtils.required((HttpServletRequest)request, (String)"serviceName");
        NamingUtils.checkServiceNameFormat((String)serviceName);
        Instance instance = HttpRequestInstanceBuilder.newBuilder().setDefaultInstanceEphemeral(this.switchDomain.isDefaultInstanceEphemeral()).setRequest(request).build();
        this.getInstanceOperator(ver).registerInstance(namespaceId, serviceName, instance);
        return "ok";
    }

    @CanDistro
    @DeleteMapping(value={"/instance"})
    @Secured(parser=NamingResourceParser.class, action=ActionTypes.WRITE)
    public String deregisterInstance(@RequestParam(defaultValue="v2", required=false) String ver, HttpServletRequest request) throws Exception {
        Instance instance = HttpRequestInstanceBuilder.newBuilder().setDefaultInstanceEphemeral(this.switchDomain.isDefaultInstanceEphemeral()).setRequest(request).build();
        String namespaceId = WebUtils.optional((HttpServletRequest)request, (String)"namespaceId", (String)"public");
        String serviceName = WebUtils.required((HttpServletRequest)request, (String)"serviceName");
        NamingUtils.checkServiceNameFormat((String)serviceName);
        this.getInstanceOperator(ver).removeInstance(namespaceId, serviceName, instance);
        return "ok";
    }

    @CanDistro
    @PutMapping(value={"/instance"})
    @Secured(parser=NamingResourceParser.class, action=ActionTypes.WRITE)
    public String updateInstance(@RequestParam(defaultValue="v2", required=false) String ver, HttpServletRequest request) throws Exception {
        String namespaceId = WebUtils.optional((HttpServletRequest)request, (String)"namespaceId", (String)"public");
        String serviceName = WebUtils.required((HttpServletRequest)request, (String)"serviceName");
        NamingUtils.checkServiceNameFormat((String)serviceName);
        Instance instance = HttpRequestInstanceBuilder.newBuilder().setDefaultInstanceEphemeral(this.switchDomain.isDefaultInstanceEphemeral()).setRequest(request).build();
        this.getInstanceOperator(ver).updateInstance(namespaceId, serviceName, instance);
        return "ok";
    }

    @GetMapping(value={"/instance/list"})
    @Secured(parser=NamingResourceParser.class, action=ActionTypes.READ)
    public Object listInstance(@RequestParam(defaultValue="v2", required=false) String ver, HttpServletRequest request) throws Exception {
        String namespaceId = WebUtils.optional((HttpServletRequest)request, (String)"namespaceId", (String)"public");
        String serviceName = WebUtils.required((HttpServletRequest)request, (String)"serviceName");
        NamingUtils.checkServiceNameFormat((String)serviceName);
        String agent = WebUtils.getUserAgent((HttpServletRequest)request);
        String clusters = WebUtils.optional((HttpServletRequest)request, (String)"clusters", (String)"");
        String clientIP = WebUtils.optional((HttpServletRequest)request, (String)"clientIP", (String)"");
        int udpPort = Integer.parseInt(WebUtils.optional((HttpServletRequest)request, (String)"udpPort", (String)"0"));
        boolean healthyOnly = Boolean.parseBoolean(WebUtils.optional((HttpServletRequest)request, (String)"healthyOnly", (String)"false"));
        boolean isCheck = Boolean.parseBoolean(WebUtils.optional((HttpServletRequest)request, (String)"isCheck", (String)"false"));
        String app = WebUtils.optional((HttpServletRequest)request, (String)"app", (String)"");
        String env = WebUtils.optional((HttpServletRequest)request, (String)"env", (String)"");
        String tenant = WebUtils.optional((HttpServletRequest)request, (String)"tid", (String)"");
        Subscriber subscriber = new Subscriber(clientIP + ":" + udpPort, agent, app, clientIP, namespaceId, serviceName, udpPort, clusters);
        return this.getInstanceOperator(ver).listInstance(namespaceId, serviceName, subscriber, clusters, healthyOnly);
    }

    @GetMapping(value={"/instance"})
    @Secured(parser=NamingResourceParser.class, action=ActionTypes.READ)
    public ObjectNode detailInstance(@RequestParam(defaultValue="v2", required=false) String ver, HttpServletRequest request) throws Exception {
        String namespaceId = WebUtils.optional((HttpServletRequest)request, (String)"namespaceId", (String)"public");
        String serviceName = WebUtils.required((HttpServletRequest)request, (String)"serviceName");
        NamingUtils.checkServiceNameFormat((String)serviceName);
        String cluster = WebUtils.optional((HttpServletRequest)request, (String)"clusterName", (String)"DEFAULT");
        String ip = WebUtils.required((HttpServletRequest)request, (String)"ip");
        int port = Integer.parseInt(WebUtils.required((HttpServletRequest)request, (String)"port"));
        Instance instance = this.getInstanceOperator(ver).getInstance(namespaceId, serviceName, cluster, ip, port);
        ObjectNode result = JacksonUtils.createEmptyJsonNode();
        result.put("service", serviceName);
        result.put("ip", ip);
        result.put("port", port);
        result.put("clusterName", cluster);
        result.put("weight", instance.getWeight());
        result.put("healthy", instance.isHealthy());
        result.put("instanceId", instance.getInstanceId());
        result.set("metadata", JacksonUtils.transferToJsonNode((Object)instance.getMetadata()));
        return result;
    }

    private InstanceOperator getInstanceOperator(String ver) {
        return "v2".equals(ver) ? this.instanceServiceV2 : this.instanceServiceV1;
    }
}

