/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.core;

import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.naming.core.Instance;
import com.alibaba.nacos.naming.core.Service;
import com.alibaba.nacos.naming.healthcheck.HealthCheckReactor;
import com.alibaba.nacos.naming.healthcheck.HealthCheckStatus;
import com.alibaba.nacos.naming.healthcheck.HealthCheckTask;
import com.alibaba.nacos.naming.misc.Loggers;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.util.Assert;

public class Cluster
extends com.alibaba.nacos.api.naming.pojo.Cluster
implements Cloneable {
    private static final String CLUSTER_NAME_SYNTAX = "[0-9a-zA-Z-]+";
    private static final long serialVersionUID = 8940123791150907510L;
    private String sitegroup = "";
    private int defCkport = 80;
    private int defIpPort = -1;
    @JsonIgnore
    private HealthCheckTask checkTask;
    @JsonIgnore
    private Set<Instance> persistentInstances = new HashSet<Instance>();
    @JsonIgnore
    private Set<Instance> ephemeralInstances = new HashSet<Instance>();
    @JsonIgnore
    private Service service;
    @JsonIgnore
    private volatile boolean inited = false;
    private Map<String, String> metadata = new ConcurrentHashMap<String, String>();

    public Cluster() {
    }

    public Cluster(String clusterName, Service service) {
        this.setName(clusterName);
        this.service = service;
        this.validate();
    }

    public int getDefIPPort() {
        return this.defIpPort == -1 ? this.defCkport : this.defIpPort;
    }

    public void setDefIPPort(int defIpPort) {
        if (defIpPort == 0) {
            throw new IllegalArgumentException("defIPPort can not be 0");
        }
        this.defIpPort = defIpPort;
    }

    public List<Instance> allIPs() {
        ArrayList<Instance> allInstances = new ArrayList<Instance>();
        allInstances.addAll(this.persistentInstances);
        allInstances.addAll(this.ephemeralInstances);
        return allInstances;
    }

    public List<Instance> allIPs(boolean ephemeral) {
        return ephemeral ? new ArrayList<Instance>(this.ephemeralInstances) : new ArrayList<Instance>(this.persistentInstances);
    }

    public void init() {
        if (this.inited) {
            return;
        }
        this.checkTask = new HealthCheckTask(this);
        HealthCheckReactor.scheduleCheck(this.checkTask);
        this.inited = true;
    }

    public void destroy() {
        if (this.checkTask != null) {
            this.checkTask.setCancelled(true);
        }
    }

    @JsonIgnore
    public HealthCheckTask getHealthCheckTask() {
        return this.checkTask;
    }

    public Service getService() {
        return this.service;
    }

    public void setService(Service service) {
        if (this.service != null) {
            return;
        }
        this.service = service;
    }

    @Deprecated
    public void setServiceName(String serviceName) {
        super.setServiceName(serviceName);
    }

    public String getServiceName() {
        if (this.service != null) {
            return this.service.getName();
        }
        return super.getServiceName();
    }

    public Cluster clone() throws CloneNotSupportedException {
        super.clone();
        Cluster cluster = new Cluster(this.getName(), this.service);
        cluster.setHealthChecker(this.getHealthChecker().clone());
        cluster.persistentInstances = new HashSet<Instance>();
        cluster.checkTask = null;
        cluster.metadata = new HashMap<String, String>(this.metadata);
        return cluster;
    }

    public boolean isEmpty() {
        return this.ephemeralInstances.isEmpty() && this.persistentInstances.isEmpty();
    }

    public void updateIps(List<Instance> ips, boolean ephemeral) {
        List<Instance> list;
        List<Instance> list2;
        Set<Instance> toUpdateInstances = ephemeral ? this.ephemeralInstances : this.persistentInstances;
        HashMap<String, Instance> oldIpMap = new HashMap<String, Instance>(toUpdateInstances.size());
        for (Instance instance : toUpdateInstances) {
            oldIpMap.put(instance.getDatumKey(), instance);
        }
        List<Instance> updatedIps = this.updatedIps(ips, oldIpMap.values());
        if (updatedIps.size() > 0) {
            for (Instance instance : updatedIps) {
                Instance oldIP = (Instance)oldIpMap.get(instance.getDatumKey());
                if (!instance.isMarked()) {
                    instance.setHealthy(oldIP.isHealthy());
                }
                if (instance.isHealthy() != oldIP.isHealthy()) {
                    Loggers.EVT_LOG.info("{} {SYNC} IP-{} {}:{}@{}", new Object[]{this.getService().getName(), instance.isHealthy() ? "ENABLED" : "DISABLED", instance.getIp(), instance.getPort(), this.getName()});
                }
                if (instance.getWeight() == oldIP.getWeight()) continue;
                Loggers.EVT_LOG.info("{} {SYNC} {IP-UPDATED} {}->{}", new Object[]{this.getService().getName(), oldIP, instance});
            }
        }
        if ((list2 = this.subtract(ips, oldIpMap.values())).size() > 0) {
            Loggers.EVT_LOG.info("{} {SYNC} {IP-NEW} cluster: {}, new ips size: {}, content: {}", new Object[]{this.getService().getName(), this.getName(), list2.size(), list2});
            for (Instance ip : list2) {
                HealthCheckStatus.reset(ip);
            }
        }
        if ((list = this.subtract(oldIpMap.values(), ips)).size() > 0) {
            Loggers.EVT_LOG.info("{} {SYNC} {IP-DEAD} cluster: {}, dead ips size: {}, content: {}", new Object[]{this.getService().getName(), this.getName(), list.size(), list});
            for (Instance ip : list) {
                HealthCheckStatus.remv(ip);
            }
        }
        toUpdateInstances = new HashSet<Instance>(ips);
        if (ephemeral) {
            this.ephemeralInstances = toUpdateInstances;
        } else {
            this.persistentInstances = toUpdateInstances;
        }
    }

    private List<Instance> updatedIps(Collection<Instance> newInstance, Collection<Instance> oldInstance) {
        List intersects = (List)CollectionUtils.intersection(newInstance, oldInstance);
        ConcurrentHashMap<String, Instance> stringIpAddressMap = new ConcurrentHashMap<String, Instance>(intersects.size());
        for (Instance instance : intersects) {
            stringIpAddressMap.put(instance.getIp() + ":" + instance.getPort(), instance);
        }
        ConcurrentHashMap<String, Integer> intersectMap = new ConcurrentHashMap<String, Integer>(newInstance.size() + oldInstance.size());
        ConcurrentHashMap updatedInstancesMap = new ConcurrentHashMap(newInstance.size());
        ConcurrentHashMap<String, Instance> newInstancesMap = new ConcurrentHashMap<String, Instance>(newInstance.size());
        for (Instance instance : oldInstance) {
            if (!stringIpAddressMap.containsKey(instance.getIp() + ":" + instance.getPort())) continue;
            intersectMap.put(instance.toString(), 1);
        }
        for (Instance instance : newInstance) {
            if (stringIpAddressMap.containsKey(instance.getIp() + ":" + instance.getPort())) {
                if (intersectMap.containsKey(instance.toString())) {
                    intersectMap.put(instance.toString(), 2);
                } else {
                    intersectMap.put(instance.toString(), 1);
                }
            }
            newInstancesMap.put(instance.toString(), instance);
        }
        for (Map.Entry entry : intersectMap.entrySet()) {
            String key = (String)entry.getKey();
            Integer value = (Integer)entry.getValue();
            if (value != 1 || !newInstancesMap.containsKey(key)) continue;
            updatedInstancesMap.put(key, newInstancesMap.get(key));
        }
        return new ArrayList<Instance>(updatedInstancesMap.values());
    }

    private List<Instance> subtract(Collection<Instance> oldIp, Collection<Instance> ips) {
        HashMap<String, Instance> ipsMap = new HashMap<String, Instance>(ips.size());
        for (Instance instance : ips) {
            ipsMap.put(instance.getIp() + ":" + instance.getPort(), instance);
        }
        ArrayList<Instance> instanceResult = new ArrayList<Instance>();
        for (Instance instance : oldIp) {
            if (ipsMap.containsKey(instance.getIp() + ":" + instance.getPort())) continue;
            instanceResult.add(instance);
        }
        return instanceResult;
    }

    public int hashCode() {
        return Objects.hash(this.getName());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Cluster)) {
            return false;
        }
        return this.getName().equals(((Cluster)obj).getName());
    }

    public int getDefCkport() {
        return this.defCkport;
    }

    public void setDefCkport(int defCkport) {
        this.defCkport = defCkport;
        super.setDefaultCheckPort(defCkport);
    }

    public void update(Cluster cluster) {
        if (!this.getHealthChecker().equals(cluster.getHealthChecker())) {
            Loggers.SRV_LOG.info("[CLUSTER-UPDATE] {}:{}:, healthChecker: {} -> {}", new Object[]{this.getService().getName(), this.getName(), this.getHealthChecker().toString(), cluster.getHealthChecker().toString()});
            this.setHealthChecker(cluster.getHealthChecker());
        }
        if (this.defCkport != cluster.getDefCkport()) {
            Loggers.SRV_LOG.info("[CLUSTER-UPDATE] {}:{}, defCkport: {} -> {}", new Object[]{this.getService().getName(), this.getName(), this.defCkport, cluster.getDefCkport()});
            this.defCkport = cluster.getDefCkport();
        }
        if (this.defIpPort != cluster.getDefIPPort()) {
            Loggers.SRV_LOG.info("[CLUSTER-UPDATE] {}:{}, defIPPort: {} -> {}", new Object[]{this.getService().getName(), this.getName(), this.defIpPort, cluster.getDefIPPort()});
            this.defIpPort = cluster.getDefIPPort();
        }
        if (!StringUtils.equals((String)this.sitegroup, (String)cluster.getSitegroup())) {
            Loggers.SRV_LOG.info("[CLUSTER-UPDATE] {}:{}, sitegroup: {} -> {}", new Object[]{this.getService().getName(), this.getName(), this.sitegroup, cluster.getSitegroup()});
            this.sitegroup = cluster.getSitegroup();
        }
        if (this.isUseIPPort4Check() != cluster.isUseIPPort4Check()) {
            Loggers.SRV_LOG.info("[CLUSTER-UPDATE] {}:{}, useIPPort4Check: {} -> {}", new Object[]{this.getService().getName(), this.getName(), this.isUseIPPort4Check(), cluster.isUseIPPort4Check()});
            this.setUseIPPort4Check(cluster.isUseIPPort4Check());
        }
        this.metadata = cluster.getMetadata();
    }

    public String getSitegroup() {
        return this.sitegroup;
    }

    public void setSitegroup(String sitegroup) {
        this.sitegroup = sitegroup;
    }

    public boolean contains(Instance ip) {
        return this.persistentInstances.contains(ip) || this.ephemeralInstances.contains(ip);
    }

    public void validate() {
        Assert.notNull((Object)this.getName(), (String)"cluster name cannot be null");
        Assert.notNull((Object)this.service, (String)"service cannot be null");
        if (!this.getName().matches(CLUSTER_NAME_SYNTAX)) {
            throw new IllegalArgumentException("cluster name can only have these characters: 0-9a-zA-Z-, current: " + this.getName());
        }
    }
}

