/*
 * Decompiled with CFR 0.152.
 */
package rpc;

import java.io.IOException;
import java.util.Properties;
import rpc.BindException;
import rpc.Connection;
import rpc.ConnectionContext;
import rpc.ConnectionOrientedPdu;
import rpc.DefaultConnection;
import rpc.FaultException;
import rpc.PresentationException;
import rpc.RpcException;
import rpc.core.PresentationContext;
import rpc.core.PresentationResult;
import rpc.pdu.AlterContextPdu;
import rpc.pdu.AlterContextResponsePdu;
import rpc.pdu.BindAcknowledgePdu;
import rpc.pdu.BindNoAcknowledgePdu;
import rpc.pdu.BindPdu;
import rpc.pdu.FaultCoPdu;

public class BasicConnectionContext
implements ConnectionContext {
    private int maxTransmitFragment = 4280;
    private int maxReceiveFragment = 4280;
    private Connection connection;
    private boolean established;
    private int transmitLength;
    private int receiveLength;

    @Override
    public ConnectionOrientedPdu init(PresentationContext context, Properties properties) throws IOException {
        this.established = false;
        this.connection = new DefaultConnection();
        if (properties != null) {
            String maxReceive;
            String maxTransmit = properties.getProperty("rpc.connectionContext.maxTransmitFragment");
            if (maxTransmit != null) {
                this.maxTransmitFragment = Integer.parseInt(maxTransmit);
            }
            if ((maxReceive = properties.getProperty("rpc.connectionContext.maxReceiveFragment")) != null) {
                this.maxReceiveFragment = Integer.parseInt(maxReceive);
            }
        }
        BindPdu pdu = new BindPdu();
        pdu.setContextList(new PresentationContext[]{context});
        pdu.setMaxTransmitFragment(this.maxTransmitFragment);
        pdu.setMaxReceiveFragment(this.maxReceiveFragment);
        return pdu;
    }

    @Override
    public ConnectionOrientedPdu alter(PresentationContext context) throws IOException {
        this.established = false;
        AlterContextPdu pdu = new AlterContextPdu();
        pdu.setContextList(new PresentationContext[]{context});
        return pdu;
    }

    @Override
    public ConnectionOrientedPdu accept(ConnectionOrientedPdu pdu) throws IOException {
        PresentationResult[] results = null;
        switch (pdu.getType()) {
            case 12: {
                BindAcknowledgePdu bindAck = (BindAcknowledgePdu)pdu;
                results = bindAck.getResultList();
                if (results == null) {
                    throw new BindException("No presentation context results.");
                }
                int i = results.length - 1;
                while (i >= 0) {
                    if (results[i].result != 0) {
                        throw new PresentationException("Context rejected.", results[i]);
                    }
                    --i;
                }
                this.transmitLength = bindAck.getMaxReceiveFragment();
                this.receiveLength = bindAck.getMaxTransmitFragment();
                this.established = true;
                this.connection = new DefaultConnection(this.transmitLength, this.receiveLength);
                return null;
            }
            case 15: {
                AlterContextResponsePdu alterContextResponse = (AlterContextResponsePdu)pdu;
                results = alterContextResponse.getResultList();
                if (results == null) {
                    throw new BindException("No presentation context results.");
                }
                int i = results.length - 1;
                while (i >= 0) {
                    if (results[i].result != 0) {
                        throw new PresentationException("Context rejected.", results[i]);
                    }
                    --i;
                }
                this.established = true;
                return null;
            }
            case 13: {
                throw new BindException("Unable to bind.", ((BindNoAcknowledgePdu)pdu).getRejectReason());
            }
            case 3: {
                throw new FaultException("Fault occurred.", ((FaultCoPdu)pdu).getStatus());
            }
            case 17: {
                throw new RpcException("Server shutdown connection.");
            }
            case 11: 
            case 14: {
                throw new RpcException("Server-side currently unsupported.");
            }
        }
        throw new RpcException("Unknown/unacceptable PDU type.");
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public boolean isEstablished() {
        return this.established;
    }
}

