/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.provider.apache;

import java.nio.ByteBuffer;
import java.util.Set;
import org.apache.directory.api.ldap.extras.controls.SynchronizationModeEnum;
import org.apache.directory.api.ldap.extras.controls.ad.AdDirSync;
import org.apache.directory.api.ldap.extras.controls.ad.AdDirSyncFlag;
import org.apache.directory.api.ldap.extras.controls.ad.AdDirSyncImpl;
import org.apache.directory.api.ldap.extras.controls.ppolicy.PasswordPolicy;
import org.apache.directory.api.ldap.extras.controls.ppolicy.PasswordPolicyErrorEnum;
import org.apache.directory.api.ldap.extras.controls.ppolicy.PasswordPolicyImpl;
import org.apache.directory.api.ldap.extras.controls.ppolicy.PasswordPolicyResponse;
import org.apache.directory.api.ldap.extras.controls.syncrepl.syncDone.SyncDoneValue;
import org.apache.directory.api.ldap.extras.controls.syncrepl.syncInfoValue.SyncRequestValueImpl;
import org.apache.directory.api.ldap.extras.controls.syncrepl.syncState.SyncStateValue;
import org.apache.directory.api.ldap.extras.controls.vlv.VirtualListViewRequestImpl;
import org.apache.directory.api.ldap.extras.controls.vlv.VirtualListViewResponse;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.controls.ChangeType;
import org.apache.directory.api.ldap.model.message.controls.EntryChange;
import org.apache.directory.api.ldap.model.message.controls.ManageDsaITImpl;
import org.apache.directory.api.ldap.model.message.controls.PagedResults;
import org.apache.directory.api.ldap.model.message.controls.PagedResultsImpl;
import org.apache.directory.api.ldap.model.message.controls.PersistentSearchImpl;
import org.apache.directory.api.ldap.model.message.controls.SortKey;
import org.apache.directory.api.ldap.model.message.controls.SortRequestControlImpl;
import org.apache.directory.api.ldap.model.message.controls.SortResponse;
import org.ldaptive.LdapUtils;
import org.ldaptive.ResultCode;
import org.ldaptive.ad.control.DirSyncControl;
import org.ldaptive.asn1.UuidType;
import org.ldaptive.control.EntryChangeNotificationControl;
import org.ldaptive.control.PagedResultsControl;
import org.ldaptive.control.PasswordPolicyControl;
import org.ldaptive.control.PersistentSearchChangeType;
import org.ldaptive.control.PersistentSearchRequestControl;
import org.ldaptive.control.RequestControl;
import org.ldaptive.control.ResponseControl;
import org.ldaptive.control.SortRequestControl;
import org.ldaptive.control.SortResponseControl;
import org.ldaptive.control.SyncDoneControl;
import org.ldaptive.control.SyncRequestControl;
import org.ldaptive.control.SyncStateControl;
import org.ldaptive.control.VirtualListViewRequestControl;
import org.ldaptive.control.VirtualListViewResponseControl;
import org.ldaptive.provider.ControlHandler;

public class ApacheLdapControlHandler
implements ControlHandler<Control> {
    public Class<Control> getControlType() {
        return Control.class;
    }

    public String getOID(Control control) {
        return control.getOid();
    }

    public Control handleRequest(RequestControl requestControl) {
        ManageDsaITImpl ctl = null;
        if ("2.16.840.1.113730.3.4.2".equals(requestControl.getOID())) {
            ctl = new ManageDsaITImpl(requestControl.getCriticality());
        } else if ("1.2.840.113556.1.4.473".equals(requestControl.getOID())) {
            SortRequestControl c = (SortRequestControl)requestControl;
            ctl = new SortRequestControlImpl();
            for (org.ldaptive.control.SortKey k : c.getSortKeys()) {
                ((SortRequestControlImpl)ctl).addSortKey(new SortKey(k.getAttributeDescription(), k.getMatchingRuleId(), k.getReverseOrder()));
            }
            ctl.setCritical(c.getCriticality());
        } else if ("1.2.840.113556.1.4.319".equals(requestControl.getOID())) {
            PagedResultsControl c = (PagedResultsControl)requestControl;
            ctl = new PagedResultsImpl();
            ((PagedResultsImpl)ctl).setSize(c.getSize());
            ((PagedResultsImpl)ctl).setCookie(c.getCookie());
            ctl.setCritical(c.getCriticality());
        } else if ("1.3.6.1.4.1.42.2.27.8.5.1".equals(requestControl.getOID())) {
            PasswordPolicyControl c = (PasswordPolicyControl)requestControl;
            ctl = new PasswordPolicyImpl();
            ctl.setCritical(c.getCriticality());
        } else if ("1.3.6.1.4.1.4203.1.9.1.1".equals(requestControl.getOID())) {
            SyncRequestControl c = (SyncRequestControl)requestControl;
            ctl = new SyncRequestValueImpl();
            ((SyncRequestValueImpl)ctl).setCookie(c.getCookie());
            ((SyncRequestValueImpl)ctl).setReloadHint(c.getReloadHint());
            ((SyncRequestValueImpl)ctl).setMode(SynchronizationModeEnum.getSyncMode((int)c.getRequestMode().value()));
            ctl.setCritical(c.getCriticality());
        } else if ("2.16.840.1.113730.3.4.3".equals(requestControl.getOID())) {
            PersistentSearchRequestControl c = (PersistentSearchRequestControl)requestControl;
            ctl = new PersistentSearchImpl();
            for (PersistentSearchChangeType type : c.getChangeTypes()) {
                ((PersistentSearchImpl)ctl).enableNotification(ChangeType.getChangeType((int)type.value()));
            }
            ((PersistentSearchImpl)ctl).setChangesOnly(c.getChangesOnly());
            ((PersistentSearchImpl)ctl).setReturnECs(c.getReturnEcs());
            ctl.setCritical(c.getCriticality());
        } else if ("1.2.840.113556.1.4.841".equals(requestControl.getOID())) {
            DirSyncControl c = (DirSyncControl)requestControl;
            ctl = new AdDirSyncImpl();
            ((AdDirSyncImpl)ctl).setCookie(c.getCookie());
            ((AdDirSyncImpl)ctl).setFlags(AdDirSyncFlag.getFlags((int)((int)c.getFlags())));
            ((AdDirSyncImpl)ctl).setMaxReturnLength(c.getMaxAttributeCount());
            ctl.setCritical(c.getCriticality());
        } else if ("2.16.840.1.113730.3.4.9".equals(requestControl.getOID())) {
            VirtualListViewRequestControl c = (VirtualListViewRequestControl)requestControl;
            ctl = new VirtualListViewRequestImpl();
            ((VirtualListViewRequestImpl)ctl).setBeforeCount(c.getBeforeCount());
            ((VirtualListViewRequestImpl)ctl).setAfterCount(c.getAfterCount());
            ((VirtualListViewRequestImpl)ctl).setContentCount(c.getContentCount());
            ((VirtualListViewRequestImpl)ctl).setOffset(c.getTargetOffset());
            ((VirtualListViewRequestImpl)ctl).setContextId(c.getContextID());
            ((VirtualListViewRequestImpl)ctl).setAssertionValue(LdapUtils.utf8Encode((String)c.getAssertionValue()));
            ctl.setCritical(c.getCriticality());
        }
        return ctl;
    }

    public ResponseControl handleResponse(Control responseControl) {
        SortResponseControl ctl = null;
        if ("1.2.840.113556.1.4.474".equals(responseControl.getOid())) {
            SortResponse c = (SortResponse)responseControl;
            ctl = new SortResponseControl(ResultCode.valueOf((int)c.getSortResult().getVal()), c.getAttributeName(), c.isCritical());
        } else if ("1.2.840.113556.1.4.319".equals(responseControl.getOid())) {
            PagedResults c = (PagedResults)responseControl;
            ctl = new PagedResultsControl(c.getSize(), c.getCookie(), c.isCritical());
        } else if ("1.3.6.1.4.1.42.2.27.8.5.1".equals(responseControl.getOid())) {
            PasswordPolicy c = (PasswordPolicy)responseControl;
            if (c.hasResponse()) {
                ctl = new PasswordPolicyControl(c.isCritical());
                PasswordPolicyResponse ppr = c.getResponse();
                ((PasswordPolicyControl)ctl).setTimeBeforeExpiration(ppr.getTimeBeforeExpiration());
                ((PasswordPolicyControl)ctl).setGraceAuthNsRemaining(ppr.getGraceAuthNRemaining());
                PasswordPolicyErrorEnum error = ppr.getPasswordPolicyError();
                if (error != null) {
                    ((PasswordPolicyControl)ctl).setError(PasswordPolicyControl.Error.valueOf((int)error.getValue()));
                }
            }
        } else if ("1.3.6.1.4.1.4203.1.9.1.2".equals(responseControl.getOid())) {
            SyncStateValue c = (SyncStateValue)responseControl;
            ctl = new SyncStateControl(SyncStateControl.State.valueOf((int)c.getSyncStateType().getValue()), UuidType.decode((ByteBuffer)ByteBuffer.wrap(c.getEntryUUID())), c.getCookie(), c.isCritical());
        } else if ("1.3.6.1.4.1.4203.1.9.1.3".equals(responseControl.getOid())) {
            SyncDoneValue c = (SyncDoneValue)responseControl;
            ctl = new SyncDoneControl(c.getCookie(), c.isRefreshDeletes(), c.isCritical());
        } else if ("2.16.840.1.113730.3.4.7".equals(responseControl.getOid())) {
            EntryChange c = (EntryChange)responseControl;
            ctl = new EntryChangeNotificationControl(PersistentSearchChangeType.valueOf((int)c.getChangeType().getValue()), c.getPreviousDn().toString(), c.getChangeNumber(), c.isCritical());
        } else if ("1.2.840.113556.1.4.841".equals(responseControl.getOid())) {
            AdDirSync c = (AdDirSync)responseControl;
            ctl = new DirSyncControl(new DirSyncControl.Flag[]{DirSyncControl.Flag.valueOf((long)AdDirSyncFlag.getBitmask((Set)c.getFlags()))}, c.getCookie(), c.getMaxReturnLength(), c.isCritical());
        } else if ("2.16.840.1.113730.3.4.10".equals(responseControl.getOid())) {
            VirtualListViewResponse c = (VirtualListViewResponse)responseControl;
            ctl = new VirtualListViewResponseControl(c.getTargetPosition(), c.getContentCount(), ResultCode.valueOf((int)c.getVirtualListViewResult().getValue()), c.getContextId(), c.isCritical());
        }
        return ctl;
    }
}

