/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.provider.apache;

import java.util.Arrays;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.ldap.client.api.LdapConnectionConfig;
import org.ldaptive.ResultCode;
import org.ldaptive.provider.ControlHandler;
import org.ldaptive.provider.ControlProcessor;
import org.ldaptive.provider.ProviderConfig;
import org.ldaptive.provider.apache.ApacheLdapControlHandler;

public class ApacheLdapProviderConfig
extends ProviderConfig<Control> {
    private LdapConnectionConfig connectionConfig;

    public ApacheLdapProviderConfig() {
        this.setOperationExceptionResultCodes(new ResultCode[]{ResultCode.SERVER_DOWN});
        this.setControlProcessor(new ControlProcessor((ControlHandler)new ApacheLdapControlHandler()));
    }

    public LdapConnectionConfig getLdapConnectionConfig() {
        return this.connectionConfig;
    }

    public void setLdapConnectionConfig(LdapConnectionConfig config) {
        this.checkImmutable();
        this.logger.trace("setting ldapConnectionConfig: {}", (Object)config);
        this.connectionConfig = config;
    }

    public String toString() {
        return String.format("[%s@%d::operationExceptionResultCodes=%s, properties=%s, controlProcessor=%s, ldapConnectionConfig=%s]", ((Object)((Object)this)).getClass().getName(), ((Object)((Object)this)).hashCode(), Arrays.toString(this.getOperationExceptionResultCodes()), this.getProperties(), this.getControlProcessor(), this.connectionConfig);
    }
}

