/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.timers;

import java.io.Serializable;
import org.apache.log4j.Logger;
import org.mobicents.timers.AfterTxCommitRunnable;
import org.mobicents.timers.FaultTolerantScheduler;
import org.mobicents.timers.TimerTask;
import org.mobicents.timers.TimerTaskData;

public class CancelTimerAfterTxCommitRunnable
extends AfterTxCommitRunnable {
    private static final Logger logger = Logger.getLogger(CancelTimerAfterTxCommitRunnable.class);

    CancelTimerAfterTxCommitRunnable(TimerTask task, FaultTolerantScheduler scheduler) {
        super(task, scheduler);
    }

    public AfterTxCommitRunnable.Type getType() {
        return AfterTxCommitRunnable.Type.CANCEL;
    }

    public void run() {
        TimerTaskData taskData = this.task.getData();
        Serializable taskID = taskData.getTaskID();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Cancelling timer task for timer ID " + taskID));
        }
        this.scheduler.getLocalRunningTasksMap().remove(taskID);
        try {
            this.task.cancel();
        }
        catch (Throwable e) {
            logger.error((Object)e.getMessage(), e);
        }
    }
}

