/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.diameter.impl.ha.common.s13;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.jboss.cache.Fqn;
import org.jdiameter.api.AvpDataException;
import org.jdiameter.api.Request;
import org.jdiameter.client.api.IContainer;
import org.jdiameter.client.api.IMessage;
import org.jdiameter.client.api.parser.IMessageParser;
import org.jdiameter.client.api.parser.ParseException;
import org.jdiameter.common.api.app.s13.IS13SessionData;
import org.jdiameter.common.api.app.s13.S13SessionState;
import org.mobicents.cluster.MobicentsCluster;
import org.mobicents.diameter.impl.ha.common.AppSessionDataReplicatedImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class S13SessionDataReplicatedImpl
extends AppSessionDataReplicatedImpl
implements IS13SessionData {
    private static final Logger logger = LoggerFactory.getLogger(S13SessionDataReplicatedImpl.class);
    private static final String STATE = "STATE";
    private static final String BUFFER = "BUFFER";
    private static final String TS_TIMERID = "TS_TIMERID";
    private IMessageParser messageParser;

    public S13SessionDataReplicatedImpl(Fqn<?> nodeFqn, MobicentsCluster mobicentsCluster, IContainer container) {
        super(nodeFqn, mobicentsCluster);
        this.messageParser = (IMessageParser)container.getAssemblerFacility().getComponentInstance(IMessageParser.class);
    }

    public void setS13SessionState(S13SessionState state) {
        if (!this.exists()) {
            throw new IllegalStateException();
        }
        this.getNode().put((Object)STATE, (Object)state);
    }

    public S13SessionState getS13SessionState() {
        if (this.exists()) {
            return (S13SessionState)this.getNode().get((Object)STATE);
        }
        throw new IllegalStateException();
    }

    public Serializable getTsTimerId() {
        if (this.exists()) {
            return (Serializable)this.getNode().get((Object)TS_TIMERID);
        }
        throw new IllegalStateException();
    }

    public void setTsTimerId(Serializable tid) {
        if (!this.exists()) {
            throw new IllegalStateException();
        }
        this.getNode().put((Object)TS_TIMERID, (Object)tid);
    }

    public Request getBuffer() {
        byte[] data = (byte[])this.getNode().get((Object)BUFFER);
        if (data != null) {
            try {
                return this.messageParser.createMessage(ByteBuffer.wrap(data));
            }
            catch (AvpDataException e) {
                logger.error("Unable to recreate message from buffer.");
                return null;
            }
        }
        return null;
    }

    public void setBuffer(Request buffer) {
        if (buffer != null) {
            try {
                byte[] data = this.messageParser.encodeMessage((IMessage)buffer).array();
                this.getNode().put((Object)BUFFER, (Object)data);
            }
            catch (ParseException e) {
                logger.error("Unable to encode message to buffer.");
            }
        } else {
            this.getNode().remove((Object)BUFFER);
        }
    }
}

