/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.diameter.impl.ha.timer;

import java.io.Serializable;
import org.jdiameter.api.BaseSession;
import org.jdiameter.client.api.IContainer;
import org.jdiameter.common.api.data.ISessionDatasource;
import org.jdiameter.common.api.timer.ITimerFacility;
import org.jdiameter.common.impl.app.AppSessionImpl;
import org.mobicents.cluster.MobicentsCluster;
import org.mobicents.diameter.impl.ha.data.ReplicatedSessionDatasource;
import org.mobicents.diameter.impl.ha.timer.DiameterTimerTaskData;
import org.mobicents.timers.FaultTolerantScheduler;
import org.mobicents.timers.TimerTask;
import org.mobicents.timers.TimerTaskData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicatedTimerFacilityImpl
implements ITimerFacility {
    private static final Logger logger = LoggerFactory.getLogger(ReplicatedTimerFacilityImpl.class);
    private ISessionDatasource sessionDataSource;
    private TimerTaskFactory taskFactory;
    private FaultTolerantScheduler ftScheduler;

    public ReplicatedTimerFacilityImpl(IContainer container) {
        this.sessionDataSource = (ISessionDatasource)container.getAssemblerFacility().getComponentInstance(ISessionDatasource.class);
        this.taskFactory = new TimerTaskFactory();
        MobicentsCluster cluster = ((ReplicatedSessionDatasource)this.sessionDataSource).getMobicentsCluster();
        this.ftScheduler = new FaultTolerantScheduler("DiameterTimer", 5, cluster, 12, null, (org.mobicents.timers.TimerTaskFactory)this.taskFactory);
    }

    public void cancel(Serializable id) {
        logger.debug("Cancelling timer with id {}", (Object)id);
        this.ftScheduler.cancel(id);
    }

    public Serializable schedule(String sessionId, String timerName, long miliseconds) throws IllegalArgumentException {
        String id = sessionId + "/" + timerName;
        logger.debug("Scheduling timer with id {}", (Object)id);
        if (this.ftScheduler.getTimerTaskData((Serializable)((Object)id)) != null) {
            throw new IllegalArgumentException("Timer already running: " + id);
        }
        DiameterTimerTaskData data = new DiameterTimerTaskData((Serializable)((Object)id), miliseconds, sessionId, timerName);
        TimerTask tt = this.taskFactory.newTimerTask(data);
        this.ftScheduler.schedule(tt);
        return id;
    }

    private final class DiameterTimerTask
    extends TimerTask {
        DiameterTimerTask(TimerTaskData data) {
            super(data);
        }

        public void runTask() {
            try {
                DiameterTimerTaskData data = (DiameterTimerTaskData)this.getData();
                BaseSession bSession = ReplicatedTimerFacilityImpl.this.sessionDataSource.getSession(data.getSessionId());
                if (bSession == null || !bSession.isAppSession()) {
                    return;
                }
                AppSessionImpl impl = (AppSessionImpl)bSession;
                impl.onTimer(data.getTimerName());
            }
            catch (Exception e) {
                logger.error("Failure executing timer task", (Throwable)e);
            }
        }
    }

    private final class TimerTaskFactory
    implements org.mobicents.timers.TimerTaskFactory {
        private TimerTaskFactory() {
        }

        public TimerTask newTimerTask(TimerTaskData data) {
            return new DiameterTimerTask(data);
        }
    }
}

