/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.diameter.dictionary;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jdiameter.common.impl.validation.AvpRepresentationImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AvpRepresentation {
    public static final String _MP_NOT_ALLOWED = "0";
    public static final String _MP_ZERO_OR_MORE = "0+";
    public static final String _MP_ZERO_OR_ONE = "0-1";
    public static final String _MP_ONE = "1";
    public static final String _MP_ONE_AND_MORE = "1+";
    public static final String _DEFAULT_MANDATORY = "may";
    public static final String _DEFAULT_PROTECTED = "may";
    public static final String _DEFAULT_VENDOR = "mustnot";
    public static final int _FIX_POSITION_INDEX = -1;
    protected String description;
    protected boolean mayEncrypt;
    protected boolean _protected;
    protected boolean _mandatory;
    protected String ruleMandatory;
    protected String ruleProtected;
    protected String ruleVendorBit;
    protected String type;
    private int positionIndex = -1;
    protected int code = -1;
    protected long vendor = 0L;
    protected boolean allowed = true;
    protected String multiplicityIndicator = "0";
    protected String name = "Some-AVP";
    protected boolean grouped = false;
    protected List<AvpRepresentation> children = new ArrayList<AvpRepresentation>();
    protected boolean weak = false;

    public AvpRepresentation(int code, long vendor) {
        this.code = code;
        this.vendor = vendor;
    }

    AvpRepresentation(AvpRepresentationImpl clone) {
        this(-1, clone.getCode(), clone.getVendorId(), clone.getMultiplicityIndicator(), clone.getName());
        this.allowed = clone.isAllowed();
        this.grouped = clone.isGrouped();
        this.positionIndex = clone.getPositionIndex();
        this.weak = clone.isWeak();
        this._mandatory = clone.isMandatory();
        this._protected = clone.isProtected();
        this.description = clone.getDescription();
        this.mayEncrypt = clone.isMayEncrypt();
        this.ruleMandatory = clone.getRuleMandatory();
        this.ruleProtected = clone.getRuleProtected();
        this.ruleVendorBit = clone.getRuleVendorBit();
        this.type = clone.getType();
        if (this.multiplicityIndicator.equals(_MP_NOT_ALLOWED)) {
            this.allowed = false;
        }
        if (this.isGrouped()) {
            for (Object o : clone.getChildren()) {
                AvpRepresentationImpl avpImpl = (AvpRepresentationImpl)o;
                this.children.add(new AvpRepresentation(avpImpl));
            }
            this.children = Collections.unmodifiableList(this.children);
        }
    }

    AvpRepresentation(int positionIndex, int code, long vendor, String multiplicityIndicator, String name) {
        this.positionIndex = positionIndex;
        this.code = code;
        this.vendor = vendor;
        this.multiplicityIndicator = multiplicityIndicator;
        this.name = name;
        if (this.multiplicityIndicator.equals(_MP_NOT_ALLOWED)) {
            this.allowed = false;
        }
    }

    public boolean isPositionFixed() {
        return this.positionIndex == -1;
    }

    public void markFixPosition(int index) {
        this.positionIndex = index;
    }

    public static int get_FIX_POSITION_INDEX() {
        return -1;
    }

    public int getPositionIndex() {
        return this.positionIndex;
    }

    public int getCode() {
        return this.code;
    }

    public long getVendorId() {
        return this.vendor;
    }

    public boolean isAllowed() {
        return this.allowed;
    }

    public boolean isAllowed(int avpCode, long vendorId) {
        if (this.isGrouped()) {
            for (AvpRepresentation rep : this.children) {
                if (rep.getCode() != avpCode || rep.getVendorId() != vendorId) continue;
                return rep.isAllowed();
            }
            return true;
        }
        return false;
    }

    public boolean isAllowed(int avpCode) {
        return this.isAllowed(avpCode, 0L);
    }

    public String getMultiplicityIndicator() {
        return this.multiplicityIndicator;
    }

    public String getName() {
        return this.name;
    }

    public boolean isGrouped() {
        return this.grouped;
    }

    public List<AvpRepresentation> getChildren() {
        return this.children;
    }

    public boolean isWeak() {
        return this.weak;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isMayEncrypt() {
        return this.mayEncrypt;
    }

    public String getRuleMandatory() {
        return this.ruleMandatory;
    }

    public int getRuleMandatoryAsInt() {
        return Rule.valueOf(this.ruleMandatory).ordinal();
    }

    public String getRuleProtected() {
        return this.ruleProtected;
    }

    public int getRuleProtectedAsInt() {
        return Rule.valueOf(this.ruleProtected).ordinal();
    }

    public String getRuleVendorBit() {
        return this.ruleVendorBit;
    }

    public int getRuleVendorBitAsInt() {
        return Rule.valueOf(this.ruleVendorBit).ordinal();
    }

    public String getType() {
        return this.type;
    }

    public boolean isProtected() {
        return this._protected;
    }

    public boolean isMandatory() {
        return this._mandatory;
    }

    public boolean isCountValidForMultiplicity(int avpCount) {
        return !this.allowed ? avpCount == 0 : (this.multiplicityIndicator.equals(_MP_ZERO_OR_MORE) ? avpCount >= 0 : (this.multiplicityIndicator.equals(_MP_ZERO_OR_ONE) ? avpCount == 0 || avpCount == 1 : (this.multiplicityIndicator.equals(_MP_ONE) ? avpCount == 1 : this.multiplicityIndicator.equals(_MP_ONE_AND_MORE) && avpCount >= 1)));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("name: ").append(this.getName()).append(", code: ").append(this.getCode()).append(", vendor: ").append(this.getVendorId()).append(", weak: ").append(this.isWeak()).append(", grouped: ").append(this.isGrouped()).append(", type: ").append(this.getType()).append(", multiplicity: ").append(this.getMultiplicityIndicator());
        if (this.isGrouped()) {
            for (AvpRepresentation child : this.getChildren()) {
                String childStr = child.toString().replace("\n", "\n---");
                sb.append("\n---" + childStr);
            }
        }
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.code;
        result = 31 * result + (int)(this.vendor ^ this.vendor >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AvpRepresentation other = (AvpRepresentation)obj;
        if (this.code != other.code) {
            return false;
        }
        return this.vendor == other.vendor;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        OctetString,
        Integer32,
        Integer64,
        Unsigned32,
        Unsigned64,
        Float32,
        Float64,
        Grouped,
        Address,
        Time,
        UTF8String,
        DiameterIdentity,
        DiameterURI,
        Enumerated,
        IPFilterRule,
        QoSFilterRule;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Rule {
        must,
        may,
        mustnot,
        shouldnot;

    }
}

