/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.diameter.stack.management;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.jdiameter.api.ApplicationId;
import org.jdiameter.api.Configuration;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.MutableConfiguration;
import org.jdiameter.api.MutablePeerTable;
import org.jdiameter.api.Peer;
import org.jdiameter.api.PeerTable;
import org.jdiameter.api.Realm;
import org.jdiameter.api.Stack;
import org.jdiameter.api.StatisticRecord;
import org.jdiameter.client.api.controller.IPeer;
import org.jdiameter.client.api.controller.IRealm;
import org.jdiameter.server.impl.MutablePeerTableImpl;
import org.jdiameter.server.impl.PeerImpl;
import org.mobicents.diameter.stack.management.ApplicationIdJMX;
import org.mobicents.diameter.stack.management.DiameterStatistic;
import org.mobicents.diameter.stack.management.LocalPeer;
import org.mobicents.diameter.stack.management.LocalPeerImpl;
import org.mobicents.diameter.stack.management.Network;
import org.mobicents.diameter.stack.management.NetworkImpl;
import org.mobicents.diameter.stack.management.NetworkPeerImpl;
import org.mobicents.diameter.stack.management.Parameters;
import org.mobicents.diameter.stack.management.ParametersImpl;
import org.mobicents.diameter.stack.management.RealmImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiameterConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(DiameterConfiguration.class);
    protected static Stack stack;
    private LocalPeer localPeer = new LocalPeerImpl();
    private Parameters parameters = null;
    private Network network = new NetworkImpl();

    public DiameterConfiguration(Stack stack) {
        DiameterConfiguration.stack = stack;
        this.updateFromStack(stack);
    }

    private void updateFromStack(Stack stack) {
        long startTime = System.currentTimeMillis();
        Peer sLocalPeer = stack.getMetaData().getLocalPeer();
        this.localPeer.setUri(sLocalPeer.getUri().toString());
        for (InetAddress ipAddress : sLocalPeer.getIPAddresses()) {
            this.localPeer.addIpAddress(ipAddress.getHostAddress());
        }
        this.localPeer.setRealm(sLocalPeer.getRealmName());
        this.localPeer.setVendorId(sLocalPeer.getVendorId());
        this.localPeer.setProductName(sLocalPeer.getProductName());
        this.localPeer.setFirmwareRev(sLocalPeer.getFirmware());
        for (ApplicationId appId : sLocalPeer.getCommonApplications()) {
            if (appId.getAuthAppId() != 0L) {
                this.localPeer.addDefaultApplication(ApplicationIdJMX.createAuthApplicationId(appId.getVendorId(), appId.getAuthAppId()));
                continue;
            }
            this.localPeer.addDefaultApplication(ApplicationIdJMX.createAcctApplicationId(appId.getVendorId(), appId.getAcctAppId()));
        }
        HashMap<String, DiameterStatistic> lpStats = new HashMap<String, DiameterStatistic>();
        for (StatisticRecord stat : ((IPeer)sLocalPeer).getStatistic().getRecords()) {
            lpStats.put(stat.getName(), new DiameterStatistic(stat.getName(), stat.getDescription(), stat.toString()));
        }
        this.localPeer.setStatistics(lpStats);
        MutableConfiguration config = (MutableConfiguration)stack.getMetaData().getConfiguration();
        this.parameters = new ParametersImpl(config);
        for (Configuration curPeer : config.getChildren(org.jdiameter.client.impl.helpers.Parameters.PeerTable.ordinal())) {
            String name = curPeer.getStringValue(org.jdiameter.client.impl.helpers.Parameters.PeerName.ordinal(), "");
            Boolean attemptConnect = curPeer.getBooleanValue(org.jdiameter.server.impl.helpers.Parameters.PeerAttemptConnection.ordinal(), false);
            Integer rating = curPeer.getIntValue(org.jdiameter.client.impl.helpers.Parameters.PeerRating.ordinal(), 0);
            String ip = curPeer.getStringValue(org.jdiameter.client.impl.helpers.Parameters.PeerIp.ordinal(), null);
            String portRange = curPeer.getStringValue(org.jdiameter.client.impl.helpers.Parameters.PeerLocalPortRange.ordinal(), "");
            Integer portRangeLow = null;
            Integer portRangeHigh = null;
            if (portRange != null && !portRange.equals("")) {
                String[] rng = portRange.trim().split("-");
                portRangeLow = Integer.parseInt(rng[0]);
                portRangeHigh = Integer.parseInt(rng[1]);
            }
            String securityRef = curPeer.getStringValue(org.jdiameter.client.impl.helpers.Parameters.SecurityRef.ordinal(), "");
            this.network.addPeer(new NetworkPeerImpl(name, attemptConnect, rating, ip, portRangeLow, portRangeHigh, securityRef));
        }
        try {
            MutablePeerTable peerTable = (MutablePeerTable)stack.unwrap(MutablePeerTable.class);
            for (Peer peer : peerTable.getPeerTable()) {
                PeerImpl p = (PeerImpl)peer;
                NetworkPeerImpl nPeer = new NetworkPeerImpl(p.getUri().toString(), p.isAttemptConnection(), p.getRating(), null, null, null, null);
                HashMap<String, DiameterStatistic> npStats = new HashMap<String, DiameterStatistic>();
                for (StatisticRecord stat : p.getStatistic().getRecords()) {
                    npStats.put(stat.getName(), new DiameterStatistic(stat.getName(), stat.getDescription(), stat.toString()));
                }
                nPeer.setStatistics(npStats);
                this.network.addPeer(nPeer);
            }
        }
        catch (InternalException e) {
            logger.error("Failed to update Diameter Configuration from Stack Mutable Peer Table", (Throwable)e);
        }
        try {
            MutablePeerTableImpl mpt = (MutablePeerTableImpl)stack.unwrap(PeerTable.class);
            for (Realm realm : mpt.getAllRealms()) {
                IRealm irealm = null;
                if (realm instanceof IRealm) {
                    irealm = (IRealm)realm;
                }
                ArrayList<ApplicationIdJMX> x = new ArrayList<ApplicationIdJMX>();
                x.add(ApplicationIdJMX.fromApplicationId(realm.getApplicationId()));
                this.network.addRealm(new RealmImpl(x, realm.getName(), new ArrayList<String>(Arrays.asList(((IRealm)realm).getPeerNames())), realm.getLocalAction().toString(), irealm != null ? irealm.getAgentConfiguration() : null, realm.isDynamic(), realm.getExpirationTime()));
            }
        }
        catch (Exception e) {
            logger.error("Failed to update Diameter Configuration from Stack Mutable Peer Table", (Throwable)e);
        }
        long endTime = System.currentTimeMillis();
        logger.debug("Info gathered in {}ms", (Object)(endTime - startTime));
    }

    public LocalPeer getLocalPeer() {
        return this.localPeer;
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    public Network getNetwork() {
        return this.network;
    }

    protected static MutableConfiguration getMutableConfiguration() {
        return (MutableConfiguration)stack.getMetaData().getConfiguration();
    }

    public String toString() {
        String toString = "## LOCAL PEER ##\r\n" + this.localPeer.toString() + "\r\n";
        toString = toString + "## PARAMETERS ##\r\n" + this.parameters.toString() + "\r\n";
        toString = toString + "## NETWORK ##\r\n" + this.network.toString() + "\r\n";
        return toString;
    }
}

