/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.evaluation.classification;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.nd4j.common.base.Preconditions;
import org.nd4j.common.primitives.Counter;
import org.nd4j.common.primitives.Pair;
import org.nd4j.common.primitives.Triple;
import org.nd4j.evaluation.BaseEvaluation;
import org.nd4j.evaluation.EvaluationAveraging;
import org.nd4j.evaluation.EvaluationUtils;
import org.nd4j.evaluation.IEvaluation;
import org.nd4j.evaluation.IMetric;
import org.nd4j.evaluation.classification.ConfusionMatrix;
import org.nd4j.evaluation.meta.Prediction;
import org.nd4j.evaluation.serde.ConfusionMatrixDeserializer;
import org.nd4j.evaluation.serde.ConfusionMatrixSerializer;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.impl.reduce.longer.MatchCondition;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.conditions.Conditions;
import org.nd4j.serde.jackson.shaded.NDArrayTextDeSerializer;
import org.nd4j.serde.jackson.shaded.NDArrayTextSerializer;
import org.nd4j.shade.jackson.annotation.JsonIgnoreProperties;
import org.nd4j.shade.jackson.databind.annotation.JsonDeserialize;
import org.nd4j.shade.jackson.databind.annotation.JsonSerialize;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(value={"confusionMatrixMetaData"})
public class Evaluation
extends BaseEvaluation<Evaluation> {
    private static final Logger log = LoggerFactory.getLogger(Evaluation.class);
    protected static final double DEFAULT_EDGE_VALUE = 0.0;
    protected static final int CONFUSION_PRINT_MAX_CLASSES = 20;
    protected int axis = 1;
    protected Integer binaryPositiveClass = 1;
    protected final int topN;
    protected int topNCorrectCount = 0;
    protected int topNTotalCount = 0;
    protected Counter<Integer> truePositives = new Counter();
    protected Counter<Integer> falsePositives = new Counter();
    protected Counter<Integer> trueNegatives = new Counter();
    protected Counter<Integer> falseNegatives = new Counter();
    @JsonSerialize(using=ConfusionMatrixSerializer.class)
    @JsonDeserialize(using=ConfusionMatrixDeserializer.class)
    protected ConfusionMatrix<Integer> confusion;
    protected int numRowCounter = 0;
    protected List<String> labelsList = new ArrayList<String>();
    protected Double binaryDecisionThreshold;
    @JsonSerialize(using=NDArrayTextSerializer.class)
    @JsonDeserialize(using=NDArrayTextDeSerializer.class)
    protected INDArray costArray;
    protected Map<Pair<Integer, Integer>, List<Object>> confusionMatrixMetaData;
    protected int maxWarningClassesToPrint = 16;

    protected Evaluation(int axis, Integer binaryPositiveClass, int topN, List<String> labelsList, Double binaryDecisionThreshold, INDArray costArray, int maxWarningClassesToPrint) {
        this.axis = axis;
        this.binaryPositiveClass = binaryPositiveClass;
        this.topN = topN;
        this.labelsList = labelsList;
        this.binaryDecisionThreshold = binaryDecisionThreshold;
        this.costArray = costArray;
        this.maxWarningClassesToPrint = maxWarningClassesToPrint;
    }

    public Evaluation() {
        this.topN = 1;
        this.binaryPositiveClass = 1;
    }

    public Evaluation(int numClasses) {
        this(numClasses, numClasses == 2 ? Integer.valueOf(1) : null);
    }

    public Evaluation(int numClasses, Integer binaryPositiveClass) {
        this(Evaluation.createLabels(numClasses), 1);
        if (binaryPositiveClass != null) {
            Preconditions.checkArgument((binaryPositiveClass == 0 || binaryPositiveClass == 1 ? 1 : 0) != 0, (String)("Only 0 and 1 are valid inputs for binaryPositiveClass; got " + binaryPositiveClass));
            Preconditions.checkArgument((numClasses == 2 ? 1 : 0) != 0, (String)("Cannot set binaryPositiveClass argument when number of classes is not equal to 2 (got: numClasses=" + numClasses + ")"));
        }
        this.binaryPositiveClass = binaryPositiveClass;
    }

    public Evaluation(List<String> labels) {
        this(labels, 1);
    }

    public Evaluation(Map<Integer, String> labels) {
        this(Evaluation.createLabelsFromMap(labels), 1);
    }

    public Evaluation(List<String> labels, int topN) {
        this.labelsList = labels;
        if (labels != null) {
            this.createConfusion(labels.size());
        }
        this.topN = topN;
        if (labels != null && labels.size() == 2) {
            this.binaryPositiveClass = 1;
        }
    }

    public Evaluation(double binaryDecisionThreshold) {
        this(binaryDecisionThreshold, (Integer)1);
    }

    public Evaluation(double binaryDecisionThreshold, @NonNull Integer binaryPositiveClass) {
        if (binaryPositiveClass == null) {
            throw new NullPointerException("binaryPositiveClass is marked non-null but is null");
        }
        if (binaryPositiveClass != null) {
            Preconditions.checkArgument((binaryPositiveClass == 0 || binaryPositiveClass == 1 ? 1 : 0) != 0, (String)("Only 0 and 1 are valid inputs for binaryPositiveClass; got " + binaryPositiveClass));
        }
        this.binaryDecisionThreshold = binaryDecisionThreshold;
        this.topN = 1;
        this.binaryPositiveClass = binaryPositiveClass;
    }

    public Evaluation(INDArray costArray) {
        this(null, costArray);
    }

    public Evaluation(List<String> labels, INDArray costArray) {
        if (costArray != null && !costArray.isRowVectorOrScalar()) {
            throw new IllegalArgumentException("Invalid cost array: must be a row vector (got shape: " + Arrays.toString(costArray.shape()) + ")");
        }
        if (costArray != null && costArray.minNumber().doubleValue() < 0.0) {
            throw new IllegalArgumentException("Invalid cost array: Cost array values must be positive");
        }
        this.labelsList = labels;
        this.costArray = costArray == null ? null : costArray.castTo(DataType.FLOAT);
        this.topN = 1;
    }

    protected int numClasses() {
        if (this.labelsList != null) {
            return this.labelsList.size();
        }
        return this.confusion().getClasses().size();
    }

    @Override
    public void reset() {
        this.confusion = null;
        this.truePositives = new Counter();
        this.falsePositives = new Counter();
        this.trueNegatives = new Counter();
        this.falseNegatives = new Counter();
        this.topNCorrectCount = 0;
        this.topNTotalCount = 0;
        this.numRowCounter = 0;
    }

    private ConfusionMatrix<Integer> confusion() {
        return this.confusion;
    }

    private static List<String> createLabels(int numClasses) {
        if (numClasses == 1) {
            numClasses = 2;
        }
        ArrayList<String> list = new ArrayList<String>(numClasses);
        for (int i = 0; i < numClasses; ++i) {
            list.add(String.valueOf(i));
        }
        return list;
    }

    private static List<String> createLabelsFromMap(Map<Integer, String> labels) {
        int size = labels.size();
        ArrayList<String> labelsList = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            String str = labels.get(i);
            if (str == null) {
                throw new IllegalArgumentException("Invalid labels map: missing key for class " + i + " (expect integers 0 to " + (size - 1) + ")");
            }
            labelsList.add(str);
        }
        return labelsList;
    }

    private void createConfusion(int nClasses) {
        ArrayList<Integer> classes = new ArrayList<Integer>();
        for (int i = 0; i < nClasses; ++i) {
            classes.add(i);
        }
        this.confusion = new ConfusionMatrix(classes);
    }

    public void setAxis(int axis) {
        this.axis = axis;
    }

    public int getAxis() {
        return this.axis;
    }

    @Override
    public void eval(INDArray realOutcomes, INDArray guesses) {
        this.eval(realOutcomes, guesses, (List<Serializable>)null);
    }

    @Override
    public void eval(INDArray labels, INDArray predictions, INDArray mask, List<? extends Serializable> recordMetaData) {
        Triple<INDArray, INDArray, INDArray> p = BaseEvaluation.reshapeAndExtractNotMasked(labels, predictions, mask, this.axis);
        if (p == null) {
            return;
        }
        INDArray labels2d = (INDArray)p.getFirst();
        INDArray predictions2d = (INDArray)p.getSecond();
        INDArray maskArray = (INDArray)p.getThird();
        Preconditions.checkState((maskArray == null ? 1 : 0) != 0, (String)"Per-output masking for Evaluation is not supported");
        long count = Nd4j.getExecutioner().execAndReturn(new MatchCondition(predictions2d, Conditions.isNan(), new int[0])).getFinalResult().longValue();
        Preconditions.checkState((count == 0L ? 1 : 0) != 0, (String)"Cannot perform evaluation with NaNs present in predictions: %s NaNs present in predictions INDArray", (long)count);
        this.numRowCounter = (int)((long)this.numRowCounter + labels2d.size(0));
        if (labels2d.dataType() != predictions2d.dataType()) {
            labels2d = labels2d.castTo(predictions2d.dataType());
        }
        if (this.confusion == null) {
            int nClasses = labels2d.columns();
            if (nClasses == 1) {
                nClasses = 2;
            }
            if (this.labelsList == null || this.labelsList.isEmpty()) {
                this.labelsList = new ArrayList<String>(nClasses);
                for (int i = 0; i < nClasses; ++i) {
                    this.labelsList.add(String.valueOf(i));
                }
            }
            this.createConfusion(nClasses);
        }
        if (!Arrays.equals(labels2d.shape(), predictions2d.shape())) {
            throw new IllegalArgumentException("Unable to evaluate. Predictions and labels arrays are not same shape. Predictions shape: " + Arrays.toString(predictions2d.shape()) + ", Labels shape: " + Arrays.toString(labels2d.shape()));
        }
        int nCols = labels2d.columns();
        int nRows = labels2d.rows();
        if (nCols == 1) {
            INDArray binaryGuesses = predictions2d.gt(this.binaryDecisionThreshold == null ? 0.5 : this.binaryDecisionThreshold).castTo(predictions.dataType());
            INDArray notLabel = labels2d.rsub(1.0);
            INDArray notGuess = binaryGuesses.rsub(1.0);
            int tp = labels2d.mul(binaryGuesses).castTo(DataType.INT).sumNumber().intValue();
            int fp = notLabel.mul(binaryGuesses).castTo(DataType.INT).sumNumber().intValue();
            int fn = notGuess.mul(labels2d).castTo(DataType.INT).sumNumber().intValue();
            int tn = nRows - tp - fp - fn;
            this.confusion().add(1, 1, tp);
            this.confusion().add(1, 0, fn);
            this.confusion().add(0, 1, fp);
            this.confusion().add(0, 0, tn);
            this.truePositives.incrementCount((Object)1, (double)tp);
            this.falsePositives.incrementCount((Object)1, (double)fp);
            this.falseNegatives.incrementCount((Object)1, (double)fn);
            this.trueNegatives.incrementCount((Object)1, (double)tn);
            this.truePositives.incrementCount((Object)0, (double)tn);
            this.falsePositives.incrementCount((Object)0, (double)fn);
            this.falseNegatives.incrementCount((Object)0, (double)fp);
            this.trueNegatives.incrementCount((Object)0, (double)tp);
            if (recordMetaData != null) {
                for (int i = 0; (long)i < binaryGuesses.size(0) && i < recordMetaData.size(); ++i) {
                    int actual = labels2d.getDouble(0L) == 0.0 ? 0 : 1;
                    int predicted = binaryGuesses.getDouble(0L) == 0.0 ? 0 : 1;
                    this.addToMetaConfusionMatrix(actual, predicted, recordMetaData.get(i));
                }
            }
        } else {
            INDArray guessIndex;
            if (this.binaryDecisionThreshold != null) {
                if (nCols != 2) {
                    throw new IllegalStateException("Binary decision threshold is set, but number of columns for predictions is " + nCols + ". Binary decision threshold can only be used for binary prediction cases");
                }
                INDArray pClass1 = predictions2d.getColumn(1L);
                guessIndex = pClass1.gt(this.binaryDecisionThreshold);
            } else {
                guessIndex = this.costArray != null ? Nd4j.argMax(predictions2d.mulRowVector(this.costArray.castTo(predictions2d.dataType())), 1) : Nd4j.argMax(predictions2d, 1);
            }
            INDArray realOutcomeIndex = Nd4j.argMax(labels2d, 1);
            long nExamples = guessIndex.length();
            int i = 0;
            while ((long)i < nExamples) {
                int actual = (int)realOutcomeIndex.getDouble((long)i);
                int predicted = (int)guessIndex.getDouble((long)i);
                this.confusion().add(actual, predicted);
                if (recordMetaData != null && recordMetaData.size() > i) {
                    Serializable m = recordMetaData.get(i);
                    this.addToMetaConfusionMatrix(actual, predicted, m);
                }
                if (actual == predicted) {
                    this.truePositives.incrementCount((Object)actual, 1.0);
                    for (int col = 0; col < nCols; ++col) {
                        if (col == actual) continue;
                        this.trueNegatives.incrementCount((Object)col, 1.0);
                    }
                } else {
                    int col;
                    int greaterIndex;
                    int lesserIndex;
                    this.falsePositives.incrementCount((Object)predicted, 1.0);
                    this.falseNegatives.incrementCount((Object)actual, 1.0);
                    if (actual < predicted) {
                        lesserIndex = actual;
                        greaterIndex = predicted;
                    } else {
                        lesserIndex = predicted;
                        greaterIndex = actual;
                    }
                    for (col = 0; col < lesserIndex; ++col) {
                        this.trueNegatives.incrementCount((Object)col, 1.0);
                    }
                    for (col = lesserIndex + 1; col < greaterIndex; ++col) {
                        this.trueNegatives.incrementCount((Object)col, 1.0);
                    }
                    for (col = greaterIndex + 1; col < nCols; ++col) {
                        this.trueNegatives.incrementCount((Object)col, 1.0);
                    }
                }
                ++i;
            }
        }
        if (nCols > 1 && this.topN > 1) {
            INDArray realOutcomeIndex = Nd4j.argMax(labels2d, 1);
            long nExamples = realOutcomeIndex.length();
            int i = 0;
            while ((long)i < nExamples) {
                int labelIdx = (int)realOutcomeIndex.getDouble((long)i);
                double prob = predictions2d.getDouble((long)i, (long)labelIdx);
                INDArray row = predictions2d.getRow(i);
                int countGreaterThan = (int)Nd4j.getExecutioner().exec(new MatchCondition(row, Conditions.greaterThan(prob), new int[0])).getDouble(0L);
                if (countGreaterThan < this.topN) {
                    ++this.topNCorrectCount;
                }
                ++this.topNTotalCount;
                ++i;
            }
        }
    }

    public void eval(int predictedIdx, int actualIdx) {
        ++this.numRowCounter;
        if (this.confusion == null) {
            throw new UnsupportedOperationException("Cannot evaluate single example without initializing confusion matrix first");
        }
        this.addToConfusion(actualIdx, predictedIdx);
        if (predictedIdx == actualIdx) {
            this.incrementTruePositives(predictedIdx);
            for (Integer clazz : this.confusion().getClasses()) {
                if (clazz == predictedIdx) continue;
                this.trueNegatives.incrementCount((Object)clazz, 1.0);
            }
        } else {
            this.incrementFalseNegatives(actualIdx);
            this.incrementFalsePositives(predictedIdx);
            for (Integer clazz : this.confusion().getClasses()) {
                if (clazz == predictedIdx || clazz == actualIdx) continue;
                this.trueNegatives.incrementCount((Object)clazz, 1.0);
            }
        }
    }

    @Override
    public String stats() {
        return this.stats(false);
    }

    public String stats(boolean suppressWarnings) {
        return this.stats(suppressWarnings, this.numClasses() <= 20, this.numClasses() > 20);
    }

    public String stats(boolean suppressWarnings, boolean includeConfusion) {
        return this.stats(suppressWarnings, includeConfusion, false);
    }

    private String stats(boolean suppressWarnings, boolean includeConfusion, boolean logConfusionSizeWarning) {
        if (this.numRowCounter == 0) {
            return "Evaluation: No data available (no evaluation has been performed)";
        }
        StringBuilder builder = new StringBuilder().append("\n");
        StringBuilder warnings = new StringBuilder();
        ConfusionMatrix<Integer> confusion = this.confusion();
        if (confusion == null) {
            confusion = new ConfusionMatrix();
        }
        List<Integer> classes = confusion.getClasses();
        ArrayList<Integer> falsePositivesWarningClasses = new ArrayList<Integer>();
        ArrayList<Integer> falseNegativesWarningClasses = new ArrayList<Integer>();
        for (Integer clazz : classes) {
            if (suppressWarnings || this.truePositives.getCount((Object)clazz) != 0.0) continue;
            if (this.falsePositives.getCount((Object)clazz) == 0.0) {
                falsePositivesWarningClasses.add(clazz);
            }
            if (this.falseNegatives.getCount((Object)clazz) != 0.0) continue;
            falseNegativesWarningClasses.add(clazz);
        }
        if (!falsePositivesWarningClasses.isEmpty()) {
            this.warningHelper(warnings, falsePositivesWarningClasses, "precision");
        }
        if (!falseNegativesWarningClasses.isEmpty()) {
            this.warningHelper(warnings, falseNegativesWarningClasses, "recall");
        }
        int nClasses = confusion.getClasses().size();
        DecimalFormat df = new DecimalFormat("0.0000");
        double acc = this.accuracy();
        double precision = this.precision();
        double recall = this.recall();
        double f1 = this.f1();
        builder.append("\n========================Evaluation Metrics========================");
        builder.append("\n # of classes:    ").append(nClasses);
        builder.append("\n Accuracy:        ").append(Evaluation.format(df, acc));
        if (this.topN > 1) {
            double topNAcc = this.topNAccuracy();
            builder.append("\n Top ").append(this.topN).append(" Accuracy:  ").append(Evaluation.format(df, topNAcc));
        }
        builder.append("\n Precision:       ").append(Evaluation.format(df, precision));
        if (nClasses > 2 && this.averagePrecisionNumClassesExcluded() > 0) {
            int ex = this.averagePrecisionNumClassesExcluded();
            builder.append("\t(").append(ex).append(" class");
            if (ex > 1) {
                builder.append("es");
            }
            builder.append(" excluded from average)");
        }
        builder.append("\n Recall:          ").append(Evaluation.format(df, recall));
        if (nClasses > 2 && this.averageRecallNumClassesExcluded() > 0) {
            int ex = this.averageRecallNumClassesExcluded();
            builder.append("\t(").append(ex).append(" class");
            if (ex > 1) {
                builder.append("es");
            }
            builder.append(" excluded from average)");
        }
        builder.append("\n F1 Score:        ").append(Evaluation.format(df, f1));
        if (nClasses > 2 && this.averageF1NumClassesExcluded() > 0) {
            int ex = this.averageF1NumClassesExcluded();
            builder.append("\t(").append(ex).append(" class");
            if (ex > 1) {
                builder.append("es");
            }
            builder.append(" excluded from average)");
        }
        if (nClasses > 2 || this.binaryPositiveClass == null) {
            builder.append("\nPrecision, recall & F1: macro-averaged (equally weighted avg. of ").append(nClasses).append(" classes)");
        }
        if (nClasses == 2 && this.binaryPositiveClass != null) {
            builder.append("\nPrecision, recall & F1: reported for positive class (class ").append(this.binaryPositiveClass);
            if (this.labelsList != null) {
                builder.append(" - \"").append(this.labelsList.get(this.binaryPositiveClass)).append("\"");
            }
            builder.append(") only");
        }
        if (this.binaryDecisionThreshold != null) {
            builder.append("\nBinary decision threshold: ").append(this.binaryDecisionThreshold);
        }
        if (this.costArray != null) {
            builder.append("\nCost array: ").append(Arrays.toString(this.costArray.dup().data().asFloat()));
        }
        builder.append("\n\n");
        builder.append((CharSequence)warnings);
        if (includeConfusion) {
            builder.append("\n=========================Confusion Matrix=========================\n");
            builder.append(this.confusionMatrix());
        } else if (logConfusionSizeWarning) {
            builder.append("\n\nNote: Confusion matrix not generated due to space requirements for ").append(nClasses).append(" classes.\n").append("Use stats(false,true) to generate anyway");
        }
        builder.append("\n==================================================================");
        return builder.toString();
    }

    public String confusionMatrix() {
        int nClasses = this.numClasses();
        if (this.confusion == null) {
            return "Confusion matrix: <no data>";
        }
        List<Integer> classes = this.confusion.getClasses();
        int maxCount = 1;
        for (Integer i : classes) {
            for (Integer j : classes) {
                int count = this.confusion().getCount(i, j);
                maxCount = Math.max(maxCount, count);
            }
        }
        int numDigits = (int)Math.ceil(Math.log10(maxCount = Math.max(maxCount, nClasses)));
        if (numDigits < 1) {
            numDigits = 1;
        }
        String digitFormat = "%" + (numDigits + 1) + "d";
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < nClasses; ++i) {
            sb.append(String.format(digitFormat, i));
        }
        sb.append("\n");
        int numDividerChars = (numDigits + 1) * nClasses + 1;
        for (int i = 0; i < numDividerChars; ++i) {
            sb.append("-");
        }
        sb.append("\n");
        for (int actual = 0; actual < nClasses; ++actual) {
            String actualName = this.resolveLabelForClass(actual);
            for (int predicted = 0; predicted < nClasses; ++predicted) {
                int count = this.confusion.getCount(actual, predicted);
                sb.append(String.format(digitFormat, count));
            }
            sb.append(" | ").append(actual).append(" = ").append(actualName).append("\n");
        }
        sb.append("\nConfusion matrix format: Actual (rowClass) predicted as (columnClass) N times");
        return sb.toString();
    }

    private static String format(DecimalFormat f, double num) {
        if (Double.isNaN(num) || Double.isInfinite(num)) {
            return String.valueOf(num);
        }
        return f.format(num);
    }

    private String resolveLabelForClass(Integer clazz) {
        if (this.labelsList != null && this.labelsList.size() > clazz) {
            return this.labelsList.get(clazz);
        }
        return clazz.toString();
    }

    private void warningHelper(StringBuilder warnings, List<Integer> list, String metric) {
        String wasWere;
        warnings.append("Warning: ").append(list.size()).append(" class");
        if (list.size() == 1) {
            wasWere = "was";
        } else {
            wasWere = "were";
            warnings.append("es");
        }
        warnings.append(" ").append(wasWere);
        warnings.append(" never predicted by the model and ").append(wasWere).append(" excluded from average ").append(metric);
        if (list.size() <= this.maxWarningClassesToPrint) {
            warnings.append("\nClasses excluded from average ").append(metric).append(": ").append(list).append("\n");
        }
    }

    public double precision(Integer classLabel) {
        return this.precision(classLabel, 0.0);
    }

    public double precision(Integer classLabel, double edgeCase) {
        Preconditions.checkState((this.numRowCounter > 0 ? 1 : 0) != 0, (String)"Cannot get precision: no evaluation has been performed");
        double tpCount = this.truePositives.getCount((Object)classLabel);
        double fpCount = this.falsePositives.getCount((Object)classLabel);
        return EvaluationUtils.precision((long)tpCount, (long)fpCount, edgeCase);
    }

    public double precision() {
        if (this.binaryPositiveClass != null && this.numClasses() == 2) {
            return this.precision(this.binaryPositiveClass);
        }
        return this.precision(EvaluationAveraging.Macro);
    }

    public double precision(EvaluationAveraging averaging) {
        Preconditions.checkState((this.numRowCounter > 0 ? 1 : 0) != 0, (String)"Cannot get precision: no evaluation has been performed");
        int nClasses = this.confusion().getClasses().size();
        if (averaging == EvaluationAveraging.Macro) {
            double macroPrecision = 0.0;
            int count = 0;
            for (int i = 0; i < nClasses; ++i) {
                double thisClassPrec = this.precision(i, -1.0);
                if (thisClassPrec == -1.0) continue;
                macroPrecision += thisClassPrec;
                ++count;
            }
            return macroPrecision /= (double)count;
        }
        if (averaging == EvaluationAveraging.Micro) {
            long tpCount = 0L;
            long fpCount = 0L;
            for (int i = 0; i < nClasses; ++i) {
                tpCount = (long)((double)tpCount + this.truePositives.getCount((Object)i));
                fpCount = (long)((double)fpCount + this.falsePositives.getCount((Object)i));
            }
            return EvaluationUtils.precision(tpCount, fpCount, 0.0);
        }
        throw new UnsupportedOperationException("Unknown averaging approach: " + (Object)((Object)averaging));
    }

    public int averagePrecisionNumClassesExcluded() {
        return this.numClassesExcluded("precision");
    }

    public int averageRecallNumClassesExcluded() {
        return this.numClassesExcluded("recall");
    }

    public int averageF1NumClassesExcluded() {
        return this.numClassesExcluded("f1");
    }

    public int averageFBetaNumClassesExcluded() {
        return this.numClassesExcluded("fbeta");
    }

    private int numClassesExcluded(String metric) {
        int countExcluded = 0;
        int nClasses = this.confusion().getClasses().size();
        for (int i = 0; i < nClasses; ++i) {
            double d;
            switch (metric.toLowerCase()) {
                case "precision": {
                    d = this.precision(i, -1.0);
                    break;
                }
                case "recall": {
                    d = this.recall(i, -1.0);
                    break;
                }
                case "f1": 
                case "fbeta": {
                    d = this.fBeta(1.0, i, -1.0);
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown metric: " + metric);
                }
            }
            if (d != -1.0) continue;
            ++countExcluded;
        }
        return countExcluded;
    }

    public double recall(int classLabel) {
        return this.recall(classLabel, 0.0);
    }

    public double recall(int classLabel, double edgeCase) {
        Preconditions.checkState((this.numRowCounter > 0 ? 1 : 0) != 0, (String)"Cannot get recall: no evaluation has been performed");
        double tpCount = this.truePositives.getCount((Object)classLabel);
        double fnCount = this.falseNegatives.getCount((Object)classLabel);
        return EvaluationUtils.recall((long)tpCount, (long)fnCount, edgeCase);
    }

    public double recall() {
        if (this.binaryPositiveClass != null && this.numClasses() == 2) {
            return this.recall(this.binaryPositiveClass);
        }
        return this.recall(EvaluationAveraging.Macro);
    }

    public double recall(EvaluationAveraging averaging) {
        Preconditions.checkState((this.numRowCounter > 0 ? 1 : 0) != 0, (String)"Cannot get recall: no evaluation has been performed");
        int nClasses = this.confusion().getClasses().size();
        if (averaging == EvaluationAveraging.Macro) {
            double macroRecall = 0.0;
            int count = 0;
            for (int i = 0; i < nClasses; ++i) {
                double thisClassRecall = this.recall(i, -1.0);
                if (thisClassRecall == -1.0) continue;
                macroRecall += thisClassRecall;
                ++count;
            }
            return macroRecall /= (double)count;
        }
        if (averaging == EvaluationAveraging.Micro) {
            long tpCount = 0L;
            long fnCount = 0L;
            for (int i = 0; i < nClasses; ++i) {
                tpCount = (long)((double)tpCount + this.truePositives.getCount((Object)i));
                fnCount = (long)((double)fnCount + this.falseNegatives.getCount((Object)i));
            }
            return EvaluationUtils.recall(tpCount, fnCount, 0.0);
        }
        throw new UnsupportedOperationException("Unknown averaging approach: " + (Object)((Object)averaging));
    }

    public double falsePositiveRate(int classLabel) {
        return this.falsePositiveRate(classLabel, 0.0);
    }

    public double falsePositiveRate(int classLabel, double edgeCase) {
        Preconditions.checkState((this.numRowCounter > 0 ? 1 : 0) != 0, (String)"Cannot get false positive rate: no evaluation has been performed");
        double fpCount = this.falsePositives.getCount((Object)classLabel);
        double tnCount = this.trueNegatives.getCount((Object)classLabel);
        return EvaluationUtils.falsePositiveRate((long)fpCount, (long)tnCount, edgeCase);
    }

    public double falsePositiveRate() {
        if (this.binaryPositiveClass != null && this.numClasses() == 2) {
            return this.falsePositiveRate(this.binaryPositiveClass);
        }
        return this.falsePositiveRate(EvaluationAveraging.Macro);
    }

    public double falsePositiveRate(EvaluationAveraging averaging) {
        Preconditions.checkState((this.numRowCounter > 0 ? 1 : 0) != 0, (String)"Cannot get false positive rate: no evaluation has been performed");
        int nClasses = this.confusion().getClasses().size();
        if (averaging == EvaluationAveraging.Macro) {
            double macroFPR = 0.0;
            for (int i = 0; i < nClasses; ++i) {
                macroFPR += this.falsePositiveRate(i);
            }
            return macroFPR /= (double)nClasses;
        }
        if (averaging == EvaluationAveraging.Micro) {
            long fpCount = 0L;
            long tnCount = 0L;
            for (int i = 0; i < nClasses; ++i) {
                fpCount = (long)((double)fpCount + this.falsePositives.getCount((Object)i));
                tnCount = (long)((double)tnCount + this.trueNegatives.getCount((Object)i));
            }
            return EvaluationUtils.falsePositiveRate(fpCount, tnCount, 0.0);
        }
        throw new UnsupportedOperationException("Unknown averaging approach: " + (Object)((Object)averaging));
    }

    public double falseNegativeRate(Integer classLabel) {
        return this.falseNegativeRate(classLabel, 0.0);
    }

    public double falseNegativeRate(Integer classLabel, double edgeCase) {
        Preconditions.checkState((this.numRowCounter > 0 ? 1 : 0) != 0, (String)"Cannot get false negative rate: no evaluation has been performed");
        double fnCount = this.falseNegatives.getCount((Object)classLabel);
        double tpCount = this.truePositives.getCount((Object)classLabel);
        return EvaluationUtils.falseNegativeRate((long)fnCount, (long)tpCount, edgeCase);
    }

    public double falseNegativeRate() {
        if (this.binaryPositiveClass != null && this.numClasses() == 2) {
            return this.falseNegativeRate(this.binaryPositiveClass);
        }
        return this.falseNegativeRate(EvaluationAveraging.Macro);
    }

    public double falseNegativeRate(EvaluationAveraging averaging) {
        Preconditions.checkState((this.numRowCounter > 0 ? 1 : 0) != 0, (String)"Cannot get false negative rate: no evaluation has been performed");
        int nClasses = this.confusion().getClasses().size();
        if (averaging == EvaluationAveraging.Macro) {
            double macroFNR = 0.0;
            for (int i = 0; i < nClasses; ++i) {
                macroFNR += this.falseNegativeRate(i);
            }
            return macroFNR /= (double)nClasses;
        }
        if (averaging == EvaluationAveraging.Micro) {
            long fnCount = 0L;
            long tnCount = 0L;
            for (int i = 0; i < nClasses; ++i) {
                fnCount = (long)((double)fnCount + this.falseNegatives.getCount((Object)i));
                tnCount = (long)((double)tnCount + this.trueNegatives.getCount((Object)i));
            }
            return EvaluationUtils.falseNegativeRate(fnCount, tnCount, 0.0);
        }
        throw new UnsupportedOperationException("Unknown averaging approach: " + (Object)((Object)averaging));
    }

    public double falseAlarmRate() {
        if (this.binaryPositiveClass != null && this.numClasses() == 2) {
            return (this.falsePositiveRate(this.binaryPositiveClass) + this.falseNegativeRate(this.binaryPositiveClass)) / 2.0;
        }
        return (this.falsePositiveRate() + this.falseNegativeRate()) / 2.0;
    }

    public double f1(int classLabel) {
        return this.fBeta(1.0, classLabel);
    }

    public double fBeta(double beta, int classLabel) {
        return this.fBeta(beta, classLabel, 0.0);
    }

    public double fBeta(double beta, int classLabel, double defaultValue) {
        Preconditions.checkState((this.numRowCounter > 0 ? 1 : 0) != 0, (String)"Cannot get fBeta score: no evaluation has been performed");
        double precision = this.precision(classLabel, -1.0);
        double recall = this.recall(classLabel, -1.0);
        if (precision == -1.0 || recall == -1.0) {
            return defaultValue;
        }
        return EvaluationUtils.fBeta(beta, precision, recall);
    }

    public double f1() {
        if (this.binaryPositiveClass != null && this.numClasses() == 2) {
            return this.f1(this.binaryPositiveClass);
        }
        return this.f1(EvaluationAveraging.Macro);
    }

    public double f1(EvaluationAveraging averaging) {
        return this.fBeta(1.0, averaging);
    }

    public double fBeta(double beta, EvaluationAveraging averaging) {
        Preconditions.checkState((this.numRowCounter > 0 ? 1 : 0) != 0, (String)"Cannot get fBeta score: no evaluation has been performed");
        int nClasses = this.confusion().getClasses().size();
        if (nClasses == 2) {
            return EvaluationUtils.fBeta(beta, (long)this.truePositives.getCount((Object)1), (long)this.falsePositives.getCount((Object)1), (long)this.falseNegatives.getCount((Object)1));
        }
        if (averaging == EvaluationAveraging.Macro) {
            double macroFBeta = 0.0;
            int count = 0;
            for (int i = 0; i < nClasses; ++i) {
                double thisFBeta = this.fBeta(beta, i, -1.0);
                if (thisFBeta == -1.0) continue;
                macroFBeta += thisFBeta;
                ++count;
            }
            return macroFBeta /= (double)count;
        }
        if (averaging == EvaluationAveraging.Micro) {
            long tpCount = 0L;
            long fpCount = 0L;
            long fnCount = 0L;
            for (int i = 0; i < nClasses; ++i) {
                tpCount = (long)((double)tpCount + this.truePositives.getCount((Object)i));
                fpCount = (long)((double)fpCount + this.falsePositives.getCount((Object)i));
                fnCount = (long)((double)fnCount + this.falseNegatives.getCount((Object)i));
            }
            return EvaluationUtils.fBeta(beta, tpCount, fpCount, fnCount);
        }
        throw new UnsupportedOperationException("Unknown averaging approach: " + (Object)((Object)averaging));
    }

    public double gMeasure(int output) {
        Preconditions.checkState((this.numRowCounter > 0 ? 1 : 0) != 0, (String)"Cannot get gMeasure: no evaluation has been performed");
        double precision = this.precision(output);
        double recall = this.recall(output);
        return EvaluationUtils.gMeasure(precision, recall);
    }

    public double gMeasure(EvaluationAveraging averaging) {
        Preconditions.checkState((this.numRowCounter > 0 ? 1 : 0) != 0, (String)"Cannot get gMeasure: no evaluation has been performed");
        int nClasses = this.confusion().getClasses().size();
        if (averaging == EvaluationAveraging.Macro) {
            double macroGMeasure = 0.0;
            for (int i = 0; i < nClasses; ++i) {
                macroGMeasure += this.gMeasure(i);
            }
            return macroGMeasure /= (double)nClasses;
        }
        if (averaging == EvaluationAveraging.Micro) {
            long tpCount = 0L;
            long fpCount = 0L;
            long fnCount = 0L;
            for (int i = 0; i < nClasses; ++i) {
                tpCount = (long)((double)tpCount + this.truePositives.getCount((Object)i));
                fpCount = (long)((double)fpCount + this.falsePositives.getCount((Object)i));
                fnCount = (long)((double)fnCount + this.falseNegatives.getCount((Object)i));
            }
            double precision = EvaluationUtils.precision(tpCount, fpCount, 0.0);
            double recall = EvaluationUtils.recall(tpCount, fnCount, 0.0);
            return EvaluationUtils.gMeasure(precision, recall);
        }
        throw new UnsupportedOperationException("Unknown averaging approach: " + (Object)((Object)averaging));
    }

    public double accuracy() {
        Preconditions.checkState((this.numRowCounter > 0 ? 1 : 0) != 0, (String)"Cannot get accuracy: no evaluation has been performed");
        int nClasses = this.confusion().getClasses().size();
        int countCorrect = 0;
        for (int i = 0; i < nClasses; ++i) {
            countCorrect += this.confusion().getCount(i, i);
        }
        return (double)countCorrect / (double)this.getNumRowCounter();
    }

    public double topNAccuracy() {
        if (this.topN <= 1) {
            return this.accuracy();
        }
        if (this.topNTotalCount == 0) {
            return 0.0;
        }
        return (double)this.topNCorrectCount / (double)this.topNTotalCount;
    }

    public double matthewsCorrelation(int classIdx) {
        Preconditions.checkState((this.numRowCounter > 0 ? 1 : 0) != 0, (String)"Cannot get Matthews correlation: no evaluation has been performed");
        return EvaluationUtils.matthewsCorrelation((long)this.truePositives.getCount((Object)classIdx), (long)this.falsePositives.getCount((Object)classIdx), (long)this.falseNegatives.getCount((Object)classIdx), (long)this.trueNegatives.getCount((Object)classIdx));
    }

    public double matthewsCorrelation(EvaluationAveraging averaging) {
        Preconditions.checkState((this.numRowCounter > 0 ? 1 : 0) != 0, (String)"Cannot get Matthews correlation: no evaluation has been performed");
        int nClasses = this.confusion().getClasses().size();
        if (averaging == EvaluationAveraging.Macro) {
            double macroMatthewsCorrelation = 0.0;
            for (int i = 0; i < nClasses; ++i) {
                macroMatthewsCorrelation += this.matthewsCorrelation(i);
            }
            return macroMatthewsCorrelation /= (double)nClasses;
        }
        if (averaging == EvaluationAveraging.Micro) {
            long tpCount = 0L;
            long fpCount = 0L;
            long fnCount = 0L;
            long tnCount = 0L;
            for (int i = 0; i < nClasses; ++i) {
                tpCount = (long)((double)tpCount + this.truePositives.getCount((Object)i));
                fpCount = (long)((double)fpCount + this.falsePositives.getCount((Object)i));
                fnCount = (long)((double)fnCount + this.falseNegatives.getCount((Object)i));
                tnCount = (long)((double)tnCount + this.trueNegatives.getCount((Object)i));
            }
            return EvaluationUtils.matthewsCorrelation(tpCount, fpCount, fnCount, tnCount);
        }
        throw new UnsupportedOperationException("Unknown averaging approach: " + (Object)((Object)averaging));
    }

    public Map<Integer, Integer> truePositives() {
        return this.convertToMap(this.truePositives, this.confusion().getClasses().size());
    }

    public Map<Integer, Integer> trueNegatives() {
        return this.convertToMap(this.trueNegatives, this.confusion().getClasses().size());
    }

    public Map<Integer, Integer> falsePositives() {
        return this.convertToMap(this.falsePositives, this.confusion().getClasses().size());
    }

    public Map<Integer, Integer> falseNegatives() {
        return this.convertToMap(this.falseNegatives, this.confusion().getClasses().size());
    }

    public Map<Integer, Integer> negative() {
        return this.addMapsByKey(this.trueNegatives(), this.falsePositives());
    }

    public Map<Integer, Integer> positive() {
        return this.addMapsByKey(this.truePositives(), this.falseNegatives());
    }

    private Map<Integer, Integer> convertToMap(Counter<Integer> counter, int maxCount) {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        for (int i = 0; i < maxCount; ++i) {
            map.put(i, (int)counter.getCount((Object)i));
        }
        return map;
    }

    private Map<Integer, Integer> addMapsByKey(Map<Integer, Integer> first, Map<Integer, Integer> second) {
        HashMap<Integer, Integer> out = new HashMap<Integer, Integer>();
        HashSet<Integer> keys = new HashSet<Integer>(first.keySet());
        keys.addAll(second.keySet());
        for (Integer i : keys) {
            Integer f = first.get(i);
            Integer s = second.get(i);
            if (f == null) {
                f = 0;
            }
            if (s == null) {
                s = 0;
            }
            out.put(i, f + s);
        }
        return out;
    }

    public void incrementTruePositives(Integer classLabel) {
        this.truePositives.incrementCount((Object)classLabel, 1.0);
    }

    public void incrementTrueNegatives(Integer classLabel) {
        this.trueNegatives.incrementCount((Object)classLabel, 1.0);
    }

    public void incrementFalseNegatives(Integer classLabel) {
        this.falseNegatives.incrementCount((Object)classLabel, 1.0);
    }

    public void incrementFalsePositives(Integer classLabel) {
        this.falsePositives.incrementCount((Object)classLabel, 1.0);
    }

    public void addToConfusion(Integer real, Integer guess) {
        this.confusion().add(real, guess);
    }

    public int classCount(Integer clazz) {
        return this.confusion().getActualTotal(clazz);
    }

    public int getNumRowCounter() {
        return this.numRowCounter;
    }

    public int getTopNCorrectCount() {
        if (this.confusion == null) {
            return 0;
        }
        if (this.topN <= 1) {
            int nClasses = this.confusion().getClasses().size();
            int countCorrect = 0;
            for (int i = 0; i < nClasses; ++i) {
                countCorrect += this.confusion().getCount(i, i);
            }
            return countCorrect;
        }
        return this.topNCorrectCount;
    }

    public int getTopNTotalCount() {
        if (this.topN <= 1) {
            return this.getNumRowCounter();
        }
        return this.topNTotalCount;
    }

    public String getClassLabel(Integer clazz) {
        return this.resolveLabelForClass(clazz);
    }

    public ConfusionMatrix<Integer> getConfusionMatrix() {
        return this.confusion;
    }

    @Override
    public void merge(Evaluation other) {
        if (other == null) {
            return;
        }
        this.truePositives.incrementAll(other.truePositives);
        this.falsePositives.incrementAll(other.falsePositives);
        this.trueNegatives.incrementAll(other.trueNegatives);
        this.falseNegatives.incrementAll(other.falseNegatives);
        if (this.confusion == null) {
            if (other.confusion != null) {
                this.confusion = new ConfusionMatrix<Integer>(other.confusion);
            }
        } else if (other.confusion != null) {
            this.confusion().add(other.confusion);
        }
        this.numRowCounter += other.numRowCounter;
        if (this.labelsList.isEmpty()) {
            this.labelsList.addAll(other.labelsList);
        }
        if (this.topN != other.topN) {
            log.warn("Different topN values ({} vs {}) detected during Evaluation merging. Top N accuracy may not be accurate.", (Object)this.topN, (Object)other.topN);
        }
        this.topNCorrectCount += other.topNCorrectCount;
        this.topNTotalCount += other.topNTotalCount;
    }

    public String confusionToString() {
        int i;
        int nClasses = this.confusion().getClasses().size();
        int maxLabelSize = 0;
        for (String s : this.labelsList) {
            maxLabelSize = Math.max(maxLabelSize, s.length());
        }
        int labelSize = Math.max(maxLabelSize + 5, 10);
        StringBuilder sb = new StringBuilder();
        sb.append("%-3d");
        sb.append("%-");
        sb.append(labelSize);
        sb.append("s | ");
        StringBuilder headerFormat = new StringBuilder();
        headerFormat.append("   %-").append(labelSize).append("s   ");
        for (int i2 = 0; i2 < nClasses; ++i2) {
            sb.append("%7d");
            headerFormat.append("%7d");
        }
        String rowFormat = sb.toString();
        StringBuilder out = new StringBuilder();
        Object[] headerArgs = new Object[nClasses + 1];
        headerArgs[0] = "Predicted:";
        for (i = 0; i < nClasses; ++i) {
            headerArgs[i + 1] = i;
        }
        out.append(String.format(headerFormat.toString(), headerArgs)).append("\n");
        out.append("   Actual:\n");
        for (i = 0; i < nClasses; ++i) {
            Object[] args = new Object[nClasses + 2];
            args[0] = i;
            args[1] = this.labelsList.get(i);
            for (int j = 0; j < nClasses; ++j) {
                args[j + 2] = this.confusion().getCount(i, j);
            }
            out.append(String.format(rowFormat, args));
            out.append("\n");
        }
        return out.toString();
    }

    private void addToMetaConfusionMatrix(int actual, int predicted, Object metaData) {
        Pair p;
        List<Object> list;
        if (this.confusionMatrixMetaData == null) {
            this.confusionMatrixMetaData = new HashMap<Pair<Integer, Integer>, List<Object>>();
        }
        if ((list = this.confusionMatrixMetaData.get(p = new Pair((Object)actual, (Object)predicted))) == null) {
            list = new ArrayList<Object>();
            this.confusionMatrixMetaData.put((Pair<Integer, Integer>)p, list);
        }
        list.add(metaData);
    }

    public List<Prediction> getPredictionErrors() {
        if (this.confusionMatrixMetaData == null) {
            return null;
        }
        ArrayList<Prediction> list = new ArrayList<Prediction>();
        ArrayList<Map.Entry<Pair<Integer, Integer>, List<Object>>> sorted = new ArrayList<Map.Entry<Pair<Integer, Integer>, List<Object>>>(this.confusionMatrixMetaData.entrySet());
        Collections.sort(sorted, new Comparator<Map.Entry<Pair<Integer, Integer>, List<Object>>>(){

            @Override
            public int compare(Map.Entry<Pair<Integer, Integer>, List<Object>> o1, Map.Entry<Pair<Integer, Integer>, List<Object>> o2) {
                Pair<Integer, Integer> p1 = o1.getKey();
                Pair<Integer, Integer> p2 = o2.getKey();
                int order = Integer.compare((Integer)p1.getFirst(), (Integer)p2.getFirst());
                if (order != 0) {
                    return order;
                }
                order = Integer.compare((Integer)p1.getSecond(), (Integer)p2.getSecond());
                return order;
            }
        });
        for (Map.Entry entry : sorted) {
            Pair p = (Pair)entry.getKey();
            if (((Integer)p.getFirst()).equals(p.getSecond())) continue;
            for (Object m : (List)entry.getValue()) {
                list.add(new Prediction((Integer)p.getFirst(), (Integer)p.getSecond(), m));
            }
        }
        return list;
    }

    public List<Prediction> getPredictionsByActualClass(int actualClass) {
        if (this.confusionMatrixMetaData == null) {
            return null;
        }
        ArrayList<Prediction> out = new ArrayList<Prediction>();
        for (Map.Entry<Pair<Integer, Integer>, List<Object>> entry : this.confusionMatrixMetaData.entrySet()) {
            if ((Integer)entry.getKey().getFirst() != actualClass) continue;
            int actual = (Integer)entry.getKey().getFirst();
            int predicted = (Integer)entry.getKey().getSecond();
            for (Object m : entry.getValue()) {
                out.add(new Prediction(actual, predicted, m));
            }
        }
        return out;
    }

    public List<Prediction> getPredictionByPredictedClass(int predictedClass) {
        if (this.confusionMatrixMetaData == null) {
            return null;
        }
        ArrayList<Prediction> out = new ArrayList<Prediction>();
        for (Map.Entry<Pair<Integer, Integer>, List<Object>> entry : this.confusionMatrixMetaData.entrySet()) {
            if ((Integer)entry.getKey().getSecond() != predictedClass) continue;
            int actual = (Integer)entry.getKey().getFirst();
            int predicted = (Integer)entry.getKey().getSecond();
            for (Object m : entry.getValue()) {
                out.add(new Prediction(actual, predicted, m));
            }
        }
        return out;
    }

    public List<Prediction> getPredictions(int actualClass, int predictedClass) {
        if (this.confusionMatrixMetaData == null) {
            return null;
        }
        ArrayList<Prediction> out = new ArrayList<Prediction>();
        List<Object> list = this.confusionMatrixMetaData.get(new Pair((Object)actualClass, (Object)predictedClass));
        if (list == null) {
            return out;
        }
        for (Object meta : list) {
            out.add(new Prediction(actualClass, predictedClass, meta));
        }
        return out;
    }

    public double scoreForMetric(Metric metric) {
        switch (metric) {
            case ACCURACY: {
                return this.accuracy();
            }
            case F1: {
                return this.f1();
            }
            case PRECISION: {
                return this.precision();
            }
            case RECALL: {
                return this.recall();
            }
            case GMEASURE: {
                return this.gMeasure(EvaluationAveraging.Macro);
            }
            case MCC: {
                return this.matthewsCorrelation(EvaluationAveraging.Macro);
            }
        }
        throw new IllegalStateException("Unknown metric: " + metric);
    }

    public static Evaluation fromJson(String json) {
        return Evaluation.fromJson(json, Evaluation.class);
    }

    public static Evaluation fromYaml(String yaml) {
        return Evaluation.fromYaml(yaml, Evaluation.class);
    }

    @Override
    public double getValue(IMetric metric) {
        if (metric instanceof Metric) {
            return this.scoreForMetric((Metric)metric);
        }
        throw new IllegalStateException("Can't get value for non-evaluation Metric " + metric);
    }

    @Override
    public Evaluation newInstance() {
        return new Evaluation(this.axis, this.binaryPositiveClass, this.topN, this.labelsList, this.binaryDecisionThreshold, this.costArray, this.maxWarningClassesToPrint);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Evaluation)) {
            return false;
        }
        Evaluation other = (Evaluation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getTopN() != other.getTopN()) {
            return false;
        }
        if (this.getTopNCorrectCount() != other.getTopNCorrectCount()) {
            return false;
        }
        if (this.getTopNTotalCount() != other.getTopNTotalCount()) {
            return false;
        }
        if (this.getNumRowCounter() != other.getNumRowCounter()) {
            return false;
        }
        if (this.getMaxWarningClassesToPrint() != other.getMaxWarningClassesToPrint()) {
            return false;
        }
        Integer this$binaryPositiveClass = this.getBinaryPositiveClass();
        Integer other$binaryPositiveClass = other.getBinaryPositiveClass();
        if (this$binaryPositiveClass == null ? other$binaryPositiveClass != null : !((Object)this$binaryPositiveClass).equals(other$binaryPositiveClass)) {
            return false;
        }
        Double this$binaryDecisionThreshold = this.getBinaryDecisionThreshold();
        Double other$binaryDecisionThreshold = other.getBinaryDecisionThreshold();
        if (this$binaryDecisionThreshold == null ? other$binaryDecisionThreshold != null : !((Object)this$binaryDecisionThreshold).equals(other$binaryDecisionThreshold)) {
            return false;
        }
        Counter<Integer> this$truePositives = this.getTruePositives();
        Counter<Integer> other$truePositives = other.getTruePositives();
        if (this$truePositives == null ? other$truePositives != null : !this$truePositives.equals(other$truePositives)) {
            return false;
        }
        Counter<Integer> this$falsePositives = this.getFalsePositives();
        Counter<Integer> other$falsePositives = other.getFalsePositives();
        if (this$falsePositives == null ? other$falsePositives != null : !this$falsePositives.equals(other$falsePositives)) {
            return false;
        }
        Counter<Integer> this$trueNegatives = this.getTrueNegatives();
        Counter<Integer> other$trueNegatives = other.getTrueNegatives();
        if (this$trueNegatives == null ? other$trueNegatives != null : !this$trueNegatives.equals(other$trueNegatives)) {
            return false;
        }
        Counter<Integer> this$falseNegatives = this.getFalseNegatives();
        Counter<Integer> other$falseNegatives = other.getFalseNegatives();
        if (this$falseNegatives == null ? other$falseNegatives != null : !this$falseNegatives.equals(other$falseNegatives)) {
            return false;
        }
        ConfusionMatrix<Integer> this$confusion = this.getConfusion();
        ConfusionMatrix<Integer> other$confusion = other.getConfusion();
        if (this$confusion == null ? other$confusion != null : !((Object)this$confusion).equals(other$confusion)) {
            return false;
        }
        List<String> this$labelsList = this.getLabelsList();
        List<String> other$labelsList = other.getLabelsList();
        if (this$labelsList == null ? other$labelsList != null : !((Object)this$labelsList).equals(other$labelsList)) {
            return false;
        }
        INDArray this$costArray = this.getCostArray();
        INDArray other$costArray = other.getCostArray();
        if (this$costArray == null ? other$costArray != null : !this$costArray.equals(other$costArray)) {
            return false;
        }
        Map<Pair<Integer, Integer>, List<Object>> this$confusionMatrixMetaData = this.getConfusionMatrixMetaData();
        Map<Pair<Integer, Integer>, List<Object>> other$confusionMatrixMetaData = other.getConfusionMatrixMetaData();
        return !(this$confusionMatrixMetaData == null ? other$confusionMatrixMetaData != null : !((Object)this$confusionMatrixMetaData).equals(other$confusionMatrixMetaData));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Evaluation;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getTopN();
        result = result * 59 + this.getTopNCorrectCount();
        result = result * 59 + this.getTopNTotalCount();
        result = result * 59 + this.getNumRowCounter();
        result = result * 59 + this.getMaxWarningClassesToPrint();
        Integer $binaryPositiveClass = this.getBinaryPositiveClass();
        result = result * 59 + ($binaryPositiveClass == null ? 43 : ((Object)$binaryPositiveClass).hashCode());
        Double $binaryDecisionThreshold = this.getBinaryDecisionThreshold();
        result = result * 59 + ($binaryDecisionThreshold == null ? 43 : ((Object)$binaryDecisionThreshold).hashCode());
        Counter<Integer> $truePositives = this.getTruePositives();
        result = result * 59 + ($truePositives == null ? 43 : $truePositives.hashCode());
        Counter<Integer> $falsePositives = this.getFalsePositives();
        result = result * 59 + ($falsePositives == null ? 43 : $falsePositives.hashCode());
        Counter<Integer> $trueNegatives = this.getTrueNegatives();
        result = result * 59 + ($trueNegatives == null ? 43 : $trueNegatives.hashCode());
        Counter<Integer> $falseNegatives = this.getFalseNegatives();
        result = result * 59 + ($falseNegatives == null ? 43 : $falseNegatives.hashCode());
        ConfusionMatrix<Integer> $confusion = this.getConfusion();
        result = result * 59 + ($confusion == null ? 43 : ((Object)$confusion).hashCode());
        List<String> $labelsList = this.getLabelsList();
        result = result * 59 + ($labelsList == null ? 43 : ((Object)$labelsList).hashCode());
        INDArray $costArray = this.getCostArray();
        result = result * 59 + ($costArray == null ? 43 : $costArray.hashCode());
        Map<Pair<Integer, Integer>, List<Object>> $confusionMatrixMetaData = this.getConfusionMatrixMetaData();
        result = result * 59 + ($confusionMatrixMetaData == null ? 43 : ((Object)$confusionMatrixMetaData).hashCode());
        return result;
    }

    public Integer getBinaryPositiveClass() {
        return this.binaryPositiveClass;
    }

    public int getTopN() {
        return this.topN;
    }

    public Counter<Integer> getTruePositives() {
        return this.truePositives;
    }

    public Counter<Integer> getFalsePositives() {
        return this.falsePositives;
    }

    public Counter<Integer> getTrueNegatives() {
        return this.trueNegatives;
    }

    public Counter<Integer> getFalseNegatives() {
        return this.falseNegatives;
    }

    public ConfusionMatrix<Integer> getConfusion() {
        return this.confusion;
    }

    public Double getBinaryDecisionThreshold() {
        return this.binaryDecisionThreshold;
    }

    public INDArray getCostArray() {
        return this.costArray;
    }

    public Map<Pair<Integer, Integer>, List<Object>> getConfusionMatrixMetaData() {
        return this.confusionMatrixMetaData;
    }

    public void setBinaryPositiveClass(Integer binaryPositiveClass) {
        this.binaryPositiveClass = binaryPositiveClass;
    }

    public void setTopNCorrectCount(int topNCorrectCount) {
        this.topNCorrectCount = topNCorrectCount;
    }

    public void setTopNTotalCount(int topNTotalCount) {
        this.topNTotalCount = topNTotalCount;
    }

    public void setTruePositives(Counter<Integer> truePositives) {
        this.truePositives = truePositives;
    }

    public void setFalsePositives(Counter<Integer> falsePositives) {
        this.falsePositives = falsePositives;
    }

    public void setTrueNegatives(Counter<Integer> trueNegatives) {
        this.trueNegatives = trueNegatives;
    }

    public void setFalseNegatives(Counter<Integer> falseNegatives) {
        this.falseNegatives = falseNegatives;
    }

    public void setConfusion(ConfusionMatrix<Integer> confusion) {
        this.confusion = confusion;
    }

    public void setNumRowCounter(int numRowCounter) {
        this.numRowCounter = numRowCounter;
    }

    public void setBinaryDecisionThreshold(Double binaryDecisionThreshold) {
        this.binaryDecisionThreshold = binaryDecisionThreshold;
    }

    public void setCostArray(INDArray costArray) {
        this.costArray = costArray;
    }

    public void setConfusionMatrixMetaData(Map<Pair<Integer, Integer>, List<Object>> confusionMatrixMetaData) {
        this.confusionMatrixMetaData = confusionMatrixMetaData;
    }

    public List<String> getLabelsList() {
        return this.labelsList;
    }

    public void setLabelsList(List<String> labelsList) {
        this.labelsList = labelsList;
    }

    public int getMaxWarningClassesToPrint() {
        return this.maxWarningClassesToPrint;
    }

    public void setMaxWarningClassesToPrint(int maxWarningClassesToPrint) {
        this.maxWarningClassesToPrint = maxWarningClassesToPrint;
    }

    public static enum Metric implements IMetric
    {
        ACCURACY,
        F1,
        PRECISION,
        RECALL,
        GMEASURE,
        MCC;


        @Override
        public Class<? extends IEvaluation> getEvaluationClass() {
            return Evaluation.class;
        }

        @Override
        public boolean minimize() {
            return false;
        }
    }
}

