/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.layers.convolution.config;

import java.util.LinkedHashMap;
import java.util.Map;
import lombok.NonNull;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.BaseConvolutionConfig;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.PaddingMode;
import org.nd4j.linalg.util.ConvConfigUtil;

public class Conv1DConfig
extends BaseConvolutionConfig {
    public static final String NCW = "NCW";
    public static final String NWC = "NWC";
    private long k;
    private long s;
    private long p;
    private long d;
    private String dataFormat;
    private PaddingMode paddingMode;

    public Conv1DConfig(long k, long s, long p, long d, String dataFormat, @NonNull PaddingMode paddingMode) {
        if (paddingMode == null) {
            throw new NullPointerException("paddingMode is marked non-null but is null");
        }
        this.k = k;
        this.s = s;
        this.p = p;
        this.d = d;
        this.dataFormat = dataFormat;
        this.paddingMode = paddingMode;
        this.validate();
    }

    public Conv1DConfig(long k, long s, long p, String dataFormat, boolean isSameMode) {
        this.k = k;
        this.s = s;
        this.p = p;
        this.dataFormat = dataFormat;
        this.paddingMode = isSameMode ? PaddingMode.SAME : PaddingMode.VALID;
        this.validate();
    }

    public boolean isNWC() {
        Preconditions.checkState((this.dataFormat.equalsIgnoreCase(NCW) || this.dataFormat.equalsIgnoreCase(NWC) ? 1 : 0) != 0, (String)"Data format must be one of %s or %s, got %s", (Object)NCW, (Object)NWC, (Object)this.dataFormat);
        return this.dataFormat.equalsIgnoreCase(NWC);
    }

    public void isNWC(boolean isNWC) {
        this.dataFormat = isNWC ? NWC : NCW;
    }

    @Override
    public Map<String, Object> toProperties() {
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
        ret.put("k", this.k);
        ret.put("s", this.s);
        ret.put("p", this.p);
        ret.put("d", this.d);
        ret.put("paddingMode", (Object)this.paddingMode);
        ret.put("dataFormat", this.dataFormat);
        return ret;
    }

    @Override
    protected void validate() {
        ConvConfigUtil.validate1D(this.k, this.s, this.p, this.d);
        Preconditions.checkArgument((this.dataFormat != null ? 1 : 0) != 0, (String)"Data format can't be null");
    }

    private static long $default$k() {
        return -1L;
    }

    private static long $default$s() {
        return 1L;
    }

    private static long $default$p() {
        return 0L;
    }

    private static long $default$d() {
        return 1L;
    }

    private static String $default$dataFormat() {
        return NCW;
    }

    public static Conv1DConfigBuilder builder() {
        return new Conv1DConfigBuilder();
    }

    public long getK() {
        return this.k;
    }

    public long getS() {
        return this.s;
    }

    public long getP() {
        return this.p;
    }

    public long getD() {
        return this.d;
    }

    public String getDataFormat() {
        return this.dataFormat;
    }

    public PaddingMode getPaddingMode() {
        return this.paddingMode;
    }

    public void setK(long k) {
        this.k = k;
    }

    public void setS(long s) {
        this.s = s;
    }

    public void setP(long p) {
        this.p = p;
    }

    public void setD(long d) {
        this.d = d;
    }

    public void setDataFormat(String dataFormat) {
        this.dataFormat = dataFormat;
    }

    public void setPaddingMode(PaddingMode paddingMode) {
        this.paddingMode = paddingMode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Conv1DConfig)) {
            return false;
        }
        Conv1DConfig other = (Conv1DConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getK() != other.getK()) {
            return false;
        }
        if (this.getS() != other.getS()) {
            return false;
        }
        if (this.getP() != other.getP()) {
            return false;
        }
        if (this.getD() != other.getD()) {
            return false;
        }
        String this$dataFormat = this.getDataFormat();
        String other$dataFormat = other.getDataFormat();
        if (this$dataFormat == null ? other$dataFormat != null : !this$dataFormat.equals(other$dataFormat)) {
            return false;
        }
        PaddingMode this$paddingMode = this.getPaddingMode();
        PaddingMode other$paddingMode = other.getPaddingMode();
        return !(this$paddingMode == null ? other$paddingMode != null : !((Object)((Object)this$paddingMode)).equals((Object)other$paddingMode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Conv1DConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $k = this.getK();
        result = result * 59 + (int)($k >>> 32 ^ $k);
        long $s = this.getS();
        result = result * 59 + (int)($s >>> 32 ^ $s);
        long $p = this.getP();
        result = result * 59 + (int)($p >>> 32 ^ $p);
        long $d = this.getD();
        result = result * 59 + (int)($d >>> 32 ^ $d);
        String $dataFormat = this.getDataFormat();
        result = result * 59 + ($dataFormat == null ? 43 : $dataFormat.hashCode());
        PaddingMode $paddingMode = this.getPaddingMode();
        result = result * 59 + ($paddingMode == null ? 43 : ((Object)((Object)$paddingMode)).hashCode());
        return result;
    }

    public String toString() {
        return "Conv1DConfig(k=" + this.getK() + ", s=" + this.getS() + ", p=" + this.getP() + ", d=" + this.getD() + ", dataFormat=" + this.getDataFormat() + ", paddingMode=" + (Object)((Object)this.getPaddingMode()) + ")";
    }

    public Conv1DConfig() {
        this.k = Conv1DConfig.$default$k();
        this.s = Conv1DConfig.$default$s();
        this.p = Conv1DConfig.$default$p();
        this.d = Conv1DConfig.$default$d();
        this.dataFormat = Conv1DConfig.$default$dataFormat();
    }

    public static class Conv1DConfigBuilder {
        private boolean k$set;
        private long k$value;
        private boolean s$set;
        private long s$value;
        private boolean p$set;
        private long p$value;
        private boolean d$set;
        private long d$value;
        private boolean dataFormat$set;
        private String dataFormat$value;
        private PaddingMode paddingMode;

        Conv1DConfigBuilder() {
        }

        public Conv1DConfigBuilder k(long k) {
            this.k$value = k;
            this.k$set = true;
            return this;
        }

        public Conv1DConfigBuilder s(long s) {
            this.s$value = s;
            this.s$set = true;
            return this;
        }

        public Conv1DConfigBuilder p(long p) {
            this.p$value = p;
            this.p$set = true;
            return this;
        }

        public Conv1DConfigBuilder d(long d) {
            this.d$value = d;
            this.d$set = true;
            return this;
        }

        public Conv1DConfigBuilder dataFormat(String dataFormat) {
            this.dataFormat$value = dataFormat;
            this.dataFormat$set = true;
            return this;
        }

        public Conv1DConfigBuilder paddingMode(PaddingMode paddingMode) {
            this.paddingMode = paddingMode;
            return this;
        }

        public Conv1DConfig build() {
            long k$value = this.k$value;
            if (!this.k$set) {
                k$value = Conv1DConfig.$default$k();
            }
            long s$value = this.s$value;
            if (!this.s$set) {
                s$value = Conv1DConfig.$default$s();
            }
            long p$value = this.p$value;
            if (!this.p$set) {
                p$value = Conv1DConfig.$default$p();
            }
            long d$value = this.d$value;
            if (!this.d$set) {
                d$value = Conv1DConfig.$default$d();
            }
            String dataFormat$value = this.dataFormat$value;
            if (!this.dataFormat$set) {
                dataFormat$value = Conv1DConfig.$default$dataFormat();
            }
            return new Conv1DConfig(k$value, s$value, p$value, d$value, dataFormat$value, this.paddingMode);
        }

        public String toString() {
            return "Conv1DConfig.Conv1DConfigBuilder(k$value=" + this.k$value + ", s$value=" + this.s$value + ", p$value=" + this.p$value + ", d$value=" + this.d$value + ", dataFormat$value=" + this.dataFormat$value + ", paddingMode=" + (Object)((Object)this.paddingMode) + ")";
        }
    }
}

