/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.factory.ops;

import org.nd4j.common.base.Preconditions;
import org.nd4j.enums.PartitionMode;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.impl.indexaccum.FirstIndex;
import org.nd4j.linalg.api.ops.impl.indexaccum.LastIndex;
import org.nd4j.linalg.api.ops.impl.indexaccum.custom.ArgMax;
import org.nd4j.linalg.api.ops.impl.indexaccum.custom.ArgMin;
import org.nd4j.linalg.api.ops.impl.reduce.Moments;
import org.nd4j.linalg.api.ops.impl.reduce.NormalizeMoments;
import org.nd4j.linalg.api.ops.impl.reduce.ZeroFraction;
import org.nd4j.linalg.api.ops.impl.reduce.custom.LogSumExp;
import org.nd4j.linalg.api.ops.impl.reduce.floating.AMean;
import org.nd4j.linalg.api.ops.impl.reduce.floating.Entropy;
import org.nd4j.linalg.api.ops.impl.reduce.floating.LogEntropy;
import org.nd4j.linalg.api.ops.impl.reduce.floating.ShannonEntropy;
import org.nd4j.linalg.api.ops.impl.reduce.longer.CountNonZero;
import org.nd4j.linalg.api.ops.impl.reduce.longer.CountZero;
import org.nd4j.linalg.api.ops.impl.reduce.same.AMax;
import org.nd4j.linalg.api.ops.impl.reduce.same.AMin;
import org.nd4j.linalg.api.ops.impl.reduce.same.ASum;
import org.nd4j.linalg.api.ops.impl.reduce3.CosineDistance;
import org.nd4j.linalg.api.ops.impl.reduce3.CosineSimilarity;
import org.nd4j.linalg.api.ops.impl.reduce3.EuclideanDistance;
import org.nd4j.linalg.api.ops.impl.reduce3.HammingDistance;
import org.nd4j.linalg.api.ops.impl.reduce3.JaccardDistance;
import org.nd4j.linalg.api.ops.impl.reduce3.ManhattanDistance;
import org.nd4j.linalg.api.ops.impl.scalar.LogX;
import org.nd4j.linalg.api.ops.impl.scalar.Pow;
import org.nd4j.linalg.api.ops.impl.scalar.ScalarAdd;
import org.nd4j.linalg.api.ops.impl.scalar.ScalarDivision;
import org.nd4j.linalg.api.ops.impl.scalar.ScalarFMod;
import org.nd4j.linalg.api.ops.impl.scalar.ScalarMultiplication;
import org.nd4j.linalg.api.ops.impl.scalar.ScalarReverseDivision;
import org.nd4j.linalg.api.ops.impl.scalar.ScalarReverseSubtraction;
import org.nd4j.linalg.api.ops.impl.scalar.ScalarSubtraction;
import org.nd4j.linalg.api.ops.impl.scalar.Step;
import org.nd4j.linalg.api.ops.impl.shape.ConfusionMatrix;
import org.nd4j.linalg.api.ops.impl.shape.Cross;
import org.nd4j.linalg.api.ops.impl.shape.Diag;
import org.nd4j.linalg.api.ops.impl.shape.DiagPart;
import org.nd4j.linalg.api.ops.impl.shape.Eye;
import org.nd4j.linalg.api.ops.impl.shape.MergeAvg;
import org.nd4j.linalg.api.ops.impl.shape.MergeMax;
import org.nd4j.linalg.api.ops.impl.shape.MergeMaxIndex;
import org.nd4j.linalg.api.ops.impl.shape.MeshGrid;
import org.nd4j.linalg.api.ops.impl.shape.tensorops.EmbeddingLookup;
import org.nd4j.linalg.api.ops.impl.transforms.any.IsMax;
import org.nd4j.linalg.api.ops.impl.transforms.bool.IsFinite;
import org.nd4j.linalg.api.ops.impl.transforms.bool.IsInf;
import org.nd4j.linalg.api.ops.impl.transforms.bool.IsNaN;
import org.nd4j.linalg.api.ops.impl.transforms.clip.ClipByAvgNorm;
import org.nd4j.linalg.api.ops.impl.transforms.clip.ClipByNorm;
import org.nd4j.linalg.api.ops.impl.transforms.clip.ClipByValue;
import org.nd4j.linalg.api.ops.impl.transforms.custom.ATan2;
import org.nd4j.linalg.api.ops.impl.transforms.custom.CyclicRShiftBits;
import org.nd4j.linalg.api.ops.impl.transforms.custom.CyclicShiftBits;
import org.nd4j.linalg.api.ops.impl.transforms.custom.IsNonDecreasing;
import org.nd4j.linalg.api.ops.impl.transforms.custom.IsStrictlyIncreasing;
import org.nd4j.linalg.api.ops.impl.transforms.custom.ListDiff;
import org.nd4j.linalg.api.ops.impl.transforms.custom.MatrixDeterminant;
import org.nd4j.linalg.api.ops.impl.transforms.custom.MatrixInverse;
import org.nd4j.linalg.api.ops.impl.transforms.custom.MatrixSetDiag;
import org.nd4j.linalg.api.ops.impl.transforms.custom.Max;
import org.nd4j.linalg.api.ops.impl.transforms.custom.Min;
import org.nd4j.linalg.api.ops.impl.transforms.custom.RShiftBits;
import org.nd4j.linalg.api.ops.impl.transforms.custom.ShiftBits;
import org.nd4j.linalg.api.ops.impl.transforms.custom.Standardize;
import org.nd4j.linalg.api.ops.impl.transforms.custom.Trace;
import org.nd4j.linalg.api.ops.impl.transforms.floating.RSqrt;
import org.nd4j.linalg.api.ops.impl.transforms.floating.Sqrt;
import org.nd4j.linalg.api.ops.impl.transforms.pairwise.arithmetic.AddOp;
import org.nd4j.linalg.api.ops.impl.transforms.pairwise.arithmetic.DivOp;
import org.nd4j.linalg.api.ops.impl.transforms.pairwise.arithmetic.FloorDivOp;
import org.nd4j.linalg.api.ops.impl.transforms.pairwise.arithmetic.FloorModOp;
import org.nd4j.linalg.api.ops.impl.transforms.pairwise.arithmetic.MergeAddOp;
import org.nd4j.linalg.api.ops.impl.transforms.pairwise.arithmetic.ModOp;
import org.nd4j.linalg.api.ops.impl.transforms.pairwise.arithmetic.MulOp;
import org.nd4j.linalg.api.ops.impl.transforms.pairwise.arithmetic.RDivOp;
import org.nd4j.linalg.api.ops.impl.transforms.pairwise.arithmetic.RSubOp;
import org.nd4j.linalg.api.ops.impl.transforms.pairwise.arithmetic.SquaredDifferenceOp;
import org.nd4j.linalg.api.ops.impl.transforms.pairwise.arithmetic.SubOp;
import org.nd4j.linalg.api.ops.impl.transforms.pairwise.bool.And;
import org.nd4j.linalg.api.ops.impl.transforms.pairwise.bool.Or;
import org.nd4j.linalg.api.ops.impl.transforms.pairwise.bool.Xor;
import org.nd4j.linalg.api.ops.impl.transforms.same.Abs;
import org.nd4j.linalg.api.ops.impl.transforms.same.Ceil;
import org.nd4j.linalg.api.ops.impl.transforms.same.Cube;
import org.nd4j.linalg.api.ops.impl.transforms.same.Floor;
import org.nd4j.linalg.api.ops.impl.transforms.same.Negative;
import org.nd4j.linalg.api.ops.impl.transforms.same.Reciprocal;
import org.nd4j.linalg.api.ops.impl.transforms.same.Round;
import org.nd4j.linalg.api.ops.impl.transforms.same.Sign;
import org.nd4j.linalg.api.ops.impl.transforms.same.Square;
import org.nd4j.linalg.api.ops.impl.transforms.strict.ACos;
import org.nd4j.linalg.api.ops.impl.transforms.strict.ACosh;
import org.nd4j.linalg.api.ops.impl.transforms.strict.ASin;
import org.nd4j.linalg.api.ops.impl.transforms.strict.ASinh;
import org.nd4j.linalg.api.ops.impl.transforms.strict.ATan;
import org.nd4j.linalg.api.ops.impl.transforms.strict.ATanh;
import org.nd4j.linalg.api.ops.impl.transforms.strict.Cos;
import org.nd4j.linalg.api.ops.impl.transforms.strict.Cosh;
import org.nd4j.linalg.api.ops.impl.transforms.strict.Erf;
import org.nd4j.linalg.api.ops.impl.transforms.strict.Erfc;
import org.nd4j.linalg.api.ops.impl.transforms.strict.Exp;
import org.nd4j.linalg.api.ops.impl.transforms.strict.Expm1;
import org.nd4j.linalg.api.ops.impl.transforms.strict.Log;
import org.nd4j.linalg.api.ops.impl.transforms.strict.Log1p;
import org.nd4j.linalg.api.ops.impl.transforms.strict.RationalTanh;
import org.nd4j.linalg.api.ops.impl.transforms.strict.RectifiedTanh;
import org.nd4j.linalg.api.ops.impl.transforms.strict.Sin;
import org.nd4j.linalg.api.ops.impl.transforms.strict.Sinh;
import org.nd4j.linalg.api.ops.impl.transforms.strict.Tan;
import org.nd4j.linalg.api.ops.impl.transforms.strict.Tanh;
import org.nd4j.linalg.factory.NDValidation;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.conditions.Condition;

public class NDMath {
    public INDArray clipByAvgNorm(INDArray x, double clipValue, int ... dimensions) {
        NDValidation.validateNumerical("ClipByAvgNorm", "x", x);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return Nd4j.exec(new ClipByAvgNorm(x, clipValue, dimensions))[0];
    }

    public INDArray embeddingLookup(INDArray x, INDArray indices, PartitionMode PartitionMode2) {
        NDValidation.validateNumerical("EmbeddingLookup", "x", x);
        NDValidation.validateInteger("EmbeddingLookup", "indices", indices);
        return Nd4j.exec(new EmbeddingLookup(x, indices, PartitionMode2, new int[0]))[0];
    }

    public INDArray mergeMaxIndex(INDArray[] x, DataType dataType) {
        NDValidation.validateNumerical("MergeMaxIndex", "x", x);
        Preconditions.checkArgument((x.length >= 1 ? 1 : 0) != 0, (String)"x has incorrect size/length. Expected: x.length >= 1, got %s", (int)x.length);
        return Nd4j.exec(new MergeMaxIndex(x, dataType))[0];
    }

    public INDArray mergeMaxIndex(INDArray ... x) {
        NDValidation.validateNumerical("MergeMaxIndex", "x", x);
        Preconditions.checkArgument((x.length >= 1 ? 1 : 0) != 0, (String)"x has incorrect size/length. Expected: x.length >= 1, got %s", (int)x.length);
        return Nd4j.exec(new MergeMaxIndex(x, DataType.INT))[0];
    }

    public INDArray abs(INDArray x) {
        NDValidation.validateNumerical("abs", "x", x);
        return Nd4j.exec(new Abs(x));
    }

    public INDArray acos(INDArray x) {
        NDValidation.validateNumerical("acos", "x", x);
        return Nd4j.exec(new ACos(x));
    }

    public INDArray acosh(INDArray x) {
        NDValidation.validateNumerical("acosh", "x", x);
        return Nd4j.exec(new ACosh(x));
    }

    public INDArray add(INDArray x, INDArray y) {
        NDValidation.validateNumerical("add", "x", x);
        NDValidation.validateNumerical("add", "y", y);
        return Nd4j.exec(new AddOp(x, y))[0];
    }

    public INDArray add(INDArray x, double value) {
        NDValidation.validateNumerical("add", "x", x);
        return Nd4j.exec(new ScalarAdd(x, value));
    }

    public INDArray amax(INDArray in, int ... dimensions) {
        NDValidation.validateNumerical("amax", "in", in);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return Nd4j.exec(new AMax(in, dimensions));
    }

    public INDArray amean(INDArray in, int ... dimensions) {
        NDValidation.validateNumerical("amean", "in", in);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return Nd4j.exec(new AMean(in, dimensions));
    }

    public INDArray amin(INDArray in, int ... dimensions) {
        NDValidation.validateNumerical("amin", "in", in);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return Nd4j.exec(new AMin(in, dimensions));
    }

    public INDArray and(INDArray x, INDArray y) {
        NDValidation.validateBool("and", "x", x);
        NDValidation.validateBool("and", "y", y);
        return Nd4j.exec(new And(x, y));
    }

    public INDArray asin(INDArray x) {
        NDValidation.validateNumerical("asin", "x", x);
        return Nd4j.exec(new ASin(x));
    }

    public INDArray asinh(INDArray x) {
        NDValidation.validateNumerical("asinh", "x", x);
        return Nd4j.exec(new ASinh(x));
    }

    public INDArray asum(INDArray in, int ... dimensions) {
        NDValidation.validateNumerical("asum", "in", in);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return Nd4j.exec(new ASum(in, dimensions));
    }

    public INDArray atan(INDArray x) {
        NDValidation.validateNumerical("atan", "x", x);
        return Nd4j.exec(new ATan(x));
    }

    public INDArray atan2(INDArray y, INDArray x) {
        NDValidation.validateNumerical("atan2", "y", y);
        NDValidation.validateNumerical("atan2", "x", x);
        return Nd4j.exec(new ATan2(y, x))[0];
    }

    public INDArray atanh(INDArray x) {
        NDValidation.validateNumerical("atanh", "x", x);
        return Nd4j.exec(new ATanh(x));
    }

    public INDArray bitShift(INDArray x, INDArray shift) {
        NDValidation.validateNumerical("bitShift", "x", x);
        NDValidation.validateNumerical("bitShift", "shift", shift);
        return Nd4j.exec(new ShiftBits(x, shift))[0];
    }

    public INDArray bitShiftRight(INDArray x, INDArray shift) {
        NDValidation.validateNumerical("bitShiftRight", "x", x);
        NDValidation.validateNumerical("bitShiftRight", "shift", shift);
        return Nd4j.exec(new RShiftBits(x, shift))[0];
    }

    public INDArray bitShiftRotl(INDArray x, INDArray shift) {
        NDValidation.validateNumerical("bitShiftRotl", "x", x);
        NDValidation.validateNumerical("bitShiftRotl", "shift", shift);
        return Nd4j.exec(new CyclicShiftBits(x, shift))[0];
    }

    public INDArray bitShiftRotr(INDArray x, INDArray shift) {
        NDValidation.validateNumerical("bitShiftRotr", "x", x);
        NDValidation.validateNumerical("bitShiftRotr", "shift", shift);
        return Nd4j.exec(new CyclicRShiftBits(x, shift))[0];
    }

    public INDArray ceil(INDArray x) {
        NDValidation.validateNumerical("ceil", "x", x);
        return Nd4j.exec(new Ceil(x));
    }

    public INDArray clipByNorm(INDArray x, double clipValue, int ... dimensions) {
        NDValidation.validateNumerical("clipByNorm", "x", x);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return Nd4j.exec(new ClipByNorm(x, clipValue, dimensions))[0];
    }

    public INDArray clipByValue(INDArray x, double clipValueMin, double clipValueMax) {
        NDValidation.validateNumerical("clipByValue", "x", x);
        return Nd4j.exec(new ClipByValue(x, clipValueMin, clipValueMax))[0];
    }

    public INDArray confusionMatrix(INDArray labels, INDArray pred, DataType dataType) {
        NDValidation.validateNumerical("confusionMatrix", "labels", labels);
        NDValidation.validateNumerical("confusionMatrix", "pred", pred);
        return Nd4j.exec(new ConfusionMatrix(labels, pred, dataType))[0];
    }

    public INDArray confusionMatrix(INDArray labels, INDArray pred, int numClasses) {
        NDValidation.validateNumerical("confusionMatrix", "labels", labels);
        NDValidation.validateNumerical("confusionMatrix", "pred", pred);
        return Nd4j.exec(new ConfusionMatrix(labels, pred, numClasses))[0];
    }

    public INDArray confusionMatrix(INDArray labels, INDArray pred, INDArray weights) {
        NDValidation.validateNumerical("confusionMatrix", "labels", labels);
        NDValidation.validateNumerical("confusionMatrix", "pred", pred);
        NDValidation.validateNumerical("confusionMatrix", "weights", weights);
        return Nd4j.exec(new ConfusionMatrix(labels, pred, weights))[0];
    }

    public INDArray confusionMatrix(INDArray labels, INDArray pred, INDArray weights, int numClasses) {
        NDValidation.validateNumerical("confusionMatrix", "labels", labels);
        NDValidation.validateNumerical("confusionMatrix", "pred", pred);
        NDValidation.validateNumerical("confusionMatrix", "weights", weights);
        return Nd4j.exec(new ConfusionMatrix(labels, pred, weights, (Integer)numClasses))[0];
    }

    public INDArray cos(INDArray x) {
        NDValidation.validateNumerical("cos", "x", x);
        return Nd4j.exec(new Cos(x));
    }

    public INDArray cosh(INDArray x) {
        NDValidation.validateNumerical("cosh", "x", x);
        return Nd4j.exec(new Cosh(x));
    }

    public INDArray cosineDistance(INDArray x, INDArray y, int ... dimensions) {
        NDValidation.validateNumerical("cosineDistance", "x", x);
        NDValidation.validateNumerical("cosineDistance", "y", y);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return Nd4j.exec(new CosineDistance(x, y, dimensions));
    }

    public INDArray cosineSimilarity(INDArray x, INDArray y, int ... dimensions) {
        NDValidation.validateNumerical("cosineSimilarity", "x", x);
        NDValidation.validateNumerical("cosineSimilarity", "y", y);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return Nd4j.exec(new CosineSimilarity(x, y, dimensions));
    }

    public INDArray countNonZero(INDArray in, int ... dimensions) {
        NDValidation.validateNumerical("countNonZero", "in", in);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return Nd4j.exec(new CountNonZero(in, dimensions));
    }

    public INDArray countZero(INDArray in, int ... dimensions) {
        NDValidation.validateNumerical("countZero", "in", in);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return Nd4j.exec(new CountZero(in, dimensions));
    }

    public INDArray cross(INDArray a, INDArray b) {
        NDValidation.validateNumerical("cross", "a", a);
        NDValidation.validateNumerical("cross", "b", b);
        return Nd4j.exec(new Cross(a, b))[0];
    }

    public INDArray cube(INDArray x) {
        NDValidation.validateNumerical("cube", "x", x);
        return Nd4j.exec(new Cube(x));
    }

    public INDArray diag(INDArray x) {
        NDValidation.validateNumerical("diag", "x", x);
        return Nd4j.exec(new Diag(x))[0];
    }

    public INDArray diagPart(INDArray x) {
        NDValidation.validateNumerical("diagPart", "x", x);
        return Nd4j.exec(new DiagPart(x))[0];
    }

    public INDArray div(INDArray x, INDArray y) {
        NDValidation.validateNumerical("div", "x", x);
        NDValidation.validateNumerical("div", "y", y);
        return Nd4j.exec(new DivOp(x, y))[0];
    }

    public INDArray div(INDArray x, double value) {
        NDValidation.validateNumerical("div", "x", x);
        return Nd4j.exec(new ScalarDivision(x, value));
    }

    public INDArray entropy(INDArray in, int ... dimensions) {
        NDValidation.validateNumerical("entropy", "in", in);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return Nd4j.exec(new Entropy(in, dimensions));
    }

    public INDArray erf(INDArray x) {
        NDValidation.validateNumerical("erf", "x", x);
        return Nd4j.exec(new Erf(x));
    }

    public INDArray erfc(INDArray x) {
        NDValidation.validateNumerical("erfc", "x", x);
        return Nd4j.exec(new Erfc(x));
    }

    public INDArray euclideanDistance(INDArray x, INDArray y, int ... dimensions) {
        NDValidation.validateNumerical("euclideanDistance", "x", x);
        NDValidation.validateNumerical("euclideanDistance", "y", y);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return Nd4j.exec(new EuclideanDistance(x, y, dimensions));
    }

    public INDArray exp(INDArray x) {
        NDValidation.validateNumerical("exp", "x", x);
        return Nd4j.exec(new Exp(x));
    }

    public INDArray expm1(INDArray x) {
        NDValidation.validateNumerical("expm1", "x", x);
        return Nd4j.exec(new Expm1(x));
    }

    public INDArray eye(int rows) {
        return Nd4j.exec(new Eye(rows))[0];
    }

    public INDArray eye(int rows, int cols) {
        return Nd4j.exec(new Eye(rows, cols))[0];
    }

    public INDArray eye(int rows, int cols, DataType dataType, int ... dimensions) {
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return Nd4j.exec(new Eye(rows, cols, dataType, dimensions))[0];
    }

    public INDArray eye(INDArray rows, INDArray cols) {
        NDValidation.validateInteger("eye", "rows", rows);
        NDValidation.validateInteger("eye", "cols", cols);
        return Nd4j.exec(new Eye(rows, cols))[0];
    }

    public INDArray eye(INDArray rows) {
        NDValidation.validateInteger("eye", "rows", rows);
        return Nd4j.exec(new Eye(rows))[0];
    }

    public INDArray firstIndex(INDArray in, Condition condition, int ... dimensions) {
        NDValidation.validateNumerical("firstIndex", "in", in);
        Preconditions.checkArgument((dimensions.length >= 1 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 1, got %s", (int)dimensions.length);
        return Nd4j.exec(new FirstIndex(in, false, condition, dimensions));
    }

    public INDArray firstIndex(INDArray in, Condition condition, boolean keepDims, int ... dimensions) {
        NDValidation.validateNumerical("firstIndex", "in", in);
        Preconditions.checkArgument((dimensions.length >= 1 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 1, got %s", (int)dimensions.length);
        return Nd4j.exec(new FirstIndex(in, keepDims, condition, dimensions));
    }

    public INDArray floor(INDArray x) {
        NDValidation.validateNumerical("floor", "x", x);
        return Nd4j.exec(new Floor(x));
    }

    public INDArray floorDiv(INDArray x, INDArray y) {
        NDValidation.validateNumerical("floorDiv", "x", x);
        NDValidation.validateNumerical("floorDiv", "y", y);
        return Nd4j.exec(new FloorDivOp(x, y))[0];
    }

    public INDArray floorMod(INDArray x, INDArray y) {
        NDValidation.validateNumerical("floorMod", "x", x);
        NDValidation.validateNumerical("floorMod", "y", y);
        return Nd4j.exec(new FloorModOp(x, y))[0];
    }

    public INDArray floorMod(INDArray x, double value) {
        NDValidation.validateNumerical("floorMod", "x", x);
        return Nd4j.exec(new ScalarFMod(x, value));
    }

    public INDArray hammingDistance(INDArray x, INDArray y, int ... dimensions) {
        NDValidation.validateNumerical("hammingDistance", "x", x);
        NDValidation.validateNumerical("hammingDistance", "y", y);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return Nd4j.exec(new HammingDistance(x, y, dimensions));
    }

    public INDArray iamax(INDArray in, int ... dimensions) {
        NDValidation.validateNumerical("iamax", "in", in);
        Preconditions.checkArgument((dimensions.length >= 1 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 1, got %s", (int)dimensions.length);
        return Nd4j.exec(new ArgMax(in, false, dimensions))[0];
    }

    public INDArray iamax(INDArray in, boolean keepDims, int ... dimensions) {
        NDValidation.validateNumerical("iamax", "in", in);
        Preconditions.checkArgument((dimensions.length >= 1 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 1, got %s", (int)dimensions.length);
        return Nd4j.exec(new ArgMax(in, keepDims, dimensions))[0];
    }

    public INDArray iamin(INDArray in, int ... dimensions) {
        NDValidation.validateNumerical("iamin", "in", in);
        Preconditions.checkArgument((dimensions.length >= 1 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 1, got %s", (int)dimensions.length);
        return Nd4j.exec(new ArgMin(in, false, dimensions))[0];
    }

    public INDArray iamin(INDArray in, boolean keepDims, int ... dimensions) {
        NDValidation.validateNumerical("iamin", "in", in);
        Preconditions.checkArgument((dimensions.length >= 1 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 1, got %s", (int)dimensions.length);
        return Nd4j.exec(new ArgMin(in, keepDims, dimensions))[0];
    }

    public INDArray isFinite(INDArray x) {
        NDValidation.validateNumerical("isFinite", "x", x);
        return Nd4j.exec(new IsFinite(x));
    }

    public INDArray isInfinite(INDArray x) {
        NDValidation.validateNumerical("isInfinite", "x", x);
        return Nd4j.exec(new IsInf(x));
    }

    public INDArray isMax(INDArray x) {
        NDValidation.validateNumerical("isMax", "x", x);
        return Nd4j.exec(new IsMax(x))[0];
    }

    public INDArray isNaN(INDArray x) {
        NDValidation.validateNumerical("isNaN", "x", x);
        return Nd4j.exec(new IsNaN(x));
    }

    public INDArray isNonDecreasing(INDArray x) {
        NDValidation.validateNumerical("isNonDecreasing", "x", x);
        return Nd4j.exec(new IsNonDecreasing(x))[0];
    }

    public INDArray isStrictlyIncreasing(INDArray x) {
        NDValidation.validateNumerical("isStrictlyIncreasing", "x", x);
        return Nd4j.exec(new IsStrictlyIncreasing(x))[0];
    }

    public INDArray jaccardDistance(INDArray x, INDArray y, int ... dimensions) {
        NDValidation.validateNumerical("jaccardDistance", "x", x);
        NDValidation.validateNumerical("jaccardDistance", "y", y);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return Nd4j.exec(new JaccardDistance(x, y, dimensions));
    }

    public INDArray lastIndex(INDArray in, Condition condition, int ... dimensions) {
        NDValidation.validateNumerical("lastIndex", "in", in);
        Preconditions.checkArgument((dimensions.length >= 1 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 1, got %s", (int)dimensions.length);
        return Nd4j.exec(new LastIndex(in, false, condition, dimensions));
    }

    public INDArray lastIndex(INDArray in, Condition condition, boolean keepDims, int ... dimensions) {
        NDValidation.validateNumerical("lastIndex", "in", in);
        Preconditions.checkArgument((dimensions.length >= 1 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 1, got %s", (int)dimensions.length);
        return Nd4j.exec(new LastIndex(in, keepDims, condition, dimensions));
    }

    public INDArray[] listDiff(INDArray x, INDArray y) {
        NDValidation.validateNumerical("listDiff", "x", x);
        NDValidation.validateNumerical("listDiff", "y", y);
        return Nd4j.exec(new ListDiff(x, y));
    }

    public INDArray log(INDArray x) {
        NDValidation.validateNumerical("log", "x", x);
        return Nd4j.exec(new Log(x));
    }

    public INDArray log(INDArray x, double base) {
        NDValidation.validateNumerical("log", "x", x);
        return Nd4j.exec(new LogX(x, base));
    }

    public INDArray log1p(INDArray x) {
        NDValidation.validateNumerical("log1p", "x", x);
        return Nd4j.exec(new Log1p(x));
    }

    public INDArray logEntropy(INDArray in, int ... dimensions) {
        NDValidation.validateNumerical("logEntropy", "in", in);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return Nd4j.exec(new LogEntropy(in, dimensions));
    }

    public INDArray logSumExp(INDArray input, int ... dimensions) {
        NDValidation.validateNumerical("logSumExp", "input", input);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return Nd4j.exec(new LogSumExp(input, dimensions))[0];
    }

    public INDArray manhattanDistance(INDArray x, INDArray y, int ... dimensions) {
        NDValidation.validateNumerical("manhattanDistance", "x", x);
        NDValidation.validateNumerical("manhattanDistance", "y", y);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return Nd4j.exec(new ManhattanDistance(x, y, dimensions));
    }

    public INDArray matrixDeterminant(INDArray in) {
        NDValidation.validateNumerical("matrixDeterminant", "in", in);
        return Nd4j.exec(new MatrixDeterminant(in))[0];
    }

    public INDArray matrixInverse(INDArray in) {
        NDValidation.validateNumerical("matrixInverse", "in", in);
        return Nd4j.exec(new MatrixInverse(in))[0];
    }

    public INDArray max(INDArray x, INDArray y) {
        NDValidation.validateNumerical("max", "x", x);
        NDValidation.validateNumerical("max", "y", y);
        return Nd4j.exec(new Max(x, y))[0];
    }

    public INDArray mergeAdd(INDArray ... inputs) {
        NDValidation.validateNumerical("mergeAdd", "inputs", inputs);
        Preconditions.checkArgument((inputs.length >= 1 ? 1 : 0) != 0, (String)"inputs has incorrect size/length. Expected: inputs.length >= 1, got %s", (int)inputs.length);
        return Nd4j.exec(new MergeAddOp(inputs))[0];
    }

    public INDArray mergeAvg(INDArray ... inputs) {
        NDValidation.validateNumerical("mergeAvg", "inputs", inputs);
        Preconditions.checkArgument((inputs.length >= 1 ? 1 : 0) != 0, (String)"inputs has incorrect size/length. Expected: inputs.length >= 1, got %s", (int)inputs.length);
        return Nd4j.exec(new MergeAvg(inputs))[0];
    }

    public INDArray mergeMax(INDArray ... inputs) {
        NDValidation.validateNumerical("mergeMax", "inputs", inputs);
        Preconditions.checkArgument((inputs.length >= 1 ? 1 : 0) != 0, (String)"inputs has incorrect size/length. Expected: inputs.length >= 1, got %s", (int)inputs.length);
        return Nd4j.exec(new MergeMax(inputs))[0];
    }

    public INDArray[] meshgrid(INDArray[] inputs, boolean cartesian) {
        NDValidation.validateNumerical("meshgrid", "inputs", inputs);
        Preconditions.checkArgument((inputs.length >= 0 ? 1 : 0) != 0, (String)"inputs has incorrect size/length. Expected: inputs.length >= 0, got %s", (int)inputs.length);
        return Nd4j.exec(new MeshGrid(inputs, cartesian));
    }

    public INDArray min(INDArray x, INDArray y) {
        NDValidation.validateNumerical("min", "x", x);
        NDValidation.validateNumerical("min", "y", y);
        return Nd4j.exec(new Min(x, y))[0];
    }

    public INDArray mod(INDArray x, INDArray y) {
        NDValidation.validateNumerical("mod", "x", x);
        NDValidation.validateNumerical("mod", "y", y);
        return Nd4j.exec(new ModOp(x, y))[0];
    }

    public INDArray[] moments(INDArray input, int ... axes) {
        NDValidation.validateNumerical("moments", "input", input);
        Preconditions.checkArgument((axes.length >= 0 ? 1 : 0) != 0, (String)"axes has incorrect size/length. Expected: axes.length >= 0, got %s", (int)axes.length);
        return Nd4j.exec(new Moments(input, axes));
    }

    public INDArray mul(INDArray x, INDArray y) {
        NDValidation.validateNumerical("mul", "x", x);
        NDValidation.validateNumerical("mul", "y", y);
        return Nd4j.exec(new MulOp(x, y))[0];
    }

    public INDArray mul(INDArray x, double value) {
        NDValidation.validateNumerical("mul", "x", x);
        return Nd4j.exec(new ScalarMultiplication(x, value));
    }

    public INDArray neg(INDArray x) {
        NDValidation.validateNumerical("neg", "x", x);
        return Nd4j.exec(new Negative(x));
    }

    public INDArray[] normalizeMoments(INDArray counts, INDArray means, INDArray variances, double shift) {
        NDValidation.validateNumerical("normalizeMoments", "counts", counts);
        NDValidation.validateNumerical("normalizeMoments", "means", means);
        NDValidation.validateNumerical("normalizeMoments", "variances", variances);
        return Nd4j.exec(new NormalizeMoments(counts, means, variances, shift));
    }

    public INDArray or(INDArray x, INDArray y) {
        NDValidation.validateBool("or", "x", x);
        NDValidation.validateBool("or", "y", y);
        return Nd4j.exec(new Or(x, y));
    }

    public INDArray pow(INDArray x, double value) {
        NDValidation.validateNumerical("pow", "x", x);
        return Nd4j.exec(new Pow(x, value));
    }

    public INDArray pow(INDArray x, INDArray y) {
        NDValidation.validateNumerical("pow", "x", x);
        NDValidation.validateNumerical("pow", "y", y);
        return Nd4j.exec(new org.nd4j.linalg.api.ops.impl.transforms.custom.Pow(x, y))[0];
    }

    public INDArray rationalTanh(INDArray x) {
        NDValidation.validateNumerical("rationalTanh", "x", x);
        return Nd4j.exec(new RationalTanh(x));
    }

    public INDArray rdiv(INDArray x, INDArray y) {
        NDValidation.validateNumerical("rdiv", "x", x);
        NDValidation.validateNumerical("rdiv", "y", y);
        return Nd4j.exec(new RDivOp(x, y))[0];
    }

    public INDArray rdiv(INDArray x, double value) {
        NDValidation.validateNumerical("rdiv", "x", x);
        return Nd4j.exec(new ScalarReverseDivision(x, value));
    }

    public INDArray reciprocal(INDArray x) {
        NDValidation.validateNumerical("reciprocal", "x", x);
        return Nd4j.exec(new Reciprocal(x));
    }

    public INDArray rectifiedTanh(INDArray x) {
        NDValidation.validateNumerical("rectifiedTanh", "x", x);
        return Nd4j.exec(new RectifiedTanh(x));
    }

    public INDArray round(INDArray x) {
        NDValidation.validateNumerical("round", "x", x);
        return Nd4j.exec(new Round(x));
    }

    public INDArray rsqrt(INDArray x) {
        NDValidation.validateNumerical("rsqrt", "x", x);
        return Nd4j.exec(new RSqrt(x));
    }

    public INDArray rsub(INDArray x, INDArray y) {
        NDValidation.validateNumerical("rsub", "x", x);
        NDValidation.validateNumerical("rsub", "y", y);
        return Nd4j.exec(new RSubOp(x, y))[0];
    }

    public INDArray rsub(INDArray x, double value) {
        NDValidation.validateNumerical("rsub", "x", x);
        return Nd4j.exec(new ScalarReverseSubtraction(x, value));
    }

    public INDArray setDiag(INDArray in, INDArray diag) {
        NDValidation.validateNumerical("setDiag", "in", in);
        NDValidation.validateNumerical("setDiag", "diag", diag);
        return Nd4j.exec(new MatrixSetDiag(in, diag))[0];
    }

    public INDArray shannonEntropy(INDArray in, int ... dimensions) {
        NDValidation.validateNumerical("shannonEntropy", "in", in);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return Nd4j.exec(new ShannonEntropy(in, dimensions));
    }

    public INDArray sign(INDArray x) {
        NDValidation.validateNumerical("sign", "x", x);
        return Nd4j.exec(new Sign(x));
    }

    public INDArray sin(INDArray x) {
        NDValidation.validateNumerical("sin", "x", x);
        return Nd4j.exec(new Sin(x));
    }

    public INDArray sinh(INDArray x) {
        NDValidation.validateNumerical("sinh", "x", x);
        return Nd4j.exec(new Sinh(x));
    }

    public INDArray sqrt(INDArray x) {
        NDValidation.validateNumerical("sqrt", "x", x);
        return Nd4j.exec(new Sqrt(x));
    }

    public INDArray square(INDArray x) {
        NDValidation.validateNumerical("square", "x", x);
        return Nd4j.exec(new Square(x));
    }

    public INDArray squaredDifference(INDArray x, INDArray y) {
        NDValidation.validateNumerical("squaredDifference", "x", x);
        NDValidation.validateNumerical("squaredDifference", "y", y);
        return Nd4j.exec(new SquaredDifferenceOp(x, y))[0];
    }

    public INDArray standardize(INDArray x, int ... dimensions) {
        NDValidation.validateNumerical("standardize", "x", x);
        Preconditions.checkArgument((dimensions.length >= 1 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 1, got %s", (int)dimensions.length);
        return Nd4j.exec(new Standardize(x, dimensions))[0];
    }

    public INDArray step(INDArray x, double value) {
        NDValidation.validateNumerical("step", "x", x);
        return Nd4j.exec(new Step(x, value));
    }

    public INDArray sub(INDArray x, INDArray y) {
        NDValidation.validateNumerical("sub", "x", x);
        NDValidation.validateNumerical("sub", "y", y);
        return Nd4j.exec(new SubOp(x, y))[0];
    }

    public INDArray sub(INDArray x, double value) {
        NDValidation.validateNumerical("sub", "x", x);
        return Nd4j.exec(new ScalarSubtraction(x, value));
    }

    public INDArray tan(INDArray x) {
        NDValidation.validateNumerical("tan", "x", x);
        return Nd4j.exec(new Tan(x));
    }

    public INDArray tanh(INDArray x) {
        NDValidation.validateNumerical("tanh", "x", x);
        return Nd4j.exec(new Tanh(x));
    }

    public INDArray trace(INDArray in) {
        NDValidation.validateNumerical("trace", "in", in);
        return Nd4j.exec(new Trace(in))[0];
    }

    public INDArray xor(INDArray x, INDArray y) {
        NDValidation.validateBool("xor", "x", x);
        NDValidation.validateBool("xor", "y", y);
        return Nd4j.exec(new Xor(x, y));
    }

    public INDArray zeroFraction(INDArray input) {
        NDValidation.validateNumerical("zeroFraction", "input", input);
        return Nd4j.exec(new ZeroFraction(input))[0];
    }
}

