/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.weightinit.impl;

import org.apache.commons.math3.util.FastMath;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.weightinit.BaseWeightInitScheme;
import org.nd4j.weightinit.WeightInit;

public class VarScalingNormalFanInInitScheme
extends BaseWeightInitScheme {
    private double fanIn;

    public VarScalingNormalFanInInitScheme(char order, double fanIn) {
        super(order);
        this.fanIn = fanIn;
    }

    @Override
    public INDArray doCreate(DataType dataType, long[] shape, INDArray paramsView) {
        return Nd4j.randn(dataType, this.order(), shape).divi(FastMath.sqrt((double)this.fanIn));
    }

    @Override
    public WeightInit type() {
        return WeightInit.VAR_SCALING_NORMAL_FAN_IN;
    }

    public static VarScalingNormalFanInInitSchemeBuilder builder() {
        return new VarScalingNormalFanInInitSchemeBuilder();
    }

    public static class VarScalingNormalFanInInitSchemeBuilder {
        private char order;
        private double fanIn;

        VarScalingNormalFanInInitSchemeBuilder() {
        }

        public VarScalingNormalFanInInitSchemeBuilder order(char order) {
            this.order = order;
            return this;
        }

        public VarScalingNormalFanInInitSchemeBuilder fanIn(double fanIn) {
            this.fanIn = fanIn;
            return this;
        }

        public VarScalingNormalFanInInitScheme build() {
            return new VarScalingNormalFanInInitScheme(this.order, this.fanIn);
        }

        public String toString() {
            return "VarScalingNormalFanInInitScheme.VarScalingNormalFanInInitSchemeBuilder(order=" + this.order + ", fanIn=" + this.fanIn + ")";
        }
    }
}

