/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.cpu.nativecpu.buffer;

import java.nio.ByteBuffer;
import org.bytedeco.javacpp.BooleanPointer;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.FloatPointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.LongPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.ShortPointer;
import org.bytedeco.javacpp.indexer.Bfloat16Indexer;
import org.bytedeco.javacpp.indexer.BooleanIndexer;
import org.bytedeco.javacpp.indexer.ByteIndexer;
import org.bytedeco.javacpp.indexer.DoubleIndexer;
import org.bytedeco.javacpp.indexer.FloatIndexer;
import org.bytedeco.javacpp.indexer.HalfIndexer;
import org.bytedeco.javacpp.indexer.Indexer;
import org.bytedeco.javacpp.indexer.IntIndexer;
import org.bytedeco.javacpp.indexer.LongIndexer;
import org.bytedeco.javacpp.indexer.ShortIndexer;
import org.bytedeco.javacpp.indexer.UByteIndexer;
import org.bytedeco.javacpp.indexer.UIntIndexer;
import org.bytedeco.javacpp.indexer.UShortIndexer;
import org.nd4j.linalg.api.buffer.BaseDataBuffer;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.buffer.util.AllocUtil;
import org.nd4j.linalg.api.memory.Deallocatable;
import org.nd4j.linalg.api.memory.Deallocator;
import org.nd4j.linalg.api.memory.MemoryWorkspace;
import org.nd4j.linalg.api.memory.pointers.PagedPointer;
import org.nd4j.linalg.cpu.nativecpu.buffer.CpuDeallocator;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.nativeblas.OpaqueDataBuffer;

public abstract class BaseCpuDataBuffer
extends BaseDataBuffer
implements Deallocatable {
    protected transient OpaqueDataBuffer ptrDataBuffer;
    private final transient long instanceId = Nd4j.getDeallocatorService().nextValue();

    protected BaseCpuDataBuffer() {
    }

    public String getUniqueId() {
        return new String("BCDB_" + this.instanceId);
    }

    public Deallocator deallocator() {
        return new CpuDeallocator(this);
    }

    public OpaqueDataBuffer getOpaqueDataBuffer() {
        if (this.released) {
            throw new IllegalStateException("You can't use DataBuffer once it was released");
        }
        return this.ptrDataBuffer;
    }

    public int targetDevice() {
        return 0;
    }

    public BaseCpuDataBuffer(long length, int elementSize) {
        if (length < 1L) {
            throw new IllegalArgumentException("Length must be >= 1");
        }
        this.initTypeAndSize();
        this.allocationMode = AllocUtil.getAllocationModeFromContext();
        this.length = length;
        this.underlyingLength = length;
        this.elementSize = (byte)elementSize;
        if (this.dataType() != DataType.UTF8) {
            this.ptrDataBuffer = OpaqueDataBuffer.allocateDataBuffer((long)length, (DataType)this.dataType(), (boolean)false);
        }
        if (this.dataType() == DataType.DOUBLE) {
            this.pointer = new PagedPointer(this.ptrDataBuffer.primaryBuffer(), length).asDoublePointer();
            this.indexer = DoubleIndexer.create((DoublePointer)((DoublePointer)this.pointer));
        } else if (this.dataType() == DataType.FLOAT) {
            this.pointer = new PagedPointer(this.ptrDataBuffer.primaryBuffer(), length).asFloatPointer();
            this.setIndexer((Indexer)FloatIndexer.create((FloatPointer)((FloatPointer)this.pointer)));
        } else if (this.dataType() == DataType.INT32) {
            this.pointer = new PagedPointer(this.ptrDataBuffer.primaryBuffer(), length).asIntPointer();
            this.setIndexer((Indexer)IntIndexer.create((IntPointer)((IntPointer)this.pointer)));
        } else if (this.dataType() == DataType.LONG) {
            this.pointer = new PagedPointer(this.ptrDataBuffer.primaryBuffer(), length).asLongPointer();
            this.setIndexer((Indexer)LongIndexer.create((LongPointer)((LongPointer)this.pointer)));
        } else if (this.dataType() == DataType.SHORT) {
            this.pointer = new PagedPointer(this.ptrDataBuffer.primaryBuffer(), length).asShortPointer();
            this.setIndexer((Indexer)ShortIndexer.create((ShortPointer)((ShortPointer)this.pointer)));
        } else if (this.dataType() == DataType.BYTE) {
            this.pointer = new PagedPointer(this.ptrDataBuffer.primaryBuffer(), length).asBytePointer();
            this.setIndexer((Indexer)ByteIndexer.create((BytePointer)((BytePointer)this.pointer)));
        } else if (this.dataType() == DataType.UBYTE) {
            this.pointer = new PagedPointer(this.ptrDataBuffer.primaryBuffer(), length).asBytePointer();
            this.setIndexer((Indexer)UByteIndexer.create((BytePointer)((BytePointer)this.pointer)));
        } else if (this.dataType() == DataType.UTF8) {
            this.ptrDataBuffer = OpaqueDataBuffer.allocateDataBuffer((long)length, (DataType)DataType.INT8, (boolean)false);
            this.pointer = new PagedPointer(this.ptrDataBuffer.primaryBuffer(), length).asBytePointer();
            this.setIndexer((Indexer)ByteIndexer.create((BytePointer)((BytePointer)this.pointer)));
        } else if (this.dataType() == DataType.FLOAT16) {
            this.pointer = new PagedPointer(this.ptrDataBuffer.primaryBuffer(), length).asShortPointer();
            this.setIndexer((Indexer)HalfIndexer.create((ShortPointer)((ShortPointer)this.pointer)));
        } else if (this.dataType() == DataType.BFLOAT16) {
            this.pointer = new PagedPointer(this.ptrDataBuffer.primaryBuffer(), length).asShortPointer();
            this.setIndexer((Indexer)Bfloat16Indexer.create((ShortPointer)((ShortPointer)this.pointer)));
        } else if (this.dataType() == DataType.BOOL) {
            this.pointer = new PagedPointer(this.ptrDataBuffer.primaryBuffer(), length).asBoolPointer();
            this.setIndexer((Indexer)BooleanIndexer.create((BooleanPointer)((BooleanPointer)this.pointer)));
        } else if (this.dataType() == DataType.UINT16) {
            this.pointer = new PagedPointer(this.ptrDataBuffer.primaryBuffer(), length).asShortPointer();
            this.setIndexer((Indexer)UShortIndexer.create((ShortPointer)((ShortPointer)this.pointer)));
        } else if (this.dataType() == DataType.UINT32) {
            this.pointer = new PagedPointer(this.ptrDataBuffer.primaryBuffer(), length).asIntPointer();
            this.setIndexer((Indexer)UIntIndexer.create((IntPointer)((IntPointer)this.pointer)));
        } else if (this.dataType() == DataType.UINT64) {
            this.pointer = new PagedPointer(this.ptrDataBuffer.primaryBuffer(), length).asLongPointer();
            this.setIndexer((Indexer)LongIndexer.create((LongPointer)((LongPointer)this.pointer)));
        }
        Nd4j.getDeallocatorService().pickObject((Deallocatable)this);
    }

    public BaseCpuDataBuffer(int length, int elementSize, long offset) {
        this((long)length, elementSize);
        this.offset = offset;
        this.originalOffset = offset;
        this.length = (long)length - offset;
        this.underlyingLength = length;
    }

    protected BaseCpuDataBuffer(DataBuffer underlyingBuffer, long length, long offset) {
        super(underlyingBuffer, length, offset);
        this.ptrDataBuffer = ((BaseCpuDataBuffer)underlyingBuffer).ptrDataBuffer.createView(length * (long)underlyingBuffer.getElementSize(), offset * (long)underlyingBuffer.getElementSize());
        Nd4j.getDeallocatorService().pickObject((Deallocatable)this);
        this.actualizePointerAndIndexer();
    }

    protected BaseCpuDataBuffer(ByteBuffer buffer, DataType dtype, long length, long offset) {
        this(length, Nd4j.sizeOfDataType((DataType)dtype));
        BytePointer temp = null;
        switch (this.dataType()) {
            case DOUBLE: {
                temp = new DoublePointer(buffer.asDoubleBuffer());
                break;
            }
            case FLOAT: {
                temp = new FloatPointer(buffer.asFloatBuffer());
                break;
            }
            case HALF: {
                temp = new ShortPointer(buffer.asShortBuffer());
                break;
            }
            case LONG: {
                temp = new LongPointer(buffer.asLongBuffer());
                break;
            }
            case INT: {
                temp = new IntPointer(buffer.asIntBuffer());
                break;
            }
            case SHORT: {
                temp = new ShortPointer(buffer.asShortBuffer());
                break;
            }
            case UBYTE: 
            case BYTE: {
                temp = new BytePointer(buffer);
                break;
            }
            case BOOL: {
                temp = new BooleanPointer(this.length());
                break;
            }
            case UTF8: {
                temp = new BytePointer(this.length());
                break;
            }
            case BFLOAT16: {
                temp = new ShortPointer(this.length());
                break;
            }
            case UINT16: {
                temp = new ShortPointer(this.length());
                break;
            }
            case UINT32: {
                temp = new IntPointer(this.length());
                break;
            }
            case UINT64: {
                temp = new LongPointer(this.length());
            }
        }
        Pointer ptr = this.ptrDataBuffer.primaryBuffer();
        if (offset > 0L) {
            temp = new PagedPointer(temp.address() + offset * (long)this.getElementSize());
        }
        Pointer.memcpy((Pointer)ptr, (Pointer)temp, (long)(length * (long)Nd4j.sizeOfDataType((DataType)dtype)));
    }

    protected double getDoubleUnsynced(long index) {
        return super.getDouble(index);
    }

    protected float getFloatUnsynced(long index) {
        return super.getFloat(index);
    }

    protected long getLongUnsynced(long index) {
        return super.getLong(index);
    }

    protected int getIntUnsynced(long index) {
        return super.getInt(index);
    }

    public void pointerIndexerByCurrentType(DataType currentType) {
        this.type = currentType;
        if (this.ptrDataBuffer == null) {
            this.ptrDataBuffer = OpaqueDataBuffer.allocateDataBuffer((long)this.length(), (DataType)this.type, (boolean)false);
            Nd4j.getDeallocatorService().pickObject((Deallocatable)this);
        }
        this.actualizePointerAndIndexer();
    }

    protected BaseCpuDataBuffer(long length) {
        this(length, true);
    }

    protected BaseCpuDataBuffer(long length, boolean initialize) {
        if (length < 0L) {
            throw new IllegalArgumentException("Length must be >= 0");
        }
        this.initTypeAndSize();
        this.length = length;
        this.underlyingLength = length;
        this.allocationMode = AllocUtil.getAllocationModeFromContext();
        if (length < 0L) {
            throw new IllegalArgumentException("Unable to create a buffer of length <= 0");
        }
        if (this.dataType() != DataType.UTF8) {
            this.ptrDataBuffer = OpaqueDataBuffer.allocateDataBuffer((long)length, (DataType)this.dataType(), (boolean)false);
        }
        if (this.dataType() == DataType.DOUBLE) {
            this.pointer = new PagedPointer(this.ptrDataBuffer.primaryBuffer(), length).asDoublePointer();
            this.indexer = DoubleIndexer.create((DoublePointer)((DoublePointer)this.pointer));
            if (initialize) {
                this.fillPointerWithZero();
            }
        } else if (this.dataType() == DataType.FLOAT) {
            this.pointer = new PagedPointer(this.ptrDataBuffer.primaryBuffer(), length).asFloatPointer();
            this.setIndexer((Indexer)FloatIndexer.create((FloatPointer)((FloatPointer)this.pointer)));
            if (initialize) {
                this.fillPointerWithZero();
            }
        } else if (this.dataType() == DataType.HALF) {
            this.pointer = new PagedPointer(this.ptrDataBuffer.primaryBuffer(), length).asShortPointer();
            this.setIndexer((Indexer)HalfIndexer.create((ShortPointer)((ShortPointer)this.pointer)));
            if (initialize) {
                this.fillPointerWithZero();
            }
        } else if (this.dataType() == DataType.BFLOAT16) {
            this.pointer = new PagedPointer(this.ptrDataBuffer.primaryBuffer(), length).asShortPointer();
            this.setIndexer((Indexer)Bfloat16Indexer.create((ShortPointer)((ShortPointer)this.pointer)));
            if (initialize) {
                this.fillPointerWithZero();
            }
        } else if (this.dataType() == DataType.INT) {
            this.pointer = new PagedPointer(this.ptrDataBuffer.primaryBuffer(), length).asIntPointer();
            this.setIndexer((Indexer)IntIndexer.create((IntPointer)((IntPointer)this.pointer)));
            if (initialize) {
                this.fillPointerWithZero();
            }
        } else if (this.dataType() == DataType.LONG) {
            this.pointer = new PagedPointer(this.ptrDataBuffer.primaryBuffer(), length).asLongPointer();
            this.setIndexer((Indexer)LongIndexer.create((LongPointer)((LongPointer)this.pointer)));
            if (initialize) {
                this.fillPointerWithZero();
            }
        } else if (this.dataType() == DataType.BYTE) {
            this.pointer = new PagedPointer(this.ptrDataBuffer.primaryBuffer(), length).asBytePointer();
            this.setIndexer((Indexer)ByteIndexer.create((BytePointer)((BytePointer)this.pointer)));
            if (initialize) {
                this.fillPointerWithZero();
            }
        } else if (this.dataType() == DataType.SHORT) {
            this.pointer = new PagedPointer(this.ptrDataBuffer.primaryBuffer(), length).asShortPointer();
            this.setIndexer((Indexer)ShortIndexer.create((ShortPointer)((ShortPointer)this.pointer)));
            if (initialize) {
                this.fillPointerWithZero();
            }
        } else if (this.dataType() == DataType.UBYTE) {
            this.pointer = new PagedPointer(this.ptrDataBuffer.primaryBuffer(), length).asBytePointer();
            this.setIndexer((Indexer)UByteIndexer.create((BytePointer)((BytePointer)this.pointer)));
            if (initialize) {
                this.fillPointerWithZero();
            }
        } else if (this.dataType() == DataType.UINT16) {
            this.pointer = new PagedPointer(this.ptrDataBuffer.primaryBuffer(), length).asShortPointer();
            this.setIndexer((Indexer)UShortIndexer.create((ShortPointer)((ShortPointer)this.pointer)));
            if (initialize) {
                this.fillPointerWithZero();
            }
        } else if (this.dataType() == DataType.UINT32) {
            this.pointer = new PagedPointer(this.ptrDataBuffer.primaryBuffer(), length).asIntPointer();
            this.setIndexer((Indexer)UIntIndexer.create((IntPointer)((IntPointer)this.pointer)));
            if (initialize) {
                this.fillPointerWithZero();
            }
        } else if (this.dataType() == DataType.UINT64) {
            this.pointer = new PagedPointer(this.ptrDataBuffer.primaryBuffer(), length).asLongPointer();
            this.setIndexer((Indexer)LongIndexer.create((LongPointer)((LongPointer)this.pointer)));
            if (initialize) {
                this.fillPointerWithZero();
            }
        } else if (this.dataType() == DataType.BOOL) {
            this.pointer = new PagedPointer(this.ptrDataBuffer.primaryBuffer(), length).asBoolPointer();
            this.setIndexer((Indexer)BooleanIndexer.create((BooleanPointer)((BooleanPointer)this.pointer)));
            if (initialize) {
                this.fillPointerWithZero();
            }
        } else if (this.dataType() == DataType.UTF8) {
            this.ptrDataBuffer = OpaqueDataBuffer.allocateDataBuffer((long)this.length(), (DataType)DataType.INT8, (boolean)false);
            this.pointer = new PagedPointer(this.ptrDataBuffer.primaryBuffer(), this.length()).asBytePointer();
            this.setIndexer((Indexer)ByteIndexer.create((BytePointer)((BytePointer)this.pointer)));
            if (initialize) {
                this.fillPointerWithZero();
            }
        }
        Nd4j.getDeallocatorService().pickObject((Deallocatable)this);
    }

    public void actualizePointerAndIndexer() {
        Pointer cptr = this.ptrDataBuffer.primaryBuffer();
        if (cptr != null && this.pointer != null && cptr.address() == this.pointer.address()) {
            return;
        }
        DataType t = this.dataType();
        if (t == DataType.BOOL) {
            this.pointer = new PagedPointer(cptr, this.length).asBoolPointer();
            this.setIndexer((Indexer)BooleanIndexer.create((BooleanPointer)((BooleanPointer)this.pointer)));
        } else if (t == DataType.UBYTE) {
            this.pointer = new PagedPointer(cptr, this.length).asBytePointer();
            this.setIndexer((Indexer)UByteIndexer.create((BytePointer)((BytePointer)this.pointer)));
        } else if (t == DataType.BYTE) {
            this.pointer = new PagedPointer(cptr, this.length).asBytePointer();
            this.setIndexer((Indexer)ByteIndexer.create((BytePointer)((BytePointer)this.pointer)));
        } else if (t == DataType.UINT16) {
            this.pointer = new PagedPointer(cptr, this.length).asShortPointer();
            this.setIndexer((Indexer)UShortIndexer.create((ShortPointer)((ShortPointer)this.pointer)));
        } else if (t == DataType.SHORT) {
            this.pointer = new PagedPointer(cptr, this.length).asShortPointer();
            this.setIndexer((Indexer)ShortIndexer.create((ShortPointer)((ShortPointer)this.pointer)));
        } else if (t == DataType.UINT32) {
            this.pointer = new PagedPointer(cptr, this.length).asIntPointer();
            this.setIndexer((Indexer)UIntIndexer.create((IntPointer)((IntPointer)this.pointer)));
        } else if (t == DataType.INT) {
            this.pointer = new PagedPointer(cptr, this.length).asIntPointer();
            this.setIndexer((Indexer)IntIndexer.create((IntPointer)((IntPointer)this.pointer)));
        } else if (t == DataType.UINT64) {
            this.pointer = new PagedPointer(cptr, this.length).asLongPointer();
            this.setIndexer((Indexer)LongIndexer.create((LongPointer)((LongPointer)this.pointer)));
        } else if (t == DataType.LONG) {
            this.pointer = new PagedPointer(cptr, this.length).asLongPointer();
            this.setIndexer((Indexer)LongIndexer.create((LongPointer)((LongPointer)this.pointer)));
        } else if (t == DataType.BFLOAT16) {
            this.pointer = new PagedPointer(cptr, this.length).asShortPointer();
            this.setIndexer((Indexer)Bfloat16Indexer.create((ShortPointer)((ShortPointer)this.pointer)));
        } else if (t == DataType.HALF) {
            this.pointer = new PagedPointer(cptr, this.length).asShortPointer();
            this.setIndexer((Indexer)HalfIndexer.create((ShortPointer)((ShortPointer)this.pointer)));
        } else if (t == DataType.FLOAT) {
            this.pointer = new PagedPointer(cptr, this.length).asFloatPointer();
            this.setIndexer((Indexer)FloatIndexer.create((FloatPointer)((FloatPointer)this.pointer)));
        } else if (t == DataType.DOUBLE) {
            this.pointer = new PagedPointer(cptr, this.length).asDoublePointer();
            this.setIndexer((Indexer)DoubleIndexer.create((DoublePointer)((DoublePointer)this.pointer)));
        } else if (t == DataType.UTF8) {
            this.pointer = new PagedPointer(cptr, this.length()).asBytePointer();
            this.setIndexer((Indexer)ByteIndexer.create((BytePointer)((BytePointer)this.pointer)));
        } else {
            throw new IllegalArgumentException("Unknown datatype: " + this.dataType());
        }
    }

    public Pointer addressPointer() {
        PagedPointer tempPtr = new PagedPointer(this.ptrDataBuffer.primaryBuffer());
        switch (this.type) {
            case DOUBLE: {
                return tempPtr.asDoublePointer();
            }
            case FLOAT: {
                return tempPtr.asFloatPointer();
            }
            case HALF: 
            case SHORT: 
            case BFLOAT16: 
            case UINT16: {
                return tempPtr.asShortPointer();
            }
            case INT: 
            case UINT32: {
                return tempPtr.asIntPointer();
            }
            case UBYTE: 
            case BYTE: {
                return tempPtr.asBytePointer();
            }
            case LONG: 
            case UINT64: {
                return tempPtr.asLongPointer();
            }
            case BOOL: {
                return tempPtr.asBoolPointer();
            }
        }
        return tempPtr.asBytePointer();
    }

    protected BaseCpuDataBuffer(long length, boolean initialize, MemoryWorkspace workspace) {
        if (length < 1L) {
            throw new IllegalArgumentException("Length must be >= 1");
        }
        this.initTypeAndSize();
        this.length = length;
        this.underlyingLength = length;
        this.allocationMode = AllocUtil.getAllocationModeFromContext();
        if (length < 0L) {
            throw new IllegalArgumentException("Unable to create a buffer of length <= 0");
        }
        if (this.dataType() == DataType.DOUBLE) {
            this.attached = true;
            this.parentWorkspace = workspace;
            this.pointer = workspace.alloc(length * (long)this.getElementSize(), this.dataType(), initialize).asDoublePointer();
            this.indexer = DoubleIndexer.create((DoublePointer)((DoublePointer)this.pointer));
        } else if (this.dataType() == DataType.FLOAT) {
            this.attached = true;
            this.parentWorkspace = workspace;
            this.pointer = workspace.alloc(length * (long)this.getElementSize(), this.dataType(), initialize).asFloatPointer();
            this.setIndexer((Indexer)FloatIndexer.create((FloatPointer)((FloatPointer)this.pointer)));
        } else if (this.dataType() == DataType.HALF) {
            this.attached = true;
            this.parentWorkspace = workspace;
            this.pointer = workspace.alloc(length * (long)this.getElementSize(), this.dataType(), initialize).asShortPointer();
            this.setIndexer((Indexer)HalfIndexer.create((ShortPointer)((ShortPointer)this.pointer)));
        } else if (this.dataType() == DataType.BFLOAT16) {
            this.attached = true;
            this.parentWorkspace = workspace;
            this.pointer = workspace.alloc(length * (long)this.getElementSize(), this.dataType(), initialize).asShortPointer();
            this.setIndexer((Indexer)Bfloat16Indexer.create((ShortPointer)((ShortPointer)this.pointer)));
        } else if (this.dataType() == DataType.INT) {
            this.attached = true;
            this.parentWorkspace = workspace;
            this.pointer = workspace.alloc(length * (long)this.getElementSize(), this.dataType(), initialize).asIntPointer();
            this.setIndexer((Indexer)IntIndexer.create((IntPointer)((IntPointer)this.pointer)));
        } else if (this.dataType() == DataType.UINT32) {
            this.attached = true;
            this.parentWorkspace = workspace;
            this.pointer = workspace.alloc(length * (long)this.getElementSize(), this.dataType(), initialize).asIntPointer();
            this.setIndexer((Indexer)UIntIndexer.create((IntPointer)((IntPointer)this.pointer)));
        } else if (this.dataType() == DataType.UINT64) {
            this.attached = true;
            this.parentWorkspace = workspace;
            this.pointer = workspace.alloc(length * (long)this.getElementSize(), this.dataType(), initialize).asLongPointer();
            this.setIndexer((Indexer)LongIndexer.create((LongPointer)((LongPointer)this.pointer)));
        } else if (this.dataType() == DataType.LONG) {
            this.attached = true;
            this.parentWorkspace = workspace;
            this.pointer = workspace.alloc(length * (long)this.getElementSize(), this.dataType(), initialize).asLongPointer();
            this.setIndexer((Indexer)LongIndexer.create((LongPointer)((LongPointer)this.pointer)));
        } else if (this.dataType() == DataType.BYTE) {
            this.attached = true;
            this.parentWorkspace = workspace;
            this.pointer = workspace.alloc(length * (long)this.getElementSize(), this.dataType(), initialize).asBytePointer();
            this.setIndexer((Indexer)ByteIndexer.create((BytePointer)((BytePointer)this.pointer)));
        } else if (this.dataType() == DataType.UBYTE) {
            this.attached = true;
            this.parentWorkspace = workspace;
            this.pointer = workspace.alloc(length * (long)this.getElementSize(), this.dataType(), initialize).asBytePointer();
            this.setIndexer((Indexer)UByteIndexer.create((BytePointer)((BytePointer)this.pointer)));
        } else if (this.dataType() == DataType.UINT16) {
            this.attached = true;
            this.parentWorkspace = workspace;
            this.pointer = workspace.alloc(length * (long)this.getElementSize(), this.dataType(), initialize).asShortPointer();
            this.setIndexer((Indexer)UShortIndexer.create((ShortPointer)((ShortPointer)this.pointer)));
        } else if (this.dataType() == DataType.SHORT) {
            this.attached = true;
            this.parentWorkspace = workspace;
            this.pointer = workspace.alloc(length * (long)this.getElementSize(), this.dataType(), initialize).asShortPointer();
            this.setIndexer((Indexer)ShortIndexer.create((ShortPointer)((ShortPointer)this.pointer)));
        } else if (this.dataType() == DataType.BOOL) {
            this.attached = true;
            this.parentWorkspace = workspace;
            this.pointer = workspace.alloc(length * (long)this.getElementSize(), this.dataType(), initialize).asBoolPointer();
            this.setIndexer((Indexer)BooleanIndexer.create((BooleanPointer)((BooleanPointer)this.pointer)));
        } else if (this.dataType() == DataType.UTF8) {
            this.attached = true;
            this.parentWorkspace = workspace;
            this.pointer = workspace.alloc(length * (long)this.getElementSize(), this.dataType(), initialize).asLongPointer();
            this.setIndexer((Indexer)LongIndexer.create((LongPointer)((LongPointer)this.pointer)));
        }
        this.ptrDataBuffer = OpaqueDataBuffer.externalizedDataBuffer((long)length, (DataType)this.dataType(), (Pointer)this.pointer, null);
        Nd4j.getDeallocatorService().pickObject((Deallocatable)this);
        this.workspaceGenerationId = workspace.getGenerationId();
    }

    public BaseCpuDataBuffer(Pointer pointer, Indexer indexer, long length) {
        super(pointer, indexer, length);
        this.ptrDataBuffer = OpaqueDataBuffer.externalizedDataBuffer((long)length, (DataType)this.dataType(), (Pointer)this.pointer, null);
        Nd4j.getDeallocatorService().pickObject((Deallocatable)this);
    }

    public BaseCpuDataBuffer(float[] data, boolean copy, long offset) {
        this(data, copy);
        this.offset = offset;
        this.originalOffset = offset;
        this.length = (long)data.length - offset;
        this.underlyingLength = data.length;
    }

    public BaseCpuDataBuffer(float[] data, boolean copy, long offset, MemoryWorkspace workspace) {
        this(data, copy, workspace);
        this.offset = offset;
        this.originalOffset = offset;
        this.length = (long)data.length - offset;
        this.underlyingLength = data.length;
    }

    public BaseCpuDataBuffer(float[] data, boolean copy) {
        this.allocationMode = AllocUtil.getAllocationModeFromContext();
        this.initTypeAndSize();
        this.pointer = new FloatPointer(data);
        this.ptrDataBuffer = OpaqueDataBuffer.allocateDataBuffer((long)data.length, (DataType)DataType.FLOAT, (boolean)false);
        this.ptrDataBuffer.setPrimaryBuffer(this.pointer, (long)data.length);
        Nd4j.getDeallocatorService().pickObject((Deallocatable)this);
        this.setIndexer((Indexer)FloatIndexer.create((FloatPointer)((FloatPointer)this.pointer)));
        this.length = data.length;
        this.underlyingLength = data.length;
    }

    public BaseCpuDataBuffer(float[] data, boolean copy, MemoryWorkspace workspace) {
        this.allocationMode = AllocUtil.getAllocationModeFromContext();
        this.length = data.length;
        this.underlyingLength = data.length;
        this.attached = true;
        this.parentWorkspace = workspace;
        this.initTypeAndSize();
        this.pointer = workspace.alloc((long)(data.length * this.getElementSize()), this.dataType(), false).asFloatPointer().put(data);
        this.ptrDataBuffer = OpaqueDataBuffer.externalizedDataBuffer((long)this.length, (DataType)this.dataType(), (Pointer)this.pointer, null);
        Nd4j.getDeallocatorService().pickObject((Deallocatable)this);
        this.workspaceGenerationId = workspace.getGenerationId();
        this.setIndexer((Indexer)FloatIndexer.create((FloatPointer)((FloatPointer)this.pointer)));
    }

    public BaseCpuDataBuffer(double[] data, boolean copy, MemoryWorkspace workspace) {
        this.allocationMode = AllocUtil.getAllocationModeFromContext();
        this.length = data.length;
        this.underlyingLength = data.length;
        this.attached = true;
        this.parentWorkspace = workspace;
        this.initTypeAndSize();
        this.pointer = workspace.alloc((long)(data.length * this.getElementSize()), this.dataType(), false).asDoublePointer().put(data);
        this.ptrDataBuffer = OpaqueDataBuffer.externalizedDataBuffer((long)this.length, (DataType)this.dataType(), (Pointer)this.pointer, null);
        Nd4j.getDeallocatorService().pickObject((Deallocatable)this);
        this.workspaceGenerationId = workspace.getGenerationId();
        this.indexer = DoubleIndexer.create((DoublePointer)((DoublePointer)this.pointer));
    }

    public BaseCpuDataBuffer(int[] data, boolean copy, MemoryWorkspace workspace) {
        this.allocationMode = AllocUtil.getAllocationModeFromContext();
        this.length = data.length;
        this.underlyingLength = data.length;
        this.attached = true;
        this.parentWorkspace = workspace;
        this.initTypeAndSize();
        this.pointer = workspace.alloc((long)(data.length * this.getElementSize()), this.dataType(), false).asIntPointer().put(data);
        this.ptrDataBuffer = OpaqueDataBuffer.externalizedDataBuffer((long)this.length, (DataType)this.dataType(), (Pointer)this.pointer, null);
        Nd4j.getDeallocatorService().pickObject((Deallocatable)this);
        this.workspaceGenerationId = workspace.getGenerationId();
        this.indexer = IntIndexer.create((IntPointer)((IntPointer)this.pointer));
    }

    public BaseCpuDataBuffer(long[] data, boolean copy, MemoryWorkspace workspace) {
        this.allocationMode = AllocUtil.getAllocationModeFromContext();
        this.length = data.length;
        this.underlyingLength = data.length;
        this.attached = true;
        this.parentWorkspace = workspace;
        this.initTypeAndSize();
        this.pointer = workspace.alloc((long)(data.length * this.getElementSize()), this.dataType(), false).asLongPointer().put(data);
        this.ptrDataBuffer = OpaqueDataBuffer.externalizedDataBuffer((long)this.length, (DataType)this.dataType(), (Pointer)this.pointer, null);
        Nd4j.getDeallocatorService().pickObject((Deallocatable)this);
        this.workspaceGenerationId = workspace.getGenerationId();
        this.indexer = LongIndexer.create((LongPointer)((LongPointer)this.pointer));
    }

    public BaseCpuDataBuffer(double[] data, boolean copy, long offset) {
        this(data, copy);
        this.offset = offset;
        this.originalOffset = offset;
        this.underlyingLength = data.length;
        this.length = this.underlyingLength - offset;
    }

    public BaseCpuDataBuffer(double[] data, boolean copy, long offset, MemoryWorkspace workspace) {
        this(data, copy, workspace);
        this.offset = offset;
        this.originalOffset = offset;
        this.underlyingLength = data.length;
        this.length = this.underlyingLength - offset;
    }

    public BaseCpuDataBuffer(double[] data, boolean copy) {
        this.allocationMode = AllocUtil.getAllocationModeFromContext();
        this.initTypeAndSize();
        this.pointer = new DoublePointer(data);
        this.indexer = DoubleIndexer.create((DoublePointer)((DoublePointer)this.pointer));
        this.ptrDataBuffer = OpaqueDataBuffer.allocateDataBuffer((long)data.length, (DataType)DataType.DOUBLE, (boolean)false);
        this.ptrDataBuffer.setPrimaryBuffer(this.pointer, (long)data.length);
        Nd4j.getDeallocatorService().pickObject((Deallocatable)this);
        this.length = data.length;
        this.underlyingLength = data.length;
    }

    public BaseCpuDataBuffer(int[] data, boolean copy, long offset) {
        this(data, copy);
        this.offset = offset;
        this.originalOffset = offset;
        this.length = (long)data.length - offset;
        this.underlyingLength = data.length;
    }

    public BaseCpuDataBuffer(int[] data, boolean copy) {
        this.allocationMode = AllocUtil.getAllocationModeFromContext();
        this.initTypeAndSize();
        this.pointer = new IntPointer(data);
        this.setIndexer((Indexer)IntIndexer.create((IntPointer)((IntPointer)this.pointer)));
        this.ptrDataBuffer = OpaqueDataBuffer.allocateDataBuffer((long)data.length, (DataType)DataType.INT32, (boolean)false);
        this.ptrDataBuffer.setPrimaryBuffer(this.pointer, (long)data.length);
        Nd4j.getDeallocatorService().pickObject((Deallocatable)this);
        this.length = data.length;
        this.underlyingLength = data.length;
    }

    public BaseCpuDataBuffer(long[] data, boolean copy) {
        this.allocationMode = AllocUtil.getAllocationModeFromContext();
        this.initTypeAndSize();
        this.pointer = new LongPointer(data);
        this.setIndexer((Indexer)LongIndexer.create((LongPointer)((LongPointer)this.pointer)));
        this.ptrDataBuffer = OpaqueDataBuffer.allocateDataBuffer((long)data.length, (DataType)DataType.INT64, (boolean)false);
        this.ptrDataBuffer.setPrimaryBuffer(this.pointer, (long)data.length);
        Nd4j.getDeallocatorService().pickObject((Deallocatable)this);
        this.length = data.length;
        this.underlyingLength = data.length;
    }

    public BaseCpuDataBuffer(double[] data) {
        this(data, true);
    }

    public BaseCpuDataBuffer(int[] data) {
        this(data, true);
    }

    public BaseCpuDataBuffer(float[] data) {
        this(data, true);
    }

    public BaseCpuDataBuffer(float[] data, MemoryWorkspace workspace) {
        this(data, true, workspace);
    }

    protected void release() {
        this.ptrDataBuffer.closeBuffer();
        super.release();
    }

    public DataBuffer reallocate(long length) {
        Pointer oldPointer = this.ptrDataBuffer.primaryBuffer();
        if (this.isAttached()) {
            long capacity = length * (long)this.getElementSize();
            PagedPointer nPtr = this.getParentWorkspace().alloc(capacity, this.dataType(), false);
            this.ptrDataBuffer.setPrimaryBuffer((Pointer)nPtr, length);
            switch (this.dataType()) {
                case BOOL: {
                    this.pointer = nPtr.asBoolPointer();
                    this.indexer = BooleanIndexer.create((BooleanPointer)((BooleanPointer)this.pointer));
                    break;
                }
                case UBYTE: 
                case BYTE: 
                case UTF8: {
                    this.pointer = nPtr.asBytePointer();
                    this.indexer = ByteIndexer.create((BytePointer)((BytePointer)this.pointer));
                    break;
                }
                case SHORT: 
                case UINT16: {
                    this.pointer = nPtr.asShortPointer();
                    this.indexer = ShortIndexer.create((ShortPointer)((ShortPointer)this.pointer));
                    break;
                }
                case UINT32: {
                    this.pointer = nPtr.asIntPointer();
                    this.indexer = UIntIndexer.create((IntPointer)((IntPointer)this.pointer));
                    break;
                }
                case INT: {
                    this.pointer = nPtr.asIntPointer();
                    this.indexer = IntIndexer.create((IntPointer)((IntPointer)this.pointer));
                    break;
                }
                case DOUBLE: {
                    this.pointer = nPtr.asDoublePointer();
                    this.indexer = DoubleIndexer.create((DoublePointer)((DoublePointer)this.pointer));
                    break;
                }
                case FLOAT: {
                    this.pointer = nPtr.asFloatPointer();
                    this.indexer = FloatIndexer.create((FloatPointer)((FloatPointer)this.pointer));
                    break;
                }
                case HALF: {
                    this.pointer = nPtr.asShortPointer();
                    this.indexer = HalfIndexer.create((ShortPointer)((ShortPointer)this.pointer));
                    break;
                }
                case BFLOAT16: {
                    this.pointer = nPtr.asShortPointer();
                    this.indexer = Bfloat16Indexer.create((ShortPointer)((ShortPointer)this.pointer));
                    break;
                }
                case LONG: 
                case UINT64: {
                    this.pointer = nPtr.asLongPointer();
                    this.indexer = LongIndexer.create((LongPointer)((LongPointer)this.pointer));
                }
            }
            Pointer.memcpy((Pointer)this.pointer, (Pointer)oldPointer, (long)(this.length() * (long)this.getElementSize()));
            this.workspaceGenerationId = this.getParentWorkspace().getGenerationId();
        } else {
            this.ptrDataBuffer.expand(length);
            PagedPointer nPtr = new PagedPointer(this.ptrDataBuffer.primaryBuffer(), length);
            switch (this.dataType()) {
                case BOOL: {
                    this.pointer = nPtr.asBoolPointer();
                    this.indexer = BooleanIndexer.create((BooleanPointer)((BooleanPointer)this.pointer));
                    break;
                }
                case UBYTE: 
                case BYTE: 
                case UTF8: {
                    this.pointer = nPtr.asBytePointer();
                    this.indexer = ByteIndexer.create((BytePointer)((BytePointer)this.pointer));
                    break;
                }
                case SHORT: 
                case UINT16: {
                    this.pointer = nPtr.asShortPointer();
                    this.indexer = ShortIndexer.create((ShortPointer)((ShortPointer)this.pointer));
                    break;
                }
                case UINT32: {
                    this.pointer = nPtr.asIntPointer();
                    this.indexer = UIntIndexer.create((IntPointer)((IntPointer)this.pointer));
                    break;
                }
                case INT: {
                    this.pointer = nPtr.asIntPointer();
                    this.indexer = IntIndexer.create((IntPointer)((IntPointer)this.pointer));
                    break;
                }
                case DOUBLE: {
                    this.pointer = nPtr.asDoublePointer();
                    this.indexer = DoubleIndexer.create((DoublePointer)((DoublePointer)this.pointer));
                    break;
                }
                case FLOAT: {
                    this.pointer = nPtr.asFloatPointer();
                    this.indexer = FloatIndexer.create((FloatPointer)((FloatPointer)this.pointer));
                    break;
                }
                case HALF: {
                    this.pointer = nPtr.asShortPointer();
                    this.indexer = HalfIndexer.create((ShortPointer)((ShortPointer)this.pointer));
                    break;
                }
                case BFLOAT16: {
                    this.pointer = nPtr.asShortPointer();
                    this.indexer = Bfloat16Indexer.create((ShortPointer)((ShortPointer)this.pointer));
                    break;
                }
                case LONG: 
                case UINT64: {
                    this.pointer = nPtr.asLongPointer();
                    this.indexer = LongIndexer.create((LongPointer)((LongPointer)this.pointer));
                }
            }
        }
        this.underlyingLength = length;
        this.length = length;
        return this;
    }

    public void syncToPrimary() {
        this.ptrDataBuffer.syncToPrimary();
    }

    public void syncToSpecial() {
        this.ptrDataBuffer.syncToSpecial();
    }
}

