/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.ArrayList;
import java.util.List;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Asterisk;
import org.neo4j.cypherdsl.core.BooleanLiteral;
import org.neo4j.cypherdsl.core.BuiltInFunctions;
import org.neo4j.cypherdsl.core.Case;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.FunctionInvocation;
import org.neo4j.cypherdsl.core.ListComprehension;
import org.neo4j.cypherdsl.core.ListExpression;
import org.neo4j.cypherdsl.core.ListLiteral;
import org.neo4j.cypherdsl.core.ListOperator;
import org.neo4j.cypherdsl.core.Literal;
import org.neo4j.cypherdsl.core.MapExpression;
import org.neo4j.cypherdsl.core.Named;
import org.neo4j.cypherdsl.core.NamedPath;
import org.neo4j.cypherdsl.core.Node;
import org.neo4j.cypherdsl.core.NullLiteral;
import org.neo4j.cypherdsl.core.NumberLiteral;
import org.neo4j.cypherdsl.core.Parameter;
import org.neo4j.cypherdsl.core.PatternComprehension;
import org.neo4j.cypherdsl.core.PatternElement;
import org.neo4j.cypherdsl.core.ProcedureCall;
import org.neo4j.cypherdsl.core.Property;
import org.neo4j.cypherdsl.core.RelationshipPattern;
import org.neo4j.cypherdsl.core.SortItem;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.cypherdsl.core.StatementBuilder;
import org.neo4j.cypherdsl.core.StringLiteral;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.neo4j.cypherdsl.core.UnionQuery;
import org.neo4j.cypherdsl.core.support.Neo4jVersion;
import org.neo4j.cypherdsl.core.utils.Assertions;

@API(status=API.Status.EXPERIMENTAL, since="1.0")
public final class Cypher {
    public static Node node(String primaryLabel, String ... additionalLabels) {
        return Node.create(primaryLabel, additionalLabels);
    }

    public static Node node(String primaryLabel, List<String> additionalLabels) {
        return Node.create(primaryLabel, additionalLabels.toArray(new String[0]));
    }

    public static Node node(String primaryLabel, MapExpression properties, String ... additionalLabels) {
        return Node.create(primaryLabel, properties, additionalLabels);
    }

    public static Node anyNode() {
        return Node.create();
    }

    public static Asterisk asterisk() {
        return Asterisk.INSTANCE;
    }

    public static Node anyNode(String symbolicName) {
        return Node.create().named(symbolicName);
    }

    public static Node anyNode(SymbolicName symbolicName) {
        return Node.create().named(symbolicName);
    }

    public static Property property(String containerName, String ... names) {
        return Cypher.property((Expression)Cypher.name(containerName), names);
    }

    public static Property property(Expression expression, String ... names) {
        return Property.create(expression, names);
    }

    public static Property property(String containerName, Expression lookup) {
        return Cypher.property((Expression)Cypher.name(containerName), lookup);
    }

    public static Property property(Expression expression, Expression lookup) {
        return Property.create(expression, lookup);
    }

    public static NamedPath.OngoingDefinitionWithName path(String name) {
        return NamedPath.named(name);
    }

    public static NamedPath.OngoingDefinitionWithName path(SymbolicName name) {
        return NamedPath.named(name);
    }

    public static NamedPath.OngoingShortestPathDefinitionWithName shortestPath(String name) {
        return NamedPath.named(name, (FunctionInvocation.FunctionDefinition)BuiltInFunctions.Scalars.SHORTEST_PATH);
    }

    public static NamedPath.OngoingShortestPathDefinitionWithName shortestPath(SymbolicName name) {
        return NamedPath.named(name, (FunctionInvocation.FunctionDefinition)BuiltInFunctions.Scalars.SHORTEST_PATH);
    }

    public static SymbolicName name(String value) {
        return SymbolicName.of(value);
    }

    public static Parameter<Object> parameter(String name) {
        return Parameter.create(name);
    }

    public static <T> Parameter<T> parameter(String name, T value) {
        return Parameter.create(name, value);
    }

    public static StatementBuilder.OngoingReadingWithoutWhere optionalMatch(PatternElement ... pattern) {
        return Statement.builder().optionalMatch(pattern);
    }

    public static StatementBuilder.OngoingReadingWithoutWhere match(PatternElement ... pattern) {
        return Statement.builder().match(pattern);
    }

    public static StatementBuilder.OngoingReadingWithoutWhere match(boolean optional, PatternElement ... pattern) {
        return Statement.builder().match(optional, pattern);
    }

    public static StatementBuilder.OngoingUpdate create(PatternElement ... pattern) {
        return Statement.builder().create(pattern);
    }

    public static StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere with(String ... variables) {
        return Statement.builder().with(variables);
    }

    public static StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere with(Named ... variables) {
        return Statement.builder().with(variables);
    }

    public static StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere with(Expression ... expressions) {
        return Statement.builder().with(expressions);
    }

    public static StatementBuilder.OngoingMerge merge(PatternElement ... pattern) {
        return Statement.builder().merge(pattern);
    }

    public static StatementBuilder.OngoingUnwind unwind(Expression expression) {
        return Statement.builder().unwind(expression);
    }

    public static StatementBuilder.OngoingUnwind unwind(Expression ... expressions) {
        return Statement.builder().unwind((Expression)Cypher.listOf(expressions));
    }

    public static SortItem sort(Expression expression) {
        return SortItem.create(expression, null);
    }

    public static MapExpression mapOf(Object ... keysAndValues) {
        return MapExpression.create(keysAndValues);
    }

    public static ListExpression listOf(Expression ... expressions) {
        return ListExpression.create(expressions);
    }

    public static <T> Literal<T> literalOf(Object object) {
        if (object == null) {
            return NullLiteral.INSTANCE;
        }
        if (object instanceof CharSequence) {
            return new StringLiteral((CharSequence)object);
        }
        if (object instanceof Number) {
            return new NumberLiteral((Number)object);
        }
        if (object instanceof Iterable) {
            for (Object element : (Iterable)object) {
                if (element instanceof Literal) continue;
                throw new IllegalArgumentException("Unsupported literal type in iterable: " + element.getClass());
            }
            ListLiteral listLiteral = new ListLiteral((Iterable)object);
            return listLiteral;
        }
        if (object instanceof Boolean) {
            return BooleanLiteral.of((Boolean)object);
        }
        throw new IllegalArgumentException("Unsupported literal type: " + object.getClass());
    }

    public static Literal<Boolean> literalTrue() {
        return BooleanLiteral.TRUE;
    }

    public static Literal<Boolean> literalFalse() {
        return BooleanLiteral.FALSE;
    }

    public static Statement union(Statement ... statements) {
        return Cypher.unionImpl(false, statements);
    }

    public static Statement unionAll(Statement ... statements) {
        return Cypher.unionImpl(true, statements);
    }

    public static StatementBuilder.OngoingReadingAndReturn returning(Expression ... expressions) {
        return Statement.builder().returning(expressions);
    }

    public static PatternComprehension.OngoingDefinitionWithPattern listBasedOn(RelationshipPattern relationshipPattern) {
        return PatternComprehension.basedOn(relationshipPattern);
    }

    public static PatternComprehension.OngoingDefinitionWithPattern listBasedOn(NamedPath namedPath) {
        return PatternComprehension.basedOn(namedPath);
    }

    public static ListComprehension.OngoingDefinitionWithVariable listWith(SymbolicName variable) {
        return ListComprehension.with(variable);
    }

    public static String quote(String unquotedString) {
        return Cypher.literalOf(unquotedString).asString();
    }

    public static Case caseExpression() {
        return Case.create();
    }

    public static Case caseExpression(Expression expression) {
        return Case.create(expression);
    }

    public static ProcedureCall.OngoingStandaloneCallWithoutArguments call(String procedureName) {
        Assertions.hasText(procedureName, "The procedure name must not be null or empty.");
        return Cypher.call(procedureName.split("\\."));
    }

    public static ProcedureCall.OngoingStandaloneCallWithoutArguments call(String ... namespaceAndProcedure) {
        return Statement.call(namespaceAndProcedure);
    }

    @Neo4jVersion(minimum="4.0.0")
    public static StatementBuilder.OngoingReadingWithoutWhere call(Statement subquery) {
        return Statement.builder().call(subquery);
    }

    public static Expression subList(Expression targetExpression, Integer start, Integer end) {
        return ListOperator.subList(targetExpression, Cypher.literalOf(start), Cypher.literalOf(end));
    }

    public static Expression subList(Expression targetExpression, Expression start, Expression end) {
        return ListOperator.subList(targetExpression, start, end);
    }

    public static Expression subListFrom(Expression targetExpression, Integer start) {
        return ListOperator.subListFrom(targetExpression, Cypher.literalOf(start));
    }

    public static Expression subListFrom(Expression targetExpression, Expression start) {
        return ListOperator.subListFrom(targetExpression, start);
    }

    public static Expression subListUntil(Expression targetExpression, Integer end) {
        return ListOperator.subListUntil(targetExpression, Cypher.literalOf(end));
    }

    public static Expression subListUntil(Expression targetExpression, Expression end) {
        return ListOperator.subListUntil(targetExpression, end);
    }

    public static ListOperator valueAt(Expression targetExpression, Integer index) {
        return ListOperator.valueAt(targetExpression, Cypher.literalOf(index));
    }

    public static ListOperator valueAt(Expression targetExpression, Expression index) {
        return ListOperator.valueAt(targetExpression, index);
    }

    private static Statement unionImpl(boolean unionAll, Statement ... statements) {
        Assertions.isTrue(statements != null && statements.length >= 2, "At least two statements are required!");
        int i = 0;
        UnionQuery existingUnionQuery = null;
        if (statements[0] instanceof UnionQuery) {
            existingUnionQuery = (UnionQuery)statements[0];
            Assertions.isTrue(existingUnionQuery.isAll() == unionAll, "Cannot mix union and union all!");
            i = 1;
        }
        ArrayList<Statement.SingleQuery> listOfQueries = new ArrayList<Statement.SingleQuery>();
        do {
            Assertions.isInstanceOf(Statement.SingleQuery.class, statements[i], "Can only union single queries!");
            listOfQueries.add((Statement.SingleQuery)statements[i]);
        } while (++i < statements.length);
        if (existingUnionQuery == null) {
            return UnionQuery.create(unionAll, listOfQueries);
        }
        return existingUnionQuery.addAdditionalQueries(listOfQueries);
    }

    private Cypher() {
    }
}

