/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.schema;

import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema.RelationTypeSchemaDescriptor;

public class SchemaDescriptorFactory {
    private SchemaDescriptorFactory() {
    }

    public static LabelSchemaDescriptor forLabel(int labelId, int ... propertyIds) {
        SchemaDescriptorFactory.validateLabelId(labelId);
        SchemaDescriptorFactory.validatePropertyIds(propertyIds);
        return new LabelSchemaDescriptor(labelId, propertyIds);
    }

    public static RelationTypeSchemaDescriptor forRelType(int relTypeId, int ... propertyIds) {
        SchemaDescriptorFactory.validateRelationshipTypeLabelId(relTypeId);
        SchemaDescriptorFactory.validatePropertyIds(propertyIds);
        return new RelationTypeSchemaDescriptor(relTypeId, propertyIds);
    }

    private static void validatePropertyIds(int[] propertyIds) {
        for (int propertyId : propertyIds) {
            if (-1 != propertyId) continue;
            throw new IllegalArgumentException("Index schema descriptor can't be created for non existent property.");
        }
    }

    private static void validateRelationshipTypeLabelId(int relType) {
        if (-1 == relType) {
            throw new IllegalArgumentException("Index schema descriptor can't be created for non existent relationship type.");
        }
    }

    private static void validateLabelId(int labelId) {
        if (-1 == labelId) {
            throw new IllegalArgumentException("Index schema descriptor can't be created for non existent label.");
        }
    }
}

