/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nonnull;
import org.neo4j.configuration.LoadableConfig;
import org.neo4j.kernel.configuration.ConfigurationMigrator;
import org.neo4j.kernel.configuration.Migrator;
import org.neo4j.logging.Log;

public class AnnotationBasedConfigurationMigrator
implements ConfigurationMigrator {
    private ArrayList<ConfigurationMigrator> migrators = new ArrayList();

    AnnotationBasedConfigurationMigrator(@Nonnull Iterable<LoadableConfig> settingsClasses) {
        for (LoadableConfig loadableConfig : settingsClasses) {
            for (ConfigurationMigrator field : AnnotationBasedConfigurationMigrator.getMigratorsFromClass(loadableConfig.getClass())) {
                this.migrators.add(field);
            }
        }
    }

    @Override
    @Nonnull
    public Map<String, String> apply(@Nonnull Map<String, String> rawConfiguration, @Nonnull Log log) {
        for (ConfigurationMigrator migrator : this.migrators) {
            rawConfiguration = migrator.apply(rawConfiguration, log);
        }
        return rawConfiguration;
    }

    private static Iterable<ConfigurationMigrator> getMigratorsFromClass(Class<?> clazz) {
        ArrayList<ConfigurationMigrator> found = new ArrayList<ConfigurationMigrator>();
        for (Field field : clazz.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Migrator.class)) continue;
            if (!ConfigurationMigrator.class.isAssignableFrom(field.getType())) {
                throw new AssertionError((Object)"Field annotated as Migrator has to implement ConfigurationMigrator");
            }
            if (!Modifier.isStatic(field.getModifiers())) {
                throw new AssertionError((Object)"Field annotated as Migrator has to be static");
            }
            try {
                field.setAccessible(true);
                found.add((ConfigurationMigrator)field.get(null));
            }
            catch (IllegalAccessException ex) {
                throw new AssertionError("Field annotated as Migrator could not be accessed", ex);
            }
        }
        return found;
    }
}

