/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index.sampling;

import java.util.function.Predicate;
import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.IndexMapSnapshotProvider;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingController;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingJobQueue;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingJobTracker;
import org.neo4j.kernel.impl.api.index.sampling.OnlineIndexSamplingJobFactory;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.register.Register;
import org.neo4j.register.Registers;
import org.neo4j.scheduler.JobScheduler;

public class IndexSamplingControllerFactory {
    private final IndexSamplingConfig config;
    private final IndexStoreView storeView;
    private final JobScheduler scheduler;
    private final TokenNameLookup tokenNameLookup;
    private final LogProvider logProvider;

    public IndexSamplingControllerFactory(IndexSamplingConfig config, IndexStoreView storeView, JobScheduler scheduler, TokenNameLookup tokenNameLookup, LogProvider logProvider) {
        this.config = config;
        this.storeView = storeView;
        this.scheduler = scheduler;
        this.tokenNameLookup = tokenNameLookup;
        this.logProvider = logProvider;
    }

    public IndexSamplingController create(IndexMapSnapshotProvider snapshotProvider) {
        OnlineIndexSamplingJobFactory jobFactory = new OnlineIndexSamplingJobFactory(this.storeView, this.tokenNameLookup, this.logProvider);
        Predicate<Long> samplingUpdatePredicate = this.createSamplingPredicate();
        IndexSamplingJobQueue<Long> jobQueue = new IndexSamplingJobQueue<Long>(samplingUpdatePredicate);
        IndexSamplingJobTracker jobTracker = new IndexSamplingJobTracker(this.config, this.scheduler);
        IndexSamplingController.RecoveryCondition indexRecoveryCondition = this.createIndexRecoveryCondition(this.logProvider, this.tokenNameLookup);
        return new IndexSamplingController(this.config, jobFactory, jobQueue, jobTracker, snapshotProvider, this.scheduler, indexRecoveryCondition);
    }

    private Predicate<Long> createSamplingPredicate() {
        return new Predicate<Long>(){
            private final Register.DoubleLongRegister output = Registers.newDoubleLongRegister();

            @Override
            public boolean test(Long indexId) {
                IndexSamplingControllerFactory.this.storeView.indexUpdatesAndSize(indexId, this.output);
                long updates = this.output.readFirst();
                long size = this.output.readSecond();
                long threshold = Math.round(IndexSamplingControllerFactory.this.config.updateRatio() * (double)size);
                return updates > threshold;
            }
        };
    }

    private IndexSamplingController.RecoveryCondition createIndexRecoveryCondition(final LogProvider logProvider, final TokenNameLookup tokenNameLookup) {
        return new IndexSamplingController.RecoveryCondition(){
            private final Log log;
            private final Register.DoubleLongRegister register;
            {
                this.log = logProvider.getLog(IndexSamplingController.class);
                this.register = Registers.newDoubleLongRegister();
            }

            @Override
            public boolean test(long indexId, IndexDescriptor descriptor) {
                boolean result;
                boolean bl = result = IndexSamplingControllerFactory.this.storeView.indexSample(indexId, this.register).readSecond() == 0L;
                if (result) {
                    this.log.debug("Recovering index sampling for index %s", new Object[]{descriptor.schema().userDescription(tokenNameLookup)});
                }
                return result;
            }
        };
    }
}

