/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.exceptions.index.IndexNotApplicableKernelException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.schema.IndexQuery;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.UpdateMode;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueTuple;

public class DeferredConflictCheckingIndexUpdater
implements IndexUpdater {
    private final IndexUpdater actual;
    private final Supplier<IndexReader> readerSupplier;
    private final IndexDescriptor indexDescriptor;
    private final Set<ValueTuple> touchedTuples = new HashSet<ValueTuple>();

    public DeferredConflictCheckingIndexUpdater(IndexUpdater actual, Supplier<IndexReader> readerSupplier, IndexDescriptor indexDescriptor) {
        this.actual = actual;
        this.readerSupplier = readerSupplier;
        this.indexDescriptor = indexDescriptor;
    }

    @Override
    public void process(IndexEntryUpdate<?> update) throws IOException, IndexEntryConflictException {
        this.actual.process(update);
        if (update.updateMode() != UpdateMode.REMOVED) {
            this.touchedTuples.add(ValueTuple.of((Value[])update.values()));
        }
    }

    @Override
    public void close() throws IOException, IndexEntryConflictException {
        this.actual.close();
        try (IndexReader reader = this.readerSupplier.get();){
            for (ValueTuple tuple : this.touchedTuples) {
                PrimitiveLongIterator results = reader.query(this.queryOf(tuple));
                if (!results.hasNext()) continue;
                long firstEntityId = results.next();
                if (!results.hasNext()) continue;
                long secondEntityId = results.next();
                throw new IndexEntryConflictException(firstEntityId, secondEntityId, tuple);
            }
        }
        catch (IndexNotApplicableKernelException e) {
            throw new IllegalArgumentException("Unexpectedly the index reader couldn't handle this query", e);
        }
    }

    private IndexQuery[] queryOf(ValueTuple tuple) {
        IndexQuery[] predicates = new IndexQuery[tuple.size()];
        for (int i = 0; i < predicates.length; ++i) {
            predicates[i] = IndexQuery.exact(this.indexDescriptor.schema().getPropertyIds()[i], tuple.valueAt(i));
        }
        return predicates;
    }
}

