/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.pagecache;

import org.neo4j.graphdb.config.Configuration;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Service;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageSwapperFactory;
import org.neo4j.io.pagecache.impl.SingleFilePageSwapperFactory;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracerSupplier;
import org.neo4j.io.pagecache.tracing.cursor.context.VersionContextSupplier;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.Settings;
import org.neo4j.kernel.impl.util.OsBeanUtil;
import org.neo4j.logging.Log;
import org.neo4j.unsafe.impl.internal.dragons.FeatureToggles;

public class ConfiguringPageCacheFactory {
    private static final int pageSize = FeatureToggles.getInteger(ConfiguringPageCacheFactory.class, (String)"pageSize", (int)8192);
    private PageSwapperFactory swapperFactory;
    private final FileSystemAbstraction fs;
    private final Config config;
    private final PageCacheTracer pageCacheTracer;
    private final Log log;
    private final VersionContextSupplier versionContextSupplier;
    private PageCache pageCache;
    private PageCursorTracerSupplier pageCursorTracerSupplier;

    public ConfiguringPageCacheFactory(FileSystemAbstraction fs, Config config, PageCacheTracer pageCacheTracer, PageCursorTracerSupplier pageCursorTracerSupplier, Log log, VersionContextSupplier versionContextSupplier) {
        this.fs = fs;
        this.versionContextSupplier = versionContextSupplier;
        this.config = config;
        this.pageCacheTracer = pageCacheTracer;
        this.log = log;
        this.pageCursorTracerSupplier = pageCursorTracerSupplier;
    }

    public synchronized PageCache getOrCreatePageCache() {
        if (this.pageCache == null) {
            this.swapperFactory = ConfiguringPageCacheFactory.createAndConfigureSwapperFactory(this.fs, this.config, this.log);
            this.pageCache = this.createPageCache();
        }
        return this.pageCache;
    }

    protected PageCache createPageCache() {
        int cachePageSize = this.calculatePageSize(this.config, this.swapperFactory);
        int maxPages = this.calculateMaxPages(this.config, cachePageSize);
        return new MuninnPageCache(this.swapperFactory, maxPages, cachePageSize, this.pageCacheTracer, this.pageCursorTracerSupplier, this.versionContextSupplier);
    }

    public int calculateMaxPages(Config config, int cachePageSize) {
        Long pageCacheMemorySetting = config.get(GraphDatabaseSettings.pagecache_memory);
        long pageCacheMemory = this.interpretMemorySetting(pageCacheMemorySetting);
        long pageCount = pageCacheMemory / (long)cachePageSize;
        return (int)Math.min(2147481647L, pageCount);
    }

    private long interpretMemorySetting(Long pageCacheMemorySetting) {
        if (pageCacheMemorySetting != null) {
            return pageCacheMemorySetting;
        }
        long heuristic = ConfiguringPageCacheFactory.defaultHeuristicPageCacheMemory();
        this.log.warn("The " + GraphDatabaseSettings.pagecache_memory.name() + " setting has not been configured. It is recommended that this setting is always explicitly configured, to ensure the system has a balanced configuration. Until then, a computed heuristic value of " + heuristic + " bytes will be used instead. Run `neo4j-admin memrec` for memory configuration suggestions.");
        return heuristic;
    }

    public static long defaultHeuristicPageCacheMemory() {
        long maxHeapMemory;
        String defaultMemoryOverride = System.getProperty("dbms.pagecache.memory.default.override");
        if (defaultMemoryOverride != null) {
            return Settings.BYTES.apply(defaultMemoryOverride);
        }
        double ratioOfFreeMem = 0.5;
        String defaultMemoryRatioOverride = System.getProperty("dbms.pagecache.memory.ratio.default.override");
        if (defaultMemoryRatioOverride != null) {
            ratioOfFreeMem = Double.parseDouble(defaultMemoryRatioOverride);
        }
        if (0L < (maxHeapMemory = Runtime.getRuntime().maxMemory()) && maxHeapMemory < Long.MAX_VALUE) {
            try {
                long physicalMemory = OsBeanUtil.getTotalPhysicalMemory();
                if (0L < physicalMemory && physicalMemory < Long.MAX_VALUE && maxHeapMemory < physicalMemory) {
                    long heuristic = (long)((double)(physicalMemory - maxHeapMemory) * ratioOfFreeMem);
                    long min = ByteUnit.mebiBytes((long)32L);
                    long max = Math.min(maxHeapMemory * 70L, ByteUnit.gibiBytes((long)20L));
                    long memory = Math.min(max, Math.max(min, heuristic));
                    return memory;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ByteUnit.gibiBytes((long)2L);
    }

    public int calculatePageSize(Config config, PageSwapperFactory swapperFactory) {
        if (config.get(GraphDatabaseSettings.mapped_memory_page_size).intValue() != 0) {
            this.log.warn("The setting unsupported.dbms.memory.pagecache.pagesize does not have any effect. It is deprecated and will be removed in a future version.");
        }
        if (swapperFactory.isCachePageSizeHintStrict()) {
            return swapperFactory.getCachePageSizeHint();
        }
        return pageSize;
    }

    public void dumpConfiguration() {
        int cachePageSize = this.calculatePageSize(this.config, this.swapperFactory);
        long maxPages = this.calculateMaxPages(this.config, cachePageSize);
        long totalPhysicalMemory = OsBeanUtil.getTotalPhysicalMemory();
        String totalPhysicalMemMb = totalPhysicalMemory == -1L ? "?" : "" + ByteUnit.Byte.toMebiBytes(totalPhysicalMemory);
        long maxVmUsageMb = ByteUnit.Byte.toMebiBytes(Runtime.getRuntime().maxMemory());
        long pageCacheMb = ByteUnit.Byte.toMebiBytes(maxPages * (long)cachePageSize);
        String msg = "Physical mem: " + totalPhysicalMemMb + " MiB, Heap size: " + maxVmUsageMb + " MiB, Page cache size: " + pageCacheMb + " MiB.";
        this.log.info(msg);
    }

    private static PageSwapperFactory createAndConfigureSwapperFactory(FileSystemAbstraction fs, Config config, Log log) {
        PageSwapperFactory factory = ConfiguringPageCacheFactory.getPageSwapperFactory(config, log);
        factory.open(fs, (Configuration)config);
        return factory;
    }

    private static PageSwapperFactory getPageSwapperFactory(Config config, Log log) {
        String desiredImplementation = config.get(GraphDatabaseSettings.pagecache_swapper);
        if (desiredImplementation != null) {
            for (PageSwapperFactory factory : Service.load(PageSwapperFactory.class)) {
                if (!factory.implementationName().equals(desiredImplementation)) continue;
                log.info("Configured " + GraphDatabaseSettings.pagecache_swapper.name() + ": " + desiredImplementation);
                return factory;
            }
            throw new IllegalArgumentException("Cannot find PageSwapperFactory: " + desiredImplementation);
        }
        return new SingleFilePageSwapperFactory();
    }
}

