/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import java.util.function.Predicate;
import org.neo4j.cursor.IOCursor;

public class FilteringIOCursor<T>
implements IOCursor<T> {
    private final IOCursor<T> delegate;
    private final Predicate<T> toKeep;

    public FilteringIOCursor(IOCursor<T> delegate, Predicate<T> toKeep) {
        this.delegate = delegate;
        this.toKeep = toKeep;
    }

    public T get() {
        return (T)this.delegate.get();
    }

    public boolean next() throws IOException {
        do {
            if (this.delegate.next()) continue;
            return false;
        } while (!this.toKeep.test(this.delegate.get()));
        return true;
    }

    public void close() throws IOException {
        this.delegate.close();
    }
}

