/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.io.File;
import java.io.IOException;

public class IncompleteLogHeaderException
extends IOException {
    public IncompleteLogHeaderException(File file, int readSize) {
        super(IncompleteLogHeaderException.template(file, readSize));
    }

    public IncompleteLogHeaderException(int readSize) {
        super(IncompleteLogHeaderException.template(null, readSize));
    }

    private static String template(File file, int readSize) {
        StringBuilder builder = new StringBuilder("Unable to read log version and last committed tx");
        if (file != null) {
            builder.append(" from '").append(file.getAbsolutePath()).append("'");
        }
        builder.append(". Was only able to read ").append(readSize).append(" bytes, but was expecting ").append(16);
        return builder.toString();
    }
}

