/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArraySet;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.event.LabelEntry;
import org.neo4j.graphdb.event.PropertyEntry;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.graphdb.event.TransactionEventHandler;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.TransactionHook;
import org.neo4j.kernel.impl.core.NodeProxy;
import org.neo4j.kernel.impl.core.RelationshipProxy;
import org.neo4j.kernel.impl.coreapi.TxStateTransactionDataSnapshot;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.storageengine.api.StorageStatement;
import org.neo4j.storageengine.api.StoreReadLayer;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;

public class TransactionEventHandlers
implements Lifecycle,
TransactionHook<TransactionHandlerState> {
    private final CopyOnWriteArraySet<TransactionEventHandler> transactionEventHandlers = new CopyOnWriteArraySet();
    private final NodeProxy.NodeActions nodeActions;
    private final RelationshipProxy.RelationshipActions relationshipActions;
    private static final TransactionData EMPTY_DATA = new TransactionData(){

        public Iterable<Node> createdNodes() {
            return Iterables.empty();
        }

        public Iterable<Node> deletedNodes() {
            return Iterables.empty();
        }

        public boolean isDeleted(Node node) {
            return false;
        }

        public Iterable<PropertyEntry<Node>> assignedNodeProperties() {
            return Iterables.empty();
        }

        public Iterable<PropertyEntry<Node>> removedNodeProperties() {
            return Iterables.empty();
        }

        public Iterable<LabelEntry> assignedLabels() {
            return Iterables.empty();
        }

        public Iterable<LabelEntry> removedLabels() {
            return Iterables.empty();
        }

        public Iterable<Relationship> createdRelationships() {
            return Iterables.empty();
        }

        public Iterable<Relationship> deletedRelationships() {
            return Iterables.empty();
        }

        public boolean isDeleted(Relationship relationship) {
            return false;
        }

        public String username() {
            return "";
        }

        public Map<String, Object> metaData() {
            return Collections.emptyMap();
        }

        public Iterable<PropertyEntry<Relationship>> assignedRelationshipProperties() {
            return Iterables.empty();
        }

        public Iterable<PropertyEntry<Relationship>> removedRelationshipProperties() {
            return Iterables.empty();
        }
    };

    public TransactionEventHandlers(NodeProxy.NodeActions nodeActions, RelationshipProxy.RelationshipActions relationshipActions) {
        this.nodeActions = nodeActions;
        this.relationshipActions = relationshipActions;
    }

    public void init() throws Throwable {
    }

    public void start() throws Throwable {
    }

    public void stop() throws Throwable {
    }

    public void shutdown() throws Throwable {
    }

    public <T> TransactionEventHandler<T> registerTransactionEventHandler(TransactionEventHandler<T> handler) {
        this.transactionEventHandlers.add(handler);
        return handler;
    }

    public <T> TransactionEventHandler<T> unregisterTransactionEventHandler(TransactionEventHandler<T> handler) {
        return this.unregisterHandler(this.transactionEventHandlers, handler);
    }

    private <T> T unregisterHandler(Collection<?> setOfHandlers, T handler) {
        if (!setOfHandlers.remove(handler)) {
            throw new IllegalStateException(handler + " isn't registered");
        }
        return handler;
    }

    @Override
    public TransactionHandlerState beforeCommit(ReadableTransactionState state, KernelTransaction transaction, StoreReadLayer storeReadLayer, StorageStatement statement) {
        Iterator<TransactionEventHandler> handlers = this.transactionEventHandlers.iterator();
        if (!handlers.hasNext()) {
            return null;
        }
        TransactionData txData = state == null ? EMPTY_DATA : new TxStateTransactionDataSnapshot(state, this.nodeActions, this.relationshipActions, storeReadLayer, statement, transaction);
        TransactionHandlerState handlerStates = new TransactionHandlerState(txData);
        while (handlers.hasNext()) {
            TransactionEventHandler handler = handlers.next();
            try {
                handlerStates.add(handler).setState(handler.beforeCommit(txData));
            }
            catch (Throwable t) {
                handlerStates.failed(t);
            }
        }
        return handlerStates;
    }

    @Override
    public void afterCommit(ReadableTransactionState state, KernelTransaction transaction, TransactionHandlerState handlerState) {
        if (handlerState == null) {
            return;
        }
        for (HandlerAndState handlerAndState : handlerState.states) {
            handlerAndState.handler.afterCommit(handlerState.txData, handlerAndState.state);
        }
    }

    @Override
    public void afterRollback(ReadableTransactionState state, KernelTransaction transaction, TransactionHandlerState handlerState) {
        if (handlerState == null) {
            return;
        }
        for (HandlerAndState handlerAndState : handlerState.states) {
            handlerAndState.handler.afterRollback(handlerState.txData, handlerAndState.state);
        }
    }

    public static class TransactionHandlerState
    implements TransactionHook.Outcome {
        private final TransactionData txData;
        private final List<HandlerAndState> states = new LinkedList<HandlerAndState>();
        private Throwable error;

        public TransactionHandlerState(TransactionData txData) {
            this.txData = txData;
        }

        public void failed(Throwable error) {
            this.error = error;
        }

        @Override
        public boolean isSuccessful() {
            return this.error == null;
        }

        @Override
        public Throwable failure() {
            return this.error;
        }

        public HandlerAndState add(TransactionEventHandler<?> handler) {
            HandlerAndState result = new HandlerAndState(handler);
            this.states.add(result);
            return result;
        }
    }

    public static class HandlerAndState {
        private final TransactionEventHandler handler;
        private Object state;

        public HandlerAndState(TransactionEventHandler<?> handler) {
            this.handler = handler;
        }

        void setState(Object state) {
            this.state = state;
        }
    }
}

