/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.util.NoSuchElementException;
import org.neo4j.csv.reader.SourceTraceability;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.unsafe.impl.batchimport.InputIterable;
import org.neo4j.unsafe.impl.batchimport.InputIterator;
import org.neo4j.unsafe.impl.batchimport.input.InputNode;
import org.neo4j.unsafe.impl.batchimport.input.SourceInputIterator;

public class Utils {
    public static boolean unsignedCompare(long dataA, long dataB, CompareType compareType) {
        switch (compareType) {
            case EQ: {
                return dataA == dataB;
            }
            case GE: {
                if (dataA == dataB) {
                    return true;
                }
            }
            case GT: {
                return dataA < dataB == (dataA < 0L != dataB < 0L);
            }
            case LE: {
                if (dataA == dataB) {
                    return true;
                }
            }
            case LT: {
                return dataA < dataB ^ dataA < 0L != dataB < 0L;
            }
            case NE: {
                return false;
            }
        }
        throw new IllegalArgumentException("Unknown compare type: " + (Object)((Object)compareType));
    }

    public static CompareType unsignedDifference(long dataA, long dataB) {
        if (dataA == dataB) {
            return CompareType.EQ;
        }
        return dataA < dataB ^ dataA < 0L != dataB < 0L ? CompareType.LT : CompareType.GT;
    }

    public static InputIterable<Object> idsOf(final InputIterable<InputNode> nodes) {
        return new InputIterable<Object>(){

            @Override
            public InputIterator<Object> iterator() {
                ResourceIterator iterator = nodes.iterator();
                return new SourceInputIterator<Object, InputNode>((SourceTraceability)iterator, (InputIterator)iterator){
                    final /* synthetic */ InputIterator val$iterator;
                    {
                        this.val$iterator = inputIterator;
                        super(source);
                    }

                    public void close() {
                        this.val$iterator.close();
                    }

                    public boolean hasNext() {
                        return this.val$iterator.hasNext();
                    }

                    public Object next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        return ((InputNode)this.val$iterator.next()).id();
                    }

                    @Override
                    public void receivePanic(Throwable cause) {
                        this.val$iterator.receivePanic(cause);
                    }
                };
            }

            @Override
            public boolean supportsMultiplePasses() {
                return false;
            }
        };
    }

    public static boolean anyIdCollides(long[] first, int firstLength, long[] other, int otherLength) {
        int f = 0;
        int o = 0;
        while (f < firstLength && o < otherLength) {
            if (first[f] == other[o]) {
                return true;
            }
            if (first[f] < other[o]) {
                while (++f < firstLength && first[f] < other[o]) {
                }
                continue;
            }
            while (++o < otherLength && first[f] > other[o]) {
            }
        }
        return false;
    }

    public static void mergeSortedInto(long[] values, long[] into, int intoLengthBefore) {
        int v = values.length - 1;
        int i = intoLengthBefore - 1;
        int t = i + values.length;
        while (v >= 0 || i >= 0) {
            if (i == -1) {
                into[t--] = values[v--];
                continue;
            }
            if (v == -1) {
                into[t--] = into[i--];
                continue;
            }
            if (values[v] >= into[i]) {
                into[t--] = values[v--];
                continue;
            }
            into[t--] = into[i--];
        }
    }

    private Utils() {
    }

    public static enum CompareType {
        EQ,
        GT,
        GE,
        LT,
        LE,
        NE;

    }
}

