/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.primitive.hopscotch;

import java.util.Arrays;
import org.neo4j.collection.primitive.hopscotch.LongKeyTable;

public class LongKeyObjectValueTable<VALUE>
extends LongKeyTable<VALUE> {
    private VALUE[] values;

    public LongKeyObjectValueTable(int capacity) {
        super(capacity, null);
    }

    @Override
    public VALUE value(int index) {
        return this.values[index];
    }

    @Override
    public void put(int index, long key, VALUE value) {
        super.put(index, key, value);
        this.values[index] = value;
    }

    @Override
    public VALUE putValue(int index, VALUE value) {
        VALUE previous = this.values[index];
        this.values[index] = value;
        return previous;
    }

    @Override
    public long move(int fromIndex, int toIndex) {
        this.values[toIndex] = this.values[fromIndex];
        this.values[fromIndex] = null;
        return super.move(fromIndex, toIndex);
    }

    @Override
    public VALUE remove(int index) {
        super.remove(index);
        VALUE existing = this.values[index];
        this.values[index] = null;
        return existing;
    }

    @Override
    protected LongKeyObjectValueTable<VALUE> newInstance(int newCapacity) {
        return new LongKeyObjectValueTable<VALUE>(newCapacity);
    }

    @Override
    protected void initializeTable() {
        super.initializeTable();
        this.values = new Object[this.capacity];
    }

    @Override
    protected void clearTable() {
        super.clearTable();
        Arrays.fill(this.values, null);
    }
}

