/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.integration.dubbo;

import com.alibaba.dubbo.common.extension.ExtensionLoader;
import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.dubbo.config.MonitorConfig;
import com.alibaba.dubbo.config.ProtocolConfig;
import com.alibaba.dubbo.config.RegistryConfig;
import com.alibaba.dubbo.rpc.Protocol;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Pattern;
import org.nutz.integration.dubbo.AnnotationBean;
import org.nutz.integration.dubbo.DubboAgent;
import org.nutz.integration.dubbo.DubboManager;
import org.nutz.integration.dubbo.ReferenceBean;
import org.nutz.integration.dubbo.ServiceBean;
import org.nutz.ioc.IocLoader;
import org.nutz.ioc.IocLoading;
import org.nutz.ioc.Iocs;
import org.nutz.ioc.ObjectLoadException;
import org.nutz.ioc.meta.IocEventSet;
import org.nutz.ioc.meta.IocField;
import org.nutz.ioc.meta.IocObject;
import org.nutz.ioc.meta.IocValue;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;
import org.nutz.lang.Xmls;
import org.nutz.lang.util.NutMap;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DubboIocLoader
implements IocLoader {
    private static final Log log = Logs.get();
    protected Map<String, IocObject> iobjs = new HashMap<String, IocObject>();
    private static final Pattern GROUP_AND_VERION = Pattern.compile("^[\\-.0-9_a-zA-Z]+(\\:[\\-.0-9_a-zA-Z]+)?$");

    public DubboIocLoader() {
    }

    public DubboIocLoader(String ... paths) {
        ArrayList<Element> tops = new ArrayList<Element>();
        for (String xmlpath : paths) {
            Document doc = Xmls.xml((InputStream)this.getClass().getClassLoader().getResourceAsStream(xmlpath));
            doc.normalizeDocument();
            Element top = doc.getDocumentElement();
            tops.add(top);
        }
        this.load(tops.toArray(new Element[tops.size()]));
    }

    public void load(Element ... tops) {
        for (Element top : tops) {
            NodeList list = top.getChildNodes();
            int count = list.getLength();
            for (int i = 0; i < count; ++i) {
                Element ele;
                String eleName;
                Node node = list.item(i);
                if (!(node instanceof Element) || !(eleName = (ele = (Element)node).getNodeName()).startsWith("dubbo:")) continue;
                String typeName = eleName.substring("dubbo:".length());
                this.load(typeName, ele);
            }
        }
        IocObject dubbo_iobjs = Iocs.wrap(this.iobjs);
        dubbo_iobjs.setType(Object.class);
        this.iobjs.put("dubbo_iobjs", dubbo_iobjs);
        for (Map.Entry<String, IocObject> en : this.iobjs.entrySet()) {
            IocObject iobj = en.getValue();
            String beanName = en.getKey();
            DubboAgent.checkIocObject(beanName, iobj);
        }
        DubboManager dubboManager = new DubboManager();
        dubboManager.iobjs = this.iobjs;
        IocObject dubbo_manager = Iocs.wrap((Object)dubboManager);
        dubbo_manager.setType(DubboManager.class);
        dubbo_manager.addField(DubboAgent._field("ioc", DubboAgent._ref("$ioc")));
        IocEventSet events = new IocEventSet();
        events.setCreate("init");
        events.setDepose("depose");
        dubbo_manager.setEvents(events);
        this.iobjs.put("dubboManager", dubbo_manager);
    }

    public String load(String typeName, Element ele) {
        String genBeanName;
        String id = genBeanName = ele.getAttribute("id");
        if (Strings.isBlank((CharSequence)genBeanName)) {
            if ("protocol".equals(typeName)) {
                genBeanName = "dubbo";
            } else {
                genBeanName = ele.getAttribute("interface");
                if (Strings.isBlank((CharSequence)genBeanName)) {
                    genBeanName = "dubbo_" + typeName;
                }
            }
            id = genBeanName;
            if (this.iobjs.containsKey(id)) {
                int count = 2;
                while (!this.iobjs.containsKey(id)) {
                    id = genBeanName + "_" + count;
                }
            }
        }
        try {
            this.add(id, typeName, ele);
        }
        catch (Exception e) {
            throw Lang.wrapThrow((Throwable)e);
        }
        return id;
    }

    protected void add(String id, String typeName, Element element) throws Exception {
        IocObject iobj = new IocObject();
        NutMap attrs = DubboIocLoader.toAttrMap(element.getAttributes());
        switch (typeName) {
            case "protocol": {
                for (IocObject _iobj : this.iobjs.values()) {
                    IocField field = (IocField)_iobj.getFields().get("protocol");
                    if (field == null || !attrs.getString("name", "").equals(field.getValue().getValue())) continue;
                    field.setValue(new IocValue("refer", (Object)id));
                }
                break;
            }
            case "service": {
                String className = attrs.getString("class");
                if (className == null) break;
                Method[] inner = new IocObject();
                String uu32 = id + "Impl";
                inner.setType(Class.forName(className));
                DubboIocLoader.parseProperties(element.getChildNodes(), (IocObject)inner);
                iobj.addField(DubboAgent._field("ref", new IocValue("refer", (Object)uu32)));
                this.iobjs.put(uu32, (IocObject)inner);
                break;
            }
            case "provider": {
                this.parseNested(element, "service", true, "service", "provider", id, iobj);
                break;
            }
            case "consumer": {
                this.parseNested(element, "reference", false, "reference", "consumer", id, iobj);
            }
        }
        try {
            Class beanClass = null;
            switch (typeName) {
                case "reference": {
                    beanClass = ReferenceBean.class;
                    break;
                }
                case "service": {
                    beanClass = ServiceBean.class;
                    break;
                }
                case "annotation": {
                    beanClass = AnnotationBean.class;
                    break;
                }
                default: {
                    beanClass = Class.forName("com.alibaba.dubbo.config." + Strings.upperFirst((CharSequence)typeName) + "Config");
                }
            }
            iobj.setType(beanClass);
            HashSet<String> props = new HashSet<String>();
            NutMap parameters = null;
            for (Method setter : beanClass.getMethods()) {
                String reference;
                IocField _field;
                String name = setter.getName();
                if (name.length() <= 3 || !name.startsWith("set") || !Modifier.isPublic(setter.getModifiers()) || setter.getParameterTypes().length != 1) continue;
                Class<?> type = setter.getParameterTypes()[0];
                String property = StringUtils.camelToSplitName((String)(name.substring(3, 4).toLowerCase() + name.substring(4)), (String)"-");
                props.add(property);
                Method getter = null;
                try {
                    getter = beanClass.getMethod("get" + name.substring(3), new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    try {
                        getter = beanClass.getMethod("is" + name.substring(3), new Class[0]);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
                if (getter == null || !Modifier.isPublic(getter.getModifiers()) || !type.equals(getter.getReturnType())) continue;
                if ("parameters".equals(property)) {
                    parameters = DubboIocLoader.parseParameters(element.getChildNodes(), iobj);
                    continue;
                }
                if ("methods".equals(property)) {
                    this.parseMethods(id, element.getChildNodes(), iobj);
                    continue;
                }
                if ("arguments".equals(property)) {
                    DubboIocLoader.parseArguments(id, element.getChildNodes(), iobj);
                    continue;
                }
                String value = attrs.getString(property);
                if (value == null || (value = value.trim()).length() <= 0) continue;
                if ("registry".equals(property) && "N/A".equalsIgnoreCase(value)) {
                    RegistryConfig registryConfig = new RegistryConfig();
                    registryConfig.setAddress("N/A");
                    _field = new IocField();
                    _field.setName(property);
                    _field.setValue(new IocValue("normal", (Object)registryConfig));
                    iobj.addField(_field);
                    continue;
                }
                if ("registry".equals(property) && value.indexOf(44) != -1) {
                    DubboIocLoader.parseMultiRef("registries", value, iobj);
                    continue;
                }
                if ("provider".equals(property) && value.indexOf(44) != -1) {
                    DubboIocLoader.parseMultiRef("providers", value, iobj);
                    continue;
                }
                if ("protocol".equals(property) && value.indexOf(44) != -1) {
                    DubboIocLoader.parseMultiRef("protocols", value, iobj);
                    continue;
                }
                if (DubboIocLoader.isPrimitive(type)) {
                    if ("async".equals(property) && "false".equals(value) || "timeout".equals(property) && "0".equals(value) || "delay".equals(property) && "0".equals(value) || "version".equals(property) && "0.0.0".equals(value) || "stat".equals(property) && "-1".equals(value) || "reliable".equals(property) && "false".equals(value)) {
                        value = null;
                    }
                    reference = value;
                } else if ("protocol".equals(property) && ExtensionLoader.getExtensionLoader(Protocol.class).hasExtension(value) && (!this.iobjs.containsKey(value) || !ProtocolConfig.class.getName().equals(this.iobjs.get(value).getType().getName()))) {
                    if ("dubbo:provider".equals(typeName)) {
                        log.warn((Object)("Recommended replace <dubbo:provider protocol=\"" + value + "\" ... /> to <dubbo:protocol name=\"" + value + "\" ... />"));
                    }
                    ProtocolConfig protocol = new ProtocolConfig();
                    protocol.setName(value);
                    reference = protocol;
                } else if (!(!"monitor".equals(property) || this.iobjs.containsKey(value) && MonitorConfig.class.getName().equals(this.iobjs.get(value).getType().getName()))) {
                    reference = DubboIocLoader.convertMonitor(value);
                } else if ("onreturn".equals(property)) {
                    int index = value.lastIndexOf(".");
                    String returnRef = value.substring(0, index);
                    String returnMethod = value.substring(index + 1);
                    reference = DubboAgent._ref(returnRef);
                    iobj.addField(DubboAgent._field("onreturnMethod", new IocValue("normal", (Object)returnMethod)));
                } else if ("onthrow".equals(property)) {
                    int index = value.lastIndexOf(".");
                    String throwRef = value.substring(0, index);
                    String throwMethod = value.substring(index + 1);
                    reference = DubboAgent._ref(throwRef);
                    iobj.addField(DubboAgent._field("onthrowMethod", new IocValue("normal", (Object)throwMethod)));
                } else {
                    IocObject _iobj;
                    if ("ref".equals(property) && this.iobjs.containsKey(value) && !(_iobj = this.iobjs.get(value)).isSingleton()) {
                        throw new IllegalStateException("The exported service ref " + value + " must be singleton! Please set the " + value + " bean scope to singleton, eg: <bean id=\"" + value + "\" scope=\"singleton\" ...>");
                    }
                    reference = new IocValue("refer", (Object)value);
                }
                _field = new IocField();
                if ("interface".equals(property)) {
                    attrs.remove((Object)property);
                    property = "interfaceName";
                }
                _field.setName(property);
                if (reference != null && reference instanceof IocValue) {
                    _field.setValue((IocValue)reference);
                } else {
                    _field.setValue(new IocValue("normal", (Object)reference));
                }
                iobj.addField(_field);
            }
            for (Map.Entry _en : attrs.entrySet()) {
                if (iobj.getFields().containsKey(_en.getKey())) continue;
                String fieldName = (String)_en.getKey();
                IocField field = new IocField();
                field.setName(fieldName);
                field.setValue(new IocValue("normal", _en.getValue()));
                iobj.addField(field);
            }
            if (parameters != null) {
                IocField field = new IocField();
                field.setName("parameters");
                IocValue value = new IocValue("normal", parameters);
                field.setValue(value);
                iobj.addField(field);
            }
            if ("reference".equals(typeName)) {
                IocObject refBean = new IocObject();
                refBean.setFactory("$dubbo_reference_" + id + "#get");
                refBean.setType(Class.forName((String)((IocField)iobj.getFields().get("interfaceName")).getValue().getValue()));
                this.iobjs.put(id, refBean);
                id = "dubbo_reference_" + id;
            }
            this.iobjs.put(id, iobj);
        }
        catch (ClassNotFoundException e) {
            throw Lang.wrapThrow((Throwable)e);
        }
    }

    private static void parseMultiRef(String property, String value, IocObject iobj) {
        String[] values = value.split("\\s*[,]+\\s*");
        ArrayList<IocValue> list = null;
        for (int i = 0; i < values.length; ++i) {
            String v = values[i];
            if (v == null || v.length() <= 0) continue;
            if (list == null) {
                list = new ArrayList<IocValue>();
            }
            IocValue iocValue = new IocValue("refer", (Object)v);
            list.add(iocValue);
        }
        IocField _field = new IocField();
        _field.setName(property);
        _field.setValue(new IocValue("normal", list));
        iobj.addField(_field);
    }

    private static boolean isPrimitive(Class<?> cls) {
        return cls.isPrimitive() || cls == Boolean.class || cls == Byte.class || cls == Character.class || cls == Short.class || cls == Integer.class || cls == Long.class || cls == Float.class || cls == Double.class || cls == String.class || cls == Date.class || cls == Class.class;
    }

    public String[] getName() {
        int count = this.iobjs.size();
        return this.iobjs.keySet().toArray(new String[count]);
    }

    public IocObject load(IocLoading loading, String name) throws ObjectLoadException {
        IocObject obj = this.iobjs.get(name);
        if (obj == null) {
            throw new ObjectLoadException("Object '" + name + "' without define!");
        }
        return obj;
    }

    public boolean has(String name) {
        return this.iobjs.containsKey(name);
    }

    protected static MonitorConfig convertMonitor(String monitor) {
        if (monitor == null || monitor.length() == 0) {
            return null;
        }
        if (GROUP_AND_VERION.matcher(monitor).matches()) {
            String version;
            String group;
            int i = monitor.indexOf(58);
            if (i > 0) {
                group = monitor.substring(0, i);
                version = monitor.substring(i + 1);
            } else {
                group = monitor;
                version = null;
            }
            MonitorConfig monitorConfig = new MonitorConfig();
            monitorConfig.setGroup(group);
            monitorConfig.setVersion(version);
            return monitorConfig;
        }
        return null;
    }

    public static NutMap toAttrMap(NamedNodeMap attrs) {
        NutMap map = new NutMap();
        int len = attrs.getLength();
        for (int j = 0; j < len; ++j) {
            Attr attr = (Attr)attrs.item(j);
            map.put((Object)attr.getName(), (Object)attr.getValue());
        }
        return map;
    }

    private static void parseProperties(NodeList nodeList, IocObject iobj) {
        if (nodeList != null && nodeList.getLength() > 0) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String name;
                Node node = nodeList.item(i);
                if (!(node instanceof Element) || !"property".equals(node.getNodeName()) && !"property".equals(node.getLocalName()) || (name = ((Element)node).getAttribute("name")) == null || name.length() <= 0) continue;
                String value = ((Element)node).getAttribute("value");
                String ref = ((Element)node).getAttribute("ref");
                if (value != null && value.length() > 0) {
                    iobj.addField(DubboAgent._field(name, new IocValue("normal", (Object)value)));
                    continue;
                }
                if (ref != null && ref.length() > 0) {
                    iobj.addField(DubboAgent._field(name, new IocValue("refer", (Object)ref)));
                    continue;
                }
                throw new UnsupportedOperationException("Unsupported <property name=\"" + name + "\"> sub tag, Only supported <property name=\"" + name + "\" ref=\"...\" /> or <property name=\"" + name + "\" value=\"...\" />");
            }
        }
    }

    private static NutMap parseParameters(NodeList nodeList, IocObject iobj) {
        if (nodeList != null && nodeList.getLength() > 0) {
            NutMap parameters = null;
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!(node instanceof Element) || !"parameter".equals(node.getNodeName()) && !"parameter".equals(node.getLocalName())) continue;
                if (parameters == null) {
                    parameters = new NutMap();
                }
                String key = ((Element)node).getAttribute("key");
                String value = ((Element)node).getAttribute("value");
                boolean hide = "true".equals(((Element)node).getAttribute("hide"));
                if (hide) {
                    key = "." + key;
                }
                parameters.put((Object)key, (Object)value);
            }
            return parameters;
        }
        return null;
    }

    protected void parseMethods(String id, NodeList nodeList, IocObject iobj) throws Exception {
        if (nodeList != null && nodeList.getLength() > 0) {
            NutMap methods = null;
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!(node instanceof Element)) continue;
                Element element = (Element)node;
                if (!"method".equals(node.getNodeName()) && !"method".equals(node.getLocalName())) continue;
                String methodName = element.getAttribute("name");
                if (methodName == null || methodName.length() == 0) {
                    throw new IllegalStateException("<dubbo:method> name attribute == null");
                }
                if (methods == null) {
                    methods = new NutMap();
                }
                String name = id + "." + methodName;
                this.add(name, "method", (Element)node);
                methods.put((Object)methodName, (Object)DubboAgent._ref(name));
            }
            if (methods != null) {
                iobj.addField(DubboAgent._field("methods", new IocValue("normal", methods)));
            }
        }
    }

    private static void parseArguments(String id, NodeList nodeList, IocObject iobj) {
        if (nodeList != null && nodeList.getLength() > 0) {
            NutMap arguments = null;
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!(node instanceof Element)) continue;
                Element element = (Element)node;
                if (!"argument".equals(node.getNodeName()) && !"argument".equals(node.getLocalName())) continue;
                String argumentIndex = element.getAttribute("index");
                if (arguments == null) {
                    arguments = new NutMap();
                }
                String name = id + "." + argumentIndex;
                arguments.put((Object)argumentIndex, (Object)DubboAgent._ref(name));
            }
            if (arguments != null) {
                iobj.addField(DubboAgent._field("arguments", new IocValue("normal", arguments)));
            }
        }
    }

    protected void parseNested(Element element, String typeName, boolean required, String tag, String property, String ref, IocObject iobj) {
        NodeList nodeList = element.getChildNodes();
        if (nodeList != null && nodeList.getLength() > 0) {
            boolean first = true;
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String subDefinition;
                Node node = nodeList.item(i);
                if (!(node instanceof Element) || !tag.equals(node.getNodeName()) && !tag.equals(node.getLocalName())) continue;
                if (first) {
                    first = false;
                    String isDefault = element.getAttribute("default");
                    if (isDefault == null || isDefault.length() == 0) {
                        iobj.addField(DubboAgent._field("default", new IocValue("normal", (Object)"false")));
                    }
                }
                if ((subDefinition = this.load(typeName, (Element)node)) == null || ref == null || ref.length() <= 0) continue;
                this.iobjs.get(subDefinition).addField(DubboAgent._field(property, DubboAgent._ref(ref)));
            }
        }
    }
}

