/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.converter.utils;

import java.awt.geom.AffineTransform;
import org.ofdrw.converter.point.Tuple2;
import org.ujmp.core.DenseMatrix;
import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.DenseDoubleMatrix2D;

public class MatrixUtils {
    public static Matrix base() {
        DenseDoubleMatrix2D matrix = DenseMatrix.Factory.zeros(3L, 3L);
        matrix.setAsDouble(1.0, new long[]{0L, 0L});
        matrix.setAsDouble(1.0, new long[]{1L, 1L});
        matrix.setAsDouble(1.0, new long[]{2L, 2L});
        return matrix;
    }

    public static Matrix create(double d1, double d2, double d3, double d4, double d5, double d6) {
        Matrix matrix = MatrixUtils.base();
        matrix.setAsDouble(d1, new long[]{0L, 0L});
        matrix.setAsDouble(d2, new long[]{0L, 1L});
        matrix.setAsDouble(d3, new long[]{1L, 0L});
        matrix.setAsDouble(d4, new long[]{1L, 1L});
        matrix.setAsDouble(d5, new long[]{2L, 0L});
        matrix.setAsDouble(d6, new long[]{2L, 1L});
        return matrix;
    }

    public static Matrix scale(Matrix matrix, double x, double y) {
        return MatrixUtils.create(x, 0.0, 0.0, y, 0.0, 0.0).mtimes(matrix);
    }

    public static Matrix move(Matrix matrix, double x, double y) {
        return matrix.mtimes(MatrixUtils.create(1.0, 0.0, 0.0, 1.0, x, y));
    }

    public static Matrix ctm(Double ... ctm) {
        return MatrixUtils.create(ctm[0], ctm[1], ctm[2], ctm[3], ctm[4], ctm[5]);
    }

    public static Matrix imageMatrix(Matrix matrix, double a, double b, double c) {
        DenseDoubleMatrix2D image = DenseMatrix.Factory.zeros(3L, 3L);
        image.setAsDouble(a * a - b * b, new long[]{0L, 0L});
        image.setAsDouble(2.0 * a * b, new long[]{0L, 1L});
        image.setAsDouble(2.0 * a * b, new long[]{1L, 0L});
        image.setAsDouble(-(a * a - b * b), new long[]{1L, 1L});
        image.setAsDouble(2.0 * a * c, new long[]{2L, 0L});
        image.setAsDouble(2.0 * b * c, new long[]{2L, 1L});
        image.setAsDouble(-(a * a + b * b), new long[]{2L, 2L});
        image = image.times(-1.0 / (a * a + b * b));
        return matrix.mtimes((Matrix)image);
    }

    public static AffineTransform createAffineTransform(Matrix matrix) {
        return new AffineTransform(matrix.getAsFloat(new long[]{0L, 0L}), matrix.getAsFloat(new long[]{0L, 1L}), matrix.getAsFloat(new long[]{1L, 0L}), matrix.getAsFloat(new long[]{1L, 1L}), matrix.getAsFloat(new long[]{2L, 0L}), matrix.getAsFloat(new long[]{2L, 1L}));
    }

    public static Tuple2<Double, Double> leftTop(Matrix matrix) {
        Matrix m = MatrixUtils.base();
        m.setAsFloat(matrix.getAsFloat(new long[]{0L, 0L}), new long[]{0L, 0L});
        m.setAsFloat(matrix.getAsFloat(new long[]{0L, 1L}), new long[]{0L, 1L});
        m.setAsFloat(matrix.getAsFloat(new long[]{1L, 0L}), new long[]{1L, 0L});
        m.setAsFloat(matrix.getAsFloat(new long[]{1L, 1L}), new long[]{1L, 1L});
        m.setAsFloat(matrix.getAsFloat(new long[]{2L, 0L}), new long[]{2L, 0L});
        m.setAsFloat(matrix.getAsFloat(new long[]{2L, 1L}), new long[]{2L, 1L});
        m.setAsFloat(1.0f, new long[]{2L, 2L});
        double x = 0.0;
        double y = 0.0;
        Tuple2<Double, Double> tuple = MatrixUtils.leftTop(m, 0.0f, 0.0f);
        x = tuple.getFirst();
        y = tuple.getSecond();
        MatrixUtils.leftTop(m, 1.0f, 0.0f);
        if (tuple.getFirst() < x) {
            x = tuple.getFirst();
        }
        if (tuple.getSecond() < y) {
            y = tuple.getSecond();
        }
        MatrixUtils.leftTop(m, 1.0f, 1.0f);
        if (tuple.getFirst() < x) {
            x = tuple.getFirst();
        }
        if (tuple.getSecond() < y) {
            y = tuple.getSecond();
        }
        MatrixUtils.leftTop(m, 0.0f, 1.0f);
        if (tuple.getFirst() < x) {
            x = tuple.getFirst();
        }
        if (tuple.getSecond() < y) {
            y = tuple.getSecond();
        }
        return new Tuple2<Double, Double>(x, y);
    }

    private static Tuple2<Double, Double> leftTop(Matrix matrix, float x, float y) {
        DenseDoubleMatrix2D m = DenseMatrix.Factory.zeros(1L, 3L);
        m.setAsFloat(x, new long[]{0L, 0L});
        m.setAsFloat(x, new long[]{0L, 1L});
        m.setAsFloat(1.0f, new long[]{0L, 2L});
        Matrix result = m.mtimes(matrix);
        return new Tuple2<Double, Double>(result.getAsDouble(new long[]{0L, 0L}), result.getAsDouble(new long[]{0L, 1L}));
    }
}

