/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.pkg.container;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.regex.Pattern;
import javax.xml.ws.Holder;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.ofdrw.core.basicStructure.pageObj.Page;
import org.ofdrw.core.basicType.ST_Loc;
import org.ofdrw.pkg.container.VirtualContainer;

public class TempsDir
extends VirtualContainer {
    public static final String TempFilePrefix = "Temp_";
    public static final Pattern TempFileNameRegex = Pattern.compile("Temp_(\\d+).xml");
    private int maxTempIndex = -1;

    public TempsDir(Path fullDir) throws IllegalArgumentException {
        super(fullDir);
    }

    public TempsDir add(Path res) throws IOException {
        if (Files.notExists(res, new LinkOption[0])) {
            return this;
        }
        this.putFile(res);
        return this;
    }

    public ST_Loc add(String fileName, Page page) {
        this.putObj(fileName, (Element)page);
        return this.getAbsLoc().cat(fileName);
    }

    public ST_Loc add(Page page) throws IOException {
        if (page == null) {
            return null;
        }
        this.maxTempIndex = this.getMaxTempIndex() + 1;
        String fileName = String.format("%s%d.xml", TempFilePrefix, this.maxTempIndex);
        return this.add(fileName, page);
    }

    public Page get(String fileName) throws DocumentException, FileNotFoundException {
        Element element = this.getObj(fileName);
        return new Page(element);
    }

    public Integer getMaxTempIndex() throws IOException {
        if (this.maxTempIndex < 0) {
            Holder maxIndexHolder = new Holder((Object)-1);
            Files.list(this.getContainerPath()).forEach(item -> {
                String fileName = item.getFileName().toString().toLowerCase();
                if (fileName.startsWith(TempFilePrefix.toLowerCase())) {
                    String numStr = fileName.replace(TempFilePrefix.toLowerCase(), "").split("\\.")[0];
                    try {
                        int n = Integer.parseInt(numStr);
                        if (n > (Integer)maxIndexHolder.value) {
                            maxIndexHolder.value = n;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            });
            this.maxTempIndex = (Integer)maxIndexHolder.value;
        }
        return this.maxTempIndex;
    }
}

